/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeUPT
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -1994358478872378695L;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;
    static final byte KOTTCOPQ = 58;
    byte uptCode = 0;
    OracleNamedType realType = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    protected OracleTypeUPT() {
    }

    public OracleTypeUPT(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeUPT(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            return this.realType.toDatum(object, oracleConnection);
        }
        return null;
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        if (object != null) {
            return this.realType.toDatumArray(object, oracleConnection, l2, n2);
        }
        return null;
    }

    @Override
    public int getTypeCode() throws SQLException {
        switch (this.uptCode) {
            case -6: {
                return this.realType.getTypeCode();
            }
            case -5: {
                return 2003;
            }
            case 58: {
                return 2007;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid type code").fillInStackTrace();
    }

    @Override
    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        long l2 = tDSReader.readLong();
        this.uptCode = tDSReader.readByte();
        tDSReader.addNormalPatch(l2, this.uptCode, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n2 = 0;
        if (datum == null) {
            n2 += pickleContext.writeElementNull();
            return n2;
        } else {
            int n3 = pickleContext.offset();
            n2 += pickleContext.writeLength(PickleContext.KOPI20_LN_MAXV + 1);
            int n4 = 0;
            if (this.uptCode == -6 && !((OracleTypeADT)this.realType).isFinalType()) {
                if (!(datum instanceof STRUCT)) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "invalid upt state").fillInStackTrace();
                n4 = ((STRUCT)datum).getDescriptor().getOracleTypeADT().pickle81(pickleContext, datum);
            } else {
                n4 = this.realType.pickle81(pickleContext, datum);
            }
            n2 += n4;
            pickleContext.patchImageLen(n3, n4);
        }
        return n2;
    }

    @Override
    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        byte by = pickleContext.readByte();
        if (PickleContext.isElementNull(by)) {
            return null;
        }
        if (n2 == 9) {
            pickleContext.skipBytes(pickleContext.readRestOfLength(by));
            return null;
        }
        pickleContext.skipRestOfLength(by);
        return this.unpickle81UPT(pickleContext, n2, map);
    }

    @Override
    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n2, Map map) throws SQLException {
        long l2 = pickleContext.readRestOfLength(by);
        if (n2 == 9) {
            pickleContext.skipBytes((int)l2);
            return null;
        }
        return this.unpickle81UPT(pickleContext, n2, map);
    }

    private Object unpickle81UPT(PickleContext pickleContext, int n2, Map map) throws SQLException {
        switch (this.uptCode) {
            case -6: {
                switch (n2) {
                    case 1: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 3, n2, map);
                    }
                    case 2: {
                        OracleStruct oracleStruct = ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 1, n2, map);
                        return oracleStruct == null ? oracleStruct : oracleStruct.toJdbc(map);
                    }
                    case 9: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 9, 1, map);
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
            case -5: {
                return ((OracleTypeCOLLECTION)this.realType).unpickle81(pickleContext, (OracleArray)null, n2 == 9 ? n2 : 3, n2, map);
            }
            case 58: {
                switch (n2) {
                    case 1: 
                    case 9: {
                        return ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n2, map);
                    }
                    case 2: {
                        OPAQUE oPAQUE = ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n2, map);
                        return oPAQUE == null ? oPAQUE : oPAQUE.toJdbc(map);
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unrecognized UPT code").fillInStackTrace();
    }

    @Override
    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        return null;
    }

    @Override
    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor structDescriptor = null;
        structDescriptor = this.sqlName == null ? new StructDescriptor((OracleTypeADT)this.realType, (Connection)this.connection) : StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return structDescriptor;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        ArrayDescriptor arrayDescriptor = null;
        arrayDescriptor = this.sqlName == null ? new ArrayDescriptor((OracleTypeCOLLECTION)this.realType, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return arrayDescriptor;
    }

    public OracleType getRealType() throws SQLException {
        return this.realType;
    }

    @Override
    public int getNumAttrs() throws SQLException {
        return ((OracleTypeADT)this.realType).getNumAttrs();
    }

    @Override
    public OracleType getAttrTypeAt(int n2) throws SQLException {
        return ((OracleTypeADT)this.realType).getAttrTypeAt(n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.uptCode);
        objectOutputStream.writeObject(this.realType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uptCode = objectInputStream.readByte();
        this.realType = (OracleNamedType)objectInputStream.readObject();
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.realType.setConnection(oracleConnection);
    }

    @Override
    public void initChildNamesRecursively(Map map) throws SQLException {
        if (this.realType != null) {
            this.realType.setSqlName(this.sqlName);
            this.realType.initChildNamesRecursively(map);
        }
    }

    @Override
    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.realType != null) {
            this.realType.initMetadataRecursively();
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleTypeUPT sqlName=\"" + this.sqlName + "\"  toid=\"" + this.toid + "\" >");
        if (this.realType != null) {
            this.realType.printXML(printWriter, n2 + 1, bl);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeUPT>");
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    static {
        try {
            $$$methodRef$$$27 = OracleTypeUPT.class.getDeclaredConstructor(OracleTypeADT.class, Integer.TYPE, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleTypeUPT.class.getDeclaredConstructor(String.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleTypeUPT.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleTypeUPT.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleTypeUPT.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleTypeUPT.class.getDeclaredMethod("cacheDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleTypeUPT.class.getDeclaredMethod("initMetadataRecursively", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleTypeUPT.class.getDeclaredMethod("initChildNamesRecursively", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleTypeUPT.class.getDeclaredMethod("setConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleTypeUPT.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleTypeUPT.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleTypeUPT.class.getDeclaredMethod("getAttrTypeAt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleTypeUPT.class.getDeclaredMethod("getNumAttrs", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleTypeUPT.class.getDeclaredMethod("getRealType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleTypeUPT.class.getDeclaredMethod("createArrayDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleTypeUPT.class.getDeclaredMethod("createStructDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleTypeUPT.class.getDeclaredMethod("unpickle81datumAsNull", PickleContext.class, Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleTypeUPT.class.getDeclaredMethod("unpickle81UPT", PickleContext.class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleTypeUPT.class.getDeclaredMethod("unpickle81rec", PickleContext.class, Byte.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleTypeUPT.class.getDeclaredMethod("unpickle81rec", PickleContext.class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleTypeUPT.class.getDeclaredMethod("pickle81", PickleContext.class, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTypeUPT.class.getDeclaredMethod("parseTDSrec", TDSReader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTypeUPT.class.getDeclaredMethod("isObjectType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTypeUPT.class.getDeclaredMethod("isInHierarchyOf", StructDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTypeUPT.class.getDeclaredMethod("isInHierarchyOf", OracleType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTypeUPT.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTypeUPT.class.getDeclaredMethod("toDatumArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTypeUPT.class.getDeclaredMethod("toDatum", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

