/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleClobInputStream
extends OracleBufferedStream {
    protected long lobOffset;
    protected OracleClob clob;
    protected long markedByte;
    protected boolean endOfStream;
    protected char[] charBuf;
    protected boolean asciiStrictConversion;
    boolean internalClob = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    public OracleClobInputStream(OracleClob oracleClob, int n2) throws SQLException {
        this(oracleClob, n2, 1L, false);
    }

    public OracleClobInputStream(OracleClob oracleClob, int n2, boolean bl) throws SQLException {
        this(oracleClob, n2, 1L, bl);
    }

    public OracleClobInputStream(OracleClob oracleClob, int n2, long l2) throws SQLException {
        this(oracleClob, n2, l2, false);
    }

    public OracleClobInputStream(OracleClob oracleClob, int n2, long l2, boolean bl) throws SQLException {
        super(n2, ((PhysicalConnection)oracleClob.getInternalConnection())::getByteBufferSync, ((PhysicalConnection)oracleClob.getInternalConnection())::cacheBufferSync);
        if (oracleClob == null || n2 <= 0 || l2 < 1L) {
            throw new IllegalArgumentException();
        }
        this.lobOffset = l2;
        this.clob = oracleClob;
        this.markedByte = -1L;
        this.endOfStream = false;
        this.internalClob = bl;
        this.asciiStrictConversion = ((PhysicalConnection)oracleClob.getInternalConnection()).isStrictAsciiConversion;
    }

    @Override
    public boolean needBytes(int n2) throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    Object object;
                    if (n2 > this.currentBufferSize || n2 == 0) {
                        this.currentBufferSize = Math.max(n2, this.initialBufferSize);
                        object = (PhysicalConnection)this.clob.getInternalConnection();
                        this.charBuf = ((PhysicalConnection)object).getCharBufferSync(this.currentBufferSize);
                    }
                    this.count = this.clob.getChars(this.lobOffset, this.currentBufferSize, this.charBuf);
                    object = this.getBuffer(this.currentBufferSize);
                    CharacterSet.convertJavaCharsToASCIIBytes(this.charBuf, 0, (byte[])object, 0, this.count, this.asciiStrictConversion);
                    if (this.count < this.currentBufferSize) {
                        this.endOfStream = true;
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        this.lobOffset += (long)this.count;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    protected void ensureOpen() throws IOException {
        try {
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException sQLException) {
            throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(DatabaseError.findMessage(196, null));
        }
        this.markedByte = this.lobOffset - (long)this.count + (long)this.pos;
    }

    public void markInternal(int n2) {
    }

    @Override
    public void reset() throws IOException {
        this.ensureOpen();
        if (this.markedByte < 0L) {
            throw new IOException(DatabaseError.findMessage(195, null));
        }
        this.lobOffset = this.markedByte;
        this.pos = this.count;
        this.endOfStream = false;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.ensureOpen();
        long l3 = 0L;
        if ((long)(this.count - this.pos) >= l2) {
            this.pos = (int)((long)this.pos + l2);
            l3 += l2;
        } else {
            l3 += (long)(this.count - this.pos);
            this.pos = this.count;
            try {
                long l4 = 0L;
                l4 = this.clob.length() - this.lobOffset + 1L;
                if (l4 >= l2 - l3) {
                    this.lobOffset += l2 - l3;
                    l3 += l2 - l3;
                } else {
                    this.lobOffset += l4;
                    l3 += l4;
                }
            }
            catch (SQLException sQLException) {
                throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
            }
        }
        return l3;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.charBuf != null) {
                PhysicalConnection physicalConnection = (PhysicalConnection)this.clob.getInternalConnection();
                physicalConnection.cacheBufferSync(this.charBuf);
                this.charBuf = null;
            }
            this.currentBufferSize = 0;
            if (this.clob != null && this.internalClob) {
                this.clob.free();
                this.internalClob = false;
            }
        }
        catch (SQLException sQLException) {
            throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
        }
        finally {
            super.close();
        }
    }

    @Override
    public int available() throws IOException {
        int n2;
        this.ensureOpen();
        OracleLargeObject.PrefetchData prefetchData = this.clob.getPrefetchData();
        if (this.clob.isActivePrefetch() && prefetchData != null && (n2 = prefetchData.length()) > 0) {
            if (this.lobOffset == 1L) {
                return n2;
            }
            if (this.lobOffset - 1L < (long)n2) {
                return n2 - this.pos;
            }
        }
        return super.available();
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        try {
            $$$methodRef$$$13 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleClobInputStream.class.getDeclaredConstructor(OracleClob.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleClobInputStream.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleClobInputStream.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleClobInputStream.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleClobInputStream.class.getDeclaredMethod("skip", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleClobInputStream.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleClobInputStream.class.getDeclaredMethod("markInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleClobInputStream.class.getDeclaredMethod("mark", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleClobInputStream.class.getDeclaredMethod("markSupported", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleClobInputStream.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleClobInputStream.class.getDeclaredMethod("needBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

