/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFDCNConnection;

class NTFDCNConnectionGroup {
    private static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS;
    private ArrayList<NTFDCNConnection> dcnListenerConnections = new ArrayList();
    private final String groupId;
    private int noOfRegistrationsInThisGroup = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    NTFDCNConnectionGroup(String string) {
        this.groupId = string;
    }

    synchronized NTFDCNConnection getNTFDCNConnection() {
        ++this.noOfRegistrationsInThisGroup;
        if (this.noOfRegistrationsInThisGroup > MAX_NTF_CONNECTIONS) {
            int n2 = this.noOfRegistrationsInThisGroup;
            NTFDCNConnection nTFDCNConnection = this.dcnListenerConnections.get(0);
            for (NTFDCNConnection nTFDCNConnection2 : this.dcnListenerConnections) {
                int n3 = nTFDCNConnection2.getNumberOfRegistrations();
                if (n3 >= n2) continue;
                nTFDCNConnection = nTFDCNConnection2;
                n2 = n3;
            }
            nTFDCNConnection.incrementNumberOfRegistrations(1);
            return nTFDCNConnection;
        }
        return null;
    }

    synchronized void startDCNListenerConnection(String string, String string2, String string3, String string4, Properties properties, ArrayList<String> arrayList, String string5, int n2) {
        assert (string5 != null) : "dcnConnectionId is null";
        String string6 = "notify" + string5;
        NTFDCNConnection nTFDCNConnection = new NTFDCNConnection(string5, arrayList, string, string2, string3, string4, properties, string6, n2);
        this.dcnListenerConnections.add(nTFDCNConnection);
        nTFDCNConnection.setDaemon(true);
        nTFDCNConnection.start();
    }

    synchronized void stopNTFDCNConnection(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        for (NTFDCNConnection nTFDCNConnection : this.dcnListenerConnections) {
            if (nTFDCNConnection == null || !string.equals(nTFDCNConnection.getClientId())) continue;
            nTFDCNConnection.decrementNumberOfRegistrations(1);
            if (nTFDCNConnection.getNumberOfRegistrations() > 0) break;
            nTFDCNConnection.setNeedToBeClosed(true);
            break;
        }
    }

    static {
        try {
            $$$methodRef$$$3 = NTFDCNConnectionGroup.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFDCNConnectionGroup.class.getDeclaredMethod("stopNTFDCNConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFDCNConnectionGroup.class.getDeclaredMethod("startDCNListenerConnection", String.class, String.class, String.class, String.class, Properties.class, ArrayList.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFDCNConnectionGroup.class.getDeclaredMethod("getNTFDCNConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        MAX_NTF_CONNECTIONS = 16;
    }
}

