/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEvent;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.DatabaseSessionState;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.internal.StateSignatures;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.EndReplayCallback;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;
import oracle.jdbc.replay.driver.TxnFailoverManager;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableBfile;
import oracle.jdbc.replay.driver.TxnReplayableBlob;
import oracle.jdbc.replay.driver.TxnReplayableClob;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableNClob;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public class TxnFailoverManagerImpl
implements TxnFailoverManager,
LogicalTransactionIdEventListener {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private static final int DIRECTIVE_ENQUEUE_CALL = 1;
    private static final int DIRECTIVE_REQ_SCOPE_CRSR = 2;
    private static final int DIRECTIVE_REPLAY_ENABLED = 4;
    private static final int DIRECTIVE_EMPTY_QUEUE = 8;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 300L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private LogicalTransactionId ltxid = null;
    private LogicalTransactionId oldLtxidForPrepareReplay = null;
    private LogicalTransactionId ltxidAtOriginalOutage = null;
    private ReplayContext[] replayContext = null;
    private ReplayContext cxtBeforePrepareReplay;
    private OracleDataSource replayDataSource = null;
    private TxnReplayableBase connectionProxy;
    private oracle.jdbc.internal.OracleConnection originalOconn = null;
    private int lastCxtLenAtOriginalOutage = 0;
    private String connectionProxyName;
    private Method callHittingOutage;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private boolean doNotAbortConn = false;
    private boolean isReplayInDynamicMode = true;
    private ReplayableConnection.StateRestorationType stateRestorationType = ReplayableConnection.StateRestorationType.NONE;
    boolean isAutoAC = false;
    private Properties savedSessionProps = null;
    private Properties savedClientInfo = null;
    private boolean savedAutoCommit = true;
    private static final long SIG_FLAGS_NO_CHANGES = 1L;
    private static final long SIG_FLAGS_CLIENT_RESTORABLE_CHANGES = 2L;
    private static final long SIG_FLAGS_SERVER_RESTORABLE_CHANGES = 4L;
    private static final long SIG_FLAGS_SIDE_EFFECT_CHANGES = 8L;
    private static final long SIG_FLAGS_CAN_CHANGE_STATE = 16L;
    private static final long SIG_FLAGS_UNRESTORABLE_CHANGES = 32L;
    private static final long SIG_FLAGS_OVERFLOW_FULL = 64L;
    boolean needStateSignatureSyncUp = false;
    private DatabaseSessionState savedDatabaseSessionState = null;
    private static final int QUEUE_NUMBER = 2;
    private static final int NOT_IN_QUEUE = -1;
    private static int activeQueues;
    private static final int INIT_EMPTY_COUNT = 0;
    private static final int NA_EMPTY_COUNT = -1;
    private static final int REQ_SCOPE_EMPTY_COUNT = Integer.MAX_VALUE;
    private int[] queueEmptyCounts = new int[2];
    boolean seenRoundtripCallInRequest = false;
    boolean originalSeenRoundtripCallInRequest = false;
    boolean didReplayingLastCallDisableReplay = false;
    short nestedLevelOfTopLevelCalls = 0;
    private static final HashSet<String> postExecuteGetCalls;
    private static final String NULL_METHOD_NAME = "NULL METHOD";
    ReplayStatisticsImpl acStatistics = null;
    private boolean callingDisableFromEndRequest = false;
    boolean lobStreamInRequest = false;
    int originalReadTimeout = 0;
    private static final int MIN_READ_TIMEOUT_RAC_DG = 120000;
    int requestSizeLimit = 0;
    int requestSize = 0;
    private static final ExecutorService executor;
    private boolean svrSupportsSignature = true;
    static boolean seenMemoryPressure;
    static long seenMemoryPressureTS;
    static final long MEMORY_PRESSURE_REPORT_WINDOW = 120000L;
    private static final String PREPARE_REPLAY = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?); END;";
    private static final String PREPARE_REPLAY_2 = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER, sig_flags IN NUMBER, client_sig IN NUMBER, server_sig IN NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded, sig_flags, client_sig, server_sig); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?,?,?,?); END;";
    static final String NLS_CALENDAR_PROPERTY = "AUTH_NLS_LXCCALENDAR";
    static final String NLS_CURRENCY_PROPERTY = "AUTH_NLS_LXCCURRENCY";
    static final String NLS_DATE_FORMAT_PROPERTY = "AUTH_NLS_LXCDATEFM";
    static final String NLS_DATE_LANGUAGE_PROPERTY = "AUTH_NLS_LXCDATELANG";
    static final String NLS_DUAL_CURRENCY_PROPERTY = "AUTH_NLS_LXCUNIONCUR";
    static final String NLS_ISO_CURRENCY_PROPERTY = "AUTH_NLS_LXCISOCURR";
    static final String NLS_LANGUAGE_PROPERTY = "AUTH_NLS_LXLAN";
    static final String NLS_LENGTH_SEMANTICS_PROPERTY = "SESSION_NLS_LXCNLSLENSEM";
    static final String NLS_NCHAR_CONV_EXCP_PROPERTY = "SESSION_NLS_LXCNCHAREXCP";
    static final String NLS_NUMERIC_CHARACTERS_PROPERTY = "AUTH_NLS_LXCNUMERICS";
    static final String NLS_SORT_PROPERTY = "AUTH_NLS_LXCSORT";
    static final String NLS_TERRITORY_PROPERTY = "AUTH_NLS_LXCTERRITORY";
    static final String NLS_TIME_FORMAT_PROPERTY = "AUTH_NLS_LXCTIMEFM";
    static final String NLS_TIME_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCTTZNFM";
    static final String NLS_TIMESTAMP_FORMAT_PROPERTY = "AUTH_NLS_LXCSTMPFM";
    static final String NLS_TIMESTAMP_TZ_FORMAT_PROPERTY = "AUTH_NLS_LXCSTZNFM";
    static final String TIME_ZONE_PROPERTY = "SESSION_TIME_ZONE";
    static final String CONTAINER_PROPERTY = "CONTAINER_NAME";
    static final String SERVICE_PROPERTY = "SERVICE_NAME";
    static final String ERROR_OVERLAP_PROPERTY = "AL8KW_ERR_OVLAP";
    static final String SCHEMA_NAME_PROPERTY = "AL8KW_SCHEMA_NAME";
    static final String ENABLED_ROLE_NAMES_PROPERTY = "AL8KW_ENABLED_ROLE_NAMES";
    static final String EDITION_PROPERTY = "AUTH_ORA_EDITION";
    static final String SQL_TXLP_PROPERTY = "AL8KW_SQL_TXLP";
    static final String FSQL_SNTX_PROPERTY = "AL8KW_FSQL_SNTX";
    static final String ROW_ARCHIVAL_PROPERTY = "AL8KW_ROW_ARCHIVAL";
    static final String OPENCURSORS_PROPERTY = "AL8KW_OPENCURSORS";
    static final String CLIENT_INFO_PROPERTY = "AL8KW_CLIENT_INFO";
    private static final String CONTAINER_QUERY = "select sys_context('userenv','con_name') from dual";
    private static final String FAILOVER_TYPE_PROPERTY = "AUTH_FAILOVER_TYPE";
    private static final int FAILOVER_TYPE_TRANSACTION = 8;
    private static final int SESSION_STATE_CONSISTENCY_STATIC = 16;
    private static final int FAILOVER_TYPE_AUTO = 32;
    private static final int KWFCSFLAGS_RESTORE_AUTO = 2;
    private static final BigInteger MASK;
    private static final MemGuardListener MEMGUARD_LISTENER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;

    private TxnFailoverManagerImpl(TxnReplayableBase txnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        this.connectionProxy = txnReplayableBase;
        this.connectionProxyName = this.connectionProxy.thisProxyNameInLog;
        this.replayDataSource = oracleDataSource;
        oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)txnReplayableBase.getDelegate();
        this.ltxid = oracleConnection.getLogicalTransactionId();
        this.replayContext = null;
        activeQueues = 2;
        this.queueEmptyCounts = new int[2];
        for (int i2 = 0; i2 < activeQueues; ++i2) {
            this.queueEmptyCounts[i2] = 0;
        }
        oracleConnection.addLogicalTransactionIdEventListener(this);
        this.acStatistics = new ReplayStatisticsImpl();
        this.replayDataSource.updateReplayStatistics(this.acStatistics);
        this.svrSupportsSignature = oracleConnection.getVersionNumber() >= 18100;
    }

    static TxnFailoverManager getFailoverManager(TxnReplayableBase txnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        return new TxnFailoverManagerImpl(txnReplayableBase, oracleDataSource);
    }

    private void append(CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntry = this.tail;
        callHistoryEntry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = callHistoryEntry;
        }
        this.tail = callHistoryEntry;
        if (this.head == null) {
            this.head = callHistoryEntry;
        }
        if (!this.isSessionStateConsistencyDynamic()) {
            JDBCReplayable jDBCReplayable = (JDBCReplayable)callHistoryEntry.jdbcProxy;
            jDBCReplayable.addToSameProxyList(callHistoryEntry);
        }
    }

    private void remove(CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntry != null) {
            callHistoryEntry.nextEntry.prevEntry = callHistoryEntry.prevEntry;
        }
        if (callHistoryEntry.prevEntry != null) {
            callHistoryEntry.prevEntry.nextEntry = callHistoryEntry.nextEntry;
        }
        if (this.head == callHistoryEntry) {
            this.head = callHistoryEntry.nextEntry;
        }
        if (this.tail == callHistoryEntry) {
            this.tail = callHistoryEntry.prevEntry;
        }
        if (!this.isSessionStateConsistencyDynamic()) {
            JDBCReplayable jDBCReplayable = (JDBCReplayable)callHistoryEntry.jdbcProxy;
            jDBCReplayable.removeFromSameProxyList(callHistoryEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        this.checkMemoryPressureAndLog();
        if (this.tail != null && this.tail.method != null && "started".equals(this.tail.callStatus)) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls + 1);
            return null;
        }
        if (++this.requestSize > this.requestSizeLimit) {
            this.disableReplayInternal(method, 367, "Replay disabled because request size exceeded limit", null);
            return null;
        }
        this.acStatistics.incrementTotalProtectedCalls();
        this.acStatistics.incrementCurrentRequestSize();
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            CallHistoryEntry callHistoryEntry = new CallHistoryEntry(object, method, objectArray, string);
            this.append(callHistoryEntry);
            return callHistoryEntry;
        }
    }

    private String dumpHistory() {
        String string = "Dump History: \n";
        if (this.head != null) {
            CallHistoryEntry callHistoryEntry = this.head;
            while (true) {
                string = string + callHistoryEntry.toString();
                if (callHistoryEntry == this.tail) break;
                callHistoryEntry = callHistoryEntry.nextEntry;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, SQLException sQLException) {
        int n2;
        int n3;
        Object object3;
        int n4;
        Object object4;
        if (this.nestedLevelOfTopLevelCalls > 0) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls - 1);
            return;
        }
        ReplayContext[] replayContextArray = null;
        boolean bl = false;
        ReplayContext[] replayContextArray2 = null;
        int n5 = -1;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            object4 = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            replayContextArray = object4.getReplayContext();
            Object object5 = object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
        }
        catch (SQLException sQLException2) {
            try {
                bl = true;
                Object object6 = object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
            }
            catch (Throwable throwable) {
                CallHistoryEntry callHistoryEntry2;
                CallHistoryEntry callHistoryEntry3 = callHistoryEntry2 = callHistoryEntry == null ? this.tail : callHistoryEntry;
                if (!bl) {
                    if (replayContextArray != null) {
                        this.replayContext = replayContextArray;
                        replayContextArray2 = new ReplayContext[replayContextArray.length];
                        if (replayContextArray.length > 0) {
                            this.seenRoundtripCallInRequest = true;
                            this.needStateSignatureSyncUp = false;
                        }
                        for (int i2 = 0; i2 < replayContextArray.length; ++i2) {
                            ReplayContext replayContext = replayContextArray[i2];
                            int n7 = (int)replayContext.getDirectives();
                            short s2 = replayContext.getQueue();
                            if ((n7 & 4) == 0) {
                                bl = true;
                                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                    this.didReplayingLastCallDisableReplay = true;
                                }
                                long l3 = replayContext.getErrorCode();
                                this.disableReplayInternal(callHistoryEntry2.method, 384, "Replay disabled by server Continuity Management", null);
                                return;
                            }
                            if ((n7 & 8) == 8) {
                                short s3 = s2;
                                this.queueEmptyCounts[s3] = this.queueEmptyCounts[s3] + 1;
                            }
                            assert ((n7 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                            if ((n7 & 1) == 1) {
                                replayContextArray2[i2] = replayContext;
                                n5 = s2;
                                n6 = this.queueEmptyCounts[s2];
                                bl3 = true;
                            }
                            if ((n7 & 2) != 2) continue;
                            bl2 = true;
                        }
                    } else {
                        if (callHistoryEntry2.replayContext != null) {
                            return;
                        }
                        n5 = -1;
                        n6 = 0;
                    }
                } else {
                    this.disableReplayInternal(callHistoryEntry2.method, 383, "Replay disabled because getting replay context failed", null);
                }
                throw throwable;
            }
            if (!bl) {
                if (replayContextArray != null) {
                    this.replayContext = replayContextArray;
                    replayContextArray2 = new ReplayContext[replayContextArray.length];
                    if (replayContextArray.length > 0) {
                        this.seenRoundtripCallInRequest = true;
                        this.needStateSignatureSyncUp = false;
                    }
                    for (n4 = 0; n4 < replayContextArray.length; ++n4) {
                        object3 = replayContextArray[n4];
                        n3 = (int)object3.getDirectives();
                        n2 = object3.getQueue();
                        if ((n3 & 4) == 0) {
                            bl = true;
                            if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                this.didReplayingLastCallDisableReplay = true;
                            }
                            long l4 = object3.getErrorCode();
                            this.disableReplayInternal(((CallHistoryEntry)object4).method, 384, "Replay disabled by server Continuity Management", null);
                            return;
                        }
                        if ((n3 & 8) == 8) {
                            int n8 = n2;
                            this.queueEmptyCounts[n8] = this.queueEmptyCounts[n8] + 1;
                        }
                        assert ((n3 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                        if ((n3 & 1) == 1) {
                            replayContextArray2[n4] = object3;
                            n5 = n2;
                            n6 = this.queueEmptyCounts[n2];
                            bl3 = true;
                        }
                        if ((n3 & 2) != 2) continue;
                        bl2 = true;
                    }
                } else {
                    if (((CallHistoryEntry)object4).replayContext != null) {
                        return;
                    }
                    n5 = -1;
                    n6 = 0;
                }
            } else {
                this.disableReplayInternal(((CallHistoryEntry)object4).method, 383, "Replay disabled because getting replay context failed", null);
            }
        }
        if (!bl) {
            if (replayContextArray != null) {
                this.replayContext = replayContextArray;
                replayContextArray2 = new ReplayContext[replayContextArray.length];
                if (replayContextArray.length > 0) {
                    this.seenRoundtripCallInRequest = true;
                    this.needStateSignatureSyncUp = false;
                }
                for (n4 = 0; n4 < replayContextArray.length; ++n4) {
                    object3 = replayContextArray[n4];
                    n3 = (int)object3.getDirectives();
                    n2 = object3.getQueue();
                    if ((n3 & 4) == 0) {
                        bl = true;
                        if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                            this.didReplayingLastCallDisableReplay = true;
                        }
                        long l5 = object3.getErrorCode();
                        this.disableReplayInternal(((CallHistoryEntry)object4).method, 384, "Replay disabled by server Continuity Management", null);
                        return;
                    }
                    if ((n3 & 8) == 8) {
                        int n9 = n2;
                        this.queueEmptyCounts[n9] = this.queueEmptyCounts[n9] + 1;
                    }
                    assert ((n3 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                    if ((n3 & 1) == 1) {
                        replayContextArray2[n4] = object3;
                        n5 = n2;
                        n6 = this.queueEmptyCounts[n2];
                        bl3 = true;
                    }
                    if ((n3 & 2) != 2) continue;
                    bl2 = true;
                }
            } else {
                if (((CallHistoryEntry)object4).replayContext != null) {
                    return;
                }
                n5 = -1;
                n6 = 0;
            }
        } else {
            this.disableReplayInternal(((CallHistoryEntry)object4).method, 383, "Replay disabled because getting replay context failed", null);
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED && this.tail != null) {
            object4 = this;
            synchronized (object4) {
                CallHistoryEntry callHistoryEntry4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
                object3 = callHistoryEntry4 == null || callHistoryEntry4.method == null ? NULL_METHOD_NAME : callHistoryEntry4.method.getName();
                callHistoryEntry4.result = object2 instanceof TxnReplayableBase || object2 instanceof OracleConcreteProxy ? object2 : null;
                callHistoryEntry4.checksum = l2;
                if (replayContextArray2 != null) {
                    if (callHistoryEntry4.replayContext == null) {
                        callHistoryEntry4.replayContext = replayContextArray2;
                    } else {
                        ReplayContext[] replayContextArray3 = new ReplayContext[callHistoryEntry4.replayContext.length + replayContextArray2.length];
                        System.arraycopy(callHistoryEntry4.replayContext, 0, replayContextArray3, 0, callHistoryEntry4.replayContext.length);
                        System.arraycopy(replayContextArray2, 0, replayContextArray3, callHistoryEntry4.replayContext.length, replayContextArray2.length);
                        callHistoryEntry4.replayContext = replayContextArray3;
                    }
                }
                callHistoryEntry4.callException = sQLException;
                callHistoryEntry4.queueId = n5;
                callHistoryEntry4.queueEmptyCount = n6;
                callHistoryEntry4.serverAsksToEnqueue = bl3;
                callHistoryEntry4.callStatus = string;
                if (replayContextArray2 != null) {
                    for (ReplayContext replayContext : replayContextArray2) {
                        if (replayContext != null) continue;
                    }
                }
                if (!this.isSessionStateConsistencyDynamic() && bl2) {
                    CallHistoryEntry callHistoryEntry5 = ((TxnReplayableResultSet)callHistoryEntry4.jdbcProxy).creatorCallEntry;
                    callHistoryEntry5.queueEmptyCount = Integer.MAX_VALUE;
                }
            }
        }
    }

    synchronized void purge() {
        this.head = null;
        this.tail = null;
        this.connectionProxy.headSameProxy = null;
        this.connectionProxy.tailSameProxy = null;
    }

    synchronized void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        Object object = callHistoryEntry == null ? null : callHistoryEntry.jdbcProxy;
        CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
        while (callHistoryEntry2 != null) {
            Object object2 = callHistoryEntry2.result;
            if (object2 != null && object2 instanceof JDBCReplayable && !set.contains(object2)) {
                JDBCReplayable jDBCReplayable = (JDBCReplayable)object2;
                jDBCReplayable.purgeSameProxyList();
                set.add(jDBCReplayable);
            }
            this.remove(callHistoryEntry2);
            callHistoryEntry2 = callHistoryEntry2.nextEntrySameProxy;
        }
    }

    synchronized boolean isEmpty() {
        return this.head == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object handleOutage(Method method, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.callHittingOutage = method;
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            this.acStatistics.incrementTotalCallsAffectedByOutages();
            this.checkMemoryPressureAndLog();
            if (this.nestedLevelOfTopLevelCalls > 0) {
                this.disableReplayAndThrowOriginalError(null, 365, "Replay disabled because unrecorded nested call hit outage", sQLRecoverableException);
                return null;
            }
            this.replayRetries = 0;
            do {
                ReplayLifecycle replayLifecycle;
                try {
                    return this.handleOutageInternal(sQLRecoverableException, this.replayRetries);
                }
                catch (SQLRecoverableException sQLRecoverableException2) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case REPLAYING_CALLBACK: {
                            int n2 = sQLRecoverableException2.getErrorCode();
                            if (n2 == 603 && sQLRecoverableException2.getMessage().indexOf("ORA-44787") != -1) {
                                this.disableReplayAndThrowOriginalError(null, 366, "Replay failed because of calling set container after PREPARE_REPLAY", sQLRecoverableException);
                            }
                        }
                        case ENABLED_NOT_REPLAYING: 
                        case REPLAYING: 
                        case REPLAYING_LASTCALL: {
                            ++this.replayRetries;
                            this.acStatistics.incrementTotalCallsAffectedByOutagesDuringReplay();
                            break;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case INTERNALLY_FAILED: {
                            ++this.replayRetries;
                            this.lifecycle = ReplayLifecycle.REPLAYING;
                            break;
                        }
                        case REPLAYING_CALLBACK: {
                            ++this.replayRetries;
                            break;
                        }
                        case ALWAYS_DISABLED: 
                        case INTERNALLY_DISABLED: 
                        case EXTERNALLY_DISABLED: {
                            if (this.didReplayingLastCallDisableReplay) {
                                this.acStatistics.incrementSuccessfulReplayCount();
                                throw sQLException;
                            }
                            this.throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                        }
                        case REPLAYING_LASTCALL: {
                            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                            this.acStatistics.incrementSuccessfulReplayCount();
                            throw sQLException;
                        }
                    }
                }
            } while (this.replayRetries <= 3);
            this.disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", sQLRecoverableException);
            return null;
        }
    }

    synchronized Object handleOutageInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        block32: {
            oracle.jdbc.internal.OracleConnection oracleConnection;
            block33: {
                short s2;
                block31: {
                    this.acStatistics.incrementTotalReplayAttempts();
                    this.didReplayingLastCallDisableReplay = false;
                    if (n2 == 0) {
                        this.ltxidAtOriginalOutage = this.ltxid;
                        if (this.tail != null) {
                            this.lastCxtLenAtOriginalOutage = this.tail.replayContext == null ? 0 : this.tail.replayContext.length;
                        }
                    }
                    ReplayLifecycle replayLifecycle = this.lifecycle;
                    if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                        if (this.replayErrorCode == 0) {
                            this.doNotAbortConn = true;
                            this.replayErrorCode = 370;
                            this.replayErrorMessage = "Replay disabled";
                        }
                        this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                    }
                    if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                        this.acStatistics.incrementTotalCallsTriggeringReplay();
                    }
                    if (n2 == 0) {
                        this.originalOconn = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
                        this.originalSeenRoundtripCallInRequest = this.seenRoundtripCallInRequest;
                    }
                    s2 = this.originalOconn.getExecutingRPCFunctionCode();
                    if (this.originalSeenRoundtripCallInRequest || s2 != 0) break block31;
                    this.replayResult = this.replayWithLocalCallsOnly(sQLRecoverableException, n2);
                    break block32;
                }
                boolean bl = this.originalOconn.isProxySession();
                boolean bl2 = ((TxnReplayableConnection)this.connectionProxy).autoCommitBeforeOutage;
                s2 = this.originalOconn.getExecutingRPCFunctionCode();
                String string = this.originalOconn.getExecutingRPCSQL();
                this.cxtBeforePrepareReplay = this.originalOconn.getLastReplayContext();
                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL && this.tail.replayContext != null && this.tail.replayContext.length > this.lastCxtLenAtOriginalOutage) {
                    if (this.lastCxtLenAtOriginalOutage == 0) {
                        this.tail.replayContext = null;
                    } else {
                        for (int i2 = this.lastCxtLenAtOriginalOutage; i2 < this.tail.replayContext.length; ++i2) {
                            this.tail.replayContext[i2] = null;
                        }
                    }
                }
                if ((oracleConnection = (oracle.jdbc.internal.OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
                    this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
                }
                if (!this.checkACChange(oracleConnection)) {
                    this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", sQLRecoverableException);
                }
                this.connectionProxy.setDelegate(oracleConnection);
                oracleConnection.setACProxy(this.connectionProxy);
                this.originalReadTimeout = ((OracleConnection)oracleConnection).getNetworkTimeout();
                if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                    ((OracleConnection)oracleConnection).setNetworkTimeout(executor, 120000);
                }
                oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
                this.oldLtxidForPrepareReplay = this.ltxid;
                if (bl) {
                    this.invokeCallbackAfterReconnect(oracleConnection, false, sQLRecoverableException);
                    this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                }
                this.ltxid = oracleConnection.getLogicalTransactionId();
                oracleConnection.addLogicalTransactionIdEventListener(this);
                String string2 = this.tail.method.getName();
                oracleConnection.setReplayContext(new ReplayContext[]{this.cxtBeforePrepareReplay});
                ReplayContext replayContext = this.lastCxtLenAtOriginalOutage == 0 ? null : (this.tail.replayContext == null ? null : this.tail.replayContext[this.lastCxtLenAtOriginalOutage - 1]);
                boolean bl3 = this.prepareReplay(oracleConnection, sQLRecoverableException, bl2, s2, string);
                if (bl3) {
                    if (this.isSessionStateConsistencyDynamic()) {
                        if (string2.equals("execute")) {
                            return false;
                        }
                        if (string2.equals("commit")) {
                            return null;
                        }
                        return null;
                    }
                    this.queueEmptyCounts[1] = this.queueEmptyCounts[1] + 1;
                }
                long l2 = System.currentTimeMillis();
                if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l2) {
                    this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
                }
                if (bl && this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.LEVEL1) >= 0) {
                    oracleConnection.setDatabaseSessionState(this.savedDatabaseSessionState);
                }
                oracleConnection.getReplayContext();
                if (!bl) {
                    this.invokeCallbackAfterReconnect(oracleConnection, true, sQLRecoverableException);
                }
                this.lifecycle = ReplayLifecycle.REPLAYING;
                this.beginReplay(oracleConnection, sQLRecoverableException);
                this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
                if (this.tail.replayContext == null || this.tail.replayContext.length == 0) {
                    this.endReplay(oracleConnection, sQLRecoverableException);
                } else {
                    oracleConnection.registerEndReplayCallback(new EndReplayCallback(this, oracleConnection, sQLRecoverableException));
                }
                if (!bl3) {
                    this.replayResult = this.replayLastCall(sQLRecoverableException);
                } else if (!this.isSessionStateConsistencyDynamic()) {
                    this.tail.callStatus = "completed";
                    this.tail.queueId = 1;
                    this.tail.queueEmptyCount = this.queueEmptyCounts[1];
                    this.tail.serverAsksToEnqueue = false;
                    this.replayResult = string2.equals("execute") ? Boolean.valueOf(false) : (string2.equals("commit") ? null : null);
                }
                if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
                    ((OracleConnection)oracleConnection).setNetworkTimeout(executor, this.originalReadTimeout);
                }
                if (this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL || this.tail == null) break block32;
                if (this.tail.replayContext == null) break block33;
                if (this.tail.replayContext.length != 0) break block32;
            }
            oracleConnection.setLastReplayContext(this.cxtBeforePrepareReplay);
        }
        if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        }
        this.acStatistics.incrementSuccessfulReplayCount();
        this.originalOconn = null;
        return this.replayResult;
    }

    synchronized Object replayWithLocalCallsOnly(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        boolean bl = this.originalOconn.isProxySession();
        oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalConnectionBuilder);
        if (oracleConnection == null) {
            this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
        }
        if (!this.checkACChange(oracleConnection)) {
            this.disableReplayAndThrowException(null, 369, "Replay disabled because it reconnected to AC-disabled instance", sQLRecoverableException);
        }
        this.connectionProxy.setDelegate(oracleConnection);
        oracleConnection.setACProxy(this.connectionProxy);
        this.originalReadTimeout = ((OracleConnection)oracleConnection).getNetworkTimeout();
        if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
            ((OracleConnection)oracleConnection).setNetworkTimeout(executor, 120000);
        }
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
        if (bl) {
            this.invokeCallbackAfterReconnect(oracleConnection, false, sQLRecoverableException);
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        }
        this.ltxid = oracleConnection.getLogicalTransactionId();
        oracleConnection.addLogicalTransactionIdEventListener(this);
        long l2 = System.currentTimeMillis();
        if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l2) {
            this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
        }
        if (!bl) {
            this.invokeCallbackAfterReconnect(oracleConnection, false, sQLRecoverableException);
        }
        oracleConnection.getReplayContext();
        if (this.isReplayInDynamicMode) {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        } else {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        }
        this.lifecycle = ReplayLifecycle.REPLAYING;
        this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
        this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        this.replayResult = this.replayLastCall(sQLRecoverableException);
        if (this.originalReadTimeout > 0 && this.originalReadTimeout < 120000) {
            ((OracleConnection)oracleConnection).setNetworkTimeout(executor, this.originalReadTimeout);
        }
        return this.replayResult;
    }

    private void invokeCallbackAfterReconnect(oracle.jdbc.internal.OracleConnection oracleConnection, boolean bl, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
        switch (this.stateRestorationType) {
            case NONE: {
                this.restoreAutoCommit(oracleConnection);
                break;
            }
            case LEVEL1: 
            case AUTO: {
                this.restoreCommonSessionState(oracleConnection, bl);
            }
        }
        ConnectionInitializationCallback connectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
        if (connectionInitializationCallback != null) {
            try {
                connectionInitializationCallback.initialize((Connection)((Object)this.connectionProxy));
            }
            catch (SQLRecoverableException sQLRecoverableException2) {
                throw sQLRecoverableException2;
            }
            catch (SQLException sQLException) {
                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", sQLRecoverableException);
            }
            EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
            if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", sQLRecoverableException);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized Object replayAllBeforeLastCall(SQLRecoverableException var1_1) throws SQLException {
        var2_2 = null;
        var3_3 = this.head;
        while (var3_3 != this.tail) {
            var4_4 = var3_3.method == null ? "NULL METHOD" : var3_3.method.getName();
            var5_5 = (TxnReplayableBase)var3_3.jdbcProxy;
            var6_6 = var5_5.thisProxyNameInLog;
            this.checkMemoryPressureAndLog();
            if (this.isSessionStateConsistencyDynamic() && (var3_3.replayContext == null || var3_3.serverAsksToEnqueue)) ** GOTO lbl13
            if (this.isSessionStateConsistencyDynamic() || !var5_5.isCreatingCallReplayable || !var5_5.isProxyReplayable) ** GOTO lbl-1000
            if (var3_3.replayContext == null && !TxnFailoverManagerImpl.postExecuteGetCalls.contains(var4_4) || var3_3.replayContext == null && TxnFailoverManagerImpl.postExecuteGetCalls.contains(var4_4) && var5_5.isCurrentExecuteReplayable || var3_3.serverAsksToEnqueue && var3_3.replayContext != null && var3_3.queueId >= 0 && var3_3.queueId < this.queueEmptyCounts.length && var3_3.queueEmptyCount == this.queueEmptyCounts[var3_3.queueId]) ** GOTO lbl13
            if (var3_3.queueEmptyCount == 0x7FFFFFFF) {
lbl13:
                // 3 sources

                var2_2 = var5_5.replayOneCall(var3_3, var1_1);
                if (!this.isSessionStateConsistencyDynamic() && var5_5 instanceof TxnReplayableStatement && var4_4.startsWith("execute")) {
                    var5_5.isCurrentExecuteReplayable = true;
                }
                if (!this.isSessionStateConsistencyDynamic() && var3_3.result != null) {
                    if (var3_3.result instanceof TxnReplayableBase) {
                        ((TxnReplayableBase)var3_3.result).isCreatingCallReplayable = true;
                    } else if (var3_3.result instanceof OracleConcreteProxy && (var7_7 = ((OracleConcreteProxy)var3_3.result).getConcreteProxy()) != null) {
                        var7_7.isCreatingCallReplayable = true;
                    }
                }
                if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                    this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, var1_1);
                }
            } else lbl-1000:
            // 2 sources

            {
                if (!this.isSessionStateConsistencyDynamic() && var5_5 instanceof TxnReplayableStatement && var4_4.startsWith("execute")) {
                    var5_5.isCurrentExecuteReplayable = false;
                }
                if (!this.isSessionStateConsistencyDynamic() && (var5_5 instanceof TxnReplayableBlob || var5_5 instanceof TxnReplayableClob || var5_5 instanceof TxnReplayableNClob || var5_5 instanceof TxnReplayableBfile) && var5_5.isProxyReplayable) {
                    var5_5.isProxyReplayable = false;
                }
                if (!this.isSessionStateConsistencyDynamic() && var3_3.result != null) {
                    if (var3_3.result instanceof TxnReplayableBase) {
                        ((TxnReplayableBase)var3_3.result).isCreatingCallReplayable = false;
                    } else if (var3_3.result instanceof OracleConcreteProxy && (var7_7 = ((OracleConcreteProxy)var3_3.result).getConcreteProxy()) != null) {
                        var7_7.isCreatingCallReplayable = false;
                    }
                }
                if (!this.isSessionStateConsistencyDynamic() && !var5_5.isCreatingCallReplayable && !"next".equals(var4_4) && var3_3.serverAsksToEnqueue && var3_3.replayContext != null && var3_3.queueId >= 0 && var3_3.queueId < this.queueEmptyCounts.length && var3_3.queueEmptyCount == this.queueEmptyCounts[var3_3.queueId]) {
                    this.disableReplayAndThrowException(var3_3.method, 399, "Replay disabled because server sent conflicting queueing instructions", var1_1);
                }
            }
            var3_3 = var3_3.nextEntry;
        }
        return var2_2;
    }

    private synchronized Object replayLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = null;
        if (this.tail != null) {
            CallHistoryEntry callHistoryEntry = this.tail;
            String string = callHistoryEntry.method == null ? NULL_METHOD_NAME : callHistoryEntry.method.getName();
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)callHistoryEntry.jdbcProxy;
            String string2 = txnReplayableBase.thisProxyNameInLog;
            if (this.isSessionStateConsistencyDynamic() && (callHistoryEntry.replayContext == null || callHistoryEntry.serverAsksToEnqueue) || !this.isSessionStateConsistencyDynamic() && txnReplayableBase.isCreatingCallReplayable && (callHistoryEntry.replayContext == null && !postExecuteGetCalls.contains(string) || callHistoryEntry.replayContext == null && postExecuteGetCalls.contains(string) && txnReplayableBase.isCurrentExecuteReplayable || callHistoryEntry.serverAsksToEnqueue && callHistoryEntry.replayContext != null && callHistoryEntry.queueId >= 0 && callHistoryEntry.queueId < this.queueEmptyCounts.length && callHistoryEntry.queueEmptyCount == this.queueEmptyCounts[callHistoryEntry.queueId] || callHistoryEntry.queueEmptyCount == Integer.MAX_VALUE)) {
                object = ((JDBCReplayable)this.tail.jdbcProxy).replayOneCall(this.tail, sQLRecoverableException);
            } else {
                this.disableReplayAndThrowException(this.tail.method, 372, "Replay disabled because of nonreplayable call", sQLRecoverableException);
            }
        }
        return object;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource oracleDataSource) {
        this.replayDataSource = oracleDataSource;
    }

    void setReplayInitiationTimeout(int n2) throws SQLException {
        this.replayInitiationTimeout = n2;
    }

    boolean isSessionStateConsistencyDynamic() {
        return this.isReplayInDynamicMode;
    }

    void setSessionStateConsistency(boolean bl) throws SQLException {
        this.isReplayInDynamicMode = !bl;
    }

    void setSessionStateRestoration(ReplayableConnection.StateRestorationType stateRestorationType) throws SQLException {
        this.stateRestorationType = stateRestorationType;
    }

    void setAutoAC(boolean bl) throws SQLException {
        this.isAutoAC = bl;
    }

    void setRequestSizeLimit(int n2) {
        this.requestSizeLimit = n2;
    }

    synchronized void beginRequest() throws SQLException {
        this.beginRequest(false);
    }

    synchronized void beginRequest(boolean bl) throws SQLException {
        Object object;
        boolean bl2 = true;
        if (this.lifecycle == ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED && this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            throw DatabaseError.createSqlException(391);
        }
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            bl2 = false;
        }
        oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
        if (this.isAutoAC || this.stateRestorationType.compareTo(ReplayableConnection.StateRestorationType.LEVEL1) >= 0) {
            this.saveCurrentSessionState(oracleConnection);
        } else {
            this.saveAutoCommitAndStateSignatures(oracleConnection);
        }
        this.requestStartTime = System.currentTimeMillis();
        oracleConnection.getReplayContext();
        if (this.isAutoAC && (object = this.savedDatabaseSessionState.getStateSignatures()) != null && (object.getSignatureFlags() & 0x20L) == 32L) {
            bl2 = false;
        }
        object = EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN);
        if (bl) {
            ((AbstractCollection)object).add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_NO_OPEN_HANDLES);
        }
        if (bl2) {
            ((AbstractCollection)object).add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED);
            if (!this.isAutoAC && !this.isReplayInDynamicMode) {
                ((AbstractCollection)object).add(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC);
            }
        }
        oracleConnection.setReplayOperations((EnumSet<OracleConnection.ReplayOperation>)object);
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sQLException = DatabaseError.createSqlException(392);
            throw sQLException;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        this.seenRoundtripCallInRequest = false;
        this.needStateSignatureSyncUp = false;
        this.callingDisableFromEndRequest = false;
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
        this.lobStreamInRequest = false;
        this.requestSize = 0;
        this.acStatistics.clearCurrentRequestSize();
        if (bl2) {
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        }
        this.acStatistics.incrementTotalRequests();
    }

    synchronized void endRequest() throws SQLException {
        block10: {
            block9: {
                oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
                this.callingDisableFromEndRequest = true;
                boolean bl = oracleConnection.isClosed();
                if (!bl) {
                    boolean bl2 = oracleConnection.getAutoCommit();
                    int n2 = oracleConnection.getTxnMode();
                    EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
                    if (!bl2 && n2 != 1 && enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                        try {
                            oracleConnection.rollback();
                        }
                        catch (SQLException sQLException) {
                        }
                        SQLException sQLException = DatabaseError.createSqlException(393);
                        throw sQLException;
                    }
                }
                this.acStatistics.incrementTotalCompletedRequests();
                this.acStatistics.updateRequestSizeHistogram(this.requestSize);
                this.requestSize = 0;
                this.acStatistics.clearCurrentRequestSize();
                this.lobStreamInRequest = false;
                if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                    return;
                }
                if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED) break block9;
                if (this.lifecycle != ReplayLifecycle.EXTERNALLY_DISABLED) break block10;
            }
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            return;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
        this.callingDisableFromEndRequest = false;
    }

    void disableReplay() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
    }

    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        if (!this.callingDisableFromEndRequest) {
            this.acStatistics.incrementReplayDisablingCount();
        }
        ReplayLifecycle replayLifecycle = this.lifecycle;
        oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        for (int i2 = 0; i2 < activeQueues; ++i2) {
            this.queueEmptyCounts[i2] = 0;
        }
        try {
            oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
            if (!this.seenRoundtripCallInRequest) {
                if (!this.isReplayInDynamicMode) {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                } else {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN));
                }
            } else if (!this.isReplayInDynamicMode) {
                if (!this.callingDisableFromEndRequest) {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                }
            } else {
                oracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            }
        }
        catch (SQLException sQLException) {
        }
    }

    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        this.originalOconn = null;
    }

    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (n2 == 0) {
            return;
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        throw sQLException;
    }

    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void disableReplayAndThrowSQLException(Method method, int n2, String string, SQLException sQLException) throws SQLException {
        this.disableReplayInternal(method, n2, string, null);
        this.killConnectionBeforeReplayDisabledException();
        throw sQLException;
    }

    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwOriginalExceptionWithReplayError(n2, string, sQLRecoverableException);
    }

    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.failReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        if (!this.doNotAbortConn) {
            this.killConnectionBeforeReplayDisabledException();
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        sQLRecoverableException.setNextException(sQLException);
        this.acStatistics.incrementFailedReplayCount();
        this.originalOconn = null;
        assert (this.callHittingOutage != null) : "Failed-call Method object is null";
        throw sQLRecoverableException;
    }

    void killConnectionBeforeReplayDisabledException() {
        final oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
        try {
            oracleConnection.abort();
        }
        catch (SQLException sQLException) {
        }
        try {
            executor.submit(new Runnable(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    TxnFailoverManagerImpl.this.closePhysicalConnection(oracleConnection);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 2.class.getDeclaredConstructor(TxnFailoverManagerImpl.class, oracle.jdbc.internal.OracleConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            });
        }
        catch (Exception exception) {
        }
    }

    void enableTxnMonitoring(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(MONITOR_TXN);
            statement.close();
        }
        catch (SQLException sQLException) {
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(395);
        }
    }

    void beginReplay(oracle.jdbc.internal.OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(BEGIN_REPLAY);
            statement.close();
            oracleConnection.setReplayingMode(true);
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLRecoverableException sQLRecoverableException2) {
            throw sQLRecoverableException2;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", sQLRecoverableException);
        }
    }

    void endReplay(oracle.jdbc.internal.OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(END_REPLAY);
            statement.close();
            oracleConnection.setReplayingMode(false);
            oracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            if (!this.isReplayInDynamicMode) {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            } else {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            }
            oracleConnection.getReplayContext();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLRecoverableException sQLRecoverableException2) {
            throw sQLRecoverableException2;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", sQLRecoverableException);
        }
    }

    boolean prepareReplay(oracle.jdbc.internal.OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException, boolean bl, short s2, String string) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            if (!this.isReplayInDynamicMode) {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
            }
            StateSignatures stateSignatures = this.savedDatabaseSessionState == null ? null : this.savedDatabaseSessionState.getStateSignatures();
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)(stateSignatures != null ? oracleConnection.prepareCall(PREPARE_REPLAY_2) : oracleConnection.prepareCall(PREPARE_REPLAY));
            oracleCallableStatement.setObject(1, (Object)this.oldLtxidForPrepareReplay);
            oracleCallableStatement.setInt(2, this.originalSeenRoundtripCallInRequest ? 1 : 0);
            oracleCallableStatement.setInt(3, bl ? 1 : 0);
            oracleCallableStatement.setInt(4, (int)s2);
            oracleCallableStatement.setString(5, string);
            if (stateSignatures != null) {
                BigDecimal bigDecimal = this.longToUB8(stateSignatures.getSignatureFlags());
                BigDecimal bigDecimal2 = this.longToUB8(stateSignatures.getClientSignature());
                BigDecimal bigDecimal3 = this.longToUB8(stateSignatures.getServerSignature());
                oracleCallableStatement.setBigDecimal(8, bigDecimal);
                oracleCallableStatement.setBigDecimal(9, bigDecimal2);
                oracleCallableStatement.setBigDecimal(10, bigDecimal3);
            }
            oracleCallableStatement.registerOutParameter(6, -7);
            oracleCallableStatement.registerOutParameter(7, -7);
            oracleCallableStatement.execute();
            bl2 = oracleCallableStatement.getBoolean(6);
            bl3 = oracleCallableStatement.getBoolean(7);
            oracleCallableStatement.close();
        }
        catch (SQLRecoverableException sQLRecoverableException2) {
            throw sQLRecoverableException2;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.disableReplayAndThrowException(null, 385, "Replay disabled because server prepare_replay call failed", sQLRecoverableException);
        }
        if (!bl3) {
            return bl2;
        }
        this.disableReplayAndThrowException(null, 386, "Replay disabled because of embedded commit", sQLRecoverableException);
        return false;
    }

    JDBCReplayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException sQLException) {
        int n2;
        boolean bl = false;
        if (sQLException instanceof SQLException && (n2 = sQLException.getErrorCode()) >= 370 && n2 < 400) {
            bl = true;
        }
        return bl;
    }

    private void closePhysicalConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
        }
    }

    LogicalTransactionId getLogicalTransactionId() {
        return this.ltxid;
    }

    LogicalTransactionId getLtxidAtOriginalOutage() {
        return this.ltxidAtOriginalOutage;
    }

    void setLogicalTransactionId(LogicalTransactionId logicalTransactionId) {
        this.ltxid = logicalTransactionId;
    }

    @Override
    public void onLogicalTransactionIdEvent(LogicalTransactionIdEvent logicalTransactionIdEvent) {
        LogicalTransactionId logicalTransactionId = logicalTransactionIdEvent.getLogicalTransactionId();
        this.setLogicalTransactionId(logicalTransactionId);
    }

    ReplayContext[] getReplayContext() {
        return this.replayContext;
    }

    void setReplayContext(ReplayContext[] replayContextArray) {
        this.replayContext = replayContextArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActiveQueues(int n2) {
        int n3;
        int n4 = (n2 + 1 - this.queueEmptyCounts.length) / 2 * 2;
        int n5 = this.queueEmptyCounts.length + n4;
        int[] nArray = new int[n5];
        System.arraycopy(this.queueEmptyCounts, 0, nArray, 0, this.queueEmptyCounts.length);
        for (n3 = this.queueEmptyCounts.length; n3 <= n2; ++n3) {
            nArray[n3] = 0;
        }
        for (n3 = n2 + 1; n3 <= n5; ++n3) {
            nArray[n3] = 0;
        }
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            this.queueEmptyCounts = nArray;
            activeQueues = n5;
        }
    }

    ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        ReplayStatistics replayStatistics = null;
        switch (statisticsReportType) {
            case FOR_CURRENT_CONNECTION: {
                replayStatistics = this.acStatistics;
                break;
            }
            case FOR_ALL_CONNECTIONS: {
                replayStatistics = this.replayDataSource.getReplayStatistics();
            }
        }
        return replayStatistics;
    }

    void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        switch (statisticsReportType) {
            case FOR_CURRENT_CONNECTION: {
                this.acStatistics.clear();
                break;
            }
            case FOR_ALL_CONNECTIONS: {
                this.replayDataSource.clearReplayStatistics();
            }
        }
    }

    protected ProxyFactory getProxyFactory() throws SQLException {
        return this.replayDataSource.getProxyFactory();
    }

    boolean isLobStreamInRequest() {
        return this.lobStreamInRequest;
    }

    void setLobStreamInRequest(boolean bl) {
        this.lobStreamInRequest = bl;
    }

    void saveAutoCommitAndStateSignatures(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        this.savedAutoCommit = oracleConnection.getAutoCommitInternal();
        if (this.svrSupportsSignature) {
            this.savedDatabaseSessionState = oracleConnection.getDatabaseSessionState();
        }
    }

    void saveCurrentSessionState(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        this.savedSessionProps = oracleConnection.getServerSessionInfo();
        this.savedClientInfo = oracleConnection.getClientInfoInternal();
        this.saveAutoCommitAndStateSignatures(oracleConnection);
    }

    void restoreAutoCommit(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        oracleConnection.setAutoCommit(this.savedAutoCommit);
    }

    void restoreCommonSessionState(oracle.jdbc.internal.OracleConnection oracleConnection, boolean bl) throws SQLException {
        Throwable throwable;
        Statement statement;
        String string;
        Object object;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        if (bl) {
            oracleConnection.setDatabaseSessionState(this.savedDatabaseSessionState);
        }
        StringBuilder stringBuilder = new StringBuilder("ALTER SESSION SET").append(" NLS_CALENDAR = '").append(this.savedSessionProps.get(NLS_CALENDAR_PROPERTY)).append("'").append(" NLS_CURRENCY = '").append(this.savedSessionProps.get(NLS_CURRENCY_PROPERTY)).append("'").append(" NLS_DATE_FORMAT = '").append(this.savedSessionProps.get(NLS_DATE_FORMAT_PROPERTY)).append("'").append(" NLS_DATE_LANGUAGE = '").append(this.savedSessionProps.get(NLS_DATE_LANGUAGE_PROPERTY)).append("'").append(" NLS_DUAL_CURRENCY = '").append(this.savedSessionProps.get(NLS_DUAL_CURRENCY_PROPERTY)).append("'").append(" NLS_ISO_CURRENCY = '").append(this.savedSessionProps.get(NLS_ISO_CURRENCY_PROPERTY)).append("'").append(" NLS_LANGUAGE = '").append(this.savedSessionProps.get(NLS_LANGUAGE_PROPERTY)).append("'").append(" NLS_LENGTH_SEMANTICS = '").append(this.savedSessionProps.get(NLS_LENGTH_SEMANTICS_PROPERTY)).append("'").append(" NLS_NCHAR_CONV_EXCP = '").append(this.savedSessionProps.get(NLS_NCHAR_CONV_EXCP_PROPERTY)).append("'").append(" NLS_NUMERIC_CHARACTERS = '").append(this.savedSessionProps.get(NLS_NUMERIC_CHARACTERS_PROPERTY)).append("'").append(" NLS_SORT = '").append(this.savedSessionProps.get(NLS_SORT_PROPERTY)).append("'").append(" NLS_TERRITORY = '").append(this.savedSessionProps.get(NLS_TERRITORY_PROPERTY)).append("'").append(" NLS_TIME_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_FORMAT_PROPERTY)).append("'").append(" NLS_TIME_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIME_TZ_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_FORMAT_PROPERTY)).append("'").append(" NLS_TIMESTAMP_TZ_FORMAT = '").append(this.savedSessionProps.get(NLS_TIMESTAMP_TZ_FORMAT_PROPERTY)).append("'");
        String string7 = this.savedSessionProps.getProperty(TIME_ZONE_PROPERTY);
        if (string7 != null && string7.length() > 3 && string7.startsWith("GMT")) {
            string7 = string7.substring(3);
        }
        stringBuilder.append(" TIME_ZONE = '").append(string7).append("'");
        String string8 = this.savedSessionProps.getProperty(SCHEMA_NAME_PROPERTY);
        if (string8 != null && !"".equals(string8) && !string8.equals(oracleConnection.getCurrentSchema())) {
            stringBuilder.append(" CURRENT_SCHEMA = ").append(string8);
        }
        if ((string6 = this.savedSessionProps.getProperty(ERROR_OVERLAP_PROPERTY)) != null && !"".equals(string6)) {
            stringBuilder.append(" ERROR_ON_OVERLAP_TIME = ").append(string6);
        }
        if ((string5 = this.savedSessionProps.getProperty(EDITION_PROPERTY)) != null && !"".equals(string5)) {
            stringBuilder.append(" EDITION = ").append(string5);
        }
        if ((string4 = this.savedSessionProps.getProperty(SQL_TXLP_PROPERTY)) != null && !"".equals(string4)) {
            stringBuilder.append(" SQL_TRANSLATION_PROFILE = ").append(string4);
        }
        if ((string3 = this.savedSessionProps.getProperty(ROW_ARCHIVAL_PROPERTY)) != null && !"".equals(string3)) {
            stringBuilder.append(" ROW ARCHIVAL VISIBILITY = ").append(string3);
        }
        String string9 = this.savedSessionProps.getProperty(CONTAINER_PROPERTY);
        String string10 = this.savedSessionProps.getProperty(SERVICE_PROPERTY);
        String string11 = "";
        if (string9 != null && !"".equals(string9)) {
            string2 = this.getContainer(oracleConnection);
            object = this.getService(oracleConnection);
            if (!string9.equals(string2) || !string10.equals(object)) {
                string11 = "ALTER SESSION SET CONTAINER = " + string9 + " SERVICE = \"" + string10 + "\"";
            }
        }
        string2 = stringBuilder.toString();
        object = oracleConnection.createStatement();
        Object object2 = null;
        try {
            object.execute(string2);
            if (!"".equals(string11)) {
                object.execute(string11);
            }
        }
        catch (Throwable throwable2) {
            object2 = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        object.close();
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object2).addSuppressed(throwable3);
                    }
                } else {
                    object.close();
                }
            }
        }
        object = this.savedSessionProps.getProperty(ENABLED_ROLE_NAMES_PROPERTY);
        if (object != null && !"".equals(object)) {
            object2 = ((String)object).replaceAll("\"", "");
            string = "SET ROLE " + (String)object2;
            statement = oracleConnection.createStatement();
            throwable = null;
            try {
                statement.execute(string);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        oracleConnection.setClientInfo(this.savedClientInfo);
        object2 = this.savedSessionProps.getProperty(CLIENT_INFO_PROPERTY);
        if (object2 != null && !"".equals(object2)) {
            string = "begin dbms_application_info.set_client_info(?); end;";
            statement = oracleConnection.prepareCall(string);
            throwable = null;
            try {
                statement.setString(1, (String)object2);
                statement.execute();
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        this.restoreAutoCommit(oracleConnection);
    }

    private String getContainer(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        String string = "";
        try (Statement statement = oracleConnection.createStatement();
             ResultSet resultSet = statement.executeQuery(CONTAINER_QUERY);){
            if (resultSet.next()) {
                string = resultSet.getString(1);
            }
        }
        return string;
    }

    private String getService(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        return oracleConnection.getServerSessionInfo().getProperty(SERVICE_PROPERTY);
    }

    private boolean checkACChange(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        Properties properties = oracleConnection.getServerSessionInfo();
        String string = properties.getProperty(FAILOVER_TYPE_PROPERTY);
        if (string != null && !"".equals(string)) {
            int n2;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
            if (!this.isAutoAC) {
                return (n2 & 8) == 8 && this.isReplayInDynamicMode == ((n2 & 0x10) == 0) || (n2 & 0x20) == 32;
            }
            return (n2 & 0x20) == 32;
        }
        return false;
    }

    boolean isStateUnrestorable() throws SQLException {
        oracle.jdbc.internal.OracleConnection oracleConnection;
        StateSignatures stateSignatures;
        return this.isAutoAC && (stateSignatures = (oracleConnection = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate()).getDatabaseSessionState().getStateSignatures()) != null && (stateSignatures.getSignatureFlags() & 0x24L) > 0L;
    }

    void setStateSignatureSyncUp() {
        if (this.tail.callException == null) {
            this.needStateSignatureSyncUp = true;
        }
    }

    void checkStateSignatureSyncUp() {
        if (this.needStateSignatureSyncUp) {
            oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.connectionProxy.getDelegate();
            try {
                oracleConnection.pingDatabase();
            }
            catch (Throwable throwable) {
            }
        }
    }

    void checkMemoryPressureAndLog() {
        if (seenMemoryPressure) {
            String string = this.replayDataSource.getReplayStatisticsString();
            if (string != null) {
            }
            if (System.currentTimeMillis() - seenMemoryPressureTS >= 120000L) {
                seenMemoryPressure = false;
                this.replayDataSource.clearDoneDumpOnMemoryPressure();
            }
        }
    }

    private BigDecimal longToUB8(long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        BigInteger bigInteger2 = l2 >= 0L ? bigInteger : bigInteger.add(MASK);
        return new BigDecimal(bigInteger2);
    }

    final CallHistoryEntry getCallHistoryTail() {
        return this.tail;
    }

    public static void cleanup() {
        MEMGUARD_LISTENER.unregister();
    }

    final void removeReplayStatistics() {
        this.replayDataSource.removeReplayStatistics(this.acStatistics);
    }

    static {
        try {
            $$$methodRef$$$71 = TxnFailoverManagerImpl.class.getDeclaredConstructor(TxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$70 = TxnFailoverManagerImpl.class.getDeclaredMethod("access$000", TxnFailoverManagerImpl.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$69 = TxnFailoverManagerImpl.class.getDeclaredMethod("removeReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$68 = TxnFailoverManagerImpl.class.getDeclaredMethod("cleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$67 = TxnFailoverManagerImpl.class.getDeclaredMethod("getCallHistoryTail", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$66 = TxnFailoverManagerImpl.class.getDeclaredMethod("longToUB8", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$65 = TxnFailoverManagerImpl.class.getDeclaredMethod("checkMemoryPressureAndLog", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$64 = TxnFailoverManagerImpl.class.getDeclaredMethod("checkStateSignatureSyncUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$63 = TxnFailoverManagerImpl.class.getDeclaredMethod("setStateSignatureSyncUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$62 = TxnFailoverManagerImpl.class.getDeclaredMethod("isStateUnrestorable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$61 = TxnFailoverManagerImpl.class.getDeclaredMethod("checkACChange", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$60 = TxnFailoverManagerImpl.class.getDeclaredMethod("getService", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$59 = TxnFailoverManagerImpl.class.getDeclaredMethod("getContainer", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$58 = TxnFailoverManagerImpl.class.getDeclaredMethod("restoreCommonSessionState", oracle.jdbc.internal.OracleConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$57 = TxnFailoverManagerImpl.class.getDeclaredMethod("restoreAutoCommit", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$56 = TxnFailoverManagerImpl.class.getDeclaredMethod("saveCurrentSessionState", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$55 = TxnFailoverManagerImpl.class.getDeclaredMethod("saveAutoCommitAndStateSignatures", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$54 = TxnFailoverManagerImpl.class.getDeclaredMethod("setLobStreamInRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$53 = TxnFailoverManagerImpl.class.getDeclaredMethod("isLobStreamInRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$52 = TxnFailoverManagerImpl.class.getDeclaredMethod("getProxyFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$51 = TxnFailoverManagerImpl.class.getDeclaredMethod("clearReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$50 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayStatistics", ReplayableConnection.StatisticsReportType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$49 = TxnFailoverManagerImpl.class.getDeclaredMethod("addActiveQueues", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$48 = TxnFailoverManagerImpl.class.getDeclaredMethod("setReplayContext", ReplayContext[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$47 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayContext", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$46 = TxnFailoverManagerImpl.class.getDeclaredMethod("onLogicalTransactionIdEvent", LogicalTransactionIdEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$45 = TxnFailoverManagerImpl.class.getDeclaredMethod("setLogicalTransactionId", LogicalTransactionId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$44 = TxnFailoverManagerImpl.class.getDeclaredMethod("getLtxidAtOriginalOutage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$43 = TxnFailoverManagerImpl.class.getDeclaredMethod("getLogicalTransactionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$42 = TxnFailoverManagerImpl.class.getDeclaredMethod("closePhysicalConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$41 = TxnFailoverManagerImpl.class.getDeclaredMethod("isReplayFailure", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$40 = TxnFailoverManagerImpl.class.getDeclaredMethod("getConnectionProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$39 = TxnFailoverManagerImpl.class.getDeclaredMethod("prepareReplay", oracle.jdbc.internal.OracleConnection.class, SQLRecoverableException.class, Boolean.TYPE, Short.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$38 = TxnFailoverManagerImpl.class.getDeclaredMethod("endReplay", oracle.jdbc.internal.OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$37 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginReplay", oracle.jdbc.internal.OracleConnection.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$36 = TxnFailoverManagerImpl.class.getDeclaredMethod("enableTxnMonitoring", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$35 = TxnFailoverManagerImpl.class.getDeclaredMethod("killConnectionBeforeReplayDisabledException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$34 = TxnFailoverManagerImpl.class.getDeclaredMethod("throwOriginalExceptionWithReplayError", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$33 = TxnFailoverManagerImpl.class.getDeclaredMethod("failReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$32 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowOriginalError", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$31 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowSQLException", Method.class, Integer.TYPE, String.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$30 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayAndThrowException", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$29 = TxnFailoverManagerImpl.class.getDeclaredMethod("throwReplayExceptionInternal", Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$28 = TxnFailoverManagerImpl.class.getDeclaredMethod("failReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$27 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplayInternal", Method.class, Integer.TYPE, String.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$26 = TxnFailoverManagerImpl.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$25 = TxnFailoverManagerImpl.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$24 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginRequest", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = TxnFailoverManagerImpl.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = TxnFailoverManagerImpl.class.getDeclaredMethod("setRequestSizeLimit", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = TxnFailoverManagerImpl.class.getDeclaredMethod("setAutoAC", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = TxnFailoverManagerImpl.class.getDeclaredMethod("setSessionStateRestoration", ReplayableConnection.StateRestorationType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnFailoverManagerImpl.class.getDeclaredMethod("setSessionStateConsistency", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnFailoverManagerImpl.class.getDeclaredMethod("isSessionStateConsistencyDynamic", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnFailoverManagerImpl.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnFailoverManagerImpl.class.getDeclaredMethod("setDataSource", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnFailoverManagerImpl.class.getDeclaredMethod("getReplayLifecycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayAllBeforeLastCall", SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnFailoverManagerImpl.class.getDeclaredMethod("invokeCallbackAfterReconnect", oracle.jdbc.internal.OracleConnection.class, Boolean.TYPE, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnFailoverManagerImpl.class.getDeclaredMethod("replayWithLocalCallsOnly", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnFailoverManagerImpl.class.getDeclaredMethod("handleOutageInternal", SQLRecoverableException.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnFailoverManagerImpl.class.getDeclaredMethod("handleOutage", Method.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnFailoverManagerImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnFailoverManagerImpl.class.getDeclaredMethod("purgeForSameProxy", Set.class, CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnFailoverManagerImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnFailoverManagerImpl.class.getDeclaredMethod("update", Object.class, CallHistoryEntry.class, Object.class, String.class, Long.TYPE, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnFailoverManagerImpl.class.getDeclaredMethod("dumpHistory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnFailoverManagerImpl.class.getDeclaredMethod("record", Object.class, Method.class, Object[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnFailoverManagerImpl.class.getDeclaredMethod("remove", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnFailoverManagerImpl.class.getDeclaredMethod("append", CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnFailoverManagerImpl.class.getDeclaredMethod("getFailoverManager", TxnReplayableBase.class, OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        activeQueues = 2;
        postExecuteGetCalls = new HashSet<String>(Arrays.asList("getGeneratedKeys", "getMoreResults", "getResultSet", "getUpdateCount", "getMetaData", "getArray", "getBigDecimal", "getBlob", "getBoolean", "getByte", "getBytes", "getCharacterStream", "getClob", "getDate", "getDouble", "getFloat", "getInt", "getLong", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRowId", "getShort", "getSQLXML", "getString", "getTime", "getTimestamp", "getURL", "wasNull", "getReturnResultSet", "getARRAY", "getAsciiStream", "getBFILE", "getBfile", "getBinaryStream", "getBLOB", "getCHAR", "getCLOB", "getCursor", "getCustomDatum", "getORAData", "getAnyDataEmbeddedObject", "getDATE", "getNUMBER", "getOPAQUE", "getOracleObject", "getRAW", "getREF", "getROWID", "getSTRUCT", "getINTERVALYM", "getINTERVALDS", "getTIMESTAMP", "getTIMESTAMPTZ", "getTIMESTAMPLTZ", "getUnicodeStream", "getPlsqlIndexTable", "getOraclePlsqlIndexTable"));
        executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(null, runnable, THREAD_NAME);
                thread.setPriority(5);
                thread.setDaemon(true);
                return thread;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("newThread", Runnable.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        seenMemoryPressure = false;
        seenMemoryPressureTS = 0L;
        MASK = new BigInteger("18446744073709551616");
        MEMGUARD_LISTENER = MemGuardListener.SOLE_INSTANCE;
    }

    @DefaultLogger(value="oracle.jdbc.internal.replay")
    @Supports(value={Feature.APPLICATION_CONTINUITY})
    private static final class MemGuardListener
    implements NotificationListener {
        private static final MemGuardListener SOLE_INSTANCE;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        private MemGuardListener() {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)memoryMXBean);
            notificationEmitter.addNotificationListener(this, null, null);
            Pattern pattern = Pattern.compile(".*Old.*");
            for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
                if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isCollectionUsageThresholdSupported() || !pattern.matcher(memoryPoolMXBean.getName()).matches() || memoryPoolMXBean.getCollectionUsageThreshold() != 0L) continue;
                MemoryUsage memoryUsage = memoryPoolMXBean.getUsage();
                final long l2 = (long)(memoryUsage.getMax() == -1L ? (double)Runtime.getRuntime().maxMemory() * 0.9 : (double)memoryUsage.getMax() * 0.9);
                final MemoryPoolMXBean memoryPoolMXBean2 = memoryPoolMXBean;
                AccessController.doPrivileged(new PrivilegedAction(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    public Object run() {
                        memoryPoolMXBean2.setCollectionUsageThreshold(l2);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(MemGuardListener.class, MemoryPoolMXBean.class, Long.TYPE);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                });
            }
        }

        @Override
        public void handleNotification(Notification notification, Object object) {
            String string = notification.getType();
            if (string.equals("java.management.memory.collection.threshold.exceeded")) {
                seenMemoryPressureTS = System.currentTimeMillis();
                seenMemoryPressure = true;
            }
        }

        public void unregister() {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)memoryMXBean);
            try {
                notificationEmitter.removeNotificationListener(this, null, null);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
            }
        }

        static {
            try {
                $$$methodRef$$$3 = MemGuardListener.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            try {
                $$$methodRef$$$2 = MemGuardListener.class.getDeclaredMethod("access$100", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            try {
                $$$methodRef$$$1 = MemGuardListener.class.getDeclaredMethod("unregister", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            try {
                $$$methodRef$$$0 = MemGuardListener.class.getDeclaredMethod("handleNotification", Notification.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
            SOLE_INSTANCE = new MemGuardListener();
        }
    }

    static final class ReplayLifecycle
    extends Enum<ReplayLifecycle> {
        public static final /* enum */ ReplayLifecycle ENABLED_NOT_REPLAYING;
        public static final /* enum */ ReplayLifecycle INTERNALLY_FAILED;
        public static final /* enum */ ReplayLifecycle INTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle ALWAYS_DISABLED;
        public static final /* enum */ ReplayLifecycle EXTERNALLY_DISABLED;
        public static final /* enum */ ReplayLifecycle REPLAYING_CALLBACK;
        public static final /* enum */ ReplayLifecycle REPLAYING;
        public static final /* enum */ ReplayLifecycle REPLAYING_LASTCALL;
        private static final /* synthetic */ ReplayLifecycle[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ReplayLifecycle[] values() {
            return (ReplayLifecycle[])$VALUES.clone();
        }

        public static ReplayLifecycle valueOf(String string) {
            return Enum.valueOf(ReplayLifecycle.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = ReplayLifecycle.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ReplayLifecycle.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ReplayLifecycle.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            ENABLED_NOT_REPLAYING = new ReplayLifecycle();
            INTERNALLY_FAILED = new ReplayLifecycle();
            INTERNALLY_DISABLED = new ReplayLifecycle();
            ALWAYS_DISABLED = new ReplayLifecycle();
            EXTERNALLY_DISABLED = new ReplayLifecycle();
            REPLAYING_CALLBACK = new ReplayLifecycle();
            REPLAYING = new ReplayLifecycle();
            REPLAYING_LASTCALL = new ReplayLifecycle();
            $VALUES = new ReplayLifecycle[]{ENABLED_NOT_REPLAYING, INTERNALLY_FAILED, INTERNALLY_DISABLED, ALWAYS_DISABLED, EXTERNALLY_DISABLED, REPLAYING_CALLBACK, REPLAYING, REPLAYING_LASTCALL};
        }
    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long checksum;
        boolean openAcrossPurge;
        int queueId;
        int queueEmptyCount;
        ReplayContext[] replayContext;
        boolean serverAsksToEnqueue;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        CallHistoryEntry(Object object, Method method, Object[] objectArray, String string) {
            this.jdbcProxy = object;
            this.method = method;
            this.args = objectArray;
            this.result = null;
            this.callStatus = string;
            this.openAcrossPurge = false;
        }

        @DisableTrace
        public String toString() {
            String string = "CallHistoryEntry: method.getName()=" + this.method.getName() + ", queueId=" + this.queueId + ", queueEmptyCount=" + this.queueEmptyCount + ", serverAsksToEnqueue=" + this.serverAsksToEnqueue + ", replayContext=" + this.replayContext;
            if (this.replayContext != null) {
                for (int i2 = 0; i2 < this.replayContext.length; ++i2) {
                    string = string + this.replayContext[i2];
                }
            }
            return string + "\n";
        }

        static {
            try {
                $$$methodRef$$$0 = CallHistoryEntry.class.getDeclaredConstructor(Object.class, Method.class, Object[].class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

