/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.jdbc.proxy.AnnotationsRegistry;
import oracle.jdbc.proxy.ClassGenerator;
import oracle.jdbc.proxy.ExtractDelegatePermission;
import oracle.jdbc.proxy.GeneratedProxiesRegistry;
import oracle.jdbc.proxy.NullProxy;
import oracle.jdbc.proxy.WeakIdentityHashMap;
import oracle.jdbc.proxy._Proxy_;

public class ProxyFactory {
    public static final String DEFAULT_PROXY_PACKAGE = "oracle.jdbc.proxy";
    final AnnotationsRegistry annotationsRegistry = new AnnotationsRegistry();
    private final GeneratedProxiesRegistry generatedRegistry = new GeneratedProxiesRegistry();
    private final Map<Class, Constructor> delegateClassToProxyConstructor = new ConcurrentHashMap<Class, Constructor>();
    private final Map<Object, WeakReference<Object>> delegateToProxy = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final Map<Class, Class> delegateToMostSuitableIface = new ConcurrentHashMap<Class, Class>();
    private static final Object STALE_DELEGATE;
    private static final Class EMPTY_VALUE;
    private ClassLoader classLoader = null;
    private final String proxyPackage;
    private static final ExtractDelegatePermission EXTRACT_DELEGATE_PERMISSION;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    private ProxyFactory(String string) {
        this.proxyPackage = string;
    }

    public static ProxyFactory createProxyFactory(String string, Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(string);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createProxyFactory(Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(String string, Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(string);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public static ProxyFactory createJDBCProxyFactory(Class ... classArray) {
        ProxyFactory proxyFactory = new ProxyFactory(DEFAULT_PROXY_PACKAGE);
        proxyFactory.annotationsRegistry.register(NullProxy.class);
        proxyFactory.annotationsRegistry.register(classArray);
        return proxyFactory;
    }

    public final boolean isProxied(Class clazz) {
        return this.annotationsRegistry.containsKey(clazz);
    }

    public final <T> T proxyFor(T t2) {
        return this.proxyFor(t2, this);
    }

    public final <T> T proxyFor(T t2, Object object) {
        return this.proxyForCache(t2, object, null, null);
    }

    public final <T> T proxyForCreate(T t2, Object object, Map<Object, WeakReference<Object>> map, Method method) {
        Constructor constructor;
        if (null == t2) {
            return null;
        }
        Class<?> clazz = t2.getClass();
        Class clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        if (null == map) {
            Map<Object, Object> map2 = map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        if (null == (constructor = this.getProxyConstructor(clazz2, clazz))) {
            return this.createProxy(clazz2, t2, object, map);
        }
        try {
            return constructor.newInstance(t2, object, this, map);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public final <T> T proxyForCache(T t2, Object object, Map<Object, WeakReference<Object>> map, Method method) {
        if (null == t2) {
            return null;
        }
        if (t2 instanceof _Proxy_) {
            return t2;
        }
        Class<?> clazz = t2.getClass();
        Class clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        Method method2 = value.getProxyAccessGetter();
        Method method3 = value.getProxyAccessSetter();
        if (null == map) {
            map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        try {
            Object t3;
            WeakReference<Object> weakReference;
            if (null != method2) {
                weakReference = method2.invoke(t2, new Object[0]);
                if (null != weakReference) {
                    return (T)weakReference;
                }
            } else {
                weakReference = map.get(t2);
                if (null != weakReference && null != (t3 = weakReference.get())) {
                    if (STALE_DELEGATE == t3) {
                        throw new RuntimeException("stale delegate");
                    }
                    return t3;
                }
            }
            if (null == (weakReference = this.getProxyConstructor(clazz2, clazz))) {
                t3 = this.createProxy(clazz2, t2, object, map);
                if (null != method3) {
                    method3.invoke(t2, t3);
                } else {
                    map.put(t2, new WeakReference(t3));
                }
                return t3;
            }
            t3 = ((Constructor)((Object)weakReference)).newInstance(t2, object, this, map);
            if (null != method3) {
                method3.invoke(t2, t3);
            } else {
                map.put(t2, new WeakReference(t3));
            }
            return t3;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public final <T> T proxyForCreateCache(T t2, Object object, Map<Object, WeakReference<Object>> map, Method method) {
        if (null == t2) {
            return null;
        }
        if (t2 instanceof _Proxy_) {
            return t2;
        }
        Class<?> clazz = t2.getClass();
        Class clazz2 = this.findMostSuitableIface(clazz);
        if (null != method && null != clazz2 && !method.getReturnType().isAssignableFrom(clazz2)) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz2);
        if (null == value) {
            return t2;
        }
        if (null == map) {
            map = value.isProxyLocale() ? new WeakIdentityHashMap() : this.delegateToProxy;
        }
        Method method2 = value.getProxyAccessSetter();
        Constructor constructor = this.getProxyConstructor(clazz2, clazz);
        try {
            if (null == constructor) {
                T t3 = this.createProxy(clazz2, t2, object, map);
                if (null != method2) {
                    method2.invoke(t2, t3);
                } else {
                    map.put(t2, new WeakReference<T>(t3));
                }
                return t3;
            }
            Object t4 = constructor.newInstance(t2, object, this, map);
            if (null != method2) {
                method2.invoke(t2, t4);
            } else {
                map.put(t2, new WeakReference(t4));
            }
            return t4;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    public <T> void updateDelegate(Object object, T t2, T t3) {
        this.delegateToProxy.put(t2, new WeakReference<Object>(STALE_DELEGATE));
        this.delegateToProxy.put(t3, new WeakReference<Object>(object));
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static final Object extractDelegate(_Proxy_ _Proxy_2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (null != securityManager) {
            securityManager.checkPermission(EXTRACT_DELEGATE_PERMISSION);
        }
        return _Proxy_2._getDelegate_();
    }

    private <T> T createProxy(Class clazz, T t2, Object object, Map<Object, WeakReference<Object>> map) {
        if (null == clazz) {
            return t2;
        }
        AnnotationsRegistry.Value value = this.annotationsRegistry.get(clazz);
        Class clazz2 = value.getSuperclass();
        GeneratedProxiesRegistry.Value value2 = this.generatedRegistry.get(this.proxyPackage, clazz, clazz2);
        Constructor constructor = null == value2 ? this.prepareProxy(clazz, clazz2) : value2.getConstructor();
        try {
            return constructor.newInstance(t2, object, this, map);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Constructor prepareProxy(Class clazz, Class clazz2) {
        Constructor<?> constructor;
        Class<?> clazz3 = null;
        try {
            clazz3 = Class.forName(new GeneratedProxiesRegistry.Key(this.proxyPackage, clazz, clazz2).toString(), true, null == this.classLoader ? clazz2.getClassLoader() : this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz3 = ClassGenerator.generate(this.proxyPackage, clazz, clazz2, this.annotationsRegistry, this.classLoader);
        }
        try {
            constructor = clazz3.getConstructor(clazz, Object.class, ProxyFactory.class, Map.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        this.generatedRegistry.put(this.proxyPackage, clazz, clazz2, new GeneratedProxiesRegistry.Value(null, null, clazz3, constructor));
        return constructor;
    }

    private Constructor getProxyConstructor(Class clazz, Class clazz2) {
        if (null == clazz2) {
            return null;
        }
        Object object = this.delegateClassToProxyConstructor.get(clazz2);
        if (null != object) {
            return object;
        }
        if (null == clazz) {
            return null;
        }
        object = this.generatedRegistry.get(this.proxyPackage, clazz, this.annotationsRegistry.get(clazz).getSuperclass());
        if (null == object) {
            return null;
        }
        Constructor constructor = ((GeneratedProxiesRegistry.Value)object).getConstructor();
        if (null != constructor) {
            this.delegateClassToProxyConstructor.put(clazz2, constructor);
        }
        return constructor;
    }

    private Class findMostSuitableIface(Class clazz) {
        if (null == clazz) {
            return null;
        }
        Class clazz2 = this.delegateToMostSuitableIface.get(clazz);
        if (null != clazz2) {
            return EMPTY_VALUE != clazz2 ? clazz2 : null;
        }
        int n2 = -1;
        Class clazz3 = null;
        for (Class clazz4 : this.annotationsRegistry.keySet()) {
            int n3 = this.intersectionCardinality(clazz, clazz4);
            if (n3 < 1 || n3 <= n2) continue;
            n2 = n3;
            clazz3 = clazz4;
        }
        this.delegateToMostSuitableIface.put(clazz, null != clazz3 ? clazz3 : EMPTY_VALUE);
        return clazz3;
    }

    private int intersectionCardinality(Class clazz, Class clazz2) {
        HashSet<Class> hashSet = new HashSet<Class>();
        this.collectIfaces(clazz2, hashSet);
        HashSet<Class> hashSet2 = new HashSet<Class>();
        this.collectIfaces(clazz, hashSet2);
        int n2 = hashSet.size();
        hashSet.removeAll(hashSet2);
        if (hashSet.size() > 0) {
            return -1;
        }
        return n2;
    }

    private void collectIfaces(Class clazz, Set<Class> set) {
        if (clazz.isInterface()) {
            set.add(clazz);
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.collectIfaces(clazz2, set);
        }
        Class clazz3 = clazz.getSuperclass();
        if (null != clazz3) {
            this.collectIfaces(clazz3, set);
        }
    }

    static {
        try {
            $$$methodRef$$$20 = ProxyFactory.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ProxyFactory.class.getDeclaredMethod("collectIfaces", Class.class, Set.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ProxyFactory.class.getDeclaredMethod("intersectionCardinality", Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ProxyFactory.class.getDeclaredMethod("findMostSuitableIface", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ProxyFactory.class.getDeclaredMethod("getProxyConstructor", Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ProxyFactory.class.getDeclaredMethod("prepareProxy", Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ProxyFactory.class.getDeclaredMethod("createProxy", Class.class, Object.class, Object.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ProxyFactory.class.getDeclaredMethod("extractDelegate", _Proxy_.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ProxyFactory.class.getDeclaredMethod("getClassLoader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ProxyFactory.class.getDeclaredMethod("setClassLoader", ClassLoader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ProxyFactory.class.getDeclaredMethod("updateDelegate", Object.class, Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ProxyFactory.class.getDeclaredMethod("proxyForCreateCache", Object.class, Object.class, Map.class, Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ProxyFactory.class.getDeclaredMethod("proxyForCache", Object.class, Object.class, Map.class, Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ProxyFactory.class.getDeclaredMethod("proxyForCreate", Object.class, Object.class, Map.class, Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ProxyFactory.class.getDeclaredMethod("proxyFor", Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ProxyFactory.class.getDeclaredMethod("proxyFor", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ProxyFactory.class.getDeclaredMethod("isProxied", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ProxyFactory.class.getDeclaredMethod("createJDBCProxyFactory", Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ProxyFactory.class.getDeclaredMethod("createJDBCProxyFactory", String.class, Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ProxyFactory.class.getDeclaredMethod("createProxyFactory", Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ProxyFactory.class.getDeclaredMethod("createProxyFactory", String.class, Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        STALE_DELEGATE = new Object();
        EMPTY_VALUE = EMPTY_CLASS.class;
        EXTRACT_DELEGATE_PERMISSION = new ExtractDelegatePermission();
    }

    private static final class EMPTY_CLASS {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;

        private EMPTY_CLASS() {
        }

        static {
            try {
                $$$methodRef$$$0 = EMPTY_CLASS.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

