/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeTIMESTAMP
extends OracleType
implements Serializable {
    static final long serialVersionUID = 3948043338303602796L;
    int precision = 0;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    protected OracleTypeTIMESTAMP() {
    }

    public OracleTypeTIMESTAMP(OracleConnection oracleConnection) {
    }

    @Override
    public int getTypeCode() {
        return 93;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readByte();
    }

    @Override
    public int getScale() throws SQLException {
        return 0;
    }

    @Override
    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.precision);
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new TIMESTAMP(byArray);
            }
            case 2: {
                return TIMESTAMP.toTimestamp(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59).fillInStackTrace();
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMP tIMESTAMP;
        block10: {
            tIMESTAMP = null;
            if (object != null) {
                try {
                    if (object instanceof TIMESTAMP) {
                        tIMESTAMP = (TIMESTAMP)object;
                        break block10;
                    }
                    if (object instanceof byte[]) {
                        tIMESTAMP = new TIMESTAMP((byte[])object);
                        break block10;
                    }
                    if (object instanceof Timestamp) {
                        tIMESTAMP = new TIMESTAMP((Timestamp)object);
                        break block10;
                    }
                    if (object instanceof DATE) {
                        tIMESTAMP = new TIMESTAMP((DATE)object);
                        break block10;
                    }
                    if (object instanceof String) {
                        tIMESTAMP = new TIMESTAMP((String)object);
                        break block10;
                    }
                    if (object instanceof Date) {
                        tIMESTAMP = new TIMESTAMP((Date)object);
                        break block10;
                    }
                    if (object instanceof Time) {
                        tIMESTAMP = new TIMESTAMP((Time)object);
                        break block10;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
                }
                catch (Exception exception) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object).fillInStackTrace();
                }
            }
        }
        return tIMESTAMP;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90).fillInStackTrace();
    }

    static {
        try {
            $$$methodRef$$$10 = OracleTypeTIMESTAMP.class.getDeclaredConstructor(OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleTypeTIMESTAMP.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleTypeTIMESTAMP.class.getDeclaredMethod("unpickle81rec", UnpickleContext.class, Integer.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleTypeTIMESTAMP.class.getDeclaredMethod("toDatum", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTypeTIMESTAMP.class.getDeclaredMethod("toObject", byte[].class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTypeTIMESTAMP.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTypeTIMESTAMP.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTypeTIMESTAMP.class.getDeclaredMethod("getPrecision", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTypeTIMESTAMP.class.getDeclaredMethod("getScale", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTypeTIMESTAMP.class.getDeclaredMethod("parseTDSrec", TDSReader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTypeTIMESTAMP.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

