/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Stack;
import java.util.logging.Logger;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class ByteArray {
    protected long position = 0L;
    private Stack<Long> positions = new Stack();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;

    ByteArray() {
    }

    abstract long length();

    abstract long getCapacity();

    final long getPosition() {
        return this.position;
    }

    final void setPosition(long l2) {
        assert (l2 >= 0L) : "index: " + l2;
        assert (this.positions.isEmpty()) : "positions: " + this.positions.size();
        this.position = l2;
    }

    final void pushPosition(long l2) {
        assert (l2 >= 0L) : "newPosition: " + l2;
        this.positions.push(this.position);
        this.position = l2;
    }

    final long popPosition() {
        assert (!this.positions.isEmpty()) : "positions: " + this.positions.size();
        this.position = this.positions.pop();
        return this.position;
    }

    final void reset() {
        this.setPosition(0L);
    }

    final byte get() {
        assert (this.position < this.length()) : "position: " + this.position + " length: " + this.length();
        return this.get(this.position++);
    }

    final byte[] getBytes(int n2) {
        assert (n2 >= 0 && this.length() >= this.getPosition() + (long)n2) : "this.length: " + this.length() + " position: " + this.position + " length: " + n2;
        byte[] byArray = this.get(this.position, n2);
        this.position += (long)n2;
        return byArray;
    }

    final void getBytes(byte[] byArray, int n2, int n3) {
        assert (byArray != null) : "dest is null";
        assert (n2 >= 0 && n3 >= 0 && byArray.length >= n2 + n3) : "destOffset: " + n2 + " length: " + n3 + " dest.length: " + byArray.length;
        assert (this.length() >= this.position + (long)n3) : " this.length: " + this.length() + " this.position: " + this.position + " length: " + n3;
        this.get(this.position, byArray, n2, n3);
        this.position += (long)n3;
    }

    final int getShort() {
        assert (this.position + 1L < this.length()) : "position: " + this.position + " length: " + this.length();
        return (this.get() & 0xFF) << 8 | this.get() & 0xFF;
    }

    final int getInt() {
        assert (this.position + 3L < this.length()) : "position: " + this.position + " length: " + this.length();
        return (this.get() & 0xFF) << 24 | (this.get() & 0xFF) << 16 | (this.get() & 0xFF) << 8 | this.get() & 0xFF;
    }

    final String getString(int n2, CharacterSet characterSet) throws SQLException {
        String string = this.getString(this.position, n2, characterSet);
        this.position += (long)n2;
        return string;
    }

    final void put(byte by) {
        this.put(this.position++, by);
    }

    final void putShort(short s2) {
        this.putShort(this.position, s2);
        this.position += 2L;
    }

    final void putInt(int n2) {
        this.putInt(this.position, n2);
        this.position += 4L;
    }

    final void put(byte[] byArray) {
        this.put(this.position, byArray);
        this.position += (long)byArray.length;
    }

    final void put(byte[] byArray, int n2, int n3) {
        assert (byArray != null) : "src is null";
        assert (n2 >= 0 && n3 >= 0) : "srcOffset: " + n2 + " length: " + n3;
        assert (byArray.length >= n2 + n3) : "src.length: " + byArray.length + " srcOffset: " + n2 + " length: " + n3;
        this.put(this.position, byArray, n2, n3);
        this.position += (long)n3;
    }

    abstract void put(long var1, byte var3);

    abstract byte get(long var1);

    final void putShort(long l2, short s2) {
        this.put(l2, (byte)(s2 >> 8 & 0xFF));
        this.put(l2 + 1L, (byte)(s2 & 0xFF));
    }

    final void putInt(long l2, int n2) {
        for (int i2 = 3; i2 >= 0; --i2) {
            this.put(l2 + (long)i2, (byte)(n2 & 0xFF));
            n2 >>= 8;
        }
    }

    final void put(long l2, byte[] byArray) {
        assert (l2 >= 0L && byArray != null) : "offset: " + l2 + " src: " + byArray;
        this.put(l2, byArray, 0, byArray.length);
    }

    abstract void put(long var1, byte[] var3, int var4, int var5);

    void put(long l2, ByteArray byteArray, long l3, int n2) {
        assert (l2 >= 0L && byteArray != null && l3 >= 0L) : "offset: " + l2 + " src: " + byteArray + " srcOffset: " + l3;
        byte[] byArray = byteArray.get(l3, n2);
        this.put(l2, byArray, 0, n2);
    }

    final byte[] get(long l2, int n2) {
        assert (l2 >= 0L && n2 >= 0 && this.length() >= l2 + (long)n2) : "this.length: " + this.length() + " offset: " + l2 + " length: " + n2;
        byte[] byArray = new byte[n2];
        this.get(l2, byArray, 0, n2);
        return byArray;
    }

    abstract void get(long var1, byte[] var3, int var4, int var5);

    String getString(long l2, int n2, CharacterSet characterSet) throws SQLException {
        int[] nArray = new int[1];
        char[] cArray = this.getChars(l2, n2, characterSet, nArray);
        if (nArray[0] == cArray.length) {
            return new String(cArray);
        }
        return String.valueOf(cArray, 0, nArray[0]);
    }

    char[] getChars(long l2, int n2, CharacterSet characterSet) throws SQLException {
        int[] nArray = new int[1];
        char[] cArray = this.getChars(l2, n2, characterSet, nArray);
        if (nArray[0] == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[nArray[0]];
        System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
        return cArray2;
    }

    abstract char[] getChars(long var1, int var3, CharacterSet var4, int[] var5) throws SQLException;

    boolean equalBytes(long l2, int n2, ByteArray byteArray, long l3) throws SQLException {
        if (l2 + (long)n2 >= this.length() || l3 + (long)n2 >= byteArray.length()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.get(l2 + (long)i2) == byteArray.get(l3 + (long)i2)) continue;
            return false;
        }
        return true;
    }

    abstract long updateChecksum(long var1, int var3, CRC64 var4, long var5);

    abstract void updateDigest(MessageDigest var1, long var2, int var4);

    byte[] getBytesFromHex(long l2, int n2, CharacterSet characterSet) throws SQLException {
        int[] nArray = new int[1];
        char[] cArray = this.getChars(l2, n2, characterSet, nArray);
        int n3 = nArray[0];
        byte[] byArray = new byte[(n3 + 1) / 2];
        boolean bl = true;
        int n4 = 0;
        for (char c2 : cArray) {
            if (bl) {
                byArray[n4] = (byte)(this.hexDigit2Nibble(c2) << 4);
            } else {
                int n5 = n4++;
                byArray[n5] = (byte)(byArray[n5] + (this.hexDigit2Nibble(c2) & 0xF));
            }
            bl = !bl;
        }
        return byArray;
    }

    final int hexDigit2Nibble(char c2) throws SQLException {
        int n2 = Character.digit(c2, 16);
        if (n2 == -1) {
            throw (SQLException)DatabaseError.createSqlException(59, "Invalid hex digit: " + c2).fillInStackTrace();
        }
        return n2;
    }

    final void freeSpace(long l2, int n2) {
    }

    byte[] getBlockBasic(long l2, int[] nArray) {
        throw new Error("not implemented");
    }

    abstract void free();

    ByteArray compact() {
        return this;
    }

    int getUtf8Bytes(long l2, int n2, byte[] byArray, int n3, CharacterSet characterSet) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    static {
        try {
            $$$methodRef$$$30 = ByteArray.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = ByteArray.class.getDeclaredMethod("getUtf8Bytes", Long.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = ByteArray.class.getDeclaredMethod("compact", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = ByteArray.class.getDeclaredMethod("getBlockBasic", Long.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = ByteArray.class.getDeclaredMethod("freeSpace", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ByteArray.class.getDeclaredMethod("hexDigit2Nibble", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ByteArray.class.getDeclaredMethod("getBytesFromHex", Long.TYPE, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ByteArray.class.getDeclaredMethod("equalBytes", Long.TYPE, Integer.TYPE, ByteArray.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ByteArray.class.getDeclaredMethod("getChars", Long.TYPE, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ByteArray.class.getDeclaredMethod("getString", Long.TYPE, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ByteArray.class.getDeclaredMethod("get", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ByteArray.class.getDeclaredMethod("put", Long.TYPE, ByteArray.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ByteArray.class.getDeclaredMethod("put", Long.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ByteArray.class.getDeclaredMethod("putInt", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ByteArray.class.getDeclaredMethod("putShort", Long.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ByteArray.class.getDeclaredMethod("put", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ByteArray.class.getDeclaredMethod("put", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ByteArray.class.getDeclaredMethod("putInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ByteArray.class.getDeclaredMethod("putShort", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ByteArray.class.getDeclaredMethod("put", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ByteArray.class.getDeclaredMethod("getString", Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ByteArray.class.getDeclaredMethod("getInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ByteArray.class.getDeclaredMethod("getShort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ByteArray.class.getDeclaredMethod("getBytes", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ByteArray.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ByteArray.class.getDeclaredMethod("get", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ByteArray.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ByteArray.class.getDeclaredMethod("popPosition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ByteArray.class.getDeclaredMethod("pushPosition", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ByteArray.class.getDeclaredMethod("setPosition", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ByteArray.class.getDeclaredMethod("getPosition", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

