/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOConnectPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NIOResendPacket;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.TimeoutInterruptHandler;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class NSProtocolNIO
extends NSProtocol {
    private static final long SEND_BREAK_TIMEOUT_MS = 30L;
    private final AtomicBoolean isWriting = new AtomicBoolean(false);
    private final AtomicBoolean isBreakPending = new AtomicBoolean(false);
    private NIONSDataChannel probePacket;
    static final int MAX_RETRIES = 10;
    DMSFactory.DMSNoun dmsParent = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    public NSProtocolNIO(boolean bl, SecuredLogger securedLogger) {
        this.sAtts = new SessionAtts(this, 0x200000, 0x200000, true, bl, securedLogger);
    }

    @Override
    void negotiateConnection(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun) throws IOException, NetException, InterruptedIOException {
        IOException iOException;
        int n2;
        NIOPacket nIOPacket;
        boolean bl3;
        NIOConnectPacket nIOConnectPacket = new NIOConnectPacket(this.sAtts);
        this.dmsParent = dMSNoun;
        do {
            iOException = null;
            nIOPacket = null;
            long l2 = System.currentTimeMillis();
            n2 = 0;
            try {
                nIOConnectPacket.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !bl, bl2, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
                nIOPacket = NIOPacket.readNIOPacket(this.sAtts);
                n2 = nIOPacket.header.type;
            }
            catch (TimeoutInterruptHandler.IOReadTimeoutException iOReadTimeoutException) {
                this.handleIOTimeoutInterrupt();
                iOException = iOReadTimeoutException;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (this.handleOutboundTimeoutInterrupt(interruptedIOException)) {
                    iOException = new NetException(503);
                }
                throw interruptedIOException;
            }
            catch (IOException iOException2) {
                this.handleIOException();
                iOException = iOException2;
            }
            if (iOException == null) continue;
            String string = String.format("%s, connect lapse %d ms.", iOException.getMessage(), System.currentTimeMillis() - l2);
            iOException = new IOException(string, iOException);
            n2 = 4;
        } while (!(bl3 = this.handleConnectPacketResponse(nVFactory, nVNavigator, nIOPacket, n2, iOException)));
    }

    private void handleIOTimeoutInterrupt() {
        Thread.interrupted();
    }

    private boolean handleOutboundTimeoutInterrupt(InterruptedIOException interruptedIOException) {
        assert (!(interruptedIOException instanceof TimeoutInterruptHandler.IOReadTimeoutException)) : "IO timeout is being handled as an outbound timeout";
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        if (interruptTask != null && interruptTask.isInterrupted()) {
            Thread.interrupted();
            return true;
        }
        return false;
    }

    private void handleIOException() {
        TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
    }

    private final boolean handleConnectPacketResponse(NVFactory nVFactory, NVNavigator nVNavigator, NIOPacket nIOPacket, int n2, IOException iOException) throws IOException, NetException, InterruptedIOException {
        switch (n2) {
            case 2: {
                this.handleAcceptPacket((NIOAcceptPacket)nIOPacket);
                return true;
            }
            case 5: {
                ConnOption connOption = this.sAtts.cOption.getOriginalConnOption();
                this.handleRedirectPacket((NIORedirectPacket)nIOPacket);
                this.redirectConnection((NIORedirectPacket)nIOPacket, connOption);
                return false;
            }
            case 4: {
                if (this.establishConnectionAfterRefusePacket()) {
                    return false;
                }
                if (iOException != null) {
                    throw iOException;
                }
                if (nIOPacket != null) {
                    throw this.createRefusePacketException(nVFactory, nVNavigator, (NIORefusePacket)nIOPacket);
                }
            }
            case 11: {
                this.handleResendPacket((NIOResendPacket)nIOPacket);
                return false;
            }
        }
        this.sAtts.cOption.nt.disconnect();
        throw new NetException(205);
    }

    private final void redirectConnection(NIORedirectPacket nIORedirectPacket, ConnOption connOption) throws NetException, IOException, InterruptedIOException {
        String string = nIORedirectPacket.redirectData;
        String string2 = null;
        if ((nIORedirectPacket.header.flags & 2) == 2 && nIORedirectPacket.redirectData.indexOf(0) != -1) {
            string = nIORedirectPacket.redirectData.substring(0, nIORedirectPacket.redirectData.indexOf(0));
            this.sAtts.redirecting = true;
            string2 = nIORedirectPacket.redirectData.substring(nIORedirectPacket.redirectData.indexOf(0) + 1, nIORedirectPacket.redirectData.length());
        }
        this.validateRedirectResponse(string);
        if ("WSS".equalsIgnoreCase(this.sAtts.cOption.protocol)) {
            string = this.getWSSRedirectAddress(string, this.sAtts.cOption.addr);
        }
        this.establishConnection(string, this.dmsParent);
        this.sAtts.cOption.setOriginalConnOption(connOption);
        if (this.sAtts.redirecting) {
            this.sAtts.cOption.conn_data.setLength(0);
            this.sAtts.cOption.conn_data.append(string2);
        } else {
            this.sAtts.cOption.conn_data = connOption.conn_data;
        }
    }

    private final boolean establishConnectionAfterRefusePacket() throws IOException, InterruptedIOException {
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.cOption = null;
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        if (interruptTask != null && interruptTask.isInterrupted()) {
            Thread.interrupted();
        }
        try {
            this.establishConnection(null, true, this.dmsParent);
        }
        catch (NetException netException) {
            // empty catch block
        }
        return this.sAtts.cOption != null;
    }

    @Override
    final CompletionStage<Void> negotiateConnectionAsync(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        return this.chainAsyncNegotiationIO(nVFactory, nVNavigator, bl, bl2, dMSNoun, new NIOConnectPacket(this.sAtts), asyncOutboundTimeoutHandler, executor);
    }

    private final CompletionStage<Void> chainAsyncNegotiationIO(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2, DMSFactory.DMSNoun dMSNoun, NIOConnectPacket nIOConnectPacket, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        class ConnectResponse {
            final int packetType;
            final NIOPacket packet;
            final IOException failure;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;

            ConnectResponse(int n2, NIOPacket nIOPacket, IOException iOException) {
                this.packetType = n2;
                this.packet = nIOPacket;
                this.failure = iOException;
            }

            static {
                try {
                    $$$methodRef$$$0 = ConnectResponse.class.getDeclaredConstructor(NSProtocolNIO.class, Integer.TYPE, NIOPacket.class, IOException.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        }
        CompletableFuture completableFuture = new CompletableFuture();
        try {
            nIOConnectPacket.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !bl, bl2, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
            this.sAtts.cOption.nt.registerForNonBlockingRead(throwable -> executor.execute(() -> {
                if (throwable == null) {
                    completableFuture.complete(null);
                } else {
                    completableFuture.completeExceptionally((Throwable)throwable);
                }
            }));
        }
        catch (IOException iOException2) {
            completableFuture.completeExceptionally(iOException2);
        }
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)completableFuture.thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
            NIOPacket nIOPacket = NIOPacket.readNIOPacket(this.sAtts);
            int n2 = nIOPacket.header.type;
            return new ConnectResponse(n2, nIOPacket, null);
        }))).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            asyncOutboundTimeoutHandler.cancelTimeout();
            int n2 = 4;
            return new ConnectResponse(n2, null, (IOException)iOException);
        }))).thenCompose(connectResponse -> this.handleConnectPacketResponseAsync(nVFactory, nVNavigator, connectResponse.packet, connectResponse.packetType, connectResponse.failure, asyncOutboundTimeoutHandler, executor))).thenCompose(bl3 -> {
            if (bl3.booleanValue()) {
                return CompletionStageUtil.VOID_COMPLETED_FUTURE;
            }
            return this.chainAsyncNegotiationIO(nVFactory, nVNavigator, bl, bl2, dMSNoun, nIOConnectPacket, asyncOutboundTimeoutHandler, executor);
        });
    }

    private final CompletionStage<Boolean> handleConnectPacketResponseAsync(NVFactory nVFactory, NVNavigator nVNavigator, NIOPacket nIOPacket, int n2, IOException iOException, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        try {
            switch (n2) {
                case 2: {
                    this.handleAcceptPacket((NIOAcceptPacket)nIOPacket);
                    return CompletionStageUtil.completedStage(Boolean.TRUE);
                }
                case 5: {
                    ConnOption connOption = this.sAtts.cOption.getOriginalConnOption();
                    this.handleRedirectPacket((NIORedirectPacket)nIOPacket);
                    return this.redirectConnectionAsync((NIORedirectPacket)nIOPacket, connOption, asyncOutboundTimeoutHandler, executor).thenApply(void_ -> Boolean.FALSE);
                }
                case 4: {
                    return this.establishConnectionAfterRefusePacketAsync(asyncOutboundTimeoutHandler, executor).thenApply(CompletionStageUtil.normalCompletionHandler(bl -> {
                        if (bl.booleanValue()) {
                            return Boolean.FALSE;
                        }
                        if (iOException != null) {
                            throw iOException;
                        }
                        if (nIOPacket != null) {
                            throw this.createRefusePacketException(nVFactory, nVNavigator, (NIORefusePacket)nIOPacket);
                        }
                        throw new NetException(206);
                    }));
                }
                case 11: {
                    this.handleResendPacket((NIOResendPacket)nIOPacket);
                    return CompletionStageUtil.completedStage(Boolean.FALSE);
                }
            }
            this.sAtts.cOption.nt.disconnect();
            return CompletionStageUtil.failedStage(new NetException(205));
        }
        catch (IOException iOException2) {
            return CompletionStageUtil.failedStage(iOException2);
        }
    }

    private final CompletionStage<Void> redirectConnectionAsync(NIORedirectPacket nIORedirectPacket, ConnOption connOption, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        String string;
        String string2;
        if ((nIORedirectPacket.header.flags & 2) == 2 && nIORedirectPacket.redirectData.indexOf(0) != -1) {
            string2 = nIORedirectPacket.redirectData.substring(0, nIORedirectPacket.redirectData.indexOf(0));
            this.sAtts.redirecting = true;
            string = nIORedirectPacket.redirectData.substring(nIORedirectPacket.redirectData.indexOf(0) + 1, nIORedirectPacket.redirectData.length());
        } else {
            string2 = nIORedirectPacket.redirectData;
            string = null;
        }
        try {
            this.validateRedirectResponse(string2);
            if ("WSS".equalsIgnoreCase(this.sAtts.cOption.protocol)) {
                string2 = this.getWSSRedirectAddress(string2, this.sAtts.cOption.addr);
            }
        }
        catch (IOException iOException) {
            return CompletionStageUtil.failedStage(iOException);
        }
        return this.establishConnectionAsync(string2, false, this.dmsParent, asyncOutboundTimeoutHandler, executor).thenAccept(sessionAtts -> {
            this.sAtts.cOption.setOriginalConnOption(connOption);
            if (this.sAtts.redirecting) {
                this.sAtts.cOption.conn_data.setLength(0);
                this.sAtts.cOption.conn_data.append(string);
            } else {
                this.sAtts.cOption.conn_data = connOption.conn_data;
            }
        });
    }

    private final CompletionStage<Boolean> establishConnectionAfterRefusePacketAsync(AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        try {
            this.sAtts.cOption.nt.disconnect();
        }
        catch (IOException iOException) {
            return CompletionStageUtil.failedStage(iOException);
        }
        this.sAtts.cOption = null;
        asyncOutboundTimeoutHandler.cancelTimeout();
        return this.establishConnectionAsync(null, true, this.dmsParent, asyncOutboundTimeoutHandler, executor).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(NetException.class, netException -> null)).thenApply(sessionAtts -> this.sAtts.cOption != null);
    }

    private final void handleAcceptPacket(NIOAcceptPacket nIOAcceptPacket) throws IOException, NetException {
        this.sAtts.setNegotiatedSDUAndTDU(nIOAcceptPacket.sduSize, nIOAcceptPacket.tduSize);
        this.sAtts.setNegotiatedOptions(nIOAcceptPacket.options);
        this.sAtts.setConnectData(nIOAcceptPacket.connectData);
        this.sAtts.cOption.nt.resetInetAddress();
        this.sAtts.payloadDataBufferForRead.position(this.sAtts.payloadDataBufferForRead.limit());
        this.sAtts.connected = true;
        if (nIOAcceptPacket.isOOBCheckEnabled) {
            this.tryUrgentByte();
            this.sendMarker(2, (byte)3);
        }
    }

    private final void handleRedirectPacket(NIORedirectPacket nIORedirectPacket) throws IOException {
        this.addrRes.connection_redirected = true;
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.cOption.nt.resetInetAddress();
    }

    private final NetException createRefusePacketException(NVFactory nVFactory, NVNavigator nVNavigator, NIORefusePacket nIORefusePacket) {
        String string = null;
        try {
            NVPair nVPair;
            NVPair nVPair2 = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(nIORefusePacket.refuseData), "ERROR");
            if (nVPair2 != null && (nVPair = nVNavigator.findNVPairRecurse(nVPair2, "CODE")) != null) {
                string = nVPair.valueToString();
            }
        }
        catch (NLException nLException) {
        }
        return new NetException(string == null ? 206 : Integer.parseInt(string), "");
    }

    private final void handleResendPacket(NIOResendPacket nIOResendPacket) throws IOException {
        if ((nIOResendPacket.header.flags & 8) == 8) {
            this.sAtts.renegotiateSSLSession();
        }
    }

    private String getWSSRedirectAddress(String string, String string2) throws IOException {
        try {
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair = new NVFactory().createNVPair(string);
            String string3 = nVNavigator.findNVPair(nVPair, "HOST").getAtom();
            String string4 = nVNavigator.findNVPair(nVPair, "PORT").getAtom();
            NVNavigator nVNavigator2 = new NVNavigator();
            NVPair nVPair2 = new NVFactory().createNVPair(string2);
            String string5 = nVNavigator.findNVPair(nVPair2, "HOST").getAtom();
            String string6 = nVNavigator.findNVPair(nVPair2, "PORT").getAtom();
            NVPair nVPair3 = nVNavigator2.findNVPair(nVPair2, "WEBSOCK_URI");
            String string7 = nVPair3 == null ? "/sqlnet" : nVPair3.getAtom();
            String string8 = string7 + "/" + string3 + ":" + string4;
            return String.format("(ADDRESS=(PROTOCOL=WSS)(HOST=%s)(PORT=%s)(WEBSOCK_URI=%s))", string5, string6, string8);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        boolean bl = false;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            if (i2 >= 1703910) {
                n4 = 1703910;
            } else {
                n4 = i2;
                bl = true;
            }
            this.sAtts.prepareWriteBuffer();
            this.sAtts.ddPacket.writeToSocketChannel(n4, bl);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n4);
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.write(byteBuffer);
            }
            n2 += n4;
        }
    }

    @Override
    public void writeZeroCopyIOHeader(boolean bl, int n2, boolean bl2) throws IOException {
        this.sAtts.prepareWriteBuffer();
        this.sAtts.ddPacket.writeToSocketChannel(n2, bl2);
    }

    @Override
    public void writeZeroCopyIOData(byte[] byArray, int n2, int n3) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n3);
        while (byteBuffer.hasRemaining()) {
            this.sAtts.socketChannel.write(byteBuffer);
        }
    }

    @Override
    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException {
        boolean bl = false;
        this.sAtts.ddPacket.readFromSocketChannel(true);
        this.sAtts.ddPacket.readPayloadBuffer();
        int n3 = this.sAtts.ddPacket.totalDataLength;
        if ((this.sAtts.ddPacket.descriptorFLaG & 1) != 0) {
            bl = true;
        }
        if (byArray.length < n2 + n3) {
            throw new IOException("Assertion Failed");
        }
        int n4 = 0;
        ByteBuffer byteBuffer = this.sAtts.readBuffer;
        if (byteBuffer.hasRemaining()) {
            int n5 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n5);
            n4 += n5;
        }
        while (n4 < n3) {
            byteBuffer.clear();
            byteBuffer.limit(Math.min(byteBuffer.capacity(), n3 - n4));
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.read(byteBuffer);
            }
            byteBuffer.rewind();
            byteBuffer.get(byArray, n2 + n4, byteBuffer.limit());
            n4 += byteBuffer.limit();
        }
        nArray[0] = n4;
        return bl;
    }

    @Override
    public void cancelTimeout() {
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.dataChannel.sendEOF();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.dmsParent = null;
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.releaseWriteBuffer();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
        this.sendMarker(1, (byte)2);
        while (this.sAtts.onBreakReset) {
            this.sAtts.markerPacket.readFromSocketChannel(true, false);
            this.sAtts.markerPacket.readPayloadBuffer();
            if (!this.sAtts.markerPacket.isResetPkt()) continue;
            this.sAtts.onBreakReset = false;
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, this.sAtts.socketChannel);
        super.sendInterrupt();
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public InputStream getInputStream() throws NetException, IOException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public OutputStream getOutputStream() throws NetException, IOException {
        return this.getNetOutputStream();
    }

    @Override
    void initializeSessionAttributes() throws NetException, IOException {
        this.sAtts.socketChannel = this.sAtts.nt.getSocketChannel();
        this.sAtts.initializeBuffer(this.sAtts.getSDU());
        this.sAtts.dataEOF = false;
    }

    @Override
    protected void sendMarker(int n2, byte by) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sAtts.markerPacket.writeToSocketChannel(n2, by);
    }

    @Override
    void sendProbePacket() throws IOException {
        if (this.probePacket == null) {
            this.probePacket = new NIONSDataChannel(this.sAtts);
        } else {
            this.probePacket.reinitialize(this.sAtts);
        }
        byte[] byArray = new byte[26];
        this.probePacket.writeDataToSocketChannel(byArray);
    }

    void doSocketRead(int n2) throws IOException {
        int n3 = this.sAtts.readBuffer.position();
        int n4 = 0;
        while (this.sAtts.readBuffer.position() < n2) {
            int n5 = this.sAtts.socketChannel.read(this.sAtts.readBuffer);
            if (n5 < 0) {
                throw new NetException(0);
            }
            if (n5 == 0) {
                if (++n4 < 10) continue;
                throw new NetException(0);
            }
            n4 = 0;
        }
        this.sAtts.readBuffer.flip();
        this.sAtts.readBuffer.position(n3);
    }

    @Override
    public void sendZDP() throws IOException {
        this.sAtts.prepareWriteBuffer();
        this.sAtts.dataChannel.header.type = 6;
        this.sAtts.payloadBufferForWrite.clear();
        this.sAtts.payloadBufferForWrite.limit(2);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.dataChannel.writeToSocketChannel();
    }

    @Override
    public boolean needsToBeClosed() {
        return this.sAtts.needsToBeClosed;
    }

    @Override
    public void readInbandNotification() {
        try {
            if (this.sAtts.needsToBeClosed) {
                return;
            }
            this.sAtts.dataChannel.readInbandNotificationCtlPacket();
        }
        catch (IOException iOException) {
            this.sAtts.needsToBeClosed = true;
        }
    }

    @Override
    public final void sendBreak() throws IOException, NetException {
        this.isBreakPending.set(true);
        if (this.isWriting.compareAndSet(false, true)) {
            try {
                this.sendPendingBreak();
            }
            finally {
                this.isWriting.set(false);
            }
        }
    }

    final void beginWrite() throws IOException {
        while (!this.isWriting.compareAndSet(false, true)) {
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException("Socket write interrupted");
        }
        try {
            this.sendPendingBreak();
        }
        catch (Throwable throwable) {
            this.isWriting.set(false);
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException(throwable);
        }
    }

    final void endWrite() throws IOException {
        try {
            this.sendPendingBreak();
        }
        finally {
            this.isWriting.set(false);
        }
        while (this.isBreakPending.get()) {
            if (this.isWriting.compareAndSet(false, true)) {
                try {
                    this.sendPendingBreak();
                    continue;
                }
                finally {
                    this.isWriting.set(false);
                    continue;
                }
            }
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedIOException("Socket write interrupted");
        }
    }

    private void sendPendingBreak() throws IOException {
        assert (this.isWriting.get()) : "Sending break without the write lock";
        if (this.isBreakPending.get()) {
            if (this.sAtts.isExpediatedAttentionEnabled() && !this.sAtts.nt.awaitWriteReadiness(30L)) {
                throw new IOException("Unable to send break without blocking");
            }
            if (!this.sAtts.connected) {
                throw new NetException(200);
            }
            TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, this.sAtts.socketChannel);
            int n2 = this.getSocketReadTimeout();
            this.setSocketReadTimeout(30);
            try {
                super.sendBreak();
                this.isBreakPending.set(false);
            }
            finally {
                this.setSocketReadTimeout(n2);
            }
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$51 = NSProtocolNIO.class.getDeclaredConstructor(Boolean.TYPE, SecuredLogger.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$50 = NSProtocolNIO.class.getDeclaredMethod("lambda$chainAsyncNegotiationIO$0", Throwable.class, CompletableFuture.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$49 = NSProtocolNIO.class.getDeclaredMethod("lambda$chainAsyncNegotiationIO$1", Executor.class, CompletableFuture.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$48 = NSProtocolNIO.class.getDeclaredMethod("lambda$chainAsyncNegotiationIO$2", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$47 = NSProtocolNIO.class.getDeclaredMethod("lambda$chainAsyncNegotiationIO$3", AsyncOutboundTimeoutHandler.class, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$46 = NSProtocolNIO.class.getDeclaredMethod("lambda$chainAsyncNegotiationIO$4", NVFactory.class, NVNavigator.class, AsyncOutboundTimeoutHandler.class, Executor.class, ConnectResponse.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$45 = NSProtocolNIO.class.getDeclaredMethod("lambda$chainAsyncNegotiationIO$5", NVFactory.class, NVNavigator.class, Boolean.TYPE, Boolean.TYPE, DMSFactory.DMSNoun.class, NIOConnectPacket.class, AsyncOutboundTimeoutHandler.class, Executor.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$44 = NSProtocolNIO.class.getDeclaredMethod("lambda$handleConnectPacketResponseAsync$6", Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$43 = NSProtocolNIO.class.getDeclaredMethod("lambda$handleConnectPacketResponseAsync$7", IOException.class, NIOPacket.class, NVFactory.class, NVNavigator.class, Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$42 = NSProtocolNIO.class.getDeclaredMethod("lambda$redirectConnectionAsync$8", ConnOption.class, String.class, SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$41 = NSProtocolNIO.class.getDeclaredMethod("lambda$establishConnectionAfterRefusePacketAsync$9", NetException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$40 = NSProtocolNIO.class.getDeclaredMethod("lambda$establishConnectionAfterRefusePacketAsync$10", SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$39 = NSProtocolNIO.class.getDeclaredMethod("sendPendingBreak", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$38 = NSProtocolNIO.class.getDeclaredMethod("endWrite", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$37 = NSProtocolNIO.class.getDeclaredMethod("beginWrite", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$36 = NSProtocolNIO.class.getDeclaredMethod("sendBreak", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$35 = NSProtocolNIO.class.getDeclaredMethod("readInbandNotification", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$34 = NSProtocolNIO.class.getDeclaredMethod("needsToBeClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$33 = NSProtocolNIO.class.getDeclaredMethod("sendZDP", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$32 = NSProtocolNIO.class.getDeclaredMethod("doSocketRead", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$31 = NSProtocolNIO.class.getDeclaredMethod("sendProbePacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$30 = NSProtocolNIO.class.getDeclaredMethod("sendMarker", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$29 = NSProtocolNIO.class.getDeclaredMethod("initializeSessionAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$28 = NSProtocolNIO.class.getDeclaredMethod("getOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$27 = NSProtocolNIO.class.getDeclaredMethod("getNetOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$26 = NSProtocolNIO.class.getDeclaredMethod("getInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$25 = NSProtocolNIO.class.getDeclaredMethod("getNetInputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$24 = NSProtocolNIO.class.getDeclaredMethod("sendInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$23 = NSProtocolNIO.class.getDeclaredMethod("sendReset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$22 = NSProtocolNIO.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$21 = NSProtocolNIO.class.getDeclaredMethod("cancelTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$20 = NSProtocolNIO.class.getDeclaredMethod("readZeroCopyIO", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$19 = NSProtocolNIO.class.getDeclaredMethod("writeZeroCopyIOData", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$18 = NSProtocolNIO.class.getDeclaredMethod("writeZeroCopyIOHeader", Boolean.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$17 = NSProtocolNIO.class.getDeclaredMethod("writeZeroCopyIO", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$16 = NSProtocolNIO.class.getDeclaredMethod("getWSSRedirectAddress", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$15 = NSProtocolNIO.class.getDeclaredMethod("handleResendPacket", NIOResendPacket.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$14 = NSProtocolNIO.class.getDeclaredMethod("createRefusePacketException", NVFactory.class, NVNavigator.class, NIORefusePacket.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$13 = NSProtocolNIO.class.getDeclaredMethod("handleRedirectPacket", NIORedirectPacket.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$12 = NSProtocolNIO.class.getDeclaredMethod("handleAcceptPacket", NIOAcceptPacket.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$11 = NSProtocolNIO.class.getDeclaredMethod("establishConnectionAfterRefusePacketAsync", AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$10 = NSProtocolNIO.class.getDeclaredMethod("redirectConnectionAsync", NIORedirectPacket.class, ConnOption.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = NSProtocolNIO.class.getDeclaredMethod("handleConnectPacketResponseAsync", NVFactory.class, NVNavigator.class, NIOPacket.class, Integer.TYPE, IOException.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = NSProtocolNIO.class.getDeclaredMethod("chainAsyncNegotiationIO", NVFactory.class, NVNavigator.class, Boolean.TYPE, Boolean.TYPE, DMSFactory.DMSNoun.class, NIOConnectPacket.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = NSProtocolNIO.class.getDeclaredMethod("negotiateConnectionAsync", NVFactory.class, NVNavigator.class, Boolean.TYPE, Boolean.TYPE, DMSFactory.DMSNoun.class, AsyncOutboundTimeoutHandler.class, Executor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = NSProtocolNIO.class.getDeclaredMethod("establishConnectionAfterRefusePacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = NSProtocolNIO.class.getDeclaredMethod("redirectConnection", NIORedirectPacket.class, ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = NSProtocolNIO.class.getDeclaredMethod("handleConnectPacketResponse", NVFactory.class, NVNavigator.class, NIOPacket.class, Integer.TYPE, IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = NSProtocolNIO.class.getDeclaredMethod("handleIOException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = NSProtocolNIO.class.getDeclaredMethod("handleOutboundTimeoutInterrupt", InterruptedIOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = NSProtocolNIO.class.getDeclaredMethod("handleIOTimeoutInterrupt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = NSProtocolNIO.class.getDeclaredMethod("negotiateConnection", NVFactory.class, NVNavigator.class, Boolean.TYPE, Boolean.TYPE, DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

