/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAHeteroResource
extends OracleXAResource {
    private int rmid = -1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public OracleXAHeteroResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
        }
    }

    @Override
    public void start(Xid xid, int n2) throws XAException {
        if (xid == null) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        int n3 = n2 & 0xFF00;
        if (((n2 &= 0xFFFF00FF) & 0x8200002) != n2) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        if ((n3 & 0xFF00) != 0 && n3 != 256 && n3 != 512 && n3 != 1024) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        if ((n3 & 0xFF00) != 0 && (n2 & 0x8200000) != 0) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        try {
            this.saveAndAlterAutoCommitModeForGlobalTransaction();
            int n4 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            int n5 = this.t2cDoXaStart(n4, byArray, byArray2, this.rmid, n2 |= n3, 0);
            this.checkStatus(n5);
            this.enterGlobalTxnMode();
        }
        catch (XAException xAException) {
            this.restoreAutoCommitModeForGlobalTransaction();
            throw xAException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n2) throws XAException {
        try {
            if (xid == null) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            int n3 = 638582786;
            if ((n2 & n3) != n2) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            int n4 = xid.getFormatId();
            byte[] byArray = xid.getGlobalTransactionId();
            byte[] byArray2 = xid.getBranchQualifier();
            this.exitGlobalTxnMode();
            int n5 = this.t2cDoXaEnd(n4, byArray, byArray2, this.rmid, n2, 0);
            this.checkStatus(n5);
        }
        finally {
            this.restoreAutoCommitModeForGlobalTransaction();
        }
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        if (xid == null) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        int n2 = bl ? 0x40000000 : 0;
        int n3 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n4 = this.t2cDoXaCommit(n3, byArray, byArray2, this.rmid, n2, 0);
        this.checkStatus(n4);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (xid == null) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.t2cDoXaPrepare(n2, byArray, byArray2, this.rmid, 0, 0);
        if (n3 != 0 && n3 != 3) {
            this.checkStatus(n3);
        }
        return n3;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (xid == null) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.t2cDoXaForget(n2, byArray, byArray2, this.rmid, 0, 0);
        this.checkStatus(n3);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (xid == null) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        int n2 = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n3 = this.t2cDoXaRollback(n2, byArray, byArray2, this.rmid, 0, 0);
        this.checkStatus(n3);
    }

    private native int t2cDoXaStart(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaEnd(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaCommit(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaPrepare(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaForget(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    private native int t2cDoXaRollback(int var1, byte[] var2, byte[] var3, int var4, int var5, int var6);

    void setRmid(int n2) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.rmid = n2;
        }
    }

    int getRmid() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            int n2 = this.rmid;
            return n2;
        }
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void checkStatus(int n2) throws XAException {
        if (n2 != 0) {
            throw (XAException)DatabaseError.createXAException(n2).fillInStackTrace();
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$10 = OracleXAHeteroResource.class.getDeclaredConstructor(Connection.class, OracleXAConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXAHeteroResource.class.getDeclaredMethod("checkStatus", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXAHeteroResource.class.getDeclaredMethod("getSerializedBytes", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXAHeteroResource.class.getDeclaredMethod("getRmid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXAHeteroResource.class.getDeclaredMethod("setRmid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXAHeteroResource.class.getDeclaredMethod("rollback", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXAHeteroResource.class.getDeclaredMethod("forget", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAHeteroResource.class.getDeclaredMethod("prepare", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAHeteroResource.class.getDeclaredMethod("commit", Xid.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAHeteroResource.class.getDeclaredMethod("end", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAHeteroResource.class.getDeclaredMethod("start", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

