/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.Datum;
import oracle.sql.Kotad;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_METADATA})
public class TypeDescriptor
implements OracleTypeMetaData,
Serializable,
ORAData,
OracleData {
    public static boolean DEBUG_SERIALIZATION;
    static final long serialVersionUID = 2022598722047823723L;
    public static final int KOIDFLEN = 16;
    static final short KOTA_TRN = 1;
    static final short KOTA_PDF = 2;
    static final short KOTA_ITOID = 4;
    static final short KOTA_LOB = 8;
    static final short KOTA_AD = 16;
    static final short KOTA_NMHSH = 32;
    static final short KOTA_TEV = 64;
    static final short KOTA_INH = 128;
    static final short KOTA_10I = 256;
    static final short KOTA_RBF = 512;
    static final short KOTA_HBF = 1024;
    static final int ANYTYPE_IMAGE_SIZE_TOID = 23;
    static final int ANYTYPE_IMAGE_SIZE_NO_TOID = 5;
    static final byte KOTTDOID = 1;
    static final byte KOTTBOID = 2;
    static final byte KOTADOID = 3;
    static final byte KOTREFOID = 4;
    static final byte KOTMDOID = 5;
    static final byte KOTMIOID = 6;
    static final byte KOTEXOID = 7;
    static final byte KOTDATOID = 8;
    static final byte KOTBYTOID = 9;
    static final byte KOTSHOOID = 10;
    static final byte KOTLONOID = 11;
    static final byte KOTREAOID = 12;
    static final byte KOTDOUOID = 13;
    static final byte KOTFLOOID = 14;
    static final byte KOTNUMOID = 15;
    static final byte KOTDECOID = 16;
    static final byte KOTUBYOID = 17;
    static final byte KOTUSHOID = 18;
    static final byte KOTULOOID = 19;
    static final byte KOTOCTOID = 20;
    static final byte KOTSMLOID = 21;
    static final byte KOTINTOID = 22;
    static final byte KOTRAWOID = 23;
    static final byte KOTPTROID = 24;
    static final byte KOTVSIOID = 25;
    static final byte KOTFSIOID = 26;
    static final byte KOTVSOOID = 27;
    static final byte KOTMLSOID = 28;
    static final byte KOTVAROID = 29;
    static final byte KOTMSTOID = 30;
    static final byte KOTNATOID = 31;
    static final byte KOTDOMOID = 32;
    static final byte KOTUND1OID = 33;
    static final byte KOTCLBOID = 34;
    static final byte KOTBLBOID = 35;
    static final byte KOTCFLOID = 36;
    static final byte KOTBFLOID = 37;
    static final byte KOTOIDOID = 38;
    static final byte KOTCAROID = 39;
    static final byte KOTCANOID = 40;
    static final byte KOTLPTOID = 41;
    static final byte KOTBRIOID = 42;
    static final byte KOTUCOOID = 43;
    static final byte KOTRECOID = 44;
    static final byte KOTRCUOID = 45;
    static final byte KOTBOOOID = 46;
    static final byte KOTRIDOID = 47;
    static final byte KOTPLOOID = 48;
    static final byte KOTPLROID = 49;
    static final byte KOTPBIOID = 50;
    static final byte KOTPINOID = 51;
    static final byte KOTPNAOID = 52;
    static final byte KOTPNNOID = 53;
    static final byte KOTPPOOID = 54;
    static final byte KOTPPNOID = 55;
    static final byte KOTPSTOID = 56;
    static final byte KOTEX1OID = 57;
    static final byte KOTOPQOID = 58;
    static final byte KOTTMOID = 59;
    static final byte KOTTMTZOID = 60;
    static final byte KOTTSOID = 61;
    static final byte KOTTSTZOID = 62;
    static final byte KOTIYMOID = 63;
    static final byte KOTIDSOID = 64;
    static final byte KOTTSIMPTZOID = 65;
    static final byte KOTTBXOID = 66;
    static final byte KOTADXOID = 67;
    static final byte KOTOIDBFLT = 68;
    static final byte KOTOIDBDBL = 69;
    static final byte KOTURDOID = 70;
    static final byte KOTJSONOID = 71;
    static final byte KOTLASTOID = 72;
    static final byte[] KOTTDEXTOID;
    static final byte[] KOTTBEXTOID;
    static final byte[] KOTADEXTOID;
    static final byte[] KOTMDEXTOID;
    static final byte[] KOTTBXEXTOID;
    static final byte[] KOTADXEXTOID;
    static final byte[] KOTTDTOID;
    static final byte[] KOTTBTOID;
    static final byte[] KOTADTOID;
    static final byte[] KOTMDTOID;
    static final byte[] KOTMITOID;
    static final byte[] KOTEXTOID;
    static final byte[] KOTEX1TOID;
    static final byte[] KOTTBXTOID;
    static final byte[] KOTADXTOID;
    public static final byte[] RAWTOID;
    public static final byte[] JSONTOID;
    public static final byte[] ANYTYPETOID;
    public static final byte[] ANYDATATOID;
    public static final byte[] ANYDATASETTOID;
    public static final byte[] XMLTYPETOID;
    static final short SQLT_NONE = 0;
    static final short SQLT_CHR = 1;
    static final short SQLT_NUM = 2;
    static final short SQLT_INT = 3;
    static final short SQLT_FLT = 4;
    static final short SQLT_STR = 5;
    static final short SQLT_VNU = 6;
    static final short SQLT_PDN = 7;
    static final short SQLT_LNG = 8;
    static final short SQLT_VCS = 9;
    static final short SQLT_NON = 10;
    static final short SQLT_RID = 11;
    static final short SQLT_DAT = 12;
    static final short SQLT_VBI = 15;
    static final short SQLT_BFLOAT = 21;
    static final short SQLT_BDOUBLE = 22;
    static final short SQLT_BIN = 23;
    static final short SQLT_LBI = 24;
    static final short SQLT_UIN = 68;
    static final short SQLT_SLS = 91;
    static final short SQLT_LVC = 94;
    static final short SQLT_LVB = 95;
    static final short SQLT_AFC = 96;
    static final short SQLT_AVC = 97;
    static final short SQLT_IBFLOAT = 100;
    static final short SQLT_IBDOUBLE = 101;
    static final short SQLT_CUR = 102;
    static final short SQLT_RDD = 104;
    static final short SQLT_LAB = 105;
    static final short SQLT_OSL = 106;
    static final short SQLT_NTY = 108;
    static final short SQLT_REF = 110;
    static final short SQLT_CLOB = 112;
    static final short SQLT_BLOB = 113;
    static final short SQLT_BFILEE = 114;
    static final short SQLT_FILE = 114;
    static final short SQLT_CFILEE = 115;
    static final short SQLT_RSET = 116;
    static final short SQLT_SVT = 118;
    static final short SQLT_NCO = 122;
    static final short SQLT_DTR = 152;
    static final short SQLT_DUN = 153;
    static final short SQLT_DOP = 154;
    static final short SQLT_VST = 155;
    static final short SQLT_ODT = 156;
    static final short SQLT_DOL = 172;
    static final short SQLT_DATE = 184;
    static final short SQLT_TIME = 185;
    static final short SQLT_TIME_TZ = 186;
    static final short SQLT_TIMESTAMP = 187;
    static final short SQLT_TIMESTAMP_TZ = 188;
    static final short SQLT_INTERVAL_YM = 189;
    static final short SQLT_INTERVAL_DS = 190;
    static final short SQLT_TIMESTAMP_LTZ = 232;
    static final short SQLT_PNTY = 241;
    static final short SQLT_CFILE = 115;
    static final short SQLT_BFILE = 114;
    static final short SQLT_REC = 250;
    static final short SQLT_TAB = 251;
    static final short SQLT_BOL = 252;
    static final short SQLCS_IMPLICIT = 1;
    static final short SQLCS_NCHAR = 2;
    static final short SQLCS_EXPLICIT = 3;
    static final short SQLCS_FLEXIBLE = 4;
    static final short SQLCS_LIT_NULL = 5;
    static final short SQLT_XDP = 103;
    static final short SQLT_OKO = 107;
    static final short SQLT_INTY = 109;
    static final short SQLT_IREF = 111;
    static final short SQLT_DCLOB = 195;
    public static final short TYPECODE_REF = 110;
    public static final short TYPECODE_DATE = 12;
    public static final short TYPECODE_SIGNED8 = 27;
    public static final short TYPECODE_SIGNED16 = 28;
    public static final short TYPECODE_SIGNED32 = 29;
    public static final short TYPECODE_REAL = 21;
    public static final short TYPECODE_DOUBLE = 22;
    public static final short TYPECODE_BFLOAT = 100;
    public static final short TYPECODE_BDOUBLE = 101;
    public static final short TYPECODE_FLOAT = 4;
    public static final short TYPECODE_NUMBER = 2;
    public static final short TYPECODE_DECIMAL = 7;
    public static final short TYPECODE_UNSIGNED8 = 23;
    public static final short TYPECODE_UNSIGNED16 = 25;
    public static final short TYPECODE_UNSIGNED32 = 26;
    public static final short TYPECODE_OCTET = 245;
    public static final short TYPECODE_SMALLINT = 246;
    public static final short TYPECODE_INTEGER = 3;
    public static final short TYPECODE_RAW = 95;
    public static final short TYPECODE_PTR = 32;
    public static final short TYPECODE_VARCHAR2 = 9;
    public static final short TYPECODE_CHAR = 96;
    public static final short TYPECODE_VARCHAR = 1;
    public static final short TYPECODE_MLSLABEL = 105;
    public static final short TYPECODE_VARRAY = 247;
    public static final short TYPECODE_TABLE = 248;
    public static final short TYPECODE_OBJECT = 108;
    public static final short TYPECODE_OPAQUE = 58;
    public static final short TYPECODE_NAMEDCOLLECTION = 122;
    public static final short TYPECODE_BLOB = 113;
    public static final short TYPECODE_BFILE = 114;
    public static final short TYPECODE_CLOB = 112;
    public static final short TYPECODE_CFILE = 115;
    public static final short TYPECODE_TIME = 185;
    public static final short TYPECODE_TIME_TZ = 186;
    public static final short TYPECODE_TIMESTAMP = 187;
    public static final short TYPECODE_TIMESTAMP_TZ = 188;
    public static final short TYPECODE_TIMESTAMP_LTZ = 232;
    public static final short TYPECODE_INTERVAL_YM = 189;
    public static final short TYPECODE_INTERVAL_DS = 190;
    public static final short TYPECODE_UROWID = 104;
    public static final short TYPECODE_OTMFIRST = 228;
    public static final short TYPECODE_OTMLAST = 320;
    public static final short TYPECODE_SYSFIRST = 228;
    public static final short TYPECODE_SYSLAST = 235;
    public static final short TYPECODE_PLS_INTEGER = 266;
    public static final short TYPECODE_ITABLE = 251;
    public static final short TYPECODE_RECORD = 250;
    public static final short TYPECODE_BOOLEAN = 252;
    public static final short TYPECODE_NCHAR = 286;
    public static final short TYPECODE_NVARCHAR2 = 287;
    public static final short TYPECODE_NCLOB = 288;
    public static final short TYPECODE_NONE = 0;
    public static final short TYPECODE_ERRHP = 283;
    public static final short TYPECODE_JDBC_JOBJECT = 2000;
    public static final short TYPECODE_JDBC_STRUCT = 2002;
    public static final short TYPECODE_JDBC_ARRAY = 2003;
    public static final short TYPECODE_JDBC_JOPAQUE = 2000;
    public static final short TYPECODE_JDBC_REF = 2006;
    public static final short TYPECODE_JDBC_JSTRUCT = 2008;
    public static final short TYPECODE_SQLXML = 2009;
    private static final short TYPECODE_MAXVALUE = 2009;
    static final short[] OID_TO_TYPECODE;
    SQLName sqlName;
    OracleNamedType pickler;
    transient oracle.jdbc.internal.OracleConnection connection;
    short internalTypeCode;
    boolean isTransient;
    byte[] toid;
    int toidVersion;
    long precision;
    byte scale;
    byte[] transientImage;
    AttributeDescriptor[] attributesDescriptor;
    transient Boolean isInstanciable;
    transient String supertype;
    transient int numLocalAttrs;
    transient String[] subtypes;
    transient String[] attrJavaNames;
    String typeNameByUser;
    private static String[] typeCodeTypeNameMap;
    Object acProxy;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;

    void copyDescriptor(TypeDescriptor typeDescriptor) {
        if (typeDescriptor.sqlName != null) {
            this.sqlName = typeDescriptor.sqlName;
        }
        this.pickler = typeDescriptor.pickler;
        this.connection = typeDescriptor.connection;
        this.internalTypeCode = typeDescriptor.internalTypeCode;
        this.isTransient = typeDescriptor.isTransient;
        this.toid = typeDescriptor.toid;
        this.toidVersion = typeDescriptor.toidVersion;
        this.precision = typeDescriptor.precision;
        this.scale = typeDescriptor.scale;
        this.transientImage = typeDescriptor.transientImage;
        this.attributesDescriptor = typeDescriptor.attributesDescriptor;
        this.isInstanciable = typeDescriptor.isInstanciable;
        this.supertype = typeDescriptor.supertype;
        this.numLocalAttrs = typeDescriptor.numLocalAttrs;
        this.subtypes = typeDescriptor.subtypes;
        this.attrJavaNames = typeDescriptor.attrJavaNames;
        if (typeDescriptor.typeNameByUser != null) {
            this.typeNameByUser = typeDescriptor.typeNameByUser;
        }
    }

    protected TypeDescriptor(short s2) {
        this.isTransient = false;
        this.toid = null;
        this.toidVersion = 1;
        this.transientImage = null;
        this.attributesDescriptor = null;
        this.isInstanciable = null;
        this.supertype = null;
        this.numLocalAttrs = -1;
        this.subtypes = null;
        this.attrJavaNames = null;
        this.internalTypeCode = s2;
    }

    protected TypeDescriptor(short s2, String string, Connection connection) throws SQLException {
        block3: {
            block2: {
                this.isTransient = false;
                this.toid = null;
                this.toidVersion = 1;
                this.transientImage = null;
                this.attributesDescriptor = null;
                this.isInstanciable = null;
                this.supertype = null;
                this.numLocalAttrs = -1;
                this.subtypes = null;
                this.attrJavaNames = null;
                this.internalTypeCode = s2;
                if (string == null) break block2;
                if (connection != null) break block3;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
        }
        this.setPhysicalConnectionOf(connection);
        this.typeNameByUser = string;
    }

    protected TypeDescriptor(short s2, SQLName sQLName, Connection connection) throws SQLException {
        block3: {
            block2: {
                this.isTransient = false;
                this.toid = null;
                this.toidVersion = 1;
                this.transientImage = null;
                this.attributesDescriptor = null;
                this.isInstanciable = null;
                this.supertype = null;
                this.numLocalAttrs = -1;
                this.subtypes = null;
                this.attrJavaNames = null;
                this.internalTypeCode = s2;
                if (sQLName == null) break block2;
                if (connection != null) break block3;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
        }
        this.sqlName = sQLName;
        this.typeNameByUser = this.sqlName.getName();
        this.setPhysicalConnectionOf(connection);
    }

    protected TypeDescriptor(short s2, SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        block5: {
            block4: {
                this.isTransient = false;
                this.toid = null;
                this.toidVersion = 1;
                this.transientImage = null;
                this.attributesDescriptor = null;
                this.isInstanciable = null;
                this.supertype = null;
                this.numLocalAttrs = -1;
                this.subtypes = null;
                this.attrJavaNames = null;
                this.internalTypeCode = s2;
                if (sQLName == null) break block4;
                if (oracleTypeADT != null) break block5;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
        }
        this.sqlName = sQLName;
        this.typeNameByUser = this.sqlName.getName();
        if (connection != null) {
            this.setPhysicalConnectionOf(connection);
        }
        this.pickler = oracleTypeADT;
        this.pickler.setDescriptor(this);
        this.toid = oracleTypeADT.getTOID();
    }

    protected TypeDescriptor(short s2, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        block3: {
            block2: {
                this.isTransient = false;
                this.toid = null;
                this.toidVersion = 1;
                this.transientImage = null;
                this.attributesDescriptor = null;
                this.isInstanciable = null;
                this.supertype = null;
                this.numLocalAttrs = -1;
                this.subtypes = null;
                this.attrJavaNames = null;
                this.internalTypeCode = s2;
                if (oracleTypeADT == null) break block2;
                if (connection != null) break block3;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Invalid arguments").fillInStackTrace();
        }
        this.setPhysicalConnectionOf(connection);
        this.sqlName = null;
        this.pickler = oracleTypeADT;
        this.pickler.setDescriptor(this);
        this.toid = oracleTypeADT.getTOID();
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            OracleTypeMetaData.Kind kind = OracleTypeMetaData.Kind.TYPE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$1, this, (Object)kind);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$1, this, null);
            }
            return kind;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getName() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            Object object;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (this.sqlName == null) {
                object = this.connection.acquireCloseableLock();
                try {
                    this.initSQLName();
                    if (object != null) {
                        ((Monitor.CloseableLock)object).close();
                    }
                }
                catch (Throwable throwable) {
                    if (object != null) {
                        try {
                            ((Monitor.CloseableLock)object).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$2, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            object = null;
            if (this.sqlName != null) {
                object = this.sqlName.getName();
            }
            Monitor.CloseableLock closeableLock = object;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$2, this, closeableLock);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$2, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public SQLName getSQLName() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            SQLName sQLName;
            block12: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$3, this, new Object[0]);
                }
                Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();
                try {
                    if (this.sqlName == null) {
                        this.initSQLName();
                    }
                    SQLName sQLName2 = this.sqlName;
                    if (closeableLock != null) {
                        closeableLock.close();
                    }
                    sQLName = sQLName2;
                    if (!bl) break block12;
                }
                catch (Throwable throwable) {
                    if (closeableLock != null) {
                        try {
                            closeableLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$3, this, throwable3);
                    }
                    throw throwable3;
                }
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$3, this, sQLName);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$3, this, null);
            }
            return sQLName;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$3, this, throwable4);
            }
            throw throwable;
        }
    }

    void initSQLName() throws SQLException {
        if (!this.isTransient) {
            if (this.connection == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
            if (this.pickler != null) {
                this.sqlName = new SQLName(this.pickler.getFullName(), this.connection);
            } else if (this.typeNameByUser != null) {
                this.sqlName = new SQLName(this.typeNameByUser, this.connection);
            } else if (this.toid != null) {
                String string;
                this.typeNameByUser = string = OracleTypeADT.toid2typename(this.connection, this.toid);
                this.sqlName = new SQLName(string, this.connection);
                TypeDescriptor typeDescriptor = null;
                String string2 = this.sqlName.getName();
                typeDescriptor = (TypeDescriptor)this.connection.getDescriptor(string2);
                if (typeDescriptor != null) {
                    this.copyDescriptor(typeDescriptor);
                }
            } else if (this.internalTypeCode == 108 || this.internalTypeCode == 122) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
    }

    @Override
    public String getSchemaName() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            String string = null;
            if (this.sqlName == null) {
                this.initSQLName();
            }
            if (this.sqlName != null) {
                string = this.sqlName.getSchema();
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$5, this, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$5, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    public String getTypeName() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            String string = null;
            if (this.sqlName == null) {
                this.initSQLName();
            }
            if (this.sqlName != null) {
                string = this.sqlName.getSimpleName();
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$6, this, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$6, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleNamedType getPickler() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$7, this, new Object[0]);
            }
            OracleNamedType oracleNamedType = this.pickler;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$7, this, oracleNamedType);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$7, this, null);
            }
            return oracleNamedType;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    public oracle.jdbc.internal.OracleConnection getInternalConnection() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            oracle.jdbc.internal.OracleConnection oracleConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$8, this, oracleConnection);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$8, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public void setPhysicalConnectionOf(Connection connection) {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$9, this, connection);
            }
            this.connection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$9, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getTypeCode() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$10, this, new Object[0]);
            }
            short s2 = this.internalTypeCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$10, this, s2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$10, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getTypeCodeName() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$11, this, new Object[0]);
            }
            String string = TypeDescriptor.getTypeCodeTypeNameMap()[this.getTypeCode()];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$11, this, string);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$11, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    private static String[] getTypeCodeTypeNameMap() throws SQLException {
        if (typeCodeTypeNameMap == null) {
            String[] stringArray = new String[2010];
            Class<?> clazz = null;
            try {
                clazz = Class.forName("oracle.sql.TypeDescriptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (SQLException)DatabaseError.createSqlException(1, "TypeDescriptor.getTypeCodeName: got a ClassNotFoundException: " + classNotFoundException.getMessage()).fillInStackTrace();
            }
            Field[] fieldArray = clazz.getFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (!fieldArray[i2].getName().startsWith("TYPECODE_")) continue;
                try {
                    stringArray[fieldArray[i2].getInt(null)] = fieldArray[i2].getName();
                    continue;
                }
                catch (Exception exception) {
                    throw (SQLException)DatabaseError.createSqlException(1, "TypeDescriptor.getTypeCodeName: " + exception.getMessage()).fillInStackTrace();
                }
            }
            typeCodeTypeNameMap = stringArray;
        }
        return typeCodeTypeNameMap;
    }

    public short getInternalTypeCode() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$13, this, new Object[0]);
            }
            short s2 = this.internalTypeCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$13, this, s2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$13, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isV2available(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$14, null, new Object[]{byArray});
            }
            int n2 = 0;
            while (byArray[n2] == 0) {
                ++n2;
            }
            if (n2 == 13 && byArray[13] == 2 && byArray[14] == 16 && byArray[15] < 67 && byArray[15] >= 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$14, null, bl2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$14, null, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$14, null, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$14, null, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$15, null, string, oracleConnection);
            }
            TypeDescriptor typeDescriptor = null;
            try {
                SQLName sQLName = new SQLName(string, oracleConnection);
                String string2 = sQLName.getName();
                typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2);
                if (typeDescriptor == null) {
                    OracleTypeADT oracleTypeADT = new OracleTypeADT(string, oracleConnection);
                    oracle.jdbc.internal.OracleConnection oracleConnection2 = (oracle.jdbc.internal.OracleConnection)oracleConnection;
                    oracleTypeADT.init(oracleConnection2);
                    typeDescriptor = TypeDescriptor.newDescriptorFromADT(sQLName, oracleConnection, oracleTypeADT);
                    oracleConnection.putDescriptor(string2, typeDescriptor);
                }
            }
            catch (SQLRecoverableException sQLRecoverableException) {
                SQLRecoverableException sQLRecoverableException2 = sQLRecoverableException;
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$15, null, sQLRecoverableException2);
                }
                throw sQLRecoverableException2;
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = (SQLException)DatabaseError.createSqlException(null, sQLException, 60, "Unable to resolve type \"" + string + "\"").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$15, null, sQLException2);
                }
                throw sQLException2;
            }
            catch (Exception exception) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 60, "Unable to resolve type \"" + string + "\"").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$15, null, sQLException);
                }
                throw sQLException;
            }
            TypeDescriptor typeDescriptor2 = typeDescriptor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$15, null, typeDescriptor2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$15, null, null);
            }
            return typeDescriptor2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public static CompletionStage<TypeDescriptor> getTypeDescriptorAsync(String string, oracle.jdbc.OracleConnection oracleConnection) {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            CompletionStage<Object> completionStage;
            String string2;
            SQLName sQLName;
            block8: {
                CompletableFuture<TypeDescriptor> completableFuture;
                block9: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$16, null, string, oracleConnection);
                    }
                    sQLName = new SQLName(string, oracleConnection);
                    string2 = sQLName.getName();
                    TypeDescriptor typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2);
                    if (typeDescriptor == null) break block8;
                    completableFuture = CompletableFuture.completedFuture(typeDescriptor);
                    if (!bl) break block9;
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$16, null, completableFuture);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$16, null, null);
                }
                return completableFuture;
            }
            try {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(string, oracleConnection);
                oracle.jdbc.internal.OracleConnection oracleConnection2 = (oracle.jdbc.internal.OracleConnection)oracleConnection;
                completionStage = oracleTypeADT.initAsync(oracleConnection2).thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
                    TypeDescriptor typeDescriptor = TypeDescriptor.newDescriptorFromADT(sQLName, oracleConnection, oracleTypeADT);
                    oracleConnection.putDescriptor(string2, typeDescriptor);
                    return typeDescriptor;
                }));
            }
            catch (Exception exception) {
                completionStage = CompletableFuture.failedStage(exception);
            }
            CompletionStage<TypeDescriptor> completionStage2 = completionStage.exceptionally(throwable -> {
                Throwable throwable2 = CompletionStageUtil.unwrapCompletionException(throwable);
                SQLException sQLException = throwable2 instanceof SQLRecoverableException ? (SQLRecoverableException)throwable2 : (throwable2 instanceof SQLException ? (SQLException)DatabaseError.createSqlException(null, (SQLException)throwable2, 60, "Unable to resolve type \"" + string + "\"").fillInStackTrace() : (SQLException)DatabaseError.createSqlException(null, 60, "Unable to resolve type \"" + string + "\"").fillInStackTrace());
                throw new CompletionException(sQLException);
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$16, null, completionStage2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$16, null, null);
            }
            return completionStage2;
        }
        catch (Throwable throwable2) {
            ClioSupport.publicExit();
            Throwable throwable3 = throwable2;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$16, null, throwable3);
            }
            throw throwable2;
        }
    }

    private static TypeDescriptor newDescriptorFromADT(SQLName sQLName, oracle.jdbc.OracleConnection oracleConnection, OracleTypeADT oracleTypeADT) throws SQLException {
        TypeDescriptor typeDescriptor;
        OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
        switch (oracleNamedType.getTypeCode()) {
            case 2002: 
            case 2008: {
                typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, (Connection)oracleConnection);
                break;
            }
            case 2003: {
                typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                break;
            }
            case 2007: {
                typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(1).fillInStackTrace();
            }
        }
        oracleNamedType.setDescriptor(typeDescriptor);
        return typeDescriptor;
    }

    public static TypeDescriptor getTypeDescriptor(String string, oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$18, null, string, oracleConnection, byArray, l2);
            }
            TypeDescriptor typeDescriptor = null;
            String string2 = TypeDescriptor.getSubtypeName(oracleConnection, byArray, l2);
            if (string2 == null) {
                string2 = string;
            }
            if ((typeDescriptor = (TypeDescriptor)oracleConnection.getDescriptor(string2)) == null) {
                SQLName sQLName = new SQLName(string2, oracleConnection);
                OracleTypeADT oracleTypeADT = new OracleTypeADT(string2, oracleConnection);
                oracle.jdbc.internal.OracleConnection oracleConnection2 = (oracle.jdbc.internal.OracleConnection)oracleConnection;
                oracleTypeADT.init(oracleConnection2);
                OracleNamedType oracleNamedType = oracleTypeADT.cleanup();
                switch (oracleNamedType.getTypeCode()) {
                    case 2002: 
                    case 2008: {
                        typeDescriptor = new StructDescriptor(sQLName, (OracleTypeADT)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    case 2003: {
                        typeDescriptor = new ArrayDescriptor(sQLName, (OracleTypeCOLLECTION)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    case 2007: {
                        typeDescriptor = new OpaqueDescriptor(sQLName, (OracleTypeOPAQUE)oracleNamedType, (Connection)oracleConnection);
                        break;
                    }
                    default: {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(1).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$18, null, sQLException);
                        }
                        throw sQLException;
                    }
                }
                oracleConnection.putDescriptor(string2, typeDescriptor);
            }
            TypeDescriptor typeDescriptor2 = typeDescriptor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$18, null, typeDescriptor2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$18, null, null);
            }
            return typeDescriptor2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Datum toDatum(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$19, this, connection);
            }
            this.connection = connection instanceof OracleConnectionWrapper && !(connection instanceof OracleConnection) ? (oracle.jdbc.internal.OracleConnection)((OracleConnectionWrapper)connection).unwrap() : (oracle.jdbc.internal.OracleConnection)connection;
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.ANYTYPE", connection);
            byte[] byArray = new byte[this.getOpaqueImageTypeSize()];
            this.pickleOpaqueTypeImage(byArray, 0, false);
            OPAQUE oPAQUE = new OPAQUE(opaqueDescriptor, this.connection, byArray);
            oPAQUE.setShareBytes(oPAQUE.toBytes());
            OPAQUE oPAQUE2 = oPAQUE;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$19, this, oPAQUE2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$19, this, null);
            }
            return oPAQUE2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJDBCObject(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$20, this, connection);
            }
            Datum datum = this.toDatum(connection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$20, this, datum);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$20, this, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static TypeDescriptor unpickleOpaqueTypeImage(PickleContext pickleContext, Connection connection, short[] sArray) throws SQLException {
        byte[] byArray = null;
        TypeDescriptor typeDescriptor = null;
        int n2 = pickleContext.offset();
        byte[] byArray2 = pickleContext.image();
        pickleContext.skipBytes(1);
        short s2 = (short)pickleContext.readUB2();
        sArray[0] = (short)pickleContext.readUB2();
        if ((s2 & 0x20) != 0) {
            throw (SQLException)DatabaseError.createSqlException(178).fillInStackTrace();
        }
        if ((s2 & 1) == 0) {
            if ((s2 & 2) == 0 || sArray[0] == 110 || sArray[0] == 58) {
                byArray = pickleContext.readDataValue(16);
                int n3 = pickleContext.readUB2();
                String string = (String)((oracle.jdbc.internal.OracleConnection)connection).getDescriptor(byArray);
                typeDescriptor = (TypeDescriptor)((oracle.jdbc.internal.OracleConnection)connection).getDescriptor(string);
                if (typeDescriptor == null) {
                    if (sArray[0] == 122) {
                        typeDescriptor = new ArrayDescriptor(byArray, n3, connection);
                    } else if (sArray[0] == 108 || sArray[0] == 110) {
                        typeDescriptor = new StructDescriptor(byArray, n3, connection);
                    } else {
                        if (sArray[0] != 58) throw (SQLException)DatabaseError.createSqlException(178).fillInStackTrace();
                        typeDescriptor = new OpaqueDescriptor(byArray, n3, connection);
                    }
                }
            } else {
                typeDescriptor = new TypeDescriptor(sArray[0]);
            }
            typeDescriptor.setTransient(false);
        } else {
            int n4 = (int)pickleContext.readUB4();
            if (sArray[0] == 108) {
                AttributeDescriptor[] attributeDescriptorArray = null;
                if (n4 > 0) {
                    attributeDescriptorArray = new AttributeDescriptor[n4];
                    for (int i2 = 0; i2 < n4; ++i2) {
                        byte by = pickleContext.readByte();
                        attributeDescriptorArray[i2] = Kotad.unpickleAttributeImage(by == 2, pickleContext);
                        if (by == 2) continue;
                        short[] sArray2 = new short[1];
                        attributeDescriptorArray[i2].setTypeDescriptor(TypeDescriptor.unpickleOpaqueTypeImage(pickleContext, connection, sArray2));
                    }
                }
                typeDescriptor = new StructDescriptor(attributeDescriptorArray, connection);
            } else {
                if (n4 != 1) throw (SQLException)DatabaseError.createSqlException(178).fillInStackTrace();
                byte by = pickleContext.readByte();
                typeDescriptor = Kotad.unpickleTypeDescriptorImage(pickleContext);
            }
            typeDescriptor.setTransient(true);
        }
        if (!typeDescriptor.isTransient()) return typeDescriptor;
        int n5 = pickleContext.offset();
        byte[] byArray3 = new byte[n5 - n2];
        System.arraycopy(byArray2, n2, byArray3, 0, byArray3.length);
        typeDescriptor.setTransientImage(byArray3);
        return typeDescriptor;
    }

    void setTransientImage(byte[] byArray) {
        this.transientImage = byArray;
    }

    void setTransient(boolean bl) {
        this.isTransient = bl;
    }

    public boolean isTransient() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$24, this, new Object[0]);
            }
            boolean bl2 = this.isTransient;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$24, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$24, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    int getOpaqueImageTypeSize() {
        int n2 = 0;
        if (this.isTransient) {
            n2 = this.transientImage.length;
        } else {
            n2 = 5;
            if (this.toid != null && this.toid.length == 16) {
                n2 = 23;
            }
        }
        return n2;
    }

    int pickleOpaqueTypeImage(byte[] byArray, int n2, boolean bl) {
        if (this.isTransient) {
            System.arraycopy(this.transientImage, 0, byArray, n2, this.transientImage.length);
            n2 += this.transientImage.length;
        } else {
            boolean bl2 = false;
            if (this.toid != null && this.toid.length == 16) {
                bl2 = true;
            }
            byArray[n2++] = 1;
            int n3 = this.internalTypeCode;
            if (bl) {
                n3 = 110;
            }
            int n4 = 512;
            if (n3 != 108 && n3 != 122) {
                n4 |= 2;
            }
            if (bl2 && n3 != 110) {
                n4 |= 4;
            }
            byArray[n2++] = (byte)((n4 & 0xFF00) >> 8 & 0xFF);
            byArray[n2++] = (byte)(n4 & 0xFF);
            byArray[n2++] = (byte)((n3 & 0xFF00) >> 8 & 0xFF);
            byArray[n2++] = (byte)(n3 & 0xFF);
            if (bl2) {
                System.arraycopy(this.toid, 0, byArray, n2, this.toid.length);
                n2 += this.toid.length;
                byArray[n2++] = (byte)((this.toidVersion & 0xFF00) >> 8 & 0xFF);
                byArray[n2++] = (byte)(this.toidVersion & 0xFF);
            }
        }
        return n2;
    }

    public void setPrecision(long l2) {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$27, this, l2);
            }
            this.precision = l2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$27, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    public long getPrecision() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$28, this, new Object[0]);
            }
            long l2 = this.precision;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$28, this, l2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$28, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    public void setScale(byte by) {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$29, this, by);
            }
            this.scale = by;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$29, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    public byte getScale() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$30, this, new Object[0]);
            }
            byte by = this.scale;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$30, this, by);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$30, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$31, this, string);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$31, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$31, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            if (this.sqlName == null) {
                this.initSQLName();
            }
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        objectOutputStream.writeObject(this.sqlName);
        objectOutputStream.writeObject(this.pickler);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.sqlName = (SQLName)objectInputStream.readObject();
        this.pickler = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(Connection connection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$34, this, connection);
            }
            this.setPhysicalConnectionOf(connection);
            this.pickler.setConnection(this.getInternalConnection());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$34, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$34, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    public static String getSubtypeName(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, long l2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$35, null, oracleConnection, byArray, l2);
            }
            if (byArray == null || byArray.length == 0 || oracleConnection == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(68, " 'image' should not be empty and 'conn' should not be null. ").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$35, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$35, null, sQLException);
                }
                throw sQLException;
            }
            String string2 = string = OracleTypeADT.getSubtypeName(oracleConnection, byArray, l2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$35, null, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$35, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    public void initMetadataRecursively() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$36, this, new Object[0]);
            }
            if (this.pickler != null) {
                this.pickler.initMetadataRecursively();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$36, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$36, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    public void initNamesRecursively() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$37, this, new Object[0]);
            }
            if (this.pickler != null) {
                this.pickler.initNamesRecursively();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$37, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$37, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    public void fixupConnection(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$38, this, oracleConnection);
            }
            if (this.connection == null) {
                this.connection = oracleConnection;
            }
            if (this.pickler != null) {
                this.pickler.fixupConnection(oracleConnection);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$38, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$38, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toXMLString() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$39, this, new Object[0]);
            }
            String string = this.toXMLString(false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$39, this, string);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$39, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toXMLString(boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$40, this, bl);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.printXMLHeader(printWriter);
            this.printXML(printWriter, 0, bl);
            String string = stringWriter.getBuffer().substring(0);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$40, this, string);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$40, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    public void printXML(PrintStream printStream) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$41, this, printStream);
            }
            this.printXML(printStream, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$41, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$41, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    public void printXML(PrintStream printStream, boolean bl) throws SQLException {
        boolean bl2 = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$42, this, printStream, bl);
            }
            PrintWriter printWriter = new PrintWriter(printStream, true);
            this.printXMLHeader(printWriter);
            this.printXML(printWriter, 0, bl);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$42, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        String string = this.tagName();
        printWriter.println("<" + string + " sqlName=\"" + this.getName() + "\" >");
        if (this.pickler != null) {
            this.pickler.printXML(printWriter, n2 + 1, bl);
        }
        printWriter.println("</" + string + ">");
    }

    String tagName() {
        return "TypeDescriptor";
    }

    void printXMLHeader(PrintWriter printWriter) throws SQLException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    public static String convToUpperCase(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$47, null, string);
            }
            if (string != null && !string.startsWith("\"")) {
                char[] cArray = string.toCharArray();
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = Character.toUpperCase(cArray[i2]);
                }
                string = String.copyValueOf(cArray);
            }
            String string2 = string;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$47, null, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$47, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public Class getClass(Map map) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$48, this, map);
            }
            String string = this.getName();
            Class clazz = this.connection.getClassForType(string, map);
            String string2 = this.getSchemaName();
            String string3 = this.getTypeName();
            if (clazz == null) {
                clazz = (Class)map.get(string3);
            }
            if (clazz == null) {
                if (this.connection.isProxySession()) {
                    string2 = TypeDescriptor.convToUpperCase(string2);
                }
                clazz = (Class)map.get(string2 + "." + string3);
            }
            if (SQLName.s_parseAllFormat) {
                if (clazz == null && this.connection.getDefaultSchemaNameForNamedTypes().equals(string2)) {
                    clazz = (Class)map.get("\"" + string3 + "\"");
                }
                if (clazz == null) {
                    clazz = (Class)map.get("\"" + string2 + "\".\"" + string3 + "\"");
                }
                if (clazz == null) {
                    clazz = (Class)map.get("\"" + string2 + "\"." + string3);
                }
                if (clazz == null) {
                    clazz = (Class)map.get(string2 + ".\"" + string3 + "\"");
                }
            }
            Class clazz2 = clazz;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$48, this, clazz2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$48, this, null);
            }
            return clazz2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void setACProxy(Object object) {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$49, this, object);
            }
            this.acProxy = object;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$49, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$49, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object getACProxy() {
        boolean bl = ClioSupport.publicEnter() && (0x100000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$50, this, new Object[0]);
            }
            Object object = this.acProxy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$50, this, object);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$50, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, TypeDescriptor.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$57 = TypeDescriptor.class.getDeclaredConstructor(Short.TYPE, OracleTypeADT.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$56 = TypeDescriptor.class.getDeclaredConstructor(Short.TYPE, SQLName.class, OracleTypeADT.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$55 = TypeDescriptor.class.getDeclaredConstructor(Short.TYPE, SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$54 = TypeDescriptor.class.getDeclaredConstructor(Short.TYPE, String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$53 = TypeDescriptor.class.getDeclaredConstructor(Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$52 = TypeDescriptor.class.getDeclaredMethod("lambda$getTypeDescriptorAsync$0", SQLName.class, oracle.jdbc.OracleConnection.class, OracleTypeADT.class, String.class, Void.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = TypeDescriptor.class.getDeclaredMethod("lambda$getTypeDescriptorAsync$1", String.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = TypeDescriptor.class.getDeclaredMethod("getACProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = TypeDescriptor.class.getDeclaredMethod("setACProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = TypeDescriptor.class.getDeclaredMethod("getClass", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = TypeDescriptor.class.getDeclaredMethod("convToUpperCase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = TypeDescriptor.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = TypeDescriptor.class.getDeclaredMethod("printXMLHeader", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = TypeDescriptor.class.getDeclaredMethod("tagName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = TypeDescriptor.class.getDeclaredMethod("printXML", PrintWriter.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = TypeDescriptor.class.getDeclaredMethod("printXML", PrintStream.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = TypeDescriptor.class.getDeclaredMethod("printXML", PrintStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = TypeDescriptor.class.getDeclaredMethod("toXMLString", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = TypeDescriptor.class.getDeclaredMethod("toXMLString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = TypeDescriptor.class.getDeclaredMethod("fixupConnection", oracle.jdbc.internal.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = TypeDescriptor.class.getDeclaredMethod("initNamesRecursively", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = TypeDescriptor.class.getDeclaredMethod("initMetadataRecursively", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = TypeDescriptor.class.getDeclaredMethod("getSubtypeName", oracle.jdbc.OracleConnection.class, byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = TypeDescriptor.class.getDeclaredMethod("setConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = TypeDescriptor.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = TypeDescriptor.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = TypeDescriptor.class.getDeclaredMethod("isInHierarchyOf", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = TypeDescriptor.class.getDeclaredMethod("getScale", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = TypeDescriptor.class.getDeclaredMethod("setScale", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = TypeDescriptor.class.getDeclaredMethod("getPrecision", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = TypeDescriptor.class.getDeclaredMethod("setPrecision", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = TypeDescriptor.class.getDeclaredMethod("pickleOpaqueTypeImage", byte[].class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = TypeDescriptor.class.getDeclaredMethod("getOpaqueImageTypeSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = TypeDescriptor.class.getDeclaredMethod("isTransient", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = TypeDescriptor.class.getDeclaredMethod("setTransient", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = TypeDescriptor.class.getDeclaredMethod("setTransientImage", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = TypeDescriptor.class.getDeclaredMethod("unpickleOpaqueTypeImage", PickleContext.class, Connection.class, short[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = TypeDescriptor.class.getDeclaredMethod("toJDBCObject", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = TypeDescriptor.class.getDeclaredMethod("toDatum", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = TypeDescriptor.class.getDeclaredMethod("getTypeDescriptor", String.class, oracle.jdbc.OracleConnection.class, byte[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = TypeDescriptor.class.getDeclaredMethod("newDescriptorFromADT", SQLName.class, oracle.jdbc.OracleConnection.class, OracleTypeADT.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = TypeDescriptor.class.getDeclaredMethod("getTypeDescriptorAsync", String.class, oracle.jdbc.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = TypeDescriptor.class.getDeclaredMethod("getTypeDescriptor", String.class, oracle.jdbc.OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = TypeDescriptor.class.getDeclaredMethod("isV2available", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = TypeDescriptor.class.getDeclaredMethod("getInternalTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = TypeDescriptor.class.getDeclaredMethod("getTypeCodeTypeNameMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = TypeDescriptor.class.getDeclaredMethod("getTypeCodeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = TypeDescriptor.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = TypeDescriptor.class.getDeclaredMethod("setPhysicalConnectionOf", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = TypeDescriptor.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = TypeDescriptor.class.getDeclaredMethod("getPickler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = TypeDescriptor.class.getDeclaredMethod("getTypeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = TypeDescriptor.class.getDeclaredMethod("getSchemaName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = TypeDescriptor.class.getDeclaredMethod("initSQLName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = TypeDescriptor.class.getDeclaredMethod("getSQLName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = TypeDescriptor.class.getDeclaredMethod("getName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = TypeDescriptor.class.getDeclaredMethod("getKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = TypeDescriptor.class.getDeclaredMethod("copyDescriptor", TypeDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        DEBUG_SERIALIZATION = false;
        KOTTDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1};
        KOTTBEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2};
        KOTADEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3};
        KOTMDEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4};
        KOTTBXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 66};
        KOTADXEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 67};
        KOTTDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        KOTTBTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2};
        KOTADTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3};
        KOTMDTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5};
        KOTMITOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6};
        KOTEXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7};
        KOTEX1TOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57};
        KOTTBXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66};
        KOTADXTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67};
        RAWTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23};
        JSONTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71};
        ANYTYPETOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 16};
        ANYDATATOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 17};
        ANYDATASETTOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 18};
        XMLTYPETOID = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0};
        OID_TO_TYPECODE = new short[72];
        TypeDescriptor.OID_TO_TYPECODE[8] = 12;
        TypeDescriptor.OID_TO_TYPECODE[9] = 27;
        TypeDescriptor.OID_TO_TYPECODE[10] = 28;
        TypeDescriptor.OID_TO_TYPECODE[11] = 29;
        TypeDescriptor.OID_TO_TYPECODE[12] = 21;
        TypeDescriptor.OID_TO_TYPECODE[13] = 22;
        TypeDescriptor.OID_TO_TYPECODE[14] = 4;
        TypeDescriptor.OID_TO_TYPECODE[15] = 2;
        TypeDescriptor.OID_TO_TYPECODE[16] = 7;
        TypeDescriptor.OID_TO_TYPECODE[17] = 23;
        TypeDescriptor.OID_TO_TYPECODE[18] = 25;
        TypeDescriptor.OID_TO_TYPECODE[19] = 26;
        TypeDescriptor.OID_TO_TYPECODE[20] = 245;
        TypeDescriptor.OID_TO_TYPECODE[21] = 246;
        TypeDescriptor.OID_TO_TYPECODE[22] = 3;
        TypeDescriptor.OID_TO_TYPECODE[23] = 95;
        TypeDescriptor.OID_TO_TYPECODE[24] = 32;
        TypeDescriptor.OID_TO_TYPECODE[25] = 9;
        TypeDescriptor.OID_TO_TYPECODE[26] = 96;
        TypeDescriptor.OID_TO_TYPECODE[27] = 1;
        TypeDescriptor.OID_TO_TYPECODE[28] = 105;
        TypeDescriptor.OID_TO_TYPECODE[29] = 247;
        TypeDescriptor.OID_TO_TYPECODE[30] = 248;
        TypeDescriptor.OID_TO_TYPECODE[31] = 108;
        TypeDescriptor.OID_TO_TYPECODE[32] = 0;
        TypeDescriptor.OID_TO_TYPECODE[33] = 0;
        TypeDescriptor.OID_TO_TYPECODE[34] = 112;
        TypeDescriptor.OID_TO_TYPECODE[35] = 113;
        TypeDescriptor.OID_TO_TYPECODE[36] = 115;
        TypeDescriptor.OID_TO_TYPECODE[37] = 114;
        TypeDescriptor.OID_TO_TYPECODE[38] = 0;
        TypeDescriptor.OID_TO_TYPECODE[39] = 0;
        TypeDescriptor.OID_TO_TYPECODE[40] = 0;
        TypeDescriptor.OID_TO_TYPECODE[41] = 0;
        TypeDescriptor.OID_TO_TYPECODE[42] = 0;
        TypeDescriptor.OID_TO_TYPECODE[43] = 0;
        TypeDescriptor.OID_TO_TYPECODE[44] = 0;
        TypeDescriptor.OID_TO_TYPECODE[45] = 0;
        TypeDescriptor.OID_TO_TYPECODE[46] = 0;
        TypeDescriptor.OID_TO_TYPECODE[47] = 0;
        TypeDescriptor.OID_TO_TYPECODE[48] = 0;
        TypeDescriptor.OID_TO_TYPECODE[49] = 0;
        TypeDescriptor.OID_TO_TYPECODE[50] = 0;
        TypeDescriptor.OID_TO_TYPECODE[51] = 0;
        TypeDescriptor.OID_TO_TYPECODE[52] = 0;
        TypeDescriptor.OID_TO_TYPECODE[53] = 0;
        TypeDescriptor.OID_TO_TYPECODE[54] = 0;
        TypeDescriptor.OID_TO_TYPECODE[55] = 0;
        TypeDescriptor.OID_TO_TYPECODE[56] = 0;
        TypeDescriptor.OID_TO_TYPECODE[57] = 0;
        TypeDescriptor.OID_TO_TYPECODE[58] = 58;
        TypeDescriptor.OID_TO_TYPECODE[59] = 185;
        TypeDescriptor.OID_TO_TYPECODE[60] = 186;
        TypeDescriptor.OID_TO_TYPECODE[61] = 187;
        TypeDescriptor.OID_TO_TYPECODE[62] = 188;
        TypeDescriptor.OID_TO_TYPECODE[63] = 189;
        TypeDescriptor.OID_TO_TYPECODE[64] = 190;
        TypeDescriptor.OID_TO_TYPECODE[65] = 232;
        TypeDescriptor.OID_TO_TYPECODE[66] = 0;
        TypeDescriptor.OID_TO_TYPECODE[67] = 0;
        TypeDescriptor.OID_TO_TYPECODE[68] = 100;
        TypeDescriptor.OID_TO_TYPECODE[69] = 101;
        TypeDescriptor.OID_TO_TYPECODE[70] = 104;
        typeCodeTypeNameMap = null;
        try {
            TypeDescriptor.getTypeCodeTypeNameMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

