/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDate;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;
import oracle.sql.LdxLib;
import oracle.sql.LdxLibThin;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class DATE
extends Datum
implements OracleDate {
    static final long serialVersionUID = 5229717576495161269L;
    public static final int BDA = 1;
    public static final int BDAL = 2;
    public static final int BMO = 4;
    public static final int BMOL = 8;
    public static final int BYR = 16;
    public static final int BYRL = 32;
    public static final int BHR = 64;
    public static final int BHRL = 128;
    public static final int BMN = 256;
    public static final int BMNL = 512;
    public static final int BSC = 1024;
    public static final int BSCL = 2048;
    public static final int MSD = 4096;
    public static final int YR0 = 8192;
    public static final int BDT = 32768;
    public static final int HRZER0 = 65536;
    public static final int MIZERO = 131072;
    public static final int SEZERO = 262144;
    private static final byte LDXTCE = 0;
    private static final byte LDXTYE = 1;
    private static final byte LDXTMO = 2;
    private static final byte LDXTDA = 3;
    private static final byte LDXTHO = 4;
    private static final byte LDXTMI = 5;
    private static final byte LDXTSE = 6;
    private static LdxLib _sldxlib;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;

    public DATE() {
        super(DATE._initDate());
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DATE.class, $$$methodRef$$$47, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(byte[] byArray) {
        super(byArray);
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null, new Object[]{byArray});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DATE.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Date date) {
        super(DATE.toBytes(date));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DATE.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Time time) {
        super(DATE.toBytes(time));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null, time);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DATE.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Timestamp timestamp) {
        super(DATE.toBytes(timestamp));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null, timestamp);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DATE.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Date date, Calendar calendar) {
        super(DATE.toBytes(date, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null, date, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DATE.class, $$$methodRef$$$52, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Time time, Calendar calendar) {
        super(DATE.toBytes(time, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null, time, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DATE.class, $$$methodRef$$$53, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Timestamp timestamp, Calendar calendar) {
        super(DATE.toBytes(timestamp, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null, timestamp, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DATE.class, $$$methodRef$$$54, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(String string) {
        super(DATE.toBytes(string));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null, string);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DATE.class, $$$methodRef$$$55, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(String string, boolean bl) throws ParseException {
        super(DATE.toBytes(string));
        boolean bl2 = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null, string, bl);
            }
            if (!bl) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                simpleDateFormat.setLenient(false);
                java.util.Date date = simpleDateFormat.parse(string);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DATE.class, $$$methodRef$$$56, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(String string, Calendar calendar) {
        super(DATE.toBytes(string, calendar));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null, string, calendar);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DATE.class, $$$methodRef$$$57, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Object object) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, object);
            }
            if (object instanceof Date) {
                this.setShareBytes(DATE.toBytes((Date)object));
            } else if (object instanceof Time) {
                this.setShareBytes(DATE.toBytes((Time)object));
            } else if (object instanceof Timestamp) {
                this.setShareBytes(DATE.toBytes((Timestamp)object));
            } else if (object instanceof String) {
                this.setShareBytes(DATE.toBytes((String)object));
            } else {
                SQLException sQLException = new SQLException("Initialization failed");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DATE.class, $$$methodRef$$$58, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE(Object object, Calendar calendar) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, object, calendar);
            }
            if (object instanceof Date) {
                this.setShareBytes(DATE.toBytes((Date)object, calendar));
            } else if (object instanceof Time) {
                this.setShareBytes(DATE.toBytes((Time)object, calendar));
            } else if (object instanceof Timestamp) {
                this.setShareBytes(DATE.toBytes((Timestamp)object, calendar));
            } else if (object instanceof String) {
                this.setShareBytes(DATE.toBytes((String)object, calendar));
            } else {
                SQLException sQLException = new SQLException("Initialization failed");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DATE.class, $$$methodRef$$$59, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Date toDate(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, new Object[]{byArray});
            }
            Date date = DATE.toDate(byArray, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, date);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DATE.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Time toTime(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, new Object[]{byArray});
            }
            Time time = DATE.toTime(byArray, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, time);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DATE.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp(byte[] byArray) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, new Object[]{byArray});
            }
            Timestamp timestamp = DATE.toTimestamp(byArray, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DATE.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Date toDate(byte[] byArray, Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Date date;
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, byArray, calendar);
            }
            int[] nArray = new int[7];
            for (n2 = 0; n2 < 7; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.set(1, n2);
            calendar2.set(2, nArray[2] - 1);
            calendar2.set(5, nArray[3]);
            if (!OracleDriver.getSystemPropertyDateZeroTimeExtra()) {
                calendar2.set(11, nArray[4] - 1);
                calendar2.set(12, nArray[5] - 1);
                calendar2.set(13, nArray[6] - 1);
            } else {
                calendar2.set(11, 0);
                calendar2.set(12, 0);
                calendar2.set(13, 0);
            }
            calendar2.set(14, 0);
            Date date2 = date = new Date(calendar2.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, date2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, null);
            }
            return date2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DATE.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Time toTime(byte[] byArray, Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, byArray, calendar);
            }
            int n2 = byArray[4] & 0xFF;
            int n3 = byArray[5] & 0xFF;
            int n4 = byArray[6] & 0xFF;
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.set(1, 1970);
            calendar2.set(2, 0);
            calendar2.set(5, 1);
            calendar2.set(11, n2 - 1);
            calendar2.set(12, n3 - 1);
            calendar2.set(13, n4 - 1);
            calendar2.set(14, 0);
            Time time = new Time(calendar2.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, time);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DATE.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp(byte[] byArray, Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Timestamp timestamp;
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, byArray, calendar);
            }
            int[] nArray = new int[7];
            for (n2 = 0; n2 < 7; ++n2) {
                nArray[n2] = byArray[n2] & 0xFF;
            }
            n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.set(1, n2);
            calendar2.set(2, nArray[2] - 1);
            calendar2.set(5, nArray[3]);
            calendar2.set(11, nArray[4] - 1);
            calendar2.set(12, nArray[5] - 1);
            calendar2.set(13, nArray[6] - 1);
            calendar2.set(14, 0);
            Timestamp timestamp2 = timestamp = new Timestamp(calendar2.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, timestamp2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, null);
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DATE.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static String toString(byte[] byArray) {
        int n2;
        if (byArray == null || byArray.length == 0) {
            return new String();
        }
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4] - 1;
        int n6 = nArray[5] - 1;
        int n7 = nArray[6] - 1;
        int n8 = -1;
        String string = TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, -1, null);
        return string;
    }

    @Override
    public byte[] toBytes() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, new Object[0]);
            }
            byte[] byArray = this.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DATE.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Date date) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, date);
            }
            byte[] byArray = DATE.toBytes(date, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DATE.class, $$$methodRef$$$7, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Time time) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, time);
            }
            byte[] byArray = DATE.toBytes(time, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DATE.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Timestamp timestamp) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, timestamp);
            }
            byte[] byArray = DATE.toBytes(timestamp, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DATE.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Date date, Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, date, calendar);
            }
            if (date == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, null);
                }
                return null;
            }
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(date);
            byte[] byArray = new byte[7];
            int n2 = TIMESTAMP.getOracleYear(calendar2);
            byArray[0] = (byte)(n2 / 100 + 100);
            byArray[1] = (byte)(n2 % 100 + 100);
            byArray[2] = (byte)(calendar2.get(2) + 1);
            byArray[3] = (byte)calendar2.get(5);
            if (!OracleDriver.getSystemPropertyDateZeroTime()) {
                byArray[4] = (byte)(calendar2.get(11) + 1);
                byArray[5] = (byte)(calendar2.get(12) + 1);
                byArray[6] = (byte)(calendar2.get(13) + 1);
            } else {
                byArray[4] = 1;
                byArray[5] = 1;
                byArray[6] = 1;
            }
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DATE.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Time time, Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, time, calendar);
            }
            if (time == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, null);
                }
                return null;
            }
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(time);
            byte[] byArray = new byte[]{119, -86, 1, 1, (byte)(calendar2.get(11) + 1), (byte)(calendar2.get(12) + 1), (byte)(calendar2.get(13) + 1)};
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DATE.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, timestamp, calendar);
            }
            if (timestamp == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, byArray);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, null);
                }
                return null;
            }
            Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
            calendar2.clear();
            calendar2.setTime(timestamp);
            byte[] byArray = new byte[7];
            int n2 = TIMESTAMP.getOracleYear(calendar2);
            byArray[0] = (byte)(n2 / 100 + 100);
            byArray[1] = (byte)(n2 % 100 + 100);
            byArray[2] = (byte)(calendar2.get(2) + 1);
            byArray[3] = (byte)calendar2.get(5);
            byArray[4] = (byte)(calendar2.get(11) + 1);
            byArray[5] = (byte)(calendar2.get(12) + 1);
            byArray[6] = (byte)(calendar2.get(13) + 1);
            byte[] byArray2 = byArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, byArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DATE.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(String string) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, string);
            }
            if (string == null) {
                byte[] byArray2 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, byArray2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, null);
                }
                return null;
            }
            byte[] byArray3 = byArray = DATE.toBytes(Timestamp.valueOf(string));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, byArray3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DATE.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static byte[] toBytes(String string, Calendar calendar) {
        return DATE.toBytes(Timestamp.valueOf(string), calendar);
    }

    @Override
    @DisableTrace
    public Date dateValue() {
        return DATE.toDate(this.getBytes());
    }

    @Override
    @DisableTrace
    public Time timeValue() {
        return DATE.toTime(this.getBytes());
    }

    @Override
    public Timestamp timestampValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, new Object[0]);
            }
            Timestamp timestamp = DATE.toTimestamp(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DATE.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public Date dateValue(Calendar calendar) {
        return DATE.toDate(this.getBytes(), calendar);
    }

    @Override
    @DisableTrace
    public Time timeValue(Calendar calendar) {
        return DATE.toTime(this.getBytes(), calendar);
    }

    @Override
    @DisableTrace
    public Timestamp timestampValue(Calendar calendar) {
        return DATE.toTimestamp(this.getBytes(), calendar);
    }

    @Override
    @DisableTrace
    public String stringValue() {
        return DATE.toString(this.getBytes());
    }

    @DisableTrace
    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object toJdbc() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, new Object[0]);
            }
            Timestamp timestamp = this.timestampValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, timestamp);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DATE.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Timestamp[] timestampArray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, n2);
            }
            Timestamp[] timestampArray2 = timestampArray = new Timestamp[n2];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, timestampArray2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, null);
            }
            return timestampArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DATE.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, clazz);
            }
            if (clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, bl2);
                    ClioSupport.publicExit();
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, bl3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DATE.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    public DATE addJulianDays(int n2, int n3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, n2, n3);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxads(this.shareBytes(), n2, n3));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DATE.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    public DATE addMonths(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, n2);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxadm(this.shareBytes(), n2));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DATE.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    public DATE zeroTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, new Object[0]);
            }
            byte[] byArray = this.toBytes();
            byArray[4] = 1;
            byArray[5] = 1;
            byArray[6] = 1;
            DATE dATE = new DATE(byArray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DATE.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    public void diffInJulianDays(DATE dATE, int[] nArray, int[] nArray2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this, dATE, nArray, nArray2);
            }
            DATE._getLdxLib().ldxsub(this.shareBytes(), dATE.shareBytes(), nArray, nArray2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DATE.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER diffInMonths(DATE dATE) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, dATE);
            }
            NUMBER nUMBER = new NUMBER(DATE._getLdxLib().ldxsbm(this.shareBytes(), dATE.shareBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, nUMBER);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DATE.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE getCurrentDate() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, new Object[0]);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxgdt());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DATE.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    public static int checkValidity(byte[] byArray) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, new Object[]{byArray});
            }
            int n2 = DATE._getLdxLib().ldxchk(byArray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DATE.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE fromJulianDays(int n2, int n3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, n2, n3);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxdfd(n2, n3));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DATE.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE fromText(String string, String string2, String string3) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, string, string2, string3);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxstd(string, string2, string3));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DATE.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE lastDayOfMonth() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, new Object[0]);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxldd(this.shareBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DATE.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    public static void numberToJulianDays(NUMBER nUMBER, int[] nArray, int[] nArray2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null, nUMBER, nArray, nArray2);
            }
            DATE._getLdxLib().ldxftd(nUMBER.toBytes(), nArray, nArray2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DATE.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE round(String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, string);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxrnd(this.shareBytes(), string));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DATE.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    public DATE setDayOfWeek(int n2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, n2);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxnxd(this.shareBytes(), n2));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DATE.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    public void toJulianDays(int[] nArray, int[] nArray2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this, nArray, nArray2);
            }
            DATE._getLdxLib().ldxdtd(this.shareBytes(), nArray, nArray2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DATE.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    public NUMBER toNumber() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, new Object[0]);
            }
            NUMBER nUMBER = new NUMBER(DATE._getLdxLib().ldxdyf(this.shareBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, nUMBER);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DATE.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toText(String string, String string2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, string, string2);
            }
            String string3 = DATE._getLdxLib().ldxdts(this.shareBytes(), string, string2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, string3);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DATE.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toText(byte[] byArray, String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, byArray, string);
            }
            String string2 = DATE._getLdxLib().ldxdts(this.shareBytes(), byArray, string);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DATE.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] parseFormat(String string, String string2) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, string, string2);
            }
            byte[] byArray = DATE._getLdxLib().ldxsto(string, string2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, byArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DATE.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    public DATE truncate(String string) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, string);
            }
            DATE dATE = new DATE(DATE._getLdxLib().ldxtrn(this.shareBytes(), string));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DATE.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    public int compareTo(DATE dATE) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, dATE);
            }
            int n2 = DATE.compareBytes(this.shareBytes(), dATE.shareBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, n2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DATE.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] _initDate() {
        byte[] byArray = new byte[]{119, -86, 1, 1, 1, 1, 1};
        return byArray;
    }

    private static LdxLib _getLdxLib() {
        if (_sldxlib == null) {
            _sldxlib = new LdxLibThin();
        }
        return _sldxlib;
    }

    private static void _printBytes(byte[] byArray) {
        System.out.println(DATE.toString(byArray));
    }

    public static DATE of(LocalDate localDate) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, localDate);
            }
            DATE dATE = new DATE(Date.valueOf(localDate));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DATE.class, $$$methodRef$$$41, null, throwable2);
            }
            throw throwable;
        }
    }

    public LocalDate toLocalDate() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, new Object[0]);
            }
            LocalDate localDate = this.dateValue().toLocalDate();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, localDate);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, null);
            }
            return localDate;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DATE.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE of(LocalDateTime localDateTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, localDateTime);
            }
            DATE dATE = new DATE(Timestamp.valueOf(localDateTime));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DATE.class, $$$methodRef$$$43, null, throwable2);
            }
            throw throwable;
        }
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, new Object[0]);
            }
            LocalDateTime localDateTime = this.timestampValue().toLocalDateTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, localDateTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, null);
            }
            return localDateTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DATE.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE of(LocalTime localTime) throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, localTime);
            }
            DATE dATE = new DATE(Time.valueOf(localTime));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, dATE);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DATE.class, $$$methodRef$$$45, null, throwable2);
            }
            throw throwable;
        }
    }

    public LocalTime toLocalTime() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, new Object[0]);
            }
            LocalTime localTime = this.timeValue().toLocalTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, localTime);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, null);
            }
            return localTime;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DATE.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$59 = DATE.class.getDeclaredConstructor(Object.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$58 = DATE.class.getDeclaredConstructor(Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$57 = DATE.class.getDeclaredConstructor(String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$56 = DATE.class.getDeclaredConstructor(String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$55 = DATE.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$54 = DATE.class.getDeclaredConstructor(Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$53 = DATE.class.getDeclaredConstructor(Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$52 = DATE.class.getDeclaredConstructor(Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = DATE.class.getDeclaredConstructor(Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = DATE.class.getDeclaredConstructor(Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = DATE.class.getDeclaredConstructor(Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = DATE.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = DATE.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = DATE.class.getDeclaredMethod("toLocalTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = DATE.class.getDeclaredMethod("of", LocalTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = DATE.class.getDeclaredMethod("toLocalDateTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = DATE.class.getDeclaredMethod("of", LocalDateTime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = DATE.class.getDeclaredMethod("toLocalDate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = DATE.class.getDeclaredMethod("of", LocalDate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = DATE.class.getDeclaredMethod("_printBytes", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = DATE.class.getDeclaredMethod("_getLdxLib", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = DATE.class.getDeclaredMethod("_initDate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = DATE.class.getDeclaredMethod("compareTo", DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = DATE.class.getDeclaredMethod("truncate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = DATE.class.getDeclaredMethod("parseFormat", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = DATE.class.getDeclaredMethod("toText", byte[].class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = DATE.class.getDeclaredMethod("toText", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = DATE.class.getDeclaredMethod("toNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = DATE.class.getDeclaredMethod("toJulianDays", int[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = DATE.class.getDeclaredMethod("setDayOfWeek", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = DATE.class.getDeclaredMethod("round", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = DATE.class.getDeclaredMethod("numberToJulianDays", NUMBER.class, int[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = DATE.class.getDeclaredMethod("lastDayOfMonth", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = DATE.class.getDeclaredMethod("fromText", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = DATE.class.getDeclaredMethod("fromJulianDays", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = DATE.class.getDeclaredMethod("checkValidity", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = DATE.class.getDeclaredMethod("getCurrentDate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = DATE.class.getDeclaredMethod("diffInMonths", DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = DATE.class.getDeclaredMethod("diffInJulianDays", DATE.class, int[].class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = DATE.class.getDeclaredMethod("zeroTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = DATE.class.getDeclaredMethod("addMonths", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = DATE.class.getDeclaredMethod("addJulianDays", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = DATE.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = DATE.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = DATE.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = DATE.class.getDeclaredMethod("timestampValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = DATE.class.getDeclaredMethod("toBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = DATE.class.getDeclaredMethod("toBytes", Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = DATE.class.getDeclaredMethod("toBytes", Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = DATE.class.getDeclaredMethod("toBytes", Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = DATE.class.getDeclaredMethod("toBytes", Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = DATE.class.getDeclaredMethod("toBytes", Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = DATE.class.getDeclaredMethod("toBytes", Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = DATE.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = DATE.class.getDeclaredMethod("toTimestamp", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = DATE.class.getDeclaredMethod("toTime", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = DATE.class.getDeclaredMethod("toDate", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = DATE.class.getDeclaredMethod("toTimestamp", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = DATE.class.getDeclaredMethod("toTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = DATE.class.getDeclaredMethod("toDate", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

