/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSet12Byte
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter12Byte";
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    CharacterSet12Byte(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSet12Byte getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 1) {
            return new CharacterSet12Byte(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 127) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182).fillInStackTrace();
            }
        }
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = 0;
        int n4 = 1;
        while (n2 >> n3 != 0) {
            n3 = (short)(n3 + 8);
            n4 = (short)(n4 + 1);
        }
        CharacterSet12Byte.need(characterBuffer, n4);
        while (n3 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n3 & 0xFF);
            n3 = (short)(n3 - 8);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = CharacterSet12Byte.class.getDeclaredConstructor(Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSet12Byte.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSet12Byte.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSet12Byte.class.getDeclaredMethod("getInstance", Integer.TYPE, JdbcCharacterConverters.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

