/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.SINT32;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeSINT32
extends OracleType
implements Serializable {
    static final long serialVersionUID = -5465988397261455848L;
    boolean isBigEndian = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    protected OracleTypeSINT32(boolean bl) {
        this.isBigEndian = bl;
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        return OracleTypeNUMBER.toNUMBER(object, oracleConnection);
    }

    @Override
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        return OracleTypeNUMBER.toNUMBERArray(object, oracleConnection, l2, n2);
    }

    @Override
    public Datum toDatumInternal(Object object, OracleConnection oracleConnection) throws SQLException {
        int n2 = 0;
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            n2 = ((Number)object).intValue();
        } else if (object instanceof NUMBER) {
            NUMBER nUMBER = (NUMBER)object;
            n2 = nUMBER.intValue();
        } else {
            NUMBER nUMBER = new NUMBER(object);
            n2 = nUMBER.intValue();
        }
        return SINT32.valueOf(n2, this.isBigEndian);
    }

    @Override
    public Datum[] toDatumArrayInternal(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Object[])object;
        Datum[] datumArray = SINT32.createArray(n2);
        long l3 = l2 + (long)n2;
        int n3 = 0;
        while (l2 < l3) {
            datumArray[n3] = this.toDatumInternal(objectArray[(int)l2], oracleConnection);
            ++n3;
            ++l2;
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() {
        return 2;
    }

    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int n3 = SINT32.bytesToInt(byArray, this.isBigEndian);
        Object object = null;
        switch (n2) {
            case 1: {
                object = new NUMBER(n3);
                break;
            }
            case 2: {
                object = new BigDecimal(n3);
                break;
            }
            case 3: {
                object = NUMBER.toBytes(n3);
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
        }
        return object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    static {
        try {
            $$$methodRef$$$8 = OracleTypeSINT32.class.getDeclaredConstructor(Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleTypeSINT32.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleTypeSINT32.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleTypeSINT32.class.getDeclaredMethod("toObject", byte[].class, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleTypeSINT32.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleTypeSINT32.class.getDeclaredMethod("toDatumArrayInternal", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleTypeSINT32.class.getDeclaredMethod("toDatumInternal", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleTypeSINT32.class.getDeclaredMethod("toDatumArray", Object.class, OracleConnection.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleTypeSINT32.class.getDeclaredMethod("toDatum", Object.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

