/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
public final class T4CTTIodpmop
extends T4CTTIfun {
    public static final int DPMOPOPC_ABORT = 1;
    public static final int DPMOPOPC_FINISH = 2;
    public static final int DPMOPOPC_FLUSH = 3;
    public static final int DPMOPOPC_DATASAVE = 4;
    public static final int DPMOPOPC_SETIU = 5;
    public static final int DPMOPOPC_FINISH_ONLY = 6;
    public static final int DPMOPOPC_ABORT_ONLY = 7;
    public static final int DPMOPOPC_CALL_KDBLAI = 8;
    public static final int DPMOPDEF_DATASAVEOPT_SAVEONLY = 0;
    public static final int DPMOPDEF_DATASAVEOPT_FINISH = 1;
    public static final int DPMOPDEF_DATASAVEOPT_PARTIAL = 2;
    public static final int DPMOPDEF_IN_PARMCOUNT = 1;
    public static final int DPMOPDEF_OUT_PARMCOUNT = 0;
    private int dpmopopc;
    private int dpmopcsr;
    private long[] dpmopi4;
    private int dpmopi4l;
    private long[] dpmopo4;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    T4CTTIodpmop(T4CConnection t4CConnection) throws SQLException {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)130);
        this.clearState();
    }

    private void clearState() {
        this.dpmopopc = 0;
        this.dpmopcsr = 0;
        this.dpmopi4 = new long[1];
        this.dpmopi4l = 0;
        this.dpmopo4 = null;
    }

    void doDPMOP(int n2, int n3, long[] lArray) throws IOException, SQLException {
        this.dpmopopc = n2;
        this.dpmopcsr = n3;
        if (lArray != null) {
            this.dpmopi4l = lArray.length;
            this.dpmopi4 = lArray;
        } else {
            this.dpmopi4l = 0;
        }
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        this.meg.marshalUB4(this.dpmopopc);
        this.meg.marshalSWORD(this.dpmopcsr);
        if (this.dpmopi4l > 0) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalUWORD(this.dpmopi4l);
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        for (int i2 = 0; i2 < this.dpmopi4l; ++i2) {
            this.meg.marshalUB4(this.dpmopi4[i2]);
        }
        this.clearState();
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int n2 = this.meg.unmarshalUB2();
        if (n2 > 0) {
            this.dpmopo4 = new long[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.dpmopo4[i2] = this.meg.unmarshalUB4();
            }
        } else {
            this.dpmopo4 = null;
        }
    }

    long getO4Value(int n2) {
        return this.dpmopo4 != null && this.dpmopo4.length > n2 ? this.dpmopo4[n2] : 0L;
    }

    long[] getO4Values() {
        return this.dpmopo4;
    }

    static {
        try {
            $$$methodRef$$$6 = T4CTTIodpmop.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIodpmop.class.getDeclaredMethod("getO4Values", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIodpmop.class.getDeclaredMethod("getO4Value", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIodpmop.class.getDeclaredMethod("readRPA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIodpmop.class.getDeclaredMethod("marshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIodpmop.class.getDeclaredMethod("doDPMOP", Integer.TYPE, Integer.TYPE, long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIodpmop.class.getDeclaredMethod("clearState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

