/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.lang.reflect.Executable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.Releaser;
import oracle.jdbc.diagnostics.SecuredLoggerImpl;

public interface SecuredLogger {
    public static final boolean IS_ENABLED = false;
    public static final int LOG_EVENT_ATTRIBUTE_LENGTH = 9;
    public static final String DEFAULT_LOG_LOCATION = System.getProperty("oracle.jdbc.diagnostics.logLocation");
    public static final String DEFAULT_CERTIFICATE_PATH = System.getProperty("oracle.jdbc.diagnostics.certificate");
    public static final String DEFAULT_CERTIFICATE_PWD = System.getProperty("oracle.jdbc.diagnostics.certificatePassword");
    public static final Filter DEFAULT_FILTER = logRecord -> true;
    public static final ConcurrentHashMap<String, SecuredLogger> ACTIVE_LOGGER_MAP = new ConcurrentHashMap();

    public boolean isLoggable(Level var1);

    public void disableMemoryLogging();

    public void enableMemoryLogging();

    public void disableFileLogging();

    public void enableFileLogging();

    public void reset();

    public String getId();

    public void dumpLog();

    public void close();

    public void setLogLevel(Level var1);

    public Level getLogLevel();

    public void addHeader(String var1, String var2);

    public void addHeader(Properties var1);

    public void add(Level var1, String var2, String var3, String var4);

    default public void add(Level level, String string, String string2, String string3, Object object) {
        this.add(level, string, string2, string3, object, null);
    }

    default public void add(Level level, String string, String string2, String string3, Object object, Object object2) {
        this.add(level, string, string2, string3, object, object2, null);
    }

    default public void add(Level level, String string, String string2, String string3, Object object, Object object2, Object object3) {
        this.add(level, string, string2, string3, object, object2, object3, null);
    }

    default public void add(Level level, String string, String string2, String string3, Object object, Object object2, Object object3, Object object4) {
        this.add(level, string, string2, string3, object, object2, object3, object4, null);
    }

    default public void add(Level level, String string, String string2, String string3, Object ... objectArray) {
        this.add(level, string, string2, string3, null, objectArray);
    }

    public void add(Level var1, String var2, String var3, String var4, Object var5, Releaser var6);

    public void add(Level var1, String var2, String var3, String var4, Object var5, Object var6, Releaser var7);

    public void add(Level var1, String var2, String var3, String var4, Object var5, Object var6, Object var7, Releaser var8);

    public void add(Level var1, String var2, String var3, String var4, Object var5, Object var6, Object var7, Object var8, Releaser var9);

    public void add(Level var1, String var2, String var3, String var4, Releaser var5, Object ... var6);

    public static SecuredLogger newLogger(String string, Properties properties) {
        SecuredLoggerImpl securedLoggerImpl = new SecuredLoggerImpl(string, properties);
        ACTIVE_LOGGER_MAP.put(string, securedLoggerImpl);
        return securedLoggerImpl;
    }

    public static SecuredLogger getLogger(String string) {
        return ACTIVE_LOGGER_MAP.get(string);
    }

    public static SecuredLogger releaseLogger(String string) {
        return ACTIVE_LOGGER_MAP.remove(string);
    }

    public static SecuredLogger noOpLogger() {
        return new SecuredLoggerImpl("noop", null);
    }

    public static String getStringProperty(String string, String string2, Properties properties) {
        String string3 = null;
        if (properties != null) {
            string3 = properties.getProperty(string);
        }
        if (string3 == null && (string3 = LogManager.getLogManager().getProperty(string)) == null) {
            string3 = string2;
        }
        return string3;
    }

    public static int getIntProperty(String string, int n2, Properties properties) {
        String string2 = SecuredLogger.getStringProperty(string, null, properties);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static boolean getBooleanProperty(String string, boolean bl, Properties properties) {
        String string2 = SecuredLogger.getStringProperty(string, null, properties);
        if (string2 == null) {
            return bl;
        }
        if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("0")) {
            return false;
        }
        return bl;
    }

    public static Level getLevelProperty(String string, Level level, Properties properties) {
        String string2 = SecuredLogger.getStringProperty(string, null, properties);
        if (string2 == null) {
            return level;
        }
        Level level2 = Level.parse(string2.trim());
        return level2 != null ? level2 : level;
    }

    public static Filter getFilterProperty(String string, Filter filter, Properties properties) {
        String string2 = SecuredLogger.getStringProperty(string, null, properties);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Filter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filter;
    }

    public static Formatter getFormatterProperty(String string, Formatter formatter, Properties properties) {
        String string2 = SecuredLogger.getStringProperty(string, null, properties);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatter;
    }

    public static final class Attribute
    extends Enum<Attribute> {
        public static final /* enum */ Attribute LENGTH;
        public static final /* enum */ Attribute EVENT_ID;
        public static final /* enum */ Attribute THREAD_ID;
        public static final /* enum */ Attribute CLASS_NAME;
        public static final /* enum */ Attribute METHOD_NAME;
        public static final /* enum */ Attribute LOG_LEVEL;
        public static final /* enum */ Attribute EVENT_TIME;
        public static final /* enum */ Attribute DEBUG_MESSAGE;
        public static final /* enum */ Attribute RELEASER;
        private final int index;
        private static final /* synthetic */ Attribute[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public static Attribute[] values() {
            return (Attribute[])$VALUES.clone();
        }

        public static Attribute valueOf(String string) {
            return Enum.valueOf(Attribute.class, string);
        }

        private Attribute(int n3) {
            this.index = n3;
        }

        public int getIndex() {
            return this.index;
        }

        private int getIndexInBuffer(int n2, int n3) {
            return (n2 + this.index) % n3;
        }

        public Object getAttributeValue(int n2, Object[] objectArray) {
            return objectArray[this.getIndexInBuffer(n2, objectArray.length)];
        }

        static {
            try {
                $$$methodRef$$$5 = Attribute.class.getDeclaredConstructor(String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Attribute.class.getDeclaredMethod("getAttributeValue", Integer.TYPE, Object[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Attribute.class.getDeclaredMethod("getIndexInBuffer", Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Attribute.class.getDeclaredMethod("getIndex", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Attribute.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Attribute.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            LENGTH = new Attribute(0);
            EVENT_ID = new Attribute(1);
            THREAD_ID = new Attribute(2);
            CLASS_NAME = new Attribute(3);
            METHOD_NAME = new Attribute(4);
            LOG_LEVEL = new Attribute(5);
            EVENT_TIME = new Attribute(6);
            DEBUG_MESSAGE = new Attribute(7);
            RELEASER = new Attribute(8);
            $VALUES = new Attribute[]{LENGTH, EVENT_ID, THREAD_ID, CLASS_NAME, METHOD_NAME, LOG_LEVEL, EVENT_TIME, DEBUG_MESSAGE, RELEASER};
        }
    }
}

