/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_PROCESSING})
@Deprecated
public class OracleRef
extends DatumWithConnection
implements oracle.jdbc.internal.OracleRef,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    String typename;
    transient StructDescriptor descriptor;
    Object acProxy;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.typename == null) {
            if (this.descriptor != null) {
                this.typename = this.descriptor.getName();
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52).fillInStackTrace();
            }
        }
        return this.typename;
    }

    public OracleRef(String string, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || string == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.typename = string;
        this.descriptor = null;
        this.setPhysicalConnectionOf(connection);
    }

    public OracleRef(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || structDescriptor == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.descriptor = structDescriptor;
        this.setPhysicalConnectionOf(connection);
    }

    @Override
    public Object getValue(Map<String, Class<?>> map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc((Map)map) : null;
        return object;
    }

    @Override
    public Object getValue() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc() : null;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            STRUCT sTRUCT;
            block10: {
                sTRUCT = null;
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getInternalConnection().prepareStatement("select deref(:1) from dual");
                oraclePreparedStatement.setRowPrefetch(1);
                oraclePreparedStatement.setRef(1, this);
                OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                try {
                    if (oracleResultSet.next()) {
                        sTRUCT = oracleResultSet.getSTRUCT(1);
                        break block10;
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 52).fillInStackTrace();
                }
                finally {
                    oracleResultSet.close();
                    oracleResultSet = null;
                    oraclePreparedStatement.close();
                    oraclePreparedStatement = null;
                }
            }
            STRUCT sTRUCT2 = sTRUCT;
            return sTRUCT2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object object) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.getInternalConnection().acquireCloseableLock();){
            STRUCT sTRUCT = STRUCT.toSTRUCT(object, this.getInternalConnection());
            if (sTRUCT.getInternalConnection() != this.getInternalConnection()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible connection object").fillInStackTrace();
            }
            if (!this.getBaseTypeName().equals(sTRUCT.getSQLTypeName())) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "Incompatible type").fillInStackTrace();
            }
            byte[] byArray = sTRUCT.toBytes();
            byte[] byArray2 = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
            CallableStatement callableStatement = null;
            try {
                callableStatement = this.getInternalConnection().prepareCall("begin :1 := sys.dbms_pickler.update_through_ref (:2, :3, :4, :5); end;");
                callableStatement.registerOutParameter(1, 2);
                callableStatement.setBytes(2, this.shareBytes());
                callableStatement.setInt(3, 0);
                callableStatement.setBytes(4, byArray2);
                callableStatement.setBytes(5, byArray);
                callableStatement.execute();
                int n2 = 0;
                n2 = callableStatement.getInt(1);
                if (n2 != 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 77, "ORA-" + n2).fillInStackTrace();
                }
            }
            finally {
                if (callableStatement != null) {
                    callableStatement.close();
                }
                callableStatement = null;
            }
        }
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        return this.getDescriptor();
    }

    @Override
    public StructDescriptor getDescriptor() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = StructDescriptor.createDescriptor(this.typename, (Connection)this.getInternalConnection());
        }
        return this.descriptor;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        String string = this.getBaseTypeName();
        return string;
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc((Map)map) : null;
        return object;
    }

    @Override
    public Object getObject() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc() : null;
        return object;
    }

    @Override
    public void setObject(Object object) throws SQLException {
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = this.getInternalConnection().prepareStatement("call sys.utl_ref.update_object( :1, :2 )");
            preparedStatement.setRef(1, this);
            preparedStatement.setObject(2, object);
            preparedStatement.execute();
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    public Object toJdbc(Map<String, Class<?>> map) throws SQLException {
        Class clazz;
        Object object = this;
        if (map != null && (clazz = this.getDescriptor().getClass(map)) != null) {
            object = this.toClass(clazz, map);
        }
        return object;
    }

    public Object toClass(Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        Object object;
        block7: {
            object = null;
            try {
                if (clazz == null || clazz == REF.class || clazz == Ref.class || clazz == oracle.jdbc.OracleRef.class || clazz == oracle.jdbc.internal.OracleRef.class) {
                    object = this;
                    break block7;
                }
                Object obj = clazz.newInstance();
                if (obj instanceof SQLData) {
                    object = this;
                    break block7;
                }
                if (obj instanceof ORADataFactory) {
                    ORADataFactory oRADataFactory = (ORADataFactory)obj;
                    object = oRADataFactory.create(this, 2006);
                    break block7;
                }
                if (obj instanceof OracleDataFactory) {
                    OracleDataFactory oracleDataFactory = (OracleDataFactory)obj;
                    object = oracleDataFactory.create(this, 2006);
                    break block7;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName()).fillInStackTrace();
            }
            catch (InstantiationException instantiationException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + instantiationException.getMessage()).fillInStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + illegalAccessException.getMessage()).fillInStackTrace();
            }
        }
        return object;
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new REF[n2];
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        REF rEF = null;
        try {
            rEF = new REF(this.getBaseTypeName(), (Connection)this.getInternalConnection(), this.getBytes());
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException(sQLException.getMessage());
        }
        return rEF;
    }

    @Override
    @DisableTrace
    public boolean equals(Object object) {
        boolean bl = false;
        try {
            bl = object instanceof OracleRef && super.equals(object) && this.getBaseTypeName().equals(((OracleRef)object).getSQLTypeName());
        }
        catch (Exception exception) {
        }
        return bl;
    }

    @Override
    @DisableTrace
    public int hashCode() {
        int n2;
        block4: {
            byte[] byArray;
            block5: {
                block3: {
                    byArray = this.shareBytes();
                    n2 = 0;
                    if ((byArray[2] & 5) != 5) break block3;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        n2 *= 256;
                        n2 += byArray[8 + i2] & 0xFF;
                    }
                    break block4;
                }
                if ((byArray[2] & 3) != 3) break block5;
                for (int i3 = 0; i3 < 4 && i3 < byArray.length; ++i3) {
                    n2 *= 256;
                    n2 += byArray[6 + i3] & 0xFF;
                }
                break block4;
            }
            if ((byArray[2] & 2) != 2) break block4;
            for (int i4 = 0; i4 < 4; ++i4) {
                n2 *= 256;
                n2 += byArray[8 + i4] & 0xFF;
            }
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.shareBytes());
        try {
            objectOutputStream.writeUTF(this.getBaseTypeName());
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setBytes((byte[])objectInputStream.readObject());
        this.typename = objectInputStream.readUTF();
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public void setTypeName(String string) {
        this.typename = string;
    }

    @Override
    public void setACProxy(Object object) {
        this.acProxy = object;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    static {
        try {
            $$$methodRef$$$24 = OracleRef.class.getDeclaredConstructor(StructDescriptor.class, Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleRef.class.getDeclaredConstructor(String.class, Connection.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleRef.class.getDeclaredMethod("getACProxy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleRef.class.getDeclaredMethod("setACProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleRef.class.getDeclaredMethod("setTypeName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleRef.class.getDeclaredMethod("getJavaSqlConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleRef.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleRef.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleRef.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleRef.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleRef.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleRef.class.getDeclaredMethod("toClass", Class.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleRef.class.getDeclaredMethod("toJdbc", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleRef.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleRef.class.getDeclaredMethod("setObject", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleRef.class.getDeclaredMethod("getObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleRef.class.getDeclaredMethod("getObject", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleRef.class.getDeclaredMethod("getSQLTypeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleRef.class.getDeclaredMethod("getDescriptor", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleRef.class.getDeclaredMethod("getOracleMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleRef.class.getDeclaredMethod("setValue", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleRef.class.getDeclaredMethod("getSTRUCT", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleRef.class.getDeclaredMethod("getValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleRef.class.getDeclaredMethod("getValue", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleRef.class.getDeclaredMethod("getBaseTypeName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

