/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.replay.driver.TxnReplayableStruct;
import oracle.sql.ANYDATA;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.sql.json.OracleJsonDatum;
import oracle.xdb.XMLType;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class AQMessageI
implements AQMessage {
    private byte[] id = null;
    private AQMessagePropertiesI properties = null;
    private byte[] toid = null;
    private int version = 1;
    private byte[] payload;
    private OracleStruct payLoadStruct;
    private ANYDATA payLoadANYDATA;
    private RAW payLoadRAW;
    private XMLType payLoadXMLType;
    private OracleJsonDatum payloadJson;
    private Connection conn;
    private String typeName;
    private TypeDescriptor sd;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    AQMessageI(AQMessagePropertiesI aQMessagePropertiesI, Connection connection) {
        this.properties = aQMessagePropertiesI;
        this.conn = connection;
    }

    AQMessageI(AQMessagePropertiesI aQMessagePropertiesI) throws SQLException {
        this.properties = aQMessagePropertiesI;
    }

    void setTypeName(String string) {
        this.typeName = string;
    }

    void setTypeDescriptor(TypeDescriptor typeDescriptor) {
        this.sd = typeDescriptor;
    }

    @Override
    public byte[] getMessageId() {
        return this.id;
    }

    void setMessageId(byte[] byArray) throws SQLException {
        this.id = byArray;
    }

    @Override
    public AQMessageProperties getMessageProperties() {
        return this.properties;
    }

    AQMessagePropertiesI getMessagePropertiesI() {
        return this.properties;
    }

    @Override
    public void setPayload(byte[] byArray) throws SQLException {
        this.payload = byArray;
        this.toid = TypeDescriptor.RAWTOID;
    }

    @Override
    public void setPayload(byte[] byArray, byte[] byArray2) throws SQLException {
        this.payload = byArray;
        this.toid = byArray2;
    }

    @Override
    public void setPayload(Struct struct) throws SQLException {
        assert (struct instanceof OracleStruct) : "_payload is " + struct;
        this.payload = ((OracleStruct)struct).toBytes();
        this.payLoadStruct = (OracleStruct)struct;
        this.toid = ((OracleStruct)struct).getDescriptor().getOracleTypeADT().getTOID();
        this.version = ((OracleStruct)struct).getDescriptor().getOracleTypeADT().getTypeVersion();
    }

    @Override
    public void setPayload(STRUCT sTRUCT) throws SQLException {
        this.payload = sTRUCT.toBytes();
        this.payLoadStruct = sTRUCT;
        this.toid = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
        this.version = sTRUCT.getDescriptor().getOracleTypeADT().getTypeVersion();
    }

    @Override
    public void setPayload(ANYDATA aNYDATA) throws SQLException {
        this.payload = aNYDATA.toDatum(this.conn).shareBytes();
        this.payLoadANYDATA = aNYDATA;
        this.toid = TypeDescriptor.ANYDATATOID;
    }

    @Override
    public void setPayload(RAW rAW) throws SQLException {
        this.payload = rAW.shareBytes();
        this.payLoadRAW = rAW;
        this.toid = TypeDescriptor.RAWTOID;
    }

    @Override
    public void setPayload(XMLType xMLType) throws SQLException {
        this.payload = xMLType.toBytes();
        this.payLoadXMLType = xMLType;
        this.toid = TypeDescriptor.XMLTYPETOID;
    }

    @Override
    public void setPayload(OracleJsonDatum oracleJsonDatum) {
        this.payload = oracleJsonDatum.shareBytes();
        this.payloadJson = oracleJsonDatum;
        this.toid = TypeDescriptor.JSONTOID;
    }

    @Override
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public RAW getRAWPayload() throws SQLException {
        RAW rAW = null;
        if (this.payLoadRAW != null) {
            rAW = this.payLoadRAW;
        } else if (this.isRAWPayload()) {
            rAW = this.payLoadRAW = new RAW(this.payload);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return rAW;
    }

    @Override
    public boolean isRAWPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return AQMessageI.compareToid(this.toid, TypeDescriptor.RAWTOID);
    }

    @Override
    public OracleJsonDatum getJSONPayload() throws SQLException {
        OracleJsonDatum oracleJsonDatum = null;
        if (this.payloadJson != null) {
            oracleJsonDatum = this.payloadJson;
        } else if (this.isJSONPayload()) {
            oracleJsonDatum = this.payloadJson = new OracleJsonDatum(this.payload);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return oracleJsonDatum;
    }

    @Override
    public boolean isJSONPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return AQMessageI.compareToid(this.toid, TypeDescriptor.JSONTOID);
    }

    @Override
    public Struct getStructPayload() throws SQLException {
        return this.getSTRUCTPayload();
    }

    @Override
    public STRUCT getSTRUCTPayload() throws SQLException {
        STRUCT sTRUCT = null;
        if (!this.isSTRUCTPayload()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        if (this.payLoadStruct != null) {
            sTRUCT = this.payLoadStruct instanceof STRUCT ? (STRUCT)this.payLoadStruct : (STRUCT)((TxnReplayableStruct)((Object)this.payLoadStruct)).getDelegateStruct();
        } else {
            if (this.sd == null) {
                this.typeName = OracleTypeADT.toid2typename(this.conn, this.toid);
                this.sd = TypeDescriptor.getTypeDescriptor(this.typeName, (OracleConnection)this.conn);
            }
            if (this.sd instanceof StructDescriptor) {
                sTRUCT = new STRUCT((StructDescriptor)this.sd, this.payload, this.conn);
                this.payLoadStruct = sTRUCT;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
            }
        }
        return sTRUCT;
    }

    @Override
    public boolean isSTRUCTPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        boolean bl = true;
        boolean bl2 = true;
        for (int i2 = 0; i2 < 15; ++i2) {
            if (this.toid[i2] == 0) continue;
            bl2 = false;
            break;
        }
        if (bl2 || this.isRAWPayload() || this.isANYDATAPayload()) {
            bl = false;
        }
        return bl;
    }

    @Override
    public ANYDATA getANYDATAPayload() throws SQLException {
        ANYDATA aNYDATA = null;
        if (this.payLoadANYDATA != null) {
            aNYDATA = this.payLoadANYDATA;
        } else if (this.isANYDATAPayload()) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.ANYDATA", this.conn);
            OPAQUE oPAQUE = new OPAQUE(opaqueDescriptor, this.payload, this.conn);
            aNYDATA = this.payLoadANYDATA = new ANYDATA(oPAQUE);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return aNYDATA;
    }

    @Override
    public boolean isANYDATAPayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return this.typeName != null && this.typeName.equals("SYS.ANYDATA") || AQMessageI.compareToid(this.toid, TypeDescriptor.ANYDATATOID);
    }

    @Override
    public XMLType getXMLTypePayload() throws SQLException {
        XMLType xMLType = null;
        if (this.payLoadXMLType != null) {
            xMLType = this.payLoadXMLType;
        } else if (this.isXMLTypePayload()) {
            OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.XMLTYPE", this.conn);
            OPAQUE oPAQUE = new OPAQUE(opaqueDescriptor, this.payload, this.conn);
            xMLType = this.payLoadXMLType = XMLType.createXML((OPAQUE)oPAQUE);
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 193).fillInStackTrace();
        }
        return xMLType;
    }

    @Override
    public boolean isXMLTypePayload() throws SQLException {
        if (this.toid == null || this.toid.length != 16) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 252).fillInStackTrace();
        }
        return this.typeName != null && this.typeName.equals("SYS.XMLTYPE") || AQMessageI.compareToid(this.toid, TypeDescriptor.XMLTYPETOID);
    }

    @Override
    public byte[] getPayloadTOID() {
        return this.toid;
    }

    public int getPayloadVersion() {
        return this.version;
    }

    static boolean compareToid(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        if (byArray != null) {
            if (byArray == byArray2) {
                bl = true;
            } else if (byArray.length == byArray2.length) {
                boolean bl2 = true;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    if (byArray[i2] == byArray2[i2]) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    @DisableTrace
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Message Properties={");
        stringBuffer.append(this.properties);
        stringBuffer.append("} ");
        return stringBuffer.toString();
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$31 = AQMessageI.class.getDeclaredConstructor(AQMessagePropertiesI.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = AQMessageI.class.getDeclaredConstructor(AQMessagePropertiesI.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = AQMessageI.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = AQMessageI.class.getDeclaredMethod("compareToid", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = AQMessageI.class.getDeclaredMethod("getPayloadVersion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = AQMessageI.class.getDeclaredMethod("getPayloadTOID", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = AQMessageI.class.getDeclaredMethod("isXMLTypePayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = AQMessageI.class.getDeclaredMethod("getXMLTypePayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = AQMessageI.class.getDeclaredMethod("isANYDATAPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = AQMessageI.class.getDeclaredMethod("getANYDATAPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = AQMessageI.class.getDeclaredMethod("isSTRUCTPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = AQMessageI.class.getDeclaredMethod("getSTRUCTPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = AQMessageI.class.getDeclaredMethod("getStructPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = AQMessageI.class.getDeclaredMethod("isJSONPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = AQMessageI.class.getDeclaredMethod("getJSONPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = AQMessageI.class.getDeclaredMethod("isRAWPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = AQMessageI.class.getDeclaredMethod("getRAWPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = AQMessageI.class.getDeclaredMethod("getPayload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = AQMessageI.class.getDeclaredMethod("setPayload", OracleJsonDatum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = AQMessageI.class.getDeclaredMethod("setPayload", XMLType.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = AQMessageI.class.getDeclaredMethod("setPayload", RAW.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = AQMessageI.class.getDeclaredMethod("setPayload", ANYDATA.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = AQMessageI.class.getDeclaredMethod("setPayload", STRUCT.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AQMessageI.class.getDeclaredMethod("setPayload", Struct.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AQMessageI.class.getDeclaredMethod("setPayload", byte[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AQMessageI.class.getDeclaredMethod("setPayload", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AQMessageI.class.getDeclaredMethod("getMessagePropertiesI", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AQMessageI.class.getDeclaredMethod("getMessageProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AQMessageI.class.getDeclaredMethod("setMessageId", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AQMessageI.class.getDeclaredMethod("getMessageId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AQMessageI.class.getDeclaredMethod("setTypeDescriptor", TypeDescriptor.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AQMessageI.class.getDeclaredMethod("setTypeName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

