/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.OsonValueFactory;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public abstract class OsonStructureImpl {
    OsonContext ctx;
    int pos;
    public int size;
    byte childOffsetUb;
    int childArrayOffset;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    public OsonStructureImpl(OsonContext osonContext) {
        this.ctx = osonContext;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    void init(int n2) {
        this.pos = n2;
    }

    void initChildOffseUb(int n2) {
        this.childOffsetUb = (n2 & 0x20) != 0 ? (byte)4 : (byte)2;
    }

    Boolean getBooleanInternal(int n2) {
        int n3 = this.ctx.b.getUB1(n2);
        if (n3 < 0) {
            return null;
        }
        if (n3 == 49) {
            return true;
        }
        if (n3 == 50) {
            return false;
        }
        return null;
    }

    String getStringInternal(int n2) {
        int n3 = this.ctx.b.getUB1(n2);
        if (n3 < 0) {
            return null;
        }
        if (n3 <= 31) {
            this.ctx.b.position(n2 + 1);
            return this.ctx.b.readString(n3);
        }
        if (n3 == 51) {
            int n4 = this.ctx.b.getUB1(n2 + 1);
            this.ctx.b.position(n2 + 2);
            return this.ctx.b.readString(n4);
        }
        if (n3 == 55) {
            int n5 = this.ctx.b.getUB2(n2 + 1);
            this.ctx.b.position(n2 + 3);
            return this.ctx.b.readString(n5);
        }
        if (n3 == 56) {
            int n6 = this.ctx.b.getUB4int(n2 + 1);
            this.ctx.b.position(n2 + 5);
            return this.ctx.b.readString(n6);
        }
        return null;
    }

    boolean isNullInternal(int n2) {
        int n3 = this.ctx.b.getUB1(n2);
        if (n3 < 0) {
            return false;
        }
        return n3 == 48;
    }

    public Object getValueInternal(int n2) {
        return OsonStructureImpl.getValueInternal(n2, this.ctx.getFactory(), this.ctx);
    }

    public static Object getValueInternal(int n2, OsonValueFactory osonValueFactory, OsonContext osonContext) {
        int n3 = osonContext.b.getUB1(n2);
        if ((n3 & 0xC0) == 192) {
            return osonValueFactory.createArray(osonContext, n2);
        }
        if ((n3 & 0xC0) == 128) {
            if ((n3 & 0x83) == 131) {
                return OsonStructureImpl.getOverflowValue(n2, osonValueFactory, osonContext);
            }
            return osonValueFactory.createObject(osonContext, n2);
        }
        if (n3 <= 31) {
            return osonValueFactory.createString(osonContext, n2 + 1, n3);
        }
        if (OsonConstants.isSB4(n3)) {
            return osonValueFactory.createNumber(OsonStructureImpl.readRaw(n2 + 1, n3 & 7, osonContext), OracleJsonDecimal.TargetType.INT);
        }
        if (OsonConstants.isSB8(n3)) {
            return osonValueFactory.createNumber(OsonStructureImpl.readRaw(n2 + 1, n3 & 0xF, osonContext), OracleJsonDecimal.TargetType.LONG);
        }
        if (OsonConstants.isOraNum16(n3)) {
            return osonValueFactory.createNumber(OsonStructureImpl.readRaw(n2 + 1, (n3 & 0xF) + 1, osonContext), null);
        }
        if (OsonConstants.isDec_16(n3)) {
            return osonValueFactory.createNumber(OsonStructureImpl.readRaw(n2 + 1, (n3 & 0xF) + 1, osonContext), OracleJsonDecimal.TargetType.DECIMAL);
        }
        switch (n3) {
            case 49: {
                return osonValueFactory.createTrue();
            }
            case 50: {
                return osonValueFactory.createFalse();
            }
            case 48: {
                return osonValueFactory.createNull();
            }
            case 51: {
                int n4 = osonContext.b.getUB1(n2 + 1);
                return osonValueFactory.createString(osonContext, n2 + 2, n4);
            }
            case 55: {
                int n5 = osonContext.b.getUB2(n2 + 1);
                return osonValueFactory.createString(osonContext, n2 + 3, n5);
            }
            case 56: {
                int n6 = osonContext.b.getUB4int(n2 + 1);
                osonContext.b.position(n2 + 5);
                return osonValueFactory.createString(osonContext, n2 + 5, n6);
            }
            case 54: {
                osonContext.b.position(n2 + 1);
                return osonValueFactory.createDouble(osonContext.b.readDtyDouble());
            }
            case 127: {
                osonContext.b.position(n2 + 1);
                return osonValueFactory.createFloat(osonContext.b.readDtyFloat());
            }
            case 53: {
                int n7 = osonContext.b.getUB1(n2 + 1);
                osonContext.b.position(n2 + 2);
                String string = osonContext.b.readString(n7);
                return osonValueFactory.createStringNumber(string);
            }
            case 52: {
                byte[] byArray = OsonStructureImpl.readRaw(n2 + 2, osonContext.b.getUB1(n2 + 1), osonContext);
                return osonValueFactory.createNumber(byArray, null);
            }
            case 116: {
                byte[] byArray = OsonStructureImpl.readRaw(n2 + 2, osonContext.b.getUB1(n2 + 1), osonContext);
                return osonValueFactory.createNumber(byArray, OracleJsonDecimal.TargetType.DECIMAL);
            }
            case 126: {
                int n8 = osonContext.b.getUB1(n2 + 1);
                if (n8 > 127 || n8 < 0) {
                    throw new UnsupportedOperationException(String.valueOf(n3));
                }
                return osonValueFactory.createBinary(osonContext, n2 + 2, n8, true);
            }
            case 58: {
                int n9 = osonContext.b.getUB2(n2 + 1);
                return osonValueFactory.createBinary(osonContext, n2 + 3, n9, false);
            }
            case 59: {
                int n10 = osonContext.b.getUB4int(n2 + 1);
                return osonValueFactory.createBinary(osonContext, n2 + 5, n10, false);
            }
            case 57: 
            case 125: {
                return osonValueFactory.createTimestamp(OsonStructureImpl.readTimestamp(osonContext.b, n2));
            }
            case 124: {
                return osonValueFactory.createTimestampTZ(OsonStructureImpl.readTimestampTZ(osonContext.b, n2));
            }
            case 60: {
                return osonValueFactory.createDate(OsonStructureImpl.readRaw(n2 + 1, 7, osonContext));
            }
            case 61: {
                return osonValueFactory.createIntervalYM(OsonStructureImpl.readRaw(n2 + 1, 5, osonContext));
            }
            case 62: {
                return osonValueFactory.createIntervalDS(OsonStructureImpl.readRaw(n2 + 1, 11, osonContext));
            }
            case 117: {
                return OsonStructureImpl.getOverflowValue(n2, osonValueFactory, osonContext);
            }
            case 118: {
                return OsonStructureImpl.getForwardedValue(osonContext.b.getUB2(n2 + 1), osonValueFactory, osonContext);
            }
            case 119: {
                return OsonStructureImpl.getForwardedValue(osonContext.b.getUB4int(n2 + 1), osonValueFactory, osonContext);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(n3));
    }

    private static Object getForwardedValue(int n2, OsonValueFactory osonValueFactory, OsonContext osonContext) {
        int n3 = n2 + osonContext.header.extendedTreeSegmentOffset;
        return OsonStructureImpl.getValueInternal(n3, osonValueFactory, osonContext);
    }

    private static Object getOverflowValue(int n2, OsonValueFactory osonValueFactory, OsonContext osonContext) {
        int n3 = n2 - osonContext.header.treeSegmentOffset;
        OsonHeader osonHeader = osonContext.header;
        int n4 = osonHeader.forwardingAddress.get(n3) + osonHeader.extendedTreeSegmentOffset;
        return OsonStructureImpl.getValueInternal(n4, osonValueFactory, osonContext);
    }

    private static byte[] readRaw(int n2, int n3, OsonContext osonContext) {
        osonContext.b.position(n2);
        byte[] byArray = new byte[n3];
        osonContext.b.get(byArray);
        return byArray;
    }

    protected static byte[] readTimestamp(OsonBuffer osonBuffer, int n2) {
        int n3;
        int n4 = osonBuffer.getUB1(n2);
        if (n4 == 125) {
            n3 = OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC;
        } else if (n4 == 57) {
            n3 = OsonPrimitiveConversions.SIZE_TIMESTAMP;
        } else {
            throw new ClassCastException();
        }
        byte[] byArray = new byte[n3];
        osonBuffer.position(n2 + 1);
        osonBuffer.get(byArray);
        return byArray;
    }

    protected static byte[] readTimestampTZ(OsonBuffer osonBuffer, int n2) {
        byte[] byArray = new byte[OsonPrimitiveConversions.SIZE_TIMESTAMPTZ];
        osonBuffer.position(n2 + 1);
        osonBuffer.get(byArray);
        return byArray;
    }

    protected OsonAbstractArray getArrayInternal(int n2) {
        int n3 = this.ctx.b.getUB1(n2);
        if ((n3 & 0xC0) == 192) {
            return this.ctx.getFactory().createArray(this.ctx, n2);
        }
        throw new ClassCastException();
    }

    protected OsonAbstractObject getJsonObjectInternal(int n2) {
        int n3 = this.ctx.b.getUB1(n2);
        if ((n3 & 0xC0) == 128) {
            return this.ctx.getFactory().createObject(this.ctx, n2);
        }
        throw new ClassCastException();
    }

    protected abstract int getChildOffset(int var1);

    public abstract OracleJsonValue.OracleJsonType getOracleJsonType();

    public ByteBuffer getBuffer() {
        ByteBuffer byteBuffer = this.ctx.b.buffer;
        byteBuffer.position(0);
        return byteBuffer;
    }

    public boolean isRoot() {
        return this.pos == this.ctx.header.getTreeSegmentOffset();
    }

    static {
        try {
            $$$methodRef$$$18 = OsonStructureImpl.class.getDeclaredConstructor(OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonStructureImpl.class.getDeclaredMethod("isRoot", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonStructureImpl.class.getDeclaredMethod("getBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonStructureImpl.class.getDeclaredMethod("getJsonObjectInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonStructureImpl.class.getDeclaredMethod("getArrayInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonStructureImpl.class.getDeclaredMethod("readTimestampTZ", OsonBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonStructureImpl.class.getDeclaredMethod("readTimestamp", OsonBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonStructureImpl.class.getDeclaredMethod("readRaw", Integer.TYPE, Integer.TYPE, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonStructureImpl.class.getDeclaredMethod("getOverflowValue", Integer.TYPE, OsonValueFactory.class, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonStructureImpl.class.getDeclaredMethod("getForwardedValue", Integer.TYPE, OsonValueFactory.class, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonStructureImpl.class.getDeclaredMethod("getValueInternal", Integer.TYPE, OsonValueFactory.class, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonStructureImpl.class.getDeclaredMethod("getValueInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonStructureImpl.class.getDeclaredMethod("isNullInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonStructureImpl.class.getDeclaredMethod("getStringInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonStructureImpl.class.getDeclaredMethod("getBooleanInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonStructureImpl.class.getDeclaredMethod("initChildOffseUb", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonStructureImpl.class.getDeclaredMethod("init", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonStructureImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonStructureImpl.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    public abstract class PositionIter<T>
    implements Iterator<T> {
        protected int ipos = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        @Override
        public boolean hasNext() {
            return this.ipos < OsonStructureImpl.this.size;
        }

        @Override
        public T next() {
            if (this.ipos >= OsonStructureImpl.this.size) {
                throw new NoSuchElementException();
            }
            return this.getValue(this.ipos++);
        }

        public abstract T getValue(int var1);

        static {
            try {
                $$$methodRef$$$2 = PositionIter.class.getDeclaredConstructor(OsonStructureImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = PositionIter.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = PositionIter.class.getDeclaredMethod("hasNext", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

