/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonValue;

public abstract class OsonAbstractArray
extends OsonStructureImpl {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;

    public OsonAbstractArray(OsonContext osonContext, int n2) {
        super(osonContext);
        this.init(n2);
    }

    protected OsonAbstractArray(OsonContext osonContext) {
        super(osonContext);
    }

    public String getString(int n2) {
        int n3 = this.getOffsetWithError(n2);
        String string = this.getStringInternal(n3);
        if (string == null) {
            throw new ClassCastException();
        }
        return string;
    }

    public boolean getBoolean(int n2) {
        int n3 = this.getOffsetWithError(n2);
        Boolean bl = this.getBooleanInternal(n3);
        if (bl == null) {
            throw new ClassCastException();
        }
        return bl;
    }

    public boolean getBoolean(int n2, boolean bl) {
        int n3 = this.getChildOffset(n2);
        if (n3 == -1) {
            return bl;
        }
        Boolean bl2 = this.getBooleanInternal(n3);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public int getInt(int n2) {
        int n3 = this.getOffsetWithError(n2);
        return ((OracleJsonNumberImpl)this.getValueInternal(n3)).intValue();
    }

    public int getInt(int n2, int n3) {
        int n4 = this.getChildOffset(n2);
        if (n4 == -1) {
            return n3;
        }
        Object object = this.getValueInternal(n4);
        if (!(object instanceof OracleJsonNumberImpl)) {
            return n3;
        }
        OracleJsonNumberImpl oracleJsonNumberImpl = (OracleJsonNumberImpl)object;
        return oracleJsonNumberImpl.intValue();
    }

    public boolean isNull(int n2) {
        int n3 = this.getOffsetWithError(n2);
        return this.isNullInternal(n3);
    }

    public boolean contains(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object2 = this.getValueInternal(this.getChildOffset(i2));
            if (!object2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.copyToArray(objectArray);
        return objectArray;
    }

    public <T> T[] toArray(T[] TArray) {
        Object[] objectArray = TArray.length >= this.size ? TArray : (Object[])Array.newInstance(TArray.getClass().getComponentType(), this.size);
        this.copyToArray(objectArray);
        if (objectArray.length >= this.size + 1) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (list.size() != this.size) {
            return false;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object2 = this.getValueInternal(this.getChildOffset(i2));
            if (object2.equals(list.get(i2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object = this.getValueInternal(this.getChildOffset(i2));
            n2 = 31 * n2 + object.hashCode();
        }
        return n2;
    }

    public Object getInternal(int n2) {
        return this.getValueInternal(this.getOffsetWithError(n2));
    }

    public int indexOf(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.getInternal(i2).equals(object)) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.getInternal(i2).equals(object)) continue;
            n2 = i2;
        }
        return n2;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.ARRAY;
    }

    @Override
    protected void init(int n2) {
        super.init(n2);
        int n3 = this.ctx.b.getUB1(n2);
        this.initChildOffseUb(n3);
        int n4 = n3 & 0x18;
        this.childArrayOffset = n2 + 1;
        if (n4 == 0) {
            ++this.childArrayOffset;
            this.size = this.ctx.b.getUB1(n2 + 1);
        } else if (n4 == 8) {
            this.childArrayOffset += 2;
            this.size = this.ctx.b.getUB2(n2 + 1);
        } else if (n4 == 16) {
            this.childArrayOffset += 4;
            this.size = this.ctx.b.getUB4int(n2 + 1);
        }
    }

    @Override
    protected int getChildOffset(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            return -1;
        }
        OsonHeader osonHeader = this.ctx.getHeader();
        if (osonHeader.relativeOffsets()) {
            if (this.childOffsetUb == 2) {
                short s2 = this.ctx.b.getShort(this.childArrayOffset + n2 * 2);
                s2 = (short)(s2 + (this.pos - osonHeader.getTreeSegmentOffset()));
                return (s2 & 0xFFFF) + osonHeader.getTreeSegmentOffset();
            }
            int n3 = this.ctx.b.getInt(this.childArrayOffset + n2 * 4);
            return ((n3 += this.pos - osonHeader.getTreeSegmentOffset()) & 0xFFFFFFFF) + osonHeader.getTreeSegmentOffset();
        }
        if (this.childOffsetUb == 2) {
            return this.ctx.b.getUB2(this.childArrayOffset + n2 * 2) + osonHeader.getTreeSegmentOffset();
        }
        return this.ctx.b.getUB4int(this.childArrayOffset + n2 * 4) + osonHeader.getTreeSegmentOffset();
    }

    private void copyToArray(Object[] objectArray) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            objectArray[i2] = this.getValueInternal(this.getChildOffset(i2));
        }
    }

    protected int getOffsetWithError(int n2) {
        int n3 = this.getChildOffset(n2);
        if (n3 == -1) {
            throw new IndexOutOfBoundsException();
        }
        return n3;
    }

    protected <T> AbstractList<T> sublist(final int n2, final int n3) {
        if (n2 < 0 || n3 > this.size || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return new AbstractList<T>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public T get(int n22) {
                return OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getOffsetWithError(n22 + n2));
            }

            @Override
            public int size() {
                return n3 - n2;
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OsonAbstractArray.class, Integer.TYPE, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("size", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("get", Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$26 = OsonAbstractArray.class.getDeclaredConstructor(OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OsonAbstractArray.class.getDeclaredConstructor(OsonContext.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OsonAbstractArray.class.getDeclaredMethod("sublist", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OsonAbstractArray.class.getDeclaredMethod("getOffsetWithError", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OsonAbstractArray.class.getDeclaredMethod("copyToArray", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OsonAbstractArray.class.getDeclaredMethod("getChildOffset", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OsonAbstractArray.class.getDeclaredMethod("init", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OsonAbstractArray.class.getDeclaredMethod("getOracleJsonType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonAbstractArray.class.getDeclaredMethod("lastIndexOf", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonAbstractArray.class.getDeclaredMethod("indexOf", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonAbstractArray.class.getDeclaredMethod("getInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonAbstractArray.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonAbstractArray.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonAbstractArray.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonAbstractArray.class.getDeclaredMethod("containsAll", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonAbstractArray.class.getDeclaredMethod("retainAll", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonAbstractArray.class.getDeclaredMethod("removeAll", Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonAbstractArray.class.getDeclaredMethod("remove", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonAbstractArray.class.getDeclaredMethod("toArray", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonAbstractArray.class.getDeclaredMethod("toArray", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonAbstractArray.class.getDeclaredMethod("contains", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonAbstractArray.class.getDeclaredMethod("isNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonAbstractArray.class.getDeclaredMethod("getInt", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonAbstractArray.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonAbstractArray.class.getDeclaredMethod("getBoolean", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonAbstractArray.class.getDeclaredMethod("getBoolean", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonAbstractArray.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    public class ListIter<T>
    extends ValueIter<T>
    implements ListIterator<T> {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;

        public ListIter(int n2) {
            this.ipos = n2;
        }

        @Override
        public boolean hasPrevious() {
            return this.ipos != 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (T)OsonAbstractArray.this.getInternal(--this.ipos);
        }

        @Override
        public int nextIndex() {
            return this.ipos;
        }

        @Override
        public int previousIndex() {
            return this.ipos - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t2) {
            throw new UnsupportedOperationException();
        }

        static {
            try {
                $$$methodRef$$$8 = ListIter.class.getDeclaredConstructor(OsonAbstractArray.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = ListIter.class.getDeclaredMethod("getValue", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = ListIter.class.getDeclaredMethod("add", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = ListIter.class.getDeclaredMethod("set", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = ListIter.class.getDeclaredMethod("remove", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = ListIter.class.getDeclaredMethod("previousIndex", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = ListIter.class.getDeclaredMethod("nextIndex", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ListIter.class.getDeclaredMethod("previous", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ListIter.class.getDeclaredMethod("hasPrevious", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    protected class ValueIter<V>
    extends OsonStructureImpl.PositionIter<V> {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        protected ValueIter() {
            super(OsonAbstractArray.this);
        }

        @Override
        public V getValue(int n2) {
            return (V)OsonAbstractArray.this.getValueInternal(OsonAbstractArray.this.getChildOffset(n2++));
        }

        static {
            try {
                $$$methodRef$$$1 = ValueIter.class.getDeclaredConstructor(OsonAbstractArray.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ValueIter.class.getDeclaredMethod("getValue", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

