/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class BINARY_FLOAT
extends Datum {
    static final long serialVersionUID = -4231112037190700631L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public BINARY_FLOAT() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$10, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$10, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public BINARY_FLOAT(byte[] byArray) {
        super(byArray);
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$11, null, new Object[]{byArray});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$11, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    public BINARY_FLOAT(float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$12, null, Float.valueOf(f2));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$12, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public BINARY_FLOAT(Float f2) {
        super(BINARY_FLOAT.floatToCanonicalFormatBytes(f2.floatValue()));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$13, null, f2);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$13, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public BINARY_FLOAT(String string) throws SQLException {
        this(BINARY_FLOAT.stringToFloat(string));
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$14, null, string);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$14, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public BINARY_FLOAT(Boolean bl) {
        this(bl != false ? 1 : 0);
        boolean bl2 = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$15, null, bl);
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$15, null);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$0, this, new Object[0]);
            }
            Float f2 = new Float(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$0, this, f2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$0, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isConvertibleTo(Class<?> clazz) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$1, this, clazz);
            }
            boolean bl3 = bl2 = (string = clazz.getName()).compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Float") == 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$1, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String stringValue() {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            String string;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$2, this, new Object[0]);
            }
            String string2 = string = Float.toString(BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes()));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$2, this, string2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$2, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public float floatValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$3, this, new Object[0]);
            }
            float f2 = BINARY_FLOAT.canonicalFormatBytesToFloat(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$3, this, Float.valueOf(f2));
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$3, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public double doubleValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$4, this, new Object[0]);
            }
            double d2 = this.floatValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$4, this, d2);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$4, this, null);
            }
            return d2;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public BigDecimal bigDecimalValue() throws SQLException {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$5, this, new Object[0]);
            }
            BigDecimal bigDecimal = new BigDecimal(this.floatValue());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$5, this, bigDecimal);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$5, this, null);
            }
            return bigDecimal;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    private static float stringToFloat(String string) throws SQLException {
        try {
            return Float.valueOf(string).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
        }
    }

    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = ClioSupport.publicEnter() && (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$7, this, n2);
            }
            Float[] floatArray = new Float[n2];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$7, this, floatArray);
                ClioSupport.publicExit();
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$7, this, null);
            }
            return floatArray;
        }
        catch (Throwable throwable) {
            ClioSupport.publicExit();
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BINARY_FLOAT.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    static byte[] floatToCanonicalFormatBytes(float f2) {
        float f3 = f2;
        if (f3 == 0.0f) {
            f3 = 0.0f;
        } else if (f3 != f3) {
            f3 = Float.NaN;
        }
        int n2 = Float.floatToIntBits(f3);
        byte[] byArray = new byte[4];
        int n3 = n2;
        int n4 = n2 >>= 8;
        int n5 = n2 >>= 8;
        int n6 = n2 >>= 8;
        if ((n6 & 0x80) == 0) {
            n6 |= 0x80;
        } else {
            n6 ^= 0xFFFFFFFF;
            n5 ^= 0xFFFFFFFF;
            n4 ^= 0xFFFFFFFF;
            n3 ^= 0xFFFFFFFF;
        }
        byArray[3] = (byte)n3;
        byArray[2] = (byte)n4;
        byArray[1] = (byte)n5;
        byArray[0] = (byte)n6;
        return byArray;
    }

    static float canonicalFormatBytesToFloat(byte[] byArray) {
        int n2 = byArray[0];
        int n3 = byArray[1];
        int n4 = byArray[2];
        int n5 = byArray[3];
        if ((n2 & 0x80) != 0) {
            n2 &= 0x7F;
            n3 &= 0xFF;
            n4 &= 0xFF;
            n5 &= 0xFF;
        } else {
            n2 = ~n2 & 0xFF;
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
        }
        int n6 = n2 << 24 | n3 << 16 | n4 << 8 | n5;
        return Float.intBitsToFloat(n6);
    }

    static {
        try {
            $$$methodRef$$$15 = BINARY_FLOAT.class.getDeclaredConstructor(Boolean.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = BINARY_FLOAT.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = BINARY_FLOAT.class.getDeclaredConstructor(Float.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = BINARY_FLOAT.class.getDeclaredConstructor(Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = BINARY_FLOAT.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = BINARY_FLOAT.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = BINARY_FLOAT.class.getDeclaredMethod("canonicalFormatBytesToFloat", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = BINARY_FLOAT.class.getDeclaredMethod("floatToCanonicalFormatBytes", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = BINARY_FLOAT.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = BINARY_FLOAT.class.getDeclaredMethod("stringToFloat", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = BINARY_FLOAT.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = BINARY_FLOAT.class.getDeclaredMethod("doubleValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = BINARY_FLOAT.class.getDeclaredMethod("floatValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = BINARY_FLOAT.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = BINARY_FLOAT.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = BINARY_FLOAT.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

