/*
 * Decompiled with CFR 0.152.
 */
package oracle.nativeimage;

import com.oracle.svm.core.annotate.AutomaticFeature;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.jdbc.logging.annotations.DisableTrace;
import org.graalvm.nativeimage.hosted.Feature;

@DisableTrace
@AutomaticFeature
final class CharacterSetFeature
implements Feature {
    private boolean characterSetLoaded = false;

    CharacterSetFeature() {
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        try {
            Class<?> clazz = Class.forName("oracle.sql.CharacterSet");
            if (duringAnalysisAccess.isReachable(clazz)) {
                if (this.characterSetLoaded) {
                    return;
                }
                this.characterSetLoaded = true;
                duringAnalysisAccess.requireAnalysisIteration();
                Field[] fieldArray = new Field[]{clazz.getDeclaredField("DEFAULT_CHARSET"), clazz.getDeclaredField("US7ASCII_CHARSET"), clazz.getDeclaredField("ISO_LATIN_1_CHARSET"), clazz.getDeclaredField("UNICODE_1_CHARSET"), clazz.getDeclaredField("WE8DEC_CHARSET"), clazz.getDeclaredField("WE8ISO8859P1_CHARSET"), clazz.getDeclaredField("WE8ISO8859P15_CHARSET"), clazz.getDeclaredField("WE8MSWIN1252_CHARSET"), clazz.getDeclaredField("UTF8_CHARSET"), clazz.getDeclaredField("UTFE_CHARSET"), clazz.getDeclaredField("AL32UTF8_CHARSET"), clazz.getDeclaredField("AL16UTF16_CHARSET"), clazz.getDeclaredField("AL16UTF16LE_CHARSET")};
                Method method = clazz.getDeclaredMethod("make", Integer.TYPE);
                method.setAccessible(true);
                for (Field field : fieldArray) {
                    int n2 = field.getInt(null);
                    Object object = method.invoke((Object)0, n2);
                    if (object != null) continue;
                    System.out.println("Character set id " + n2 + " does not have data");
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
    }
}

