/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayStatistics;

public class ReplayStatisticsImpl
implements oracle.jdbc.replay.internal.ReplayStatistics,
Cloneable,
Serializable {
    private long totalRequests = 0L;
    private long totalCompletedRequests = 0L;
    private long totalCalls = 0L;
    private long totalProtectedCalls = 0L;
    private long totalCallsAffectedByOutages = 0L;
    private long totalCallsTriggeringReplay = 0L;
    private long totalCallsAffectedByOutagesDuringReplay = 0L;
    private long successfulReplayCount = 0L;
    private long failedReplayCount = 0L;
    private long replayDisablingCount = 0L;
    private long totalReplayAttempts = 0L;
    private int currentRequestSize = 0;
    private static final int HISTOGRAM_SIZE = 31;
    private int[] requestSizeHistogram = new int[31];
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;

    public ReplayStatisticsImpl() {
    }

    public ReplayStatisticsImpl(long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, int n2) {
        this.totalRequests = l2;
        this.totalCompletedRequests = l3;
        this.totalCalls = l4;
        this.totalProtectedCalls = l5;
        this.totalCallsAffectedByOutages = l6;
        this.totalCallsTriggeringReplay = l7;
        this.totalCallsAffectedByOutagesDuringReplay = l8;
        this.successfulReplayCount = l9;
        this.failedReplayCount = l10;
        this.replayDisablingCount = l11;
        this.totalReplayAttempts = l12;
        this.currentRequestSize = n2;
    }

    @Override
    public long getTotalRequests() {
        return this.totalRequests;
    }

    @Override
    public long getTotalCompletedRequests() {
        return this.totalCompletedRequests;
    }

    @Override
    public long getTotalCalls() {
        return this.totalCalls;
    }

    @Override
    public long getTotalProtectedCalls() {
        return this.totalProtectedCalls;
    }

    @Override
    public long getTotalCallsAffectedByOutages() {
        return this.totalCallsAffectedByOutages;
    }

    @Override
    public long getTotalCallsTriggeringReplay() {
        return this.totalCallsTriggeringReplay;
    }

    @Override
    public long getTotalCallsAffectedByOutagesDuringReplay() {
        return this.totalCallsAffectedByOutagesDuringReplay;
    }

    @Override
    public long getSuccessfulReplayCount() {
        return this.successfulReplayCount;
    }

    @Override
    public long getFailedReplayCount() {
        return this.failedReplayCount;
    }

    @Override
    public long getReplayDisablingCount() {
        return this.replayDisablingCount;
    }

    @Override
    public long getTotalReplayAttempts() {
        return this.totalReplayAttempts;
    }

    @Override
    public int getCurrentRequestSize() {
        return this.currentRequestSize;
    }

    @Override
    public int[] getRequestSizeHistogram() {
        int[] nArray = null;
        if (this.requestSizeHistogram != null && this.requestSizeHistogram.length > 0) {
            nArray = new int[this.requestSizeHistogram.length];
            System.arraycopy(this.requestSizeHistogram, 0, nArray, 0, this.requestSizeHistogram.length);
        }
        return nArray;
    }

    void incrementTotalRequests() {
        ++this.totalRequests;
    }

    void incrementTotalCompletedRequests() {
        ++this.totalCompletedRequests;
    }

    void incrementTotalCalls() {
        ++this.totalCalls;
    }

    void incrementTotalProtectedCalls() {
        ++this.totalProtectedCalls;
    }

    void incrementTotalCallsAffectedByOutages() {
        ++this.totalCallsAffectedByOutages;
    }

    void incrementTotalCallsTriggeringReplay() {
        ++this.totalCallsTriggeringReplay;
    }

    void incrementTotalCallsAffectedByOutagesDuringReplay() {
        ++this.totalCallsAffectedByOutagesDuringReplay;
    }

    void incrementSuccessfulReplayCount() {
        ++this.successfulReplayCount;
    }

    void incrementFailedReplayCount() {
        ++this.failedReplayCount;
    }

    void incrementReplayDisablingCount() {
        ++this.replayDisablingCount;
    }

    void incrementTotalReplayAttempts() {
        ++this.totalReplayAttempts;
    }

    void incrementCurrentRequestSize() {
        ++this.currentRequestSize;
    }

    void aggregate(ReplayStatistics replayStatistics) {
        this.totalRequests += replayStatistics.getTotalRequests();
        this.totalCompletedRequests += replayStatistics.getTotalCompletedRequests();
        this.totalCalls += replayStatistics.getTotalCalls();
        this.totalProtectedCalls += replayStatistics.getTotalProtectedCalls();
        this.totalCallsAffectedByOutages += replayStatistics.getTotalCallsAffectedByOutages();
        this.totalCallsTriggeringReplay += replayStatistics.getTotalCallsTriggeringReplay();
        this.totalCallsAffectedByOutagesDuringReplay += replayStatistics.getTotalCallsAffectedByOutagesDuringReplay();
        this.successfulReplayCount += replayStatistics.getSuccessfulReplayCount();
        this.failedReplayCount += replayStatistics.getFailedReplayCount();
        this.replayDisablingCount += replayStatistics.getReplayDisablingCount();
        this.totalReplayAttempts += replayStatistics.getTotalReplayAttempts();
        this.currentRequestSize += replayStatistics.getCurrentRequestSize();
    }

    void clearCurrentRequestSize() {
        this.currentRequestSize = 0;
    }

    void updateRequestSizeHistogram(int n2) {
        if (n2 > 0) {
            int n3 = -1;
            for (int i2 = n2; i2 > 0; i2 /= 2) {
                ++n3;
            }
            int n4 = n3;
            this.requestSizeHistogram[n4] = this.requestSizeHistogram[n4] + 1;
        }
    }

    @Override
    public void setRequestSizeHistogram(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            this.requestSizeHistogram = nArray;
        }
    }

    @Override
    public void clear() {
        this.totalRequests = 0L;
        this.totalCompletedRequests = 0L;
        this.totalCalls = 0L;
        this.totalProtectedCalls = 0L;
        this.totalCallsAffectedByOutages = 0L;
        this.totalCallsTriggeringReplay = 0L;
        this.totalCallsAffectedByOutagesDuringReplay = 0L;
        this.successfulReplayCount = 0L;
        this.failedReplayCount = 0L;
        this.replayDisablingCount = 0L;
        this.totalReplayAttempts = 0L;
        this.requestSizeHistogram = null;
    }

    @DisableTrace
    public String toString() {
        return "AC Statistics:" + "\n===============================================" + "\nTotalRequests = " + this.getTotalRequests() + "\nTotalCompletedRequests = " + this.getTotalCompletedRequests() + "\nTotalCalls = " + this.getTotalCalls() + "\nTotalProtectedCalls = " + this.getTotalProtectedCalls() + "\nCurrentRequestSize = " + this.getCurrentRequestSize() + "\n===============================================" + "\nTotalCallsAffectedByOutages = " + this.getTotalCallsAffectedByOutages() + "\nTotalCallsTriggeringReplay = " + this.getTotalCallsTriggeringReplay() + "\nTotalCallsAffectedByOutagesDuringReplay = " + this.getTotalCallsAffectedByOutagesDuringReplay() + "\n===============================================" + "\nSuccessfulReplayCount = " + this.getSuccessfulReplayCount() + "\nFailedReplayCount = " + this.getFailedReplayCount() + "\nReplayDisablingCount = " + this.getReplayDisablingCount() + "\nTotalReplayAttempts = " + this.getTotalReplayAttempts() + "\n===============================================";
    }

    @DisableTrace
    public String getRequestSizeHistogramString() {
        StringBuilder stringBuilder = new StringBuilder().append("AC Request-Size Histogram:").append("\n===============================================");
        if (this.requestSizeHistogram != null && this.requestSizeHistogram.length > 0) {
            int n2 = 1;
            int n3 = 0;
            for (int i2 = 0; i2 < this.requestSizeHistogram.length; ++i2) {
                if (n3 > 0) {
                    n2 = n3 + 1;
                }
                n3 = n2 * 2 - 1;
                stringBuilder.append("\nSizes between ").append(n2).append(" and ").append(n3).append(" : ").append(this.requestSizeHistogram[i2]);
            }
        }
        stringBuilder.append("\n===============================================");
        return stringBuilder.toString();
    }

    static {
        try {
            $$$methodRef$$$31 = ReplayStatisticsImpl.class.getDeclaredConstructor(Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = ReplayStatisticsImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = ReplayStatisticsImpl.class.getDeclaredMethod("clear", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = ReplayStatisticsImpl.class.getDeclaredMethod("setRequestSizeHistogram", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = ReplayStatisticsImpl.class.getDeclaredMethod("updateRequestSizeHistogram", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = ReplayStatisticsImpl.class.getDeclaredMethod("clearCurrentRequestSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ReplayStatisticsImpl.class.getDeclaredMethod("aggregate", ReplayStatistics.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementCurrentRequestSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalReplayAttempts", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementReplayDisablingCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementFailedReplayCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementSuccessfulReplayCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalCallsAffectedByOutagesDuringReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalCallsTriggeringReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalCallsAffectedByOutages", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalProtectedCalls", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalCalls", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalCompletedRequests", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ReplayStatisticsImpl.class.getDeclaredMethod("incrementTotalRequests", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ReplayStatisticsImpl.class.getDeclaredMethod("getRequestSizeHistogram", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ReplayStatisticsImpl.class.getDeclaredMethod("getCurrentRequestSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalReplayAttempts", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ReplayStatisticsImpl.class.getDeclaredMethod("getReplayDisablingCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ReplayStatisticsImpl.class.getDeclaredMethod("getFailedReplayCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ReplayStatisticsImpl.class.getDeclaredMethod("getSuccessfulReplayCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalCallsAffectedByOutagesDuringReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalCallsTriggeringReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalCallsAffectedByOutages", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalProtectedCalls", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalCalls", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalCompletedRequests", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ReplayStatisticsImpl.class.getDeclaredMethod("getTotalRequests", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

