/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.PooledConnection;
import oracle.jdbc.OraclePooledConnectionBuilder;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.pool.OraclePooledConnectionBuilderImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
public class OracleConnectionPoolDataSource
extends OracleDataSource
implements oracle.jdbc.datasource.OracleConnectionPoolDataSource {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    public OracleConnectionPoolDataSource() throws SQLException {
        this.dataSourceName = "OracleConnectionPoolDataSource";
        this.isOracleDataSource = false;
        this.connCachingEnabled = false;
        this.fastConnFailover = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        String string = null;
        String string2 = null;
        OracleConnectionPoolDataSource oracleConnectionPoolDataSource = this;
        synchronized (oracleConnectionPoolDataSource) {
            string = this.user;
            string2 = this.password != null ? this.password.get() : null;
        }
        return this.getPooledConnection(string, string2);
    }

    @Override
    public PooledConnection getPooledConnection(String string, @Blind String string2) throws SQLException {
        Connection connection = this.getPhysicalConnection(string, string2);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        if (string2 == null) {
            string2 = this.password != null ? this.password.get() : null;
        }
        oraclePooledConnection.setUserName(this.user != null && !string.startsWith("\"") ? string.toLowerCase() : string, string2);
        return oraclePooledConnection;
    }

    PooledConnection getPooledConnection(Properties properties) throws SQLException {
        String string;
        Connection connection = this.getPhysicalConnection(properties, null, null);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        String string2 = properties.getProperty("user");
        if (string2 == null) {
            string2 = ((OracleConnection)connection).getUserName();
        }
        if ((string = properties.getProperty("password")) == null) {
            string = this.password != null ? this.password.get() : null;
        }
        oraclePooledConnection.setUserName(this.user != null && !string2.startsWith("\"") ? string2.toLowerCase() : string2, string);
        return oraclePooledConnection;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection(this.user, this.password != null ? this.password.get() : null);
    }

    protected Connection getPhysicalConnection(String string, String string2, @Blind String string3) throws SQLException {
        this.url = string;
        return super.getConnection(string2, string3);
    }

    protected Connection getPhysicalConnection(String string, @Blind String string2) throws SQLException {
        return super.getConnection(string, string2);
    }

    protected OraclePooledConnection getPooledConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        String string;
        Connection connection = super.getConnection(oracleConnectionBuilderImpl);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        String string2 = oracleConnectionBuilderImpl.getUser();
        if (string2 == null) {
            string2 = ((OracleConnection)connection).getUserName();
        }
        if ((string = oracleConnectionBuilderImpl.getPassword()) == null) {
            string = this.password != null ? this.password.get() : null;
        }
        oraclePooledConnection.setUserName(this.user != null && !string2.startsWith("\"") ? string2.toLowerCase() : string2, string);
        return oraclePooledConnection;
    }

    @Override
    public OraclePooledConnectionBuilder createPooledConnectionBuilder() throws SQLException {
        return new OraclePooledConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public oracle.jdbc.datasource.OraclePooledConnection build() throws SQLException {
                OracleConnectionBuilderImpl oracleConnectionBuilderImpl = OracleConnectionPoolDataSource.this.createConnectionBuilder().user(this.user).password(this.password).instanceName(this.instanceName).serviceName(this.serviceName).shardingKey(this.shardingKey).superShardingKey(this.superShardingKey);
                if (this.sslContext != null) {
                    oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.sslContext(this.sslContext);
                }
                if (this.gssCredential != null) {
                    oracleConnectionBuilderImpl = oracleConnectionBuilderImpl.gssCredential(this.gssCredential);
                }
                if (oracleConnectionBuilderImpl.getGSSCredential() != null && (oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null)) {
                    throw (SQLException)DatabaseError.createSqlException(1702).fillInStackTrace();
                }
                return OracleConnectionPoolDataSource.this.getPooledConnection(oracleConnectionBuilderImpl);
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(OracleConnectionPoolDataSource.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$9 = OracleConnectionPoolDataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleConnectionPoolDataSource.class.getDeclaredMethod("createPooledConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleConnectionPoolDataSource.class.getDeclaredMethod("createPooledConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleConnectionPoolDataSource.class.getDeclaredMethod("getPooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

