/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.logging.Logger;
import javax.json.JsonNumber;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.jdbc.driver.json.JsonpExceptionFactory;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public final class JsonpPrimitive {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    private static boolean stringsEqual(JsonString jsonString, Object object) {
        if (!(object instanceof JsonString)) {
            return false;
        }
        return jsonString == object || jsonString.getString().equals(((JsonString)object).getString());
    }

    private JsonpPrimitive() {
    }

    static {
        try {
            $$$methodRef$$$2 = JsonpPrimitive.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JsonpPrimitive.class.getDeclaredMethod("access$100", JsonString.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JsonpPrimitive.class.getDeclaredMethod("stringsEqual", JsonString.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static interface DefaultJsonString
    extends JsonString,
    Wrapper {
        default public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.STRING;
        }

        public OracleJsonValue getUnwrapped();

        @Override
        default public <T> T unwrap(Class<T> clazz) throws SQLException {
            OracleJsonValue oracleJsonValue = this.getUnwrapped();
            if (clazz.isInstance(oracleJsonValue)) {
                return (T)oracleJsonValue;
            }
            throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, clazz.getName()).getMessage());
        }

        @Override
        default public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return clazz.isInstance(this.getUnwrapped());
        }

        default public CharSequence getChars() {
            return this.getString();
        }
    }

    private static abstract class DefaultJsonNumber
    extends OracleJsonNumberImpl
    implements JsonNumber,
    Wrapper {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        private DefaultJsonNumber() {
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.NUMBER;
        }

        abstract OracleJsonValue getUnwrapped();

        @Override
        public <T> T unwrap(Class<T> clazz) throws SQLException {
            OracleJsonValue oracleJsonValue = this.getUnwrapped();
            if (clazz.isInstance(oracleJsonValue)) {
                return (T)oracleJsonValue;
            }
            throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, clazz.getName()).getMessage());
        }

        @Override
        public boolean isWrapperFor(Class<?> clazz) throws SQLException {
            return clazz.isInstance(this.getUnwrapped());
        }

        @Override
        public String getString() {
            try {
                return ((OracleJsonNumberImpl)((Object)this.unwrap(OracleJsonNumber.class))).getString();
            }
            catch (SQLException sQLException) {
                throw new IllegalStateException();
            }
        }

        public final boolean equals(Object object) {
            if (!(object instanceof JsonNumber)) {
                return false;
            }
            return this.bigDecimalValue().equals(((JsonNumber)object).bigDecimalValue());
        }

        public final int hashCode() {
            return this.bigDecimalValue().hashCode();
        }

        static {
            try {
                $$$methodRef$$$7 = DefaultJsonNumber.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = DefaultJsonNumber.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = DefaultJsonNumber.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = DefaultJsonNumber.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = DefaultJsonNumber.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = DefaultJsonNumber.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = DefaultJsonNumber.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = DefaultJsonNumber.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpStringNumberImpl
    extends DefaultJsonNumber {
        private String value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public JsonpStringNumberImpl(String string) {
            this.value = string;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return new BigDecimal(this.value);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonStringNumberImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$6 = JsonpStringNumberImpl.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JsonpStringNumberImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpStringNumberImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpStringNumberImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpStringNumberImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpStringNumberImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpStringNumberImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpIntervalYMImpl
    implements DefaultJsonString {
        byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JsonpIntervalYMImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JsonpPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.serializeIntervalYM(JsonpExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonIntervalYMImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JsonpIntervalYMImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpIntervalYMImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpIntervalYMImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpIntervalYMImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpIntervalYMImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpIntervalYMImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpIntervalDSImpl
    implements DefaultJsonString {
        private byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JsonpIntervalDSImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JsonpPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.serializeIntervalDS(JsonpExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonIntervalDSImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JsonpIntervalDSImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpIntervalDSImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpIntervalDSImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpIntervalDSImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpIntervalDSImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpIntervalDSImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpTimestampImpl
    implements DefaultJsonString {
        private byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JsonpTimestampImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JsonpPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.timestampToString(JsonpExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonTimestampImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JsonpTimestampImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpTimestampImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpTimestampImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpTimestampImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpTimestampImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpTimestampImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpDateImpl
    implements DefaultJsonString {
        byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JsonpDateImpl(byte[] byArray) {
            this.raw = byArray;
        }

        public boolean equals(Object object) {
            return JsonpPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.dateToString(JsonpExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDateImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JsonpDateImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpDateImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpDateImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpDateImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpDateImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpDateImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpBinaryImpl
    implements DefaultJsonString {
        byte[] bytes;
        boolean isId;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JsonpBinaryImpl(byte[] byArray, boolean bl) {
            this.bytes = byArray;
            this.isId = bl;
        }

        public boolean equals(Object object) {
            return JsonpPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OracleJsonBinaryImpl.getString(this.bytes, this.isId);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonBinaryImpl(this.bytes, this.isId);
        }

        static {
            try {
                $$$methodRef$$$5 = JsonpBinaryImpl.class.getDeclaredConstructor(byte[].class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpBinaryImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpBinaryImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpBinaryImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpBinaryImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpBinaryImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpStringImpl
    implements DefaultJsonString {
        String value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JsonpStringImpl(String string) {
            this.value = string;
        }

        public boolean equals(Object object) {
            return JsonpPrimitive.stringsEqual(this, object);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String getString() {
            return this.value;
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonStringImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$5 = JsonpStringImpl.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpStringImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpStringImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpStringImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpStringImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpStringImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpDoubleImpl
    extends DefaultJsonNumber {
        double value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        public JsonpDoubleImpl(double d2) {
            this.value = d2;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDoubleImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$7 = JsonpDoubleImpl.class.getDeclaredConstructor(Double.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = JsonpDoubleImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JsonpDoubleImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpDoubleImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpDoubleImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpDoubleImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpDoubleImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpDoubleImpl.class.getDeclaredMethod("doubleValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpFloatImpl
    extends DefaultJsonNumber {
        private float value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        public JsonpFloatImpl(float f2) {
            this.value = f2;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonFloatImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$7 = JsonpFloatImpl.class.getDeclaredConstructor(Float.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = JsonpFloatImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JsonpFloatImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpFloatImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpFloatImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpFloatImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpFloatImpl.class.getDeclaredMethod("floatValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpFloatImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JsonpNumberImpl
    extends DefaultJsonNumber {
        byte[] raw;
        OracleJsonDecimal.TargetType type;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public JsonpNumberImpl(byte[] byArray, OracleJsonDecimal.TargetType targetType) {
            this.raw = byArray;
            this.type = targetType;
        }

        @Override
        public final BigDecimal bigDecimalValue() {
            return OsonPrimitiveConversions.toBigDecimal(this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDecimalImpl(this.raw, this.type);
        }

        static {
            try {
                $$$methodRef$$$6 = JsonpNumberImpl.class.getDeclaredConstructor(byte[].class, OracleJsonDecimal.TargetType.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JsonpNumberImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JsonpNumberImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JsonpNumberImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JsonpNumberImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JsonpNumberImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JsonpNumberImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

