/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleDataSource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFJMSConnection
extends Thread {
    private String jmsConnectionId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn = null;
    private T4CTTIoaqnfy oaqnfy = null;
    private volatile boolean needToBeClosed = false;
    private boolean safeToClose = true;
    private int numberOfRegistrations = 0;
    private NTFJMSConnectionGroup connectionGroup = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    NTFJMSConnection(String string, ArrayList<String> arrayList, String string2, String string3, String string4, @Blind String string5, String string6, int n2) {
        this.userName = string4;
        this.password = OpaqueString.newOpaqueString(string5);
        this.serviceName = string3;
        this.jmsConnectionId = string;
        this.listenerAddresses = arrayList;
        this.instanceName = string2;
        this.connClass = string6;
        this.numberOfRegistrations = n2;
        assert (arrayList != null) : "listenerAddresses is null";
        assert (string2 != null) : "instancename is null";
    }

    @Override
    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 2 && !this.needToBeClosed; ++i2) {
            try {
                if (i2 == 0 || bl2) {
                    this.conn = this.getConnection(n2);
                    this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.jmsConnectionId);
                }
                if (bl || !this.needToBeClosed) {
                    bl = false;
                    bl2 = false;
                    i2 = 0;
                }
                this.oaqnfy.doRPC();
                continue;
            }
            catch (IOException iOException) {
                this.needToBeClosed = true;
                continue;
            }
            catch (Exception exception) {
                if (this.needToBeClosed) break;
                if (bl) {
                    this.getConnectionGroup().raiseException();
                    break;
                }
                if (exception instanceof SQLException) {
                    n3 = ((SQLException)exception).getErrorCode();
                }
                if (n3 == 17410) {
                    bl2 = true;
                    n3 = 0;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception2) {}
                } else {
                    bl2 = false;
                }
                bl = true;
            }
        }
    }

    Connection getConnection(int n2) throws SQLException, InterruptedException {
        Connection connection = null;
        OracleDataSource oracleDataSource = new OracleDataSource();
        oracleDataSource.setUser(this.userName);
        oracleDataSource.setPassword(this.password.get());
        if (this.connClass != null) {
            Properties properties = new Properties();
            properties.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
            properties.put("oracle.jdbc.jmsNotification", "true");
            properties.put("oracle.jdbc.ReadTimeout", (Object)0);
            properties.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
            oracleDataSource.setConnectionProperties(properties);
        }
        while (connection == null && n2++ < 5 && !this.needToBeClosed) {
            connection = this.tryListenerAddressesToGetConnection(oracleDataSource);
            if (connection != null || n2 >= 5) continue;
            Thread.sleep(n2 * 5000);
        }
        if (connection == null && !this.needToBeClosed) {
            throw new SQLException("Failed to create notification connection to emon server");
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource oracleDataSource) {
        for (String string : this.listenerAddresses) {
            String string2 = "jdbc:oracle:thin:@(DESCRIPTION=" + string + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
            oracleDataSource.setURL(string2);
            try {
                NTFJMSConnection nTFJMSConnection = this;
                synchronized (nTFJMSConnection) {
                    if (this.needToBeClosed) {
                        return null;
                    }
                    Connection connection = oracleDataSource.getConnection();
                    if (connection != null) {
                        return connection;
                    }
                }
            }
            catch (SQLException sQLException) {
            }
        }
        return null;
    }

    synchronized void closeThisListener() {
        this.needToBeClosed = true;
        try {
            if (this.oaqnfy != null) {
                this.oaqnfy.stopListening();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
        }
    }

    void setNeedToBeClosed(boolean bl) {
        this.needToBeClosed = bl;
    }

    String getJMSConnectionId() {
        return this.jmsConnectionId;
    }

    int getNumberOfRegistrations() {
        return this.numberOfRegistrations;
    }

    void incrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations += n2;
    }

    void decrementNumberOfRegistrations(int n2) {
        this.numberOfRegistrations -= n2;
    }

    void setConnectionGroup(NTFJMSConnectionGroup nTFJMSConnectionGroup) {
        this.connectionGroup = nTFJMSConnectionGroup;
    }

    NTFJMSConnectionGroup getConnectionGroup() {
        if (this.connectionGroup == null) {
            this.connectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
        }
        return this.connectionGroup;
    }

    static {
        try {
            $$$methodRef$$$11 = NTFJMSConnection.class.getDeclaredConstructor(String.class, ArrayList.class, String.class, String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFJMSConnection.class.getDeclaredMethod("getConnectionGroup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFJMSConnection.class.getDeclaredMethod("setConnectionGroup", NTFJMSConnectionGroup.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFJMSConnection.class.getDeclaredMethod("decrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFJMSConnection.class.getDeclaredMethod("incrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFJMSConnection.class.getDeclaredMethod("getNumberOfRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFJMSConnection.class.getDeclaredMethod("getJMSConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFJMSConnection.class.getDeclaredMethod("setNeedToBeClosed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFJMSConnection.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFJMSConnection.class.getDeclaredMethod("tryListenerAddressesToGetConnection", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFJMSConnection.class.getDeclaredMethod("getConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFJMSConnection.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

