/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class ArrayLocatorResultSet
extends ForwardOnlyResultSet {
    static int COUNT_UNLIMITED;
    Map map;
    long beginIndex;
    int count;
    long currentIndex;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    static ArrayLocatorResultSet create(PhysicalConnection physicalConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, Map map) throws SQLException {
        return ArrayLocatorResultSet.create(physicalConnection, arrayDescriptor, byArray, 0L, COUNT_UNLIMITED, map);
    }

    static ArrayLocatorResultSet create(PhysicalConnection physicalConnection, ArrayDescriptor arrayDescriptor, byte[] byArray, long l2, int n2, Map map) throws SQLException {
        OraclePreparedStatement oraclePreparedStatement = null;
        ARRAY aRRAY = new ARRAY(arrayDescriptor, physicalConnection, (Object)null);
        aRRAY.setLocator(byArray);
        oraclePreparedStatement = arrayDescriptor.getBaseType() == 2002 || arrayDescriptor.getBaseType() == 2008 ? physicalConnection.prepareStatementInternal("SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS " + arrayDescriptor.getName() + ") )", 1003, 1007) : physicalConnection.prepareStatementInternal("SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS " + arrayDescriptor.getName() + ") )", 1003, 1007);
        oraclePreparedStatement.setArray(1, aRRAY);
        oraclePreparedStatement.executeQuery();
        return new ArrayLocatorResultSet(physicalConnection, oraclePreparedStatement, l2, n2, map);
    }

    private ArrayLocatorResultSet(OracleConnection oracleConnection, OracleStatement oracleStatement, long l2, int n2, Map map) throws SQLException {
        super((PhysicalConnection)oracleConnection, oracleStatement);
        if (oracleConnection == null || oracleStatement == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid arguments").fillInStackTrace();
        }
        oracleStatement.closeOnCompletion();
        this.count = n2;
        this.currentIndex = 0L;
        this.beginIndex = l2;
        this.map = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.currentIndex < this.beginIndex) {
                while (this.currentIndex < this.beginIndex) {
                    ++this.currentIndex;
                    if (super.next()) continue;
                    return false;
                }
                return true;
            }
            if (this.count == COUNT_UNLIMITED) {
                return super.next();
            }
            if (this.currentIndex < this.beginIndex + (long)this.count - 1L) {
                ++this.currentIndex;
                return super.next();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            return this.getObject(n2, this.map);
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (string.equalsIgnoreCase("index")) {
                return 1;
            }
            if (string.equalsIgnoreCase("value")) {
                return 2;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index").fillInStackTrace();
        }
    }

    static {
        try {
            $$$methodRef$$$5 = ArrayLocatorResultSet.class.getDeclaredConstructor(OracleConnection.class, OracleStatement.class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ArrayLocatorResultSet.class.getDeclaredMethod("findColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ArrayLocatorResultSet.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ArrayLocatorResultSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ArrayLocatorResultSet.class.getDeclaredMethod("create", PhysicalConnection.class, ArrayDescriptor.class, byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ArrayLocatorResultSet.class.getDeclaredMethod("create", PhysicalConnection.class, ArrayDescriptor.class, byte[].class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        COUNT_UNLIMITED = -1;
    }
}

