/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntryKey;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class ResultSetCacheEntry {
    private final AtomicReference<QueryResultState> queryResultState = new AtomicReference<QueryResultState>(QueryResultState.FETCHING);
    private int numRows = -1;
    private ByteArray rowData = null;
    private AccessorPrototype[] accessorPrototypes = null;
    String userName;
    ResultSetCacheEntryKey key;
    long queryId;
    long sizeInMemory;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    ResultSetCacheEntry(ResultSetCacheEntryKey resultSetCacheEntryKey, long l2) {
        assert (l2 != 0L);
        this.key = resultSetCacheEntryKey;
        this.queryId = l2;
    }

    ResultSetCacheEntryKey getResultSetCacheEntryKey() {
        return this.key;
    }

    void initialize(int n2, ByteArray byteArray, Accessor[] accessorArray, long l2) throws SQLException {
        assert (this.queryResultState.get() != QueryResultState.VALID) : "queryResultState: " + this.queryResultState;
        assert (n2 >= 0) : "_numRows: " + n2;
        assert (byteArray != null) : "null _rowData";
        assert (accessorArray != null) : "null _accessors";
        if (this.queryResultState.get() == QueryResultState.INVALID) {
            return;
        }
        this.numRows = n2;
        this.rowData = byteArray;
        this.accessorPrototypes = new AccessorPrototype[accessorArray.length];
        for (int i2 = 0; i2 < accessorArray.length; ++i2) {
            assert (accessorArray[i2] != null) : "null _accessor: " + i2;
            this.accessorPrototypes[i2] = accessorArray[i2].newPrototype(this.numRows);
        }
        this.sizeInMemory = l2;
        this.queryResultState.compareAndSet(QueryResultState.FETCHING, QueryResultState.VALID);
    }

    boolean isFetching() {
        return this.queryResultState.get() == QueryResultState.FETCHING;
    }

    boolean isValid() {
        return this.queryResultState.get() == QueryResultState.VALID;
    }

    boolean isInvalid() {
        return this.queryResultState.get() == QueryResultState.INVALID;
    }

    void invalidate() {
        this.queryResultState.set(QueryResultState.INVALID);
    }

    int getNumberOfRows() {
        assert (this.queryResultState.get() != QueryResultState.FETCHING) : "queryResultState: " + this.queryResultState;
        return this.numRows;
    }

    ByteArray getRowData() {
        assert (this.queryResultState.get() != QueryResultState.FETCHING) : "queryResultState: " + this.queryResultState;
        return this.rowData;
    }

    long getQueryId() {
        return this.queryId;
    }

    long getSizeInMemory() {
        return this.sizeInMemory;
    }

    Accessor[] newAccessors(OracleStatement oracleStatement) throws SQLException {
        assert (this.queryResultState.get() != QueryResultState.FETCHING) : "queryResultState: " + this.queryResultState;
        assert (oracleStatement != null) : "null stmt";
        Accessor[] accessorArray = new Accessor[this.accessorPrototypes.length];
        for (int i2 = 0; i2 < this.accessorPrototypes.length; ++i2) {
            accessorArray[i2] = this.accessorPrototypes[i2].newAccessor(oracleStatement);
        }
        return accessorArray;
    }

    static {
        try {
            $$$methodRef$$$11 = ResultSetCacheEntry.class.getDeclaredConstructor(ResultSetCacheEntryKey.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ResultSetCacheEntry.class.getDeclaredMethod("newAccessors", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ResultSetCacheEntry.class.getDeclaredMethod("getSizeInMemory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ResultSetCacheEntry.class.getDeclaredMethod("getQueryId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ResultSetCacheEntry.class.getDeclaredMethod("getRowData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ResultSetCacheEntry.class.getDeclaredMethod("getNumberOfRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ResultSetCacheEntry.class.getDeclaredMethod("invalidate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ResultSetCacheEntry.class.getDeclaredMethod("isInvalid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ResultSetCacheEntry.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ResultSetCacheEntry.class.getDeclaredMethod("isFetching", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ResultSetCacheEntry.class.getDeclaredMethod("initialize", Integer.TYPE, ByteArray.class, Accessor[].class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetCacheEntry.class.getDeclaredMethod("getResultSetCacheEntryKey", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static final class QueryResultState
    extends Enum<QueryResultState> {
        public static final /* enum */ QueryResultState FETCHING;
        public static final /* enum */ QueryResultState VALID;
        public static final /* enum */ QueryResultState INVALID;
        private static final /* synthetic */ QueryResultState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static QueryResultState[] values() {
            return (QueryResultState[])$VALUES.clone();
        }

        public static QueryResultState valueOf(String string) {
            return Enum.valueOf(QueryResultState.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = QueryResultState.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = QueryResultState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = QueryResultState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            FETCHING = new QueryResultState();
            VALID = new QueryResultState();
            INVALID = new QueryResultState();
            $VALUES = new QueryResultState[]{FETCHING, VALID, INVALID};
        }
    }
}

