/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableStatement;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={ResultSet.class, OracleResultSet.class, oracle.jdbc.internal.OracleResultSet.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableResultSet
extends NonTxnReplayableBase
implements Replayable {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="deleteRow", args={}), @Signature(name="insertRow", args={}), @Signature(name="updateRow", args={})})
    protected void preForRowUpdates(Method method, Object object, Object ... objectArray) {
        block1: {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method method, Object object, Object ... objectArray) {
        block1: {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="next", args={})})
    protected boolean postForNext(Method method, boolean bl) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                this.doPostWhenRecordingNext(method, bl, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplaying(method, bl, null);
            }
        }
        return bl;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.doPostWhenRecordingClose(method, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        this.onErrorForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method method, SQLException sQLException) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw sQLException;
        }
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (sQLException instanceof SQLRecoverableException && replayLifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) throws SQLException {
        OracleStatement oracleStatement = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        long l2 = oracleStatement.getChecksum();
        this.failoverMngr.update(this, callHistoryEntry, callHistoryEntry.result, callHistoryEntry.callStatus, l2, callHistoryEntry.scn, callHistoryEntry.callException);
    }

    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = super.replayOneCall(callHistoryEntry, sQLRecoverableException);
        return object;
    }

    protected void doPostWhenRecordingNext(Method method, Object object, SQLException sQLException) {
        long l2 = 0L;
        OracleStatement oracleStatement = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
        try {
            l2 = oracleStatement.getChecksum();
        }
        catch (SQLException sQLException2) {
            l2 = 0L;
        }
        this.failoverMngr.update(this, null, object, "completed", l2, -1L, sQLException);
    }

    protected void doPostWhenRecordingClose(Method method, SQLException sQLException) {
        NonTxnReplayableStatement nonTxnReplayableStatement = (NonTxnReplayableStatement)this.getCreator();
        if (nonTxnReplayableStatement.okToPurgeSameProxyList()) {
            this.purgeSameProxyList();
        }
        this.isClosedAndNoReplay = true;
    }

    @Override
    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
        try {
            FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            switch (replayLifecycle) {
                case REPLAYING: {
                    if (this.replayingCallEntry.checksum == 0L) break;
                    OracleStatement oracleStatement = (OracleStatement)((NonTxnReplayableBase)this.getCreator()).getDelegate();
                    long l2 = oracleStatement.getChecksum();
                    if (this.replayingCallEntry.checksum != l2) {
                        this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 388, "Replay failed because of checksum mismatch", this.originalError);
                    }
                    break;
                }
            }
        }
        catch (SQLException sQLException2) {
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Statement getStatement() {
        return (Statement)this.getCreator();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)this.getDelegate();
    }

    static {
        try {
            $$$methodRef$$$17 = NonTxnReplayableResultSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = NonTxnReplayableResultSet.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = NonTxnReplayableResultSet.class.getDeclaredMethod("getStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = NonTxnReplayableResultSet.class.getDeclaredMethod("doPostWhenReplaying", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = NonTxnReplayableResultSet.class.getDeclaredMethod("doPostWhenRecordingClose", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = NonTxnReplayableResultSet.class.getDeclaredMethod("doPostWhenRecordingNext", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = NonTxnReplayableResultSet.class.getDeclaredMethod("replayOneCall", FailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = NonTxnReplayableResultSet.class.getDeclaredMethod("fillInChecksum", FailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = NonTxnReplayableResultSet.class.getDeclaredMethod("onErrorForLast", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableResultSet.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableResultSet.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForClose", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForNext", Method.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableResultSet.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableResultSet.class.getDeclaredMethod("preForUpdateStreams", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableResultSet.class.getDeclaredMethod("preForRowUpdates", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableResultSet.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

