/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class KeywordValueI
extends KeywordValue {
    private int keyword;
    private byte[] binaryValue;
    private String textValue;
    private byte[] textValueArr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    KeywordValueI(int n2, String string, byte[] byArray) {
        this.keyword = n2;
        this.textValue = string;
        this.binaryValue = byArray;
        this.textValueArr = null;
    }

    void doCharConversion(DBConversion dBConversion) throws SQLException {
        this.textValueArr = (byte[])(this.textValue != null ? dBConversion.StringToCharBytes(this.textValue) : null);
    }

    @Override
    public byte[] getBinaryValue() throws SQLException {
        return this.binaryValue;
    }

    @Override
    public String getTextValue() throws SQLException {
        return this.textValue;
    }

    @Override
    public int getKeyword() throws SQLException {
        return this.keyword;
    }

    void marshal(T4CMAREngine t4CMAREngine) throws IOException {
        if (this.textValueArr != null) {
            t4CMAREngine.marshalUB2(this.textValueArr.length);
            t4CMAREngine.marshalCLR(this.textValueArr, this.textValueArr.length);
            t4CMAREngine.marshalUB2(0);
        } else {
            t4CMAREngine.marshalUB2(0);
            if (this.binaryValue != null) {
                t4CMAREngine.marshalUB2(this.binaryValue.length);
                t4CMAREngine.marshalCLR(this.binaryValue, this.binaryValue.length);
            } else {
                t4CMAREngine.marshalUB2(0);
            }
        }
        t4CMAREngine.marshalUB2(this.keyword);
    }

    static KeywordValueI unmarshal(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        int n2;
        int[] nArray = new int[1];
        String string = null;
        byte[] byArray = null;
        int n3 = t4CMAREngine.unmarshalUB2();
        if (n3 != 0) {
            byte[] byArray2 = new byte[n3];
            t4CMAREngine.unmarshalCLR(byArray2, 0, nArray);
            string = t4CMAREngine.conv.CharBytesToString(byArray2, byArray2.length);
        }
        if ((n2 = t4CMAREngine.unmarshalUB2()) != 0) {
            byArray = new byte[n2];
            t4CMAREngine.unmarshalCLR(byArray, 0, nArray);
        }
        int n4 = t4CMAREngine.unmarshalUB2();
        return new KeywordValueI(n4, string, byArray);
    }

    static {
        try {
            $$$methodRef$$$6 = KeywordValueI.class.getDeclaredConstructor(Integer.TYPE, String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = KeywordValueI.class.getDeclaredMethod("unmarshal", T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = KeywordValueI.class.getDeclaredMethod("marshal", T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = KeywordValueI.class.getDeclaredMethod("getKeyword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = KeywordValueI.class.getDeclaredMethod("getTextValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = KeywordValueI.class.getDeclaredMethod("getBinaryValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = KeywordValueI.class.getDeclaredMethod("doCharConversion", DBConversion.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

