/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.dms.instrument.NounIntf;
import oracle.jdbc.SecurityInformation;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.DNVerifier;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;
import oracle.net.nt.TimeoutSocketChannel;
import oracle.net.nt.WSSSocketChannel;

public class TcpsNTAdapter
extends TcpNTAdapter {
    String matchSSLServerCertDNWith;
    boolean fullDNMatch;
    SSLSocketFactory l_sslSockFac;
    Socket underlyingSocket = null;
    SocketChannel underlyingSocketChannel = null;
    InetAddress[] inetAddresses = null;
    int count;
    int attempts;
    SSLSocket socketWithListener;
    SSLEngine l_sslEngine;
    boolean useNio;
    private String websocketURI = "/sqlnet";
    private final DNVerifier dnVerifier;
    private SSLContext sslContext;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public TcpsNTAdapter(String string, Properties properties, SSLContext sSLContext, ConnOption connOption) throws NLException, IOException {
        super(string, properties);
        this.sslContext = sSLContext;
        this.dnVerifier = new DNVerifier(connOption, Boolean.valueOf((String)this.getOption(106)));
        NVPair nVPair = this.nav.findNVPair(this.nvpAddr, "WEBSOCK_URI");
        if (nVPair != null) {
            this.websocketURI = nVPair.getAtom();
        }
    }

    @Override
    public void connect(NounIntf nounIntf) throws IOException {
        this.useNio = Boolean.parseBoolean((String)this.socketOptions.get(20));
        if (!this.useNio) {
            this.l_sslSockFac = this.newSSLSocketFactory(nounIntf);
            this.underlyingSocket = new Socket();
        } else {
            this.l_sslEngine = this.newSSLEngine();
        }
        String string = (String)this.socketOptions.get(2);
        int n2 = string == null ? 0 : Integer.parseInt(string);
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(18));
        if (this.inetAddresses == null) {
            this.inetAddresses = InetAddress.getAllByName(this.host);
            if (bl && this.inetAddresses.length > 1) {
                this.inetAddresses = TcpsNTAdapter.getAddressesInCircularOrder(this.host, this.inetAddresses);
            }
            DownHostsCache.getInstance().reorderAddresses(this.inetAddresses, this.port);
            this.attempts = this.inetAddresses.length;
            this.count = 0;
        }
        do {
            InetAddress inetAddress = this.inetAddresses[this.count];
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
            ++this.count;
            --this.attempts;
            InetSocketAddress inetSocketAddress2 = null;
            if (this.httpProxy != null) {
                inetSocketAddress2 = new InetSocketAddress(this.httpProxy, this.httpProxyPort);
            }
            long l2 = System.currentTimeMillis();
            this.underlyingSocket = new Socket();
            try {
                if (!this.useNio) {
                    this.underlyingSocket.connect(inetSocketAddress, n2);
                } else {
                    this.netStat = new NetStatImpl();
                    this.underlyingSocketChannel = new TimeoutSocketChannel(new InetSocketAddress(inetAddress, this.port), n2, this.netStat, inetSocketAddress2);
                    this.underlyingSocket = this.underlyingSocketChannel.socket();
                }
                if (!this.useNio) {
                    this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
                } else {
                    this.socketChannel = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine, this.dnVerifier);
                    this.socket = this.socketChannel.socket();
                }
                String string2 = (String)this.socketOptions.get(3);
                if (string2 != null) {
                    this.setOption(3, string2);
                }
                this.setSSLSocketOptions();
                if (!this.useNio || this.protocol == null || !this.protocol.equalsIgnoreCase("wss")) break;
                String string3 = (String)this.socketOptions.get(26);
                String string4 = (String)this.socketOptions.get(27);
                this.socketChannel = new WSSSocketChannel(this.socketChannel, this.websocketURI, this.host, this.port, string3, string4);
                break;
            }
            catch (IOException iOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                try {
                    if (this.underlyingSocket != null) {
                        this.underlyingSocket.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.attempts > 0) continue;
                this.resetInetAddress();
                String string5 = String.format("%s, socket connect lapse %d ms. %s %d %s %d", iOException.getMessage(), System.currentTimeMillis() - l2, inetAddress.toString(), this.port, string, this.count);
                IOException iOException2 = new IOException(string5, iOException);
                throw iOException2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NetException(505);
            }
        } while (this.count < this.inetAddresses.length);
    }

    @Override
    public boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.count < this.inetAddresses.length;
    }

    @Override
    public void resetInetAddress() {
        this.inetAddresses = null;
    }

    public void renegotiateSession() throws IOException {
        Object object;
        if (this.useNio) {
            this.l_sslEngine = this.newSSLEngine();
            object = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine, this.dnVerifier);
            if (this.protocol.equalsIgnoreCase("wss")) {
                this.socketChannel.setUnderlyingChannel((SocketChannel)object);
            } else {
                this.socketChannel = object;
            }
            this.socket = this.socketChannel.socket();
        } else {
            this.socketWithListener = (SSLSocket)this.socket;
            this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
        }
        object = (String)this.socketOptions.get(3);
        if (object != null) {
            this.setOption(3, object);
        }
        this.setSSLSocketOptions();
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
        SSLSocket sSLSocket = null;
        if (!this.useNio) {
            sSLSocket = (SSLSocket)this.socket;
            sSLSocket.setUseClientMode(true);
        }
        TcpsConfigure.configureVersion(sSLSocket, this.l_sslEngine, (String)this.socketOptions.get(6), this.useNio);
        TcpsConfigure.configureCipherSuites(sSLSocket, this.l_sslEngine, (String)this.socketOptions.get(7), this.useNio);
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        switch (n2) {
            case 108: {
                this.setServerDNMatchValue((String[])object);
                break;
            }
            case 107: {
                if (((String)object).equalsIgnoreCase("TRUE")) {
                    this.fullDNMatch = true;
                    break;
                }
                this.fullDNMatch = false;
                break;
            }
            default: {
                super.setOption(n2, object);
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        switch (n2) {
            case 102: {
                String string = this.getSSLSession().getCipherSuite();
                if (string != null && string.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 105: {
                return this.getSSLSession().getCipherSuite();
            }
            case 103: {
                X509Certificate x509Certificate = (X509Certificate)this.getSSLSession().getPeerCertificates()[0];
                return x509Certificate.getSubjectDN().getName();
            }
            case 104: {
                return this.getSSLSession().getPeerCertificateChain();
            }
            case 106: {
                if (this.isDnMatchingEnabled()) {
                    return "TRUE";
                }
                return "FALSE";
            }
        }
        return super.getOption(n2);
    }

    @Override
    public boolean isDnMatchingEnabled() {
        String string = (String)this.socketOptions.get(4);
        if (string == null) {
            string = System.getProperty("oracle.net.ssl_server_dn_match", (String)this.socketOptions.get(40));
        }
        return string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE");
    }

    public void setServerDNMatchValue(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string != null) {
            this.matchSSLServerCertDNWith = string;
            this.fullDNMatch = true;
        } else if (string2 != null) {
            this.matchSSLServerCertDNWith = string2.indexOf(46) != -1 ? "CN=" + string2.substring(0, string2.indexOf(46)) : "CN=" + string2.trim();
        } else if (string3 != null) {
            this.matchSSLServerCertDNWith = string3.indexOf(46) != -1 ? "CN=" + string3.substring(0, string3.indexOf(46)) : "CN=" + string3.trim();
        }
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCPS;
    }

    private SSLSession getSSLSession() {
        return this.useNio ? this.l_sslEngine.getSession() : ((SSLSocket)this.socket).getSession();
    }

    public SecurityInformation.DNMatchStatus getDNMatchStatus() {
        return ((SSLSocketChannel)this.socketChannel).getDnMatchStatus();
    }

    public void verifyDN() throws IOException {
        if (this.dnVerifier.isWeakDNMatchAllowed()) {
            ((SSLSocketChannel)this.socketChannel).verifyDN();
        }
    }

    private SSLEngine newSSLEngine() throws IOException {
        if (this.sslContext == null) {
            this.sslContext = CustomSSLSocketFactory.getSSLContext(this.socketOptions);
        }
        SSLEngine sSLEngine = this.sslContext.createSSLEngine(this.host, this.port);
        sSLEngine.setUseClientMode(true);
        return sSLEngine;
    }

    private SSLSocketFactory newSSLSocketFactory(NounIntf nounIntf) throws IOException {
        if (this.sslContext == null) {
            return CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions, nounIntf);
        }
        SSLSocketFactory sSLSocketFactory = this.sslContext.getSocketFactory();
        sSLSocketFactory = new MetricsEnabledSSLSocketFactoryWrapper(sSLSocketFactory, nounIntf);
        return sSLSocketFactory;
    }

    static {
        try {
            $$$methodRef$$$15 = TcpsNTAdapter.class.getDeclaredConstructor(String.class, Properties.class, SSLContext.class, ConnOption.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TcpsNTAdapter.class.getDeclaredMethod("newSSLSocketFactory", NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TcpsNTAdapter.class.getDeclaredMethod("newSSLEngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TcpsNTAdapter.class.getDeclaredMethod("verifyDN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpsNTAdapter.class.getDeclaredMethod("getDNMatchStatus", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpsNTAdapter.class.getDeclaredMethod("getSSLSession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpsNTAdapter.class.getDeclaredMethod("getNetworkAdapterType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpsNTAdapter.class.getDeclaredMethod("setServerDNMatchValue", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpsNTAdapter.class.getDeclaredMethod("isDnMatchingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpsNTAdapter.class.getDeclaredMethod("getOption", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpsNTAdapter.class.getDeclaredMethod("setOption", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpsNTAdapter.class.getDeclaredMethod("setSSLSocketOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpsNTAdapter.class.getDeclaredMethod("renegotiateSession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpsNTAdapter.class.getDeclaredMethod("resetInetAddress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpsNTAdapter.class.getDeclaredMethod("hasMoreInetAddresses", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpsNTAdapter.class.getDeclaredMethod("connect", NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

