/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleCachedRowSetWriter;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSet;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleSerialBlob;
import oracle.jdbc.rowset.OracleSerialClob;
import oracle.jdbc.rowset.OracleSqlForRowSet;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleCachedRowSet
extends OracleRowSet
implements RowSet,
RowSetInternal,
Serializable,
Cloneable,
CachedRowSet {
    static final long serialVersionUID = -2066958142885801470L;
    private SQLWarning sqlWarning;
    private RowSetWarning rowsetWarning;
    protected int presentRow = 0;
    private int currentPage;
    private boolean isPopulateDone;
    private boolean previousColumnWasNull = false;
    private OracleRow insertRow;
    private int insertRowPosition;
    private boolean insertRowFlag = false;
    private int updateRowPosition;
    private boolean updateRowFlag = false;
    protected ResultSetMetaData rowsetMetaData;
    private transient ResultSet resultSet;
    private transient Connection connection;
    private transient boolean isConnectionStayingOpenForTxnControl = false;
    private transient OracleSqlForRowSet osql = null;
    protected Vector rows;
    private Vector param = new Vector();
    private String[] metaData;
    protected int colCount;
    protected int rowCount;
    private RowSetReader reader;
    private RowSetWriter writer;
    private int[] keyColumns;
    private int pageSize;
    private SyncProvider syncProvider;
    private static final String DEFAULT_SYNCPROVIDER = "com.sun.rowset.providers.RIOptimisticProvider";
    private String tableName;
    private boolean executeCalled = false;
    private boolean driverManagerInitialized = false;
    private static final int MAX_CHAR_BUFFER_SIZE = 1024;
    private static final int MAX_BYTE_BUFFER_SIZE = 1024;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;
    private static Executable $$$methodRef$$$123;
    private static Logger $$$loggerRef$$$123;
    private static Executable $$$methodRef$$$124;
    private static Logger $$$loggerRef$$$124;
    private static Executable $$$methodRef$$$125;
    private static Logger $$$loggerRef$$$125;
    private static Executable $$$methodRef$$$126;
    private static Logger $$$loggerRef$$$126;
    private static Executable $$$methodRef$$$127;
    private static Logger $$$loggerRef$$$127;
    private static Executable $$$methodRef$$$128;
    private static Logger $$$loggerRef$$$128;
    private static Executable $$$methodRef$$$129;
    private static Logger $$$loggerRef$$$129;
    private static Executable $$$methodRef$$$130;
    private static Logger $$$loggerRef$$$130;
    private static Executable $$$methodRef$$$131;
    private static Logger $$$loggerRef$$$131;
    private static Executable $$$methodRef$$$132;
    private static Logger $$$loggerRef$$$132;
    private static Executable $$$methodRef$$$133;
    private static Logger $$$loggerRef$$$133;
    private static Executable $$$methodRef$$$134;
    private static Logger $$$loggerRef$$$134;
    private static Executable $$$methodRef$$$135;
    private static Logger $$$loggerRef$$$135;
    private static Executable $$$methodRef$$$136;
    private static Logger $$$loggerRef$$$136;
    private static Executable $$$methodRef$$$137;
    private static Logger $$$loggerRef$$$137;
    private static Executable $$$methodRef$$$138;
    private static Logger $$$loggerRef$$$138;
    private static Executable $$$methodRef$$$139;
    private static Logger $$$loggerRef$$$139;
    private static Executable $$$methodRef$$$140;
    private static Logger $$$loggerRef$$$140;
    private static Executable $$$methodRef$$$141;
    private static Logger $$$loggerRef$$$141;
    private static Executable $$$methodRef$$$142;
    private static Logger $$$loggerRef$$$142;
    private static Executable $$$methodRef$$$143;
    private static Logger $$$loggerRef$$$143;
    private static Executable $$$methodRef$$$144;
    private static Logger $$$loggerRef$$$144;
    private static Executable $$$methodRef$$$145;
    private static Logger $$$loggerRef$$$145;
    private static Executable $$$methodRef$$$146;
    private static Logger $$$loggerRef$$$146;
    private static Executable $$$methodRef$$$147;
    private static Logger $$$loggerRef$$$147;
    private static Executable $$$methodRef$$$148;
    private static Logger $$$loggerRef$$$148;
    private static Executable $$$methodRef$$$149;
    private static Logger $$$loggerRef$$$149;
    private static Executable $$$methodRef$$$150;
    private static Logger $$$loggerRef$$$150;
    private static Executable $$$methodRef$$$151;
    private static Logger $$$loggerRef$$$151;
    private static Executable $$$methodRef$$$152;
    private static Logger $$$loggerRef$$$152;
    private static Executable $$$methodRef$$$153;
    private static Logger $$$loggerRef$$$153;
    private static Executable $$$methodRef$$$154;
    private static Logger $$$loggerRef$$$154;
    private static Executable $$$methodRef$$$155;
    private static Logger $$$loggerRef$$$155;
    private static Executable $$$methodRef$$$156;
    private static Logger $$$loggerRef$$$156;
    private static Executable $$$methodRef$$$157;
    private static Logger $$$loggerRef$$$157;
    private static Executable $$$methodRef$$$158;
    private static Logger $$$loggerRef$$$158;
    private static Executable $$$methodRef$$$159;
    private static Logger $$$loggerRef$$$159;
    private static Executable $$$methodRef$$$160;
    private static Logger $$$loggerRef$$$160;
    private static Executable $$$methodRef$$$161;
    private static Logger $$$loggerRef$$$161;
    private static Executable $$$methodRef$$$162;
    private static Logger $$$loggerRef$$$162;
    private static Executable $$$methodRef$$$163;
    private static Logger $$$loggerRef$$$163;
    private static Executable $$$methodRef$$$164;
    private static Logger $$$loggerRef$$$164;
    private static Executable $$$methodRef$$$165;
    private static Logger $$$loggerRef$$$165;
    private static Executable $$$methodRef$$$166;
    private static Logger $$$loggerRef$$$166;
    private static Executable $$$methodRef$$$167;
    private static Logger $$$loggerRef$$$167;
    private static Executable $$$methodRef$$$168;
    private static Logger $$$loggerRef$$$168;
    private static Executable $$$methodRef$$$169;
    private static Logger $$$loggerRef$$$169;
    private static Executable $$$methodRef$$$170;
    private static Logger $$$loggerRef$$$170;
    private static Executable $$$methodRef$$$171;
    private static Logger $$$loggerRef$$$171;
    private static Executable $$$methodRef$$$172;
    private static Logger $$$loggerRef$$$172;
    private static Executable $$$methodRef$$$173;
    private static Logger $$$loggerRef$$$173;
    private static Executable $$$methodRef$$$174;
    private static Logger $$$loggerRef$$$174;
    private static Executable $$$methodRef$$$175;
    private static Logger $$$loggerRef$$$175;
    private static Executable $$$methodRef$$$176;
    private static Logger $$$loggerRef$$$176;
    private static Executable $$$methodRef$$$177;
    private static Logger $$$loggerRef$$$177;
    private static Executable $$$methodRef$$$178;
    private static Logger $$$loggerRef$$$178;
    private static Executable $$$methodRef$$$179;
    private static Logger $$$loggerRef$$$179;
    private static Executable $$$methodRef$$$180;
    private static Logger $$$loggerRef$$$180;
    private static Executable $$$methodRef$$$181;
    private static Logger $$$loggerRef$$$181;
    private static Executable $$$methodRef$$$182;
    private static Logger $$$loggerRef$$$182;
    private static Executable $$$methodRef$$$183;
    private static Logger $$$loggerRef$$$183;
    private static Executable $$$methodRef$$$184;
    private static Logger $$$loggerRef$$$184;
    private static Executable $$$methodRef$$$185;
    private static Logger $$$loggerRef$$$185;
    private static Executable $$$methodRef$$$186;
    private static Logger $$$loggerRef$$$186;
    private static Executable $$$methodRef$$$187;
    private static Logger $$$loggerRef$$$187;
    private static Executable $$$methodRef$$$188;
    private static Logger $$$loggerRef$$$188;
    private static Executable $$$methodRef$$$189;
    private static Logger $$$loggerRef$$$189;
    private static Executable $$$methodRef$$$190;
    private static Logger $$$loggerRef$$$190;
    private static Executable $$$methodRef$$$191;
    private static Logger $$$loggerRef$$$191;
    private static Executable $$$methodRef$$$192;
    private static Logger $$$loggerRef$$$192;
    private static Executable $$$methodRef$$$193;
    private static Logger $$$loggerRef$$$193;
    private static Executable $$$methodRef$$$194;
    private static Logger $$$loggerRef$$$194;
    private static Executable $$$methodRef$$$195;
    private static Logger $$$loggerRef$$$195;
    private static Executable $$$methodRef$$$196;
    private static Logger $$$loggerRef$$$196;
    private static Executable $$$methodRef$$$197;
    private static Logger $$$loggerRef$$$197;
    private static Executable $$$methodRef$$$198;
    private static Logger $$$loggerRef$$$198;
    private static Executable $$$methodRef$$$199;
    private static Logger $$$loggerRef$$$199;
    private static Executable $$$methodRef$$$200;
    private static Logger $$$loggerRef$$$200;
    private static Executable $$$methodRef$$$201;
    private static Logger $$$loggerRef$$$201;
    private static Executable $$$methodRef$$$202;
    private static Logger $$$loggerRef$$$202;
    private static Executable $$$methodRef$$$203;
    private static Logger $$$loggerRef$$$203;
    private static Executable $$$methodRef$$$204;
    private static Logger $$$loggerRef$$$204;
    private static Executable $$$methodRef$$$205;
    private static Logger $$$loggerRef$$$205;
    private static Executable $$$methodRef$$$206;
    private static Logger $$$loggerRef$$$206;
    private static Executable $$$methodRef$$$207;
    private static Logger $$$loggerRef$$$207;
    private static Executable $$$methodRef$$$208;
    private static Logger $$$loggerRef$$$208;
    private static Executable $$$methodRef$$$209;
    private static Logger $$$loggerRef$$$209;
    private static Executable $$$methodRef$$$210;
    private static Logger $$$loggerRef$$$210;
    private static Executable $$$methodRef$$$211;
    private static Logger $$$loggerRef$$$211;
    private static Executable $$$methodRef$$$212;
    private static Logger $$$loggerRef$$$212;
    private static Executable $$$methodRef$$$213;
    private static Logger $$$loggerRef$$$213;
    private static Executable $$$methodRef$$$214;
    private static Logger $$$loggerRef$$$214;
    private static Executable $$$methodRef$$$215;
    private static Logger $$$loggerRef$$$215;
    private static Executable $$$methodRef$$$216;
    private static Logger $$$loggerRef$$$216;
    private static Executable $$$methodRef$$$217;
    private static Logger $$$loggerRef$$$217;
    private static Executable $$$methodRef$$$218;
    private static Logger $$$loggerRef$$$218;
    private static Executable $$$methodRef$$$219;
    private static Logger $$$loggerRef$$$219;
    private static Executable $$$methodRef$$$220;
    private static Logger $$$loggerRef$$$220;
    private static Executable $$$methodRef$$$221;
    private static Logger $$$loggerRef$$$221;
    private static Executable $$$methodRef$$$222;
    private static Logger $$$loggerRef$$$222;
    private static Executable $$$methodRef$$$223;
    private static Logger $$$loggerRef$$$223;
    private static Executable $$$methodRef$$$224;
    private static Logger $$$loggerRef$$$224;
    private static Executable $$$methodRef$$$225;
    private static Logger $$$loggerRef$$$225;
    private static Executable $$$methodRef$$$226;
    private static Logger $$$loggerRef$$$226;
    private static Executable $$$methodRef$$$227;
    private static Logger $$$loggerRef$$$227;
    private static Executable $$$methodRef$$$228;
    private static Logger $$$loggerRef$$$228;
    private static Executable $$$methodRef$$$229;
    private static Logger $$$loggerRef$$$229;
    private static Executable $$$methodRef$$$230;
    private static Logger $$$loggerRef$$$230;
    private static Executable $$$methodRef$$$231;
    private static Logger $$$loggerRef$$$231;
    private static Executable $$$methodRef$$$232;
    private static Logger $$$loggerRef$$$232;
    private static Executable $$$methodRef$$$233;
    private static Logger $$$loggerRef$$$233;
    private static Executable $$$methodRef$$$234;
    private static Logger $$$loggerRef$$$234;
    private static Executable $$$methodRef$$$235;
    private static Logger $$$loggerRef$$$235;
    private static Executable $$$methodRef$$$236;
    private static Logger $$$loggerRef$$$236;
    private static Executable $$$methodRef$$$237;
    private static Logger $$$loggerRef$$$237;
    private static Executable $$$methodRef$$$238;
    private static Logger $$$loggerRef$$$238;
    private static Executable $$$methodRef$$$239;
    private static Logger $$$loggerRef$$$239;
    private static Executable $$$methodRef$$$240;
    private static Logger $$$loggerRef$$$240;
    private static Executable $$$methodRef$$$241;
    private static Logger $$$loggerRef$$$241;
    private static Executable $$$methodRef$$$242;
    private static Logger $$$loggerRef$$$242;
    private static Executable $$$methodRef$$$243;
    private static Logger $$$loggerRef$$$243;
    private static Executable $$$methodRef$$$244;
    private static Logger $$$loggerRef$$$244;
    private static Executable $$$methodRef$$$245;
    private static Logger $$$loggerRef$$$245;
    private static Executable $$$methodRef$$$246;
    private static Logger $$$loggerRef$$$246;
    private static Executable $$$methodRef$$$247;
    private static Logger $$$loggerRef$$$247;
    private static Executable $$$methodRef$$$248;
    private static Logger $$$loggerRef$$$248;
    private static Executable $$$methodRef$$$249;
    private static Logger $$$loggerRef$$$249;
    private static Executable $$$methodRef$$$250;
    private static Logger $$$loggerRef$$$250;
    private static Executable $$$methodRef$$$251;
    private static Logger $$$loggerRef$$$251;
    private static Executable $$$methodRef$$$252;
    private static Logger $$$loggerRef$$$252;
    private static Executable $$$methodRef$$$253;
    private static Logger $$$loggerRef$$$253;
    private static Executable $$$methodRef$$$254;
    private static Logger $$$loggerRef$$$254;
    private static Executable $$$methodRef$$$255;
    private static Logger $$$loggerRef$$$255;
    private static Executable $$$methodRef$$$256;
    private static Logger $$$loggerRef$$$256;
    private static Executable $$$methodRef$$$257;
    private static Logger $$$loggerRef$$$257;
    private static Executable $$$methodRef$$$258;
    private static Logger $$$loggerRef$$$258;
    private static Executable $$$methodRef$$$259;
    private static Logger $$$loggerRef$$$259;
    private static Executable $$$methodRef$$$260;
    private static Logger $$$loggerRef$$$260;
    private static Executable $$$methodRef$$$261;
    private static Logger $$$loggerRef$$$261;
    private static Executable $$$methodRef$$$262;
    private static Logger $$$loggerRef$$$262;
    private static Executable $$$methodRef$$$263;
    private static Logger $$$loggerRef$$$263;
    private static Executable $$$methodRef$$$264;
    private static Logger $$$loggerRef$$$264;
    private static Executable $$$methodRef$$$265;
    private static Logger $$$loggerRef$$$265;
    private static Executable $$$methodRef$$$266;
    private static Logger $$$loggerRef$$$266;
    private static Executable $$$methodRef$$$267;
    private static Logger $$$loggerRef$$$267;
    private static Executable $$$methodRef$$$268;
    private static Logger $$$loggerRef$$$268;
    private static Executable $$$methodRef$$$269;
    private static Logger $$$loggerRef$$$269;
    private static Executable $$$methodRef$$$270;
    private static Logger $$$loggerRef$$$270;
    private static Executable $$$methodRef$$$271;
    private static Logger $$$loggerRef$$$271;
    private static Executable $$$methodRef$$$272;
    private static Logger $$$loggerRef$$$272;
    private static Executable $$$methodRef$$$273;
    private static Logger $$$loggerRef$$$273;
    private static Executable $$$methodRef$$$274;
    private static Logger $$$loggerRef$$$274;
    private static Executable $$$methodRef$$$275;
    private static Logger $$$loggerRef$$$275;
    private static Executable $$$methodRef$$$276;
    private static Logger $$$loggerRef$$$276;
    private static Executable $$$methodRef$$$277;
    private static Logger $$$loggerRef$$$277;
    private static Executable $$$methodRef$$$278;
    private static Logger $$$loggerRef$$$278;
    private static Executable $$$methodRef$$$279;
    private static Logger $$$loggerRef$$$279;
    private static Executable $$$methodRef$$$280;
    private static Logger $$$loggerRef$$$280;
    private static Executable $$$methodRef$$$281;
    private static Logger $$$loggerRef$$$281;
    private static Executable $$$methodRef$$$282;
    private static Logger $$$loggerRef$$$282;
    private static Executable $$$methodRef$$$283;
    private static Logger $$$loggerRef$$$283;
    private static Executable $$$methodRef$$$284;
    private static Logger $$$loggerRef$$$284;
    private static Executable $$$methodRef$$$285;
    private static Logger $$$loggerRef$$$285;
    private static Executable $$$methodRef$$$286;
    private static Logger $$$loggerRef$$$286;
    private static Executable $$$methodRef$$$287;
    private static Logger $$$loggerRef$$$287;
    private static Executable $$$methodRef$$$288;
    private static Logger $$$loggerRef$$$288;
    private static Executable $$$methodRef$$$289;
    private static Logger $$$loggerRef$$$289;
    private static Executable $$$methodRef$$$290;
    private static Logger $$$loggerRef$$$290;
    private static Executable $$$methodRef$$$291;
    private static Logger $$$loggerRef$$$291;
    private static Executable $$$methodRef$$$292;
    private static Logger $$$loggerRef$$$292;
    private static Executable $$$methodRef$$$293;
    private static Logger $$$loggerRef$$$293;
    private static Executable $$$methodRef$$$294;
    private static Logger $$$loggerRef$$$294;
    private static Executable $$$methodRef$$$295;
    private static Logger $$$loggerRef$$$295;
    private static Executable $$$methodRef$$$296;
    private static Logger $$$loggerRef$$$296;
    private static Executable $$$methodRef$$$297;
    private static Logger $$$loggerRef$$$297;
    private static Executable $$$methodRef$$$298;
    private static Logger $$$loggerRef$$$298;
    private static Executable $$$methodRef$$$299;
    private static Logger $$$loggerRef$$$299;
    private static Executable $$$methodRef$$$300;
    private static Logger $$$loggerRef$$$300;
    private static Executable $$$methodRef$$$301;
    private static Logger $$$loggerRef$$$301;
    private static Executable $$$methodRef$$$302;
    private static Logger $$$loggerRef$$$302;
    private static Executable $$$methodRef$$$303;
    private static Logger $$$loggerRef$$$303;
    private static Executable $$$methodRef$$$304;
    private static Logger $$$loggerRef$$$304;
    private static Executable $$$methodRef$$$305;
    private static Logger $$$loggerRef$$$305;
    private static Executable $$$methodRef$$$306;
    private static Logger $$$loggerRef$$$306;
    private static Executable $$$methodRef$$$307;
    private static Logger $$$loggerRef$$$307;
    private static Executable $$$methodRef$$$308;
    private static Logger $$$loggerRef$$$308;
    private static Executable $$$methodRef$$$309;
    private static Logger $$$loggerRef$$$309;
    private static Executable $$$methodRef$$$310;
    private static Logger $$$loggerRef$$$310;
    private static Executable $$$methodRef$$$311;
    private static Logger $$$loggerRef$$$311;
    private static Executable $$$methodRef$$$312;
    private static Logger $$$loggerRef$$$312;
    private static Executable $$$methodRef$$$313;
    private static Logger $$$loggerRef$$$313;
    private static Executable $$$methodRef$$$314;
    private static Logger $$$loggerRef$$$314;
    private static Executable $$$methodRef$$$315;
    private static Logger $$$loggerRef$$$315;
    private static Executable $$$methodRef$$$316;
    private static Logger $$$loggerRef$$$316;
    private static Executable $$$methodRef$$$317;
    private static Logger $$$loggerRef$$$317;
    private static Executable $$$methodRef$$$318;
    private static Logger $$$loggerRef$$$318;
    private static Executable $$$methodRef$$$319;
    private static Logger $$$loggerRef$$$319;
    private static Executable $$$methodRef$$$320;
    private static Logger $$$loggerRef$$$320;
    private static Executable $$$methodRef$$$321;
    private static Logger $$$loggerRef$$$321;
    private static Executable $$$methodRef$$$322;
    private static Logger $$$loggerRef$$$322;
    private static Executable $$$methodRef$$$323;
    private static Logger $$$loggerRef$$$323;
    private static Executable $$$methodRef$$$324;
    private static Logger $$$loggerRef$$$324;
    private static Executable $$$methodRef$$$325;
    private static Logger $$$loggerRef$$$325;
    private static Executable $$$methodRef$$$326;
    private static Logger $$$loggerRef$$$326;
    private static Executable $$$methodRef$$$327;
    private static Logger $$$loggerRef$$$327;
    private static Executable $$$methodRef$$$328;
    private static Logger $$$loggerRef$$$328;
    private static Executable $$$methodRef$$$329;
    private static Logger $$$loggerRef$$$329;
    private static Executable $$$methodRef$$$330;
    private static Logger $$$loggerRef$$$330;
    private static Executable $$$methodRef$$$331;
    private static Logger $$$loggerRef$$$331;
    private static Executable $$$methodRef$$$332;
    private static Logger $$$loggerRef$$$332;
    private static Executable $$$methodRef$$$333;
    private static Logger $$$loggerRef$$$333;
    private static Executable $$$methodRef$$$334;
    private static Logger $$$loggerRef$$$334;
    private static Executable $$$methodRef$$$335;
    private static Logger $$$loggerRef$$$335;
    private static Executable $$$methodRef$$$336;
    private static Logger $$$loggerRef$$$336;
    private static Executable $$$methodRef$$$337;
    private static Logger $$$loggerRef$$$337;
    private static Executable $$$methodRef$$$338;
    private static Logger $$$loggerRef$$$338;
    private static Executable $$$methodRef$$$339;
    private static Logger $$$loggerRef$$$339;
    private static Executable $$$methodRef$$$340;
    private static Logger $$$loggerRef$$$340;
    private static Executable $$$methodRef$$$341;
    private static Logger $$$loggerRef$$$341;
    private static Executable $$$methodRef$$$342;
    private static Logger $$$loggerRef$$$342;
    private static Executable $$$methodRef$$$343;
    private static Logger $$$loggerRef$$$343;
    private static Executable $$$methodRef$$$344;
    private static Logger $$$loggerRef$$$344;
    private static Executable $$$methodRef$$$345;
    private static Logger $$$loggerRef$$$345;
    private static Executable $$$methodRef$$$346;
    private static Logger $$$loggerRef$$$346;
    private static Executable $$$methodRef$$$347;
    private static Logger $$$loggerRef$$$347;
    private static Executable $$$methodRef$$$348;
    private static Logger $$$loggerRef$$$348;
    private static Executable $$$methodRef$$$349;
    private static Logger $$$loggerRef$$$349;
    private static Executable $$$methodRef$$$350;
    private static Logger $$$loggerRef$$$350;
    private static Executable $$$methodRef$$$351;
    private static Logger $$$loggerRef$$$351;
    private static Executable $$$methodRef$$$352;
    private static Logger $$$loggerRef$$$352;
    private static Executable $$$methodRef$$$353;
    private static Logger $$$loggerRef$$$353;
    private static Executable $$$methodRef$$$354;
    private static Logger $$$loggerRef$$$354;
    private static Executable $$$methodRef$$$355;
    private static Logger $$$loggerRef$$$355;
    private static Executable $$$methodRef$$$356;
    private static Logger $$$loggerRef$$$356;
    private static Executable $$$methodRef$$$357;
    private static Logger $$$loggerRef$$$357;
    private static Executable $$$methodRef$$$358;
    private static Logger $$$loggerRef$$$358;
    private static Executable $$$methodRef$$$359;
    private static Logger $$$loggerRef$$$359;
    private static Executable $$$methodRef$$$360;
    private static Logger $$$loggerRef$$$360;
    private static Executable $$$methodRef$$$361;
    private static Logger $$$loggerRef$$$361;
    private static Executable $$$methodRef$$$362;
    private static Logger $$$loggerRef$$$362;
    private static Executable $$$methodRef$$$363;
    private static Logger $$$loggerRef$$$363;
    private static Executable $$$methodRef$$$364;
    private static Logger $$$loggerRef$$$364;
    private static Executable $$$methodRef$$$365;
    private static Logger $$$loggerRef$$$365;
    private static Executable $$$methodRef$$$366;
    private static Logger $$$loggerRef$$$366;
    private static Executable $$$methodRef$$$367;
    private static Logger $$$loggerRef$$$367;
    private static Executable $$$methodRef$$$368;
    private static Logger $$$loggerRef$$$368;
    private static Executable $$$methodRef$$$369;
    private static Logger $$$loggerRef$$$369;
    private static Executable $$$methodRef$$$370;
    private static Logger $$$loggerRef$$$370;
    private static Executable $$$methodRef$$$371;
    private static Logger $$$loggerRef$$$371;
    private static Executable $$$methodRef$$$372;
    private static Logger $$$loggerRef$$$372;
    private static Executable $$$methodRef$$$373;
    private static Logger $$$loggerRef$$$373;
    private static Executable $$$methodRef$$$374;
    private static Logger $$$loggerRef$$$374;
    private static Executable $$$methodRef$$$375;
    private static Logger $$$loggerRef$$$375;
    private static Executable $$$methodRef$$$376;
    private static Logger $$$loggerRef$$$376;
    private static Executable $$$methodRef$$$377;
    private static Logger $$$loggerRef$$$377;
    private static Executable $$$methodRef$$$378;
    private static Logger $$$loggerRef$$$378;
    private static Executable $$$methodRef$$$379;
    private static Logger $$$loggerRef$$$379;
    private static Executable $$$methodRef$$$380;
    private static Logger $$$loggerRef$$$380;
    private static Executable $$$methodRef$$$381;
    private static Logger $$$loggerRef$$$381;
    private static Executable $$$methodRef$$$382;
    private static Logger $$$loggerRef$$$382;
    private static Executable $$$methodRef$$$383;
    private static Logger $$$loggerRef$$$383;
    private static Executable $$$methodRef$$$384;
    private static Logger $$$loggerRef$$$384;
    private static Executable $$$methodRef$$$385;
    private static Logger $$$loggerRef$$$385;
    private static Executable $$$methodRef$$$386;
    private static Logger $$$loggerRef$$$386;
    private static Executable $$$methodRef$$$387;
    private static Logger $$$loggerRef$$$387;
    private static Executable $$$methodRef$$$388;
    private static Logger $$$loggerRef$$$388;
    private static Executable $$$methodRef$$$389;
    private static Logger $$$loggerRef$$$389;
    private static Executable $$$methodRef$$$390;
    private static Logger $$$loggerRef$$$390;
    private static Executable $$$methodRef$$$391;
    private static Logger $$$loggerRef$$$391;
    private static Executable $$$methodRef$$$392;
    private static Logger $$$loggerRef$$$392;
    private static Executable $$$methodRef$$$393;
    private static Logger $$$loggerRef$$$393;
    private static Executable $$$methodRef$$$394;
    private static Logger $$$loggerRef$$$394;
    private static Executable $$$methodRef$$$395;
    private static Logger $$$loggerRef$$$395;
    private static Executable $$$methodRef$$$396;
    private static Logger $$$loggerRef$$$396;
    private static Executable $$$methodRef$$$397;
    private static Logger $$$loggerRef$$$397;
    private static Executable $$$methodRef$$$398;
    private static Logger $$$loggerRef$$$398;
    private static Executable $$$methodRef$$$399;
    private static Logger $$$loggerRef$$$399;
    private static Executable $$$methodRef$$$400;
    private static Logger $$$loggerRef$$$400;
    private static Executable $$$methodRef$$$401;
    private static Logger $$$loggerRef$$$401;
    private static Executable $$$methodRef$$$402;
    private static Logger $$$loggerRef$$$402;
    private static Executable $$$methodRef$$$403;
    private static Logger $$$loggerRef$$$403;

    public OracleCachedRowSet() throws SQLException {
        this.rows = new Vector();
        this.sqlWarning = new SQLWarning();
        try {
            this.syncProvider = SyncFactory.getInstance(DEFAULT_SYNCPROVIDER);
        }
        catch (SyncFactoryException syncFactoryException) {
            throw (SQLException)DatabaseError.createSqlException(304).fillInStackTrace();
        }
        this.setReader(new OracleCachedRowSetReader());
        this.setWriter(new OracleCachedRowSetWriter());
        this.currentPage = 0;
        this.pageSize = 0;
        this.isPopulateDone = false;
        this.keyColumns = null;
        this.tableName = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionInternal();
    }

    Connection getConnectionInternal() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            String string = this.getUsername();
            String string2 = this.getPassword();
            if (this.getDataSourceName() != null) {
                try {
                    Object object;
                    InitialContext initialContext = null;
                    try {
                        object = System.getProperties();
                        initialContext = new InitialContext((Hashtable<?, ?>)object);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (initialContext == null) {
                        initialContext = new InitialContext();
                    }
                    object = (DataSource)initialContext.lookup(this.getDataSourceName());
                    if (this.username == null || string2 == null) {
                        this.connection = object.getConnection();
                    }
                    this.connection = object.getConnection(this.username, string2);
                }
                catch (NamingException namingException) {
                    throw (SQLException)DatabaseError.createSqlException(300, namingException.getMessage()).fillInStackTrace();
                }
            } else if (this.getUrl() != null) {
                if (!this.driverManagerInitialized) {
                    DriverManager.registerDriver(new OracleDriver());
                    this.driverManagerInitialized = true;
                }
                String string3 = this.getUrl();
                if (string3.equals("") || string == null || string.equals("") || string2 == null || string2.equals("")) {
                    throw (SQLException)DatabaseError.createSqlException(301).fillInStackTrace();
                }
                this.connection = DriverManager.getConnection(string3, string, string2);
            } else {
                throw (SQLException)DatabaseError.createSqlException(301).fillInStackTrace();
            }
        }
        return this.connection;
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.resultSet == null) {
            throw (SQLException)DatabaseError.createSqlException(305).fillInStackTrace();
        }
        return this.resultSet.getStatement();
    }

    public RowSetReader getReader() {
        return this.reader;
    }

    public RowSetWriter getWriter() {
        return this.writer;
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        if (this.rowsetType == 1005) {
            throw (SQLException)DatabaseError.createSqlException(306).fillInStackTrace();
        }
        switch (n2) {
            case 1000: 
            case 1002: {
                this.presentRow = 0;
                break;
            }
            case 1001: {
                if (this.rowsetType == 1003) {
                    throw (SQLException)DatabaseError.createSqlException(307).fillInStackTrace();
                }
                this.presentRow = this.rowCount + 1;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(308).fillInStackTrace();
            }
        }
        super.setFetchDirection(n2);
    }

    @Override
    public void setCommand(String string) throws SQLException {
        super.setCommand(string);
        this.osql = string == null || string.equals("") ? null : new OracleSqlForRowSet(string);
    }

    public void setReader(RowSetReader rowSetReader) {
        this.reader = rowSetReader;
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.writer = rowSetWriter;
    }

    private final int getColumnIndex(String string) throws SQLException {
        int n2;
        if (string == null || string.equals("")) {
            throw (SQLException)DatabaseError.createSqlException(6, string).fillInStackTrace();
        }
        string = string.toUpperCase();
        for (n2 = 0; n2 < this.metaData.length && !string.equals(this.metaData[n2]); ++n2) {
        }
        if (n2 >= this.metaData.length) {
            throw (SQLException)DatabaseError.createSqlException(6, string).fillInStackTrace();
        }
        return n2 + 1;
    }

    private final void checkColumnIndex(int n2) throws SQLException {
        if (this.readOnly) {
            throw (SQLException)DatabaseError.createSqlException(309).fillInStackTrace();
        }
        if (n2 < 1 || n2 > this.colCount) {
            throw (SQLException)DatabaseError.createSqlException(3, "" + n2).fillInStackTrace();
        }
    }

    private final boolean isUpdated(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            throw (SQLException)DatabaseError.createSqlException(3, "" + n2).fillInStackTrace();
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    private final void checkParamIndex(int n2) throws SQLException {
        if (n2 < 1) {
            throw (SQLException)DatabaseError.createSqlException(310, "" + n2).fillInStackTrace();
        }
    }

    private final void populateInit(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        Statement statement = resultSet.getStatement();
        this.maxFieldSize = statement.getMaxFieldSize();
        this.fetchSize = statement.getFetchSize();
        this.queryTimeout = statement.getQueryTimeout();
        this.connection = statement.getConnection();
        this.transactionIsolation = this.connection.getTransactionIsolation();
        this.typeMap = this.connection.getTypeMap();
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        this.url = databaseMetaData.getURL();
        this.username = databaseMetaData.getUserName();
        this.presentRow = 0;
    }

    private synchronized InputStream getStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof InputStream) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new ByteArrayInputStream(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            return ((OracleSerialClob)object).getAsciiStream();
        }
        if (object instanceof OracleSerialBlob) {
            return ((OracleSerialBlob)object).getBinaryStream();
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = null;
            PipedOutputStream pipedOutputStream = null;
            try {
                bufferedReader = new BufferedReader((Reader)object);
                int n3 = 0;
                PipedInputStream pipedInputStream = new PipedInputStream();
                pipedOutputStream = new PipedOutputStream(pipedInputStream);
                while ((n3 = ((Reader)bufferedReader).read()) != -1) {
                    pipedOutputStream.write(n3);
                }
                PipedInputStream pipedInputStream2 = pipedInputStream;
                return pipedInputStream2;
            }
            catch (IOException iOException) {
                throw (SQLException)DatabaseError.createSqlException(null, 311, iOException.getMessage()).fillInStackTrace();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        ((Reader)bufferedReader).close();
                    }
                }
                catch (IOException iOException) {
                    throw (SQLException)DatabaseError.createSqlException(null, 311, iOException.getMessage()).fillInStackTrace();
                }
                try {
                    if (pipedOutputStream != null) {
                        pipedOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    throw (SQLException)DatabaseError.createSqlException(null, 311, iOException.getMessage()).fillInStackTrace();
                }
            }
        }
        throw (SQLException)DatabaseError.createSqlException(312).fillInStackTrace();
    }

    private final Calendar getSessionCalendar(Connection connection) {
        Calendar calendar;
        String string = ((OracleConnection)connection).getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setID(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    private boolean isStreamType(int n2) {
        return n2 == 2004 || n2 == 2005 || n2 == 2011 || n2 == -4 || n2 == -16 || n2 == -1;
    }

    @Override
    protected synchronized void notifyCursorMoved() {
        if (this.insertRowFlag) {
            this.insertRowFlag = false;
            this.insertRow.setRowUpdated(false);
            this.sqlWarning.setNextWarning(new SQLWarning("Cancelling insertion, due to cursor movement."));
        } else if (this.updateRowFlag) {
            try {
                this.updateRowFlag = false;
                int n2 = this.presentRow;
                this.presentRow = this.updateRowPosition;
                this.getCurrentRow().setRowUpdated(false);
                this.presentRow = n2;
                this.sqlWarning.setNextWarning(new SQLWarning("Cancelling all updates, due to cursor movement."));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        super.notifyCursorMoved();
    }

    protected void checkAndFilterObject(int n2, Object object) throws SQLException {
    }

    OracleRow getCurrentRow() throws SQLException {
        int n2 = this.presentRow - 1;
        if (this.presentRow < 1 || this.presentRow > this.rowCount) {
            throw (SQLException)DatabaseError.createSqlException(313).fillInStackTrace();
        }
        return (OracleRow)this.rows.elementAt(this.presentRow - 1);
    }

    boolean isExecuteCalled() {
        return this.executeCalled;
    }

    int getCurrentPage() {
        return this.currentPage;
    }

    boolean isConnectionStayingOpen() {
        return this.isConnectionStayingOpenForTxnControl;
    }

    void setOriginal() throws SQLException {
        int n2 = 1;
        do {
            boolean bl;
            if (bl = this.setOriginalRowInternal(n2)) continue;
            ++n2;
        } while (n2 <= this.rowCount);
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    boolean setOriginalRowInternal(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.rowCount) {
            throw (SQLException)DatabaseError.createSqlException(313).fillInStackTrace();
        }
        boolean bl = false;
        OracleRow oracleRow = (OracleRow)this.rows.elementAt(n2 - 1);
        if (oracleRow.isRowDeleted()) {
            this.rows.remove(n2 - 1);
            --this.rowCount;
            bl = true;
        } else {
            if (oracleRow.isRowInserted()) {
                oracleRow.setInsertedFlag(false);
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.makeUpdatesOriginal();
            }
        }
        return bl;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.next();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.rowCount < 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            if (this.presentRow + 1 <= this.rowCount) {
                ++this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = this.rowCount + 1;
            return false;
        }
        if (this.fetchDirection == 1000 || this.fetchDirection == 1002) {
            if (this.presentRow - 1 > 0) {
                --this.presentRow;
                if (!this.showDeleted && this.getCurrentRow().isRowDeleted()) {
                    return this.previous();
                }
                this.notifyCursorMoved();
                return true;
            }
            this.presentRow = 0;
            return false;
        }
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        return this.rowCount > 0 && this.presentRow == 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        return this.rowCount > 0 && this.presentRow == this.rowCount + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        return this.presentRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        return this.presentRow == this.rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        this.presentRow = 0;
    }

    @Override
    public void afterLast() throws SQLException {
        this.presentRow = this.rowCount + 1;
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        if (this.rowsetType == 1003) {
            throw (SQLException)DatabaseError.createSqlException(314).fillInStackTrace();
        }
        if (n2 == 0 || Math.abs(n2) > this.rowCount) {
            return false;
        }
        this.presentRow = n2 < 0 ? this.rowCount + n2 + 1 : n2;
        this.notifyCursorMoved();
        return true;
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        return this.absolute(this.presentRow + n2);
    }

    @Override
    public synchronized void populate(ResultSet resultSet) throws SQLException {
        int n2;
        if (this.rows == null) {
            this.rows = new Vector(50, 10);
        } else {
            this.rows.clear();
        }
        this.rowsetMetaData = new OracleRowSetMetaData(resultSet.getMetaData());
        this.colCount = this.rowsetMetaData.getColumnCount();
        this.metaData = new String[this.colCount];
        for (n2 = 0; n2 < this.colCount; ++n2) {
            this.metaData[n2] = this.rowsetMetaData.getColumnName(n2 + 1);
        }
        if (!(resultSet instanceof OracleCachedRowSet)) {
            this.populateInit(resultSet);
        }
        n2 = this.fetchDirection == 1000 || this.fetchDirection == 1002 ? 1 : 0;
        this.rowCount = 0;
        OracleRow oracleRow = null;
        int n3 = this.maxRows == 0 && this.pageSize == 0 ? Integer.MAX_VALUE : (this.maxRows == 0 || this.pageSize == 0 ? Math.max(this.maxRows, this.pageSize) : Math.min(this.maxRows, this.pageSize));
        if (resultSet.getType() != 1003 && this.rows.size() == 0 && n2 == 0) {
            resultSet.afterLast();
        }
        boolean bl = false;
        while (this.rowCount < n3) {
            if (n2 != 0) {
                if (!resultSet.next()) {
                    bl = true;
                    break;
                }
            } else if (!resultSet.previous()) {
                bl = true;
                break;
            }
            oracleRow = new OracleRow(this.colCount);
            for (int i2 = 1; i2 <= this.colCount; ++i2) {
                Object object = null;
                try {
                    object = resultSet.getObject(i2, this.typeMap);
                }
                catch (Exception exception) {
                    object = resultSet.getObject(i2);
                }
                catch (AbstractMethodError abstractMethodError) {
                    object = resultSet.getObject(i2);
                }
                if (object instanceof Clob || object instanceof CLOB) {
                    oracleRow.setColumnValue(i2, new OracleSerialClob((Clob)object));
                } else if (object instanceof Blob || object instanceof BLOB) {
                    oracleRow.setColumnValue(i2, new OracleSerialBlob((Blob)object));
                } else {
                    oracleRow.setColumnValue(i2, object);
                }
                oracleRow.markOriginalNull(i2, resultSet.wasNull());
            }
            if (n2 != 0) {
                this.rows.add(oracleRow);
            } else {
                this.rows.add(1, oracleRow);
            }
            ++this.rowCount;
        }
        if (bl || n2 != 0 && resultSet.isAfterLast() || n2 == 0 && resultSet.isBeforeFirst()) {
            this.isPopulateDone = true;
        }
        this.connection = null;
        this.notifyRowSetChanged();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(23).fillInStackTrace();
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.param = null;
        this.param = new Vector();
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.isClosed) {
            throw (SQLException)DatabaseError.createSqlException(10).fillInStackTrace();
        }
        return this.previousColumnWasNull;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.release();
            this.isClosed = true;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rowsetMetaData;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        return this.getColumnIndex(string);
    }

    @Override
    public Object[] getParams() throws SQLException {
        return this.param.toArray();
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.rowsetMetaData = rowSetMetaData;
        if (rowSetMetaData != null) {
            this.colCount = rowSetMetaData.getColumnCount();
        }
    }

    @Override
    public synchronized void execute() throws SQLException {
        this.isConnectionStayingOpenForTxnControl = false;
        this.getReader().readData(this);
        this.executeCalled = true;
        this.isClosed = false;
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        try {
            this.getWriter().writeData(this);
        }
        catch (SQLException sQLException) {
            SyncProviderException syncProviderException = new SyncProviderException(sQLException.getMessage());
            syncProviderException.initCause(sQLException);
            throw syncProviderException;
        }
    }

    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        this.connection = connection;
        this.isConnectionStayingOpenForTxnControl = true;
        this.acceptChanges();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("SQL Error occured while cloning: " + sQLException.getMessage());
        }
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createShared();
        int n2 = this.rows.size();
        oracleCachedRowSet.rows = new Vector(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            oracleCachedRowSet.rows.add(((OracleRow)this.rows.elementAt(i2)).createCopy());
        }
        return oracleCachedRowSet;
    }

    @Override
    public RowSet createShared() throws SQLException {
        int n2;
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rows = this.rows;
        oracleCachedRowSet.setDataSource(this.getDataSource());
        oracleCachedRowSet.setDataSourceName(this.getDataSourceName());
        oracleCachedRowSet.setUsername(this.getUsername());
        oracleCachedRowSet.setPassword(this.getPassword());
        oracleCachedRowSet.setUrl(this.getUrl());
        oracleCachedRowSet.setTypeMap(this.getTypeMap());
        oracleCachedRowSet.setMaxFieldSize(this.getMaxFieldSize());
        oracleCachedRowSet.setMaxRows(this.getMaxRows());
        oracleCachedRowSet.setQueryTimeout(this.getQueryTimeout());
        oracleCachedRowSet.setFetchSize(this.getFetchSize());
        oracleCachedRowSet.setEscapeProcessing(this.getEscapeProcessing());
        oracleCachedRowSet.setConcurrency(this.getConcurrency());
        oracleCachedRowSet.setReadOnly(this.readOnly);
        this.rowsetType = this.getType();
        this.fetchDirection = this.getFetchDirection();
        oracleCachedRowSet.setCommand(this.getCommand());
        oracleCachedRowSet.setTransactionIsolation(this.getTransactionIsolation());
        oracleCachedRowSet.presentRow = this.presentRow;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.showDeleted = this.showDeleted;
        oracleCachedRowSet.syncProvider = this.syncProvider;
        oracleCachedRowSet.currentPage = this.currentPage;
        oracleCachedRowSet.pageSize = this.pageSize;
        oracleCachedRowSet.tableName = this.tableName == null ? null : this.tableName;
        oracleCachedRowSet.keyColumns = this.keyColumns == null ? null : (int[])this.keyColumns.clone();
        int n3 = this.listener.size();
        for (n2 = 0; n2 < n3; ++n2) {
            oracleCachedRowSet.listener.add(this.listener.elementAt(n2));
        }
        oracleCachedRowSet.rowsetMetaData = new OracleRowSetMetaData(this.rowsetMetaData);
        n3 = this.param.size();
        for (n2 = 0; n2 < n3; ++n2) {
            oracleCachedRowSet.param.add(this.param.elementAt(n2));
        }
        oracleCachedRowSet.metaData = new String[this.metaData.length];
        System.arraycopy(this.metaData, 0, oracleCachedRowSet.metaData, 0, this.metaData.length);
        return oracleCachedRowSet;
    }

    @Override
    public void release() throws SQLException {
        this.rows = null;
        this.rows = new Vector();
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.rowCount = 0;
        this.presentRow = 0;
        this.notifyRowSetChanged();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        boolean bl = false;
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
            if (oracleRow.isRowInserted()) {
                this.rows.remove(i2);
                --this.rowCount;
                --i2;
                bl = true;
                continue;
            }
            if (oracleRow.isRowUpdated()) {
                oracleRow.setRowUpdated(false);
                bl = true;
                continue;
            }
            if (!oracleRow.isRowDeleted()) continue;
            oracleRow.setRowDeleted(false);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(315).fillInStackTrace();
        }
        this.notifyRowSetChanged();
        this.presentRow = 0;
    }

    public Collection toCollection() throws SQLException {
        Map<Integer, Collection> map = Collections.synchronizedMap(new TreeMap());
        try {
            for (int i2 = 0; i2 < this.rowCount; ++i2) {
                map.put(i2, ((OracleRow)this.rows.elementAt(i2)).toCollection());
            }
        }
        catch (Exception exception) {
            map = null;
            throw (SQLException)DatabaseError.createSqlException(316).fillInStackTrace();
        }
        return map.values();
    }

    public Collection toCollection(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.colCount) {
            throw (SQLException)DatabaseError.createSqlException(null, 3, "" + n2).fillInStackTrace();
        }
        Vector<Object> vector = new Vector<Object>(this.rowCount);
        for (int i2 = 0; i2 < this.rowCount; ++i2) {
            OracleRow oracleRow = (OracleRow)this.rows.elementAt(i2);
            Object object = oracleRow.isColumnChanged(n2) ? oracleRow.getModifiedColumn(n2) : oracleRow.getColumn(n2);
            vector.add(object);
        }
        return vector;
    }

    public Collection toCollection(String string) throws SQLException {
        return this.toCollection(this.getColumnIndex(string));
    }

    @Override
    public int getRow() throws SQLException {
        if (this.presentRow > this.rowCount) {
            return this.rowCount;
        }
        return this.presentRow;
    }

    public void cancelRowInsert() throws SQLException {
        if (this.getCurrentRow().isRowInserted()) {
            this.rows.remove(--this.presentRow);
            --this.rowCount;
        } else {
            throw (SQLException)DatabaseError.createSqlException(317).fillInStackTrace();
        }
        this.notifyRowChanged();
    }

    public void cancelRowDelete() throws SQLException {
        if (!this.getCurrentRow().isRowDeleted()) {
            throw (SQLException)DatabaseError.createSqlException(318).fillInStackTrace();
        }
        this.getCurrentRow().setRowDeleted(false);
        this.notifyRowChanged();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (!this.getCurrentRow().isRowUpdated()) {
            throw (SQLException)DatabaseError.createSqlException(319).fillInStackTrace();
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(false);
        this.notifyRowChanged();
    }

    @Override
    public void insertRow() throws SQLException {
        if (this.isReadOnly()) {
            throw (SQLException)DatabaseError.createSqlException(309).fillInStackTrace();
        }
        if (!this.insertRowFlag) {
            throw (SQLException)DatabaseError.createSqlException(317).fillInStackTrace();
        }
        if (!this.insertRow.isRowFullyPopulated()) {
            throw (SQLException)DatabaseError.createSqlException(320).fillInStackTrace();
        }
        this.insertRow.insertRow();
        this.rows.insertElementAt(this.insertRow, this.insertRowPosition - 1);
        this.insertRowFlag = false;
        ++this.rowCount;
        this.notifyRowChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.isReadOnly()) {
            throw (SQLException)DatabaseError.createSqlException(309).fillInStackTrace();
        }
        if (!this.updateRowFlag) {
            throw (SQLException)DatabaseError.createSqlException(319).fillInStackTrace();
        }
        this.updateRowFlag = false;
        this.getCurrentRow().setRowUpdated(true);
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        if (this.isReadOnly()) {
            throw (SQLException)DatabaseError.createSqlException(309).fillInStackTrace();
        }
        this.getCurrentRow().setRowDeleted(true);
        this.notifyRowChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        OracleRow oracleRow = this.getCurrentRow();
        if (oracleRow.isRowUpdated()) {
            oracleRow.cancelRowUpdates();
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        if (this.isReadOnly()) {
            throw (SQLException)DatabaseError.createSqlException(309).fillInStackTrace();
        }
        this.insertRow = new OracleRow(this.colCount, true);
        this.insertRowFlag = true;
        this.insertRowPosition = this.isAfterLast() ? this.presentRow : this.presentRow + 1;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.isReadOnly()) {
            throw (SQLException)DatabaseError.createSqlException(309).fillInStackTrace();
        }
        this.insertRowFlag = false;
        this.updateRowFlag = false;
        this.absolute(this.presentRow);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.getCurrentRow().isRowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.getCurrentRow().isRowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.getCurrentRow().isRowDeleted();
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = 1;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        OracleRow oracleRow = new OracleRow(this.rowsetMetaData.getColumnCount(), this.getCurrentRow().getOriginalRow());
        oracleCachedRowSet.rows.add(oracleRow);
        return oracleCachedRowSet;
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = new OracleCachedRowSet();
        oracleCachedRowSet.rowsetMetaData = this.rowsetMetaData;
        oracleCachedRowSet.rowCount = this.rowCount;
        oracleCachedRowSet.colCount = this.colCount;
        oracleCachedRowSet.presentRow = 0;
        oracleCachedRowSet.setType(1004);
        oracleCachedRowSet.setConcurrency(1008);
        oracleCachedRowSet.setReader(null);
        oracleCachedRowSet.setWriter(null);
        int n2 = this.rowsetMetaData.getColumnCount();
        OracleRow oracleRow = null;
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            oracleRow = new OracleRow(n2, ((OracleRow)iterator.next()).getOriginalRow());
            oracleCachedRowSet.rows.add(oracleRow);
        }
        return oracleCachedRowSet;
    }

    @Override
    public void setNull(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, null);
    }

    @Override
    public void setNull(int n2, int n3, String string) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{n3, string};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, bl);
    }

    @Override
    public void setByte(int n2, byte by) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, new Byte(by));
    }

    @Override
    public void setShort(int n2, short s2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, s2);
    }

    @Override
    public void setInt(int n2, int n3) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, n3);
    }

    @Override
    public void setLong(int n2, long l2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, l2);
    }

    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, Float.valueOf(f2));
    }

    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, d2);
    }

    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, bigDecimal);
    }

    @Override
    public void setString(int n2, String string) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, string);
    }

    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, byArray);
    }

    @Override
    public void setDate(int n2, java.sql.Date date) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, date);
    }

    @Override
    public void setTime(int n2, Time time) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, time);
    }

    @Override
    public void setObject(int n2, Object object) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, object);
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, ref);
    }

    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, blob);
    }

    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, clob);
    }

    @Override
    public void setArray(int n2, Array array) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, array);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, n3, 2};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{time, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, timestamp);
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, n3, 3};
        this.param.add(n2 - 1, objectArray);
    }

    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, n3, 1};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, n3, 4};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, n3, n4};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{object, n3};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setDate(int n2, java.sql.Date date, Calendar calendar) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{date, calendar};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, uRL.toString());
    }

    @Override
    public synchronized Object getObject(int n2) throws SQLException {
        int n3 = this.presentRow * this.colCount + n2 - 1;
        Object object = null;
        object = !this.isUpdated(n2) ? this.getCurrentRow().getColumn(n2) : this.getCurrentRow().getModifiedColumn(n2);
        this.previousColumnWasNull = object == null;
        return object;
    }

    private synchronized Number getNumber(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof BigDecimal || object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof String) {
            try {
                return new BigDecimal((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
            }
        }
        throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue() != 0.0;
        }
        if (object instanceof String) {
            String string = ((String)object).trim();
            if (string.equals("1")) {
                return true;
            }
            if (string.equals("0")) {
                return false;
            }
        }
        throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return 0;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            if (bigDecimal.compareTo(new BigDecimal(127)) == 1 || bigDecimal.compareTo(new BigDecimal(-128)) == -1) {
                throw (SQLException)DatabaseError.createSqlException(26).fillInStackTrace();
            }
            return bigDecimal.byteValue();
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            return ((String)object).getBytes()[0];
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(1L, 1)[0];
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(1L, 1).getBytes()[0];
        }
        throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
    }

    @Override
    public short getShort(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? (short)0 : number.shortValue();
    }

    @Override
    public int getInt(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0 : number.intValue();
    }

    @Override
    public long getLong(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0L : number.longValue();
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0f : number.floatValue();
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        return number == null ? 0.0 : number.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Number number = this.getNumber(n2);
        if (number == null || number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        return new BigDecimal(number.doubleValue());
    }

    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        return this.getBigDecimal(n2);
    }

    @Override
    public java.sql.Date getDate(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (java.sql.Date)object;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            return new java.sql.Date(time.getTime());
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new java.sql.Date(date.getYear(), date.getMonth(), date.getDate());
        }
        if (object instanceof TIMESTAMP) {
            return ((TIMESTAMP)object).dateValue();
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).dateValue(this.getConnectionInternal());
        }
        if (object instanceof TIMESTAMPLTZ) {
            Connection connection = this.getConnectionInternal();
            return ((TIMESTAMPLTZ)object).dateValue(connection, this.getSessionCalendar(connection));
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public java.sql.Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (Time)object;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new Time(date.getHours(), date.getMinutes(), date.getSeconds());
        }
        if (object instanceof TIMESTAMP) {
            return ((TIMESTAMP)object).timeValue();
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).timeValue(this.getConnectionInternal());
        }
        if (object instanceof TIMESTAMPLTZ) {
            Connection connection = this.getConnectionInternal();
            return ((TIMESTAMPLTZ)object).timeValue(connection, this.getSessionCalendar(connection));
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        if (object instanceof TIMESTAMP) {
            return ((TIMESTAMP)object).timestampValue();
        }
        if (object instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)object).timestampValue(this.getConnectionInternal());
        }
        if (object instanceof TIMESTAMPLTZ) {
            Connection connection = this.getConnectionInternal();
            return ((TIMESTAMPLTZ)object).timestampValue(connection, this.getSessionCalendar(connection));
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (byte[])object;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof Number) {
            return ((Number)object).toString().getBytes();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).toString().getBytes();
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length());
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(1L, (int)oracleSerialClob.length()).getBytes();
        }
        throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Ref) {
            return (Ref)object;
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof OracleSerialBlob) {
            return (Blob)object;
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof OracleSerialClob) {
            return (Clob)object;
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof Array) {
            return (Array)object;
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public String getString(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (String)object;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Number || object instanceof BigDecimal) {
            return object.toString();
        }
        if (object instanceof java.sql.Date) {
            return object.toString();
        }
        if (object instanceof Timestamp) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            return new String((byte[])object);
        }
        if (object instanceof OracleSerialClob) {
            OracleSerialClob oracleSerialClob = (OracleSerialClob)object;
            return oracleSerialClob.getSubString(1L, (int)oracleSerialClob.length());
        }
        if (object instanceof OracleSerialBlob) {
            OracleSerialBlob oracleSerialBlob = (OracleSerialBlob)object;
            return new String(oracleSerialBlob.getBytes(1L, (int)oracleSerialBlob.length()));
        }
        if (object instanceof URL) {
            return ((URL)object).toString();
        }
        if (object instanceof ROWID) {
            return ((ROWID)object).stringValue();
        }
        if (object instanceof Reader) {
            try {
                Reader reader = (Reader)object;
                char[] cArray = new char[1024];
                int n3 = 0;
                StringBuffer stringBuffer = new StringBuffer(1024);
                while ((n3 = reader.read(cArray)) > 0) {
                    stringBuffer.append(cArray, 0, n3);
                }
                return stringBuffer.substring(0, stringBuffer.length());
            }
            catch (IOException iOException) {
                throw (SQLException)DatabaseError.createSqlException(321).fillInStackTrace();
            }
        }
        throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (InputStream)object;
        }
        if (object instanceof String) {
            return new StringBufferInputStream((String)object);
        }
        throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        InputStream inputStream = this.getStream(n2);
        return inputStream == null ? null : inputStream;
    }

    @Override
    public synchronized Reader getCharacterStream(int n2) throws SQLException {
        try {
            InputStream inputStream = this.getAsciiStream(n2);
            if (inputStream == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while ((n3 = inputStream.read()) != -1) {
                stringBuffer.append((char)n3);
            }
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            cArray = null;
            return charArrayReader;
        }
        catch (IOException iOException) {
            throw (SQLException)DatabaseError.createSqlException(322).fillInStackTrace();
        }
    }

    @Override
    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.getColumnIndex(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColumnIndex(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColumnIndex(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColumnIndex(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColumnIndex(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColumnIndex(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColumnIndex(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColumnIndex(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string), n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColumnIndex(string));
    }

    @Override
    public java.sql.Date getDate(String string) throws SQLException {
        return this.getDate(this.getColumnIndex(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColumnIndex(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.getColumnIndex(string), calendar);
    }

    @Override
    public java.sql.Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.getColumnIndex(string), calendar);
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColumnIndex(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColumnIndex(string));
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.getColumnIndex(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColumnIndex(string));
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.getColumnIndex(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(string), calendar);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.getColumnIndex(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.getColumnIndex(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getColumnIndex(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.getColumnIndex(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.getColumnIndex(string));
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.updateObject(n2, object, (long[])null);
    }

    protected synchronized void updateObject(int n2, Object object, long[] lArray) throws SQLException {
        this.checkColumnIndex(n2);
        if (this.insertRowFlag) {
            this.checkAndFilterObject(n2, object);
            this.insertRow.updateObject(n2, object, lArray);
        } else if (!this.isBeforeFirst() && !this.isAfterLast()) {
            this.updateRowFlag = true;
            this.updateRowPosition = this.presentRow;
            this.getCurrentRow().updateObject(n2, object, lArray);
        } else {
            throw (SQLException)DatabaseError.createSqlException(90).fillInStackTrace();
        }
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.updateObject(n2, null);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.updateCharacterStreamInternal(n2, reader, n3, false, true);
    }

    synchronized void updateCharacterStreamInternal(int n2, Reader reader, long l2, boolean bl, boolean bl2) throws SQLException {
        this.checkColumnIndex(n2);
        if (l2 < 0L) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n3 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n3)) {
            if (bl2 && l2 > Integer.MAX_VALUE) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            try {
                int n4;
                int n5 = 0;
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder(1024);
                for (n4 = bl2 ? (int)l2 : Integer.MAX_VALUE; n4 > 0 && (n5 = n4 >= 1024 ? reader.read(cArray) : reader.read(cArray, 0, n4)) != -1; n4 -= n5) {
                    stringBuilder.append(cArray, 0, n5);
                }
                reader.close();
                if ((long)n4 == l2) {
                    this.updateNull(n2);
                    return;
                }
                this.updateString(n2, stringBuilder.toString());
            }
            catch (IOException iOException) {
                throw (SQLException)DatabaseError.createSqlException(null, iOException).fillInStackTrace();
            }
        } else {
            int n6 = bl2 ? (bl ? 4 : 3) : (bl ? 8 : 7);
            long[] lArray = new long[]{l2, n6};
            this.updateObject(n2, (Object)reader, lArray);
        }
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.getColumnIndex(string), reader, n2);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getColumnIndex(string), timestamp);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, n2, true);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateBinaryStream(n2, inputStream, n3, true);
    }

    synchronized void updateBinaryStream(int n2, InputStream inputStream, long l2, boolean bl) throws SQLException {
        this.checkColumnIndex(n2);
        if (l2 < 0L) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n3 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n3)) {
            if (bl && l2 > Integer.MAX_VALUE) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            try {
                int n4;
                int n5 = 0;
                byte[] byArray = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                for (n4 = bl ? (int)l2 : Integer.MAX_VALUE; n4 > 0 && (n5 = n4 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n4)) != -1; n4 -= n5) {
                    byteArrayOutputStream.write(byArray, 0, n5);
                }
                inputStream.close();
                if ((long)n4 == l2) {
                    this.updateNull(n2);
                    return;
                }
                this.updateBytes(n2, byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw (SQLException)DatabaseError.createSqlException(null, iOException).fillInStackTrace();
            }
        } else {
            long[] lArray = new long[]{l2, 0L};
            lArray[1] = bl ? 2 : 6;
            this.updateObject(n2, (Object)inputStream, lArray);
        }
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.updateAsciiStream(n2, inputStream, n3, true);
    }

    synchronized void updateAsciiStream(int n2, InputStream inputStream, long l2, boolean bl) throws SQLException {
        this.checkColumnIndex(n2);
        if (l2 < 0L) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        int n3 = this.getMetaData().getColumnType(n2);
        if (!this.isStreamType(n3)) {
            if (bl && l2 > Integer.MAX_VALUE) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            try {
                int n4;
                int n5 = 0;
                byte[] byArray = new byte[1024];
                char[] cArray = new char[1024];
                StringBuilder stringBuilder = new StringBuilder(1024);
                for (n4 = bl ? (int)l2 : Integer.MAX_VALUE; n4 > 0 && (n5 = n4 >= 1024 ? inputStream.read(byArray) : inputStream.read(byArray, 0, n4)) != -1; n4 -= n5) {
                    DBConversion.asciiBytesToJavaChars(byArray, n5, cArray);
                    stringBuilder.append(cArray, 0, n5);
                }
                inputStream.close();
                if ((long)n4 == l2) {
                    this.updateNull(n2);
                    return;
                }
                this.updateString(n2, stringBuilder.toString());
            }
            catch (IOException iOException) {
                throw (SQLException)DatabaseError.createSqlException(null, iOException).fillInStackTrace();
            }
        } else {
            long[] lArray = new long[]{l2, 0L};
            lArray[1] = bl ? 1 : 5;
            this.updateObject(n2, (Object)inputStream, lArray);
        }
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.updateObject(n2, (Object)timestamp);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        this.updateObject(n2, (Object)bl);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.updateObject(n2, (Object)new Byte(by));
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.updateObject(n2, (Object)s2);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.updateObject(n2, (Object)n3);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.updateObject(n2, (Object)l2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        this.updateObject(n2, (Object)Float.valueOf(f2));
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        this.updateObject(n2, (Object)d2);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n2, (Object)bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.updateObject(n2, (Object)byArray);
    }

    @Override
    public void updateDate(int n2, java.sql.Date date) throws SQLException {
        this.updateObject(n2, (Object)date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.updateObject(n2, (Object)new Timestamp(0, 0, 0, time.getHours(), time.getMinutes(), time.getSeconds(), 0));
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        if (!(object instanceof Number)) {
            throw (SQLException)DatabaseError.createSqlException(323).fillInStackTrace();
        }
        this.updateObject(n2, (Object)new BigDecimal(new BigInteger(((Number)object).toString()), n3));
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.getColumnIndex(string));
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, n2, true);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.getColumnIndex(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.getColumnIndex(string), by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.getColumnIndex(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.getColumnIndex(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.getColumnIndex(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.getColumnIndex(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.getColumnIndex(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getColumnIndex(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getColumnIndex(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.getColumnIndex(string), byArray);
    }

    @Override
    public void updateDate(String string, java.sql.Date date) throws SQLException {
        this.updateDate(this.getColumnIndex(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getColumnIndex(string), time);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.getColumnIndex(string), object, n2);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null) {
            return (URL)object;
        }
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object instanceof String) {
            try {
                return new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw (SQLException)DatabaseError.createSqlException(136).fillInStackTrace();
            }
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.getColumnIndex(string));
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        this.updateObject(n2, (Object)ref);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.getColumnIndex(string), ref);
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.updateObject(n2, (Object)blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.updateObject(n2, (Object)clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.getColumnIndex(string), clob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.updateObject(n2, (Object)array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.getColumnIndex(string), array);
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyColumns;
    }

    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        int n2 = 0;
        if (this.rowsetMetaData != null) {
            n2 = this.rowsetMetaData.getColumnCount();
            if (nArray == null || nArray.length > n2) {
                throw (SQLException)DatabaseError.createSqlException(324).fillInStackTrace();
            }
        }
        int n3 = nArray.length;
        this.keyColumns = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] <= 0 || nArray[i2] > n2) {
                throw (SQLException)DatabaseError.createSqlException(null, 3, "" + nArray[i2]).fillInStackTrace();
            }
            this.keyColumns[i2] = nArray[i2];
        }
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int n2) throws SQLException {
        if (n2 < 0 || this.maxRows > 0 && n2 > this.maxRows) {
            throw (SQLException)DatabaseError.createSqlException(325).fillInStackTrace();
        }
        this.pageSize = n2;
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.syncProvider;
    }

    @Override
    public void setSyncProvider(String string) throws SQLException {
        this.syncProvider = SyncFactory.getInstance(string);
        this.reader = this.syncProvider.getRowSetReader();
        this.writer = this.syncProvider.getRowSetWriter();
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public void setTableName(String string) throws SQLException {
        this.tableName = string;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.initializeProperties();
        oracleCachedRowSet.listener = new Vector();
        try {
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnIndexes());
            oracleCachedRowSet.unsetMatchColumn(oracleCachedRowSet.getMatchColumnNames());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return oracleCachedRowSet;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)this.createCopy();
        oracleCachedRowSet.rows = null;
        oracleCachedRowSet.rowCount = 0;
        oracleCachedRowSet.currentPage = 0;
        return oracleCachedRowSet;
    }

    @Override
    public boolean columnUpdated(int n2) throws SQLException {
        if (this.insertRowFlag) {
            throw (SQLException)DatabaseError.createSqlException(326).fillInStackTrace();
        }
        return this.getCurrentRow().isColumnChanged(n2);
    }

    @Override
    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getColumnIndex(string));
    }

    @Override
    public synchronized void execute(Connection connection) throws SQLException {
        this.connection = connection;
        this.execute();
    }

    @Override
    public void commit() throws SQLException {
        this.getConnectionInternal().commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.getConnectionInternal().rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.getConnectionInternal().rollback(savepoint);
    }

    public void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        ((OracleConnection)this.getConnectionInternal()).oracleRollback(oracleSavepoint);
    }

    @Override
    public void setOriginalRow() throws SQLException {
        if (this.insertRowFlag) {
            throw (SQLException)DatabaseError.createSqlException(327).fillInStackTrace();
        }
        this.setOriginalRowInternal(this.presentRow);
    }

    @Override
    public int size() {
        return this.rowCount;
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.fetchDirection == 1001 && this.resultSet != null && this.resultSet.getType() == 1003) {
            throw (SQLException)DatabaseError.createSqlException(328).fillInStackTrace();
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            throw (SQLException)DatabaseError.createSqlException(329).fillInStackTrace();
        }
        if ((this.isExecuteCalled() || this.isPopulateDone) && this.rowCount < this.pageSize) {
            return false;
        }
        if (this.isExecuteCalled()) {
            ++this.currentPage;
            this.execute();
        } else {
            this.populate(this.resultSet);
            ++this.currentPage;
        }
        return !this.isPopulateDone;
    }

    @Override
    public boolean previousPage() throws SQLException {
        if (this.resultSet != null && this.resultSet.getType() == 1003) {
            throw (SQLException)DatabaseError.createSqlException(328).fillInStackTrace();
        }
        if (this.rows.size() == 0 && !this.isPopulateDone) {
            throw (SQLException)DatabaseError.createSqlException(329).fillInStackTrace();
        }
        if (this.currentPage == 0) {
            return false;
        }
        if (this.fetchDirection == 1001) {
            this.resultSet.relative(this.pageSize * 2);
        } else {
            this.resultSet.relative(-2 * this.pageSize);
        }
        this.populate(this.resultSet);
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        return this.currentPage != 0;
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n2) throws SQLException {
        if (n2 <= 0 || n2 < this.fetchSize) {
            throw (SQLException)DatabaseError.createSqlException(330).fillInStackTrace();
        }
        if (this.rowCount % n2 == 0) {
            this.rowsetEvent = new RowSetEvent(this);
            this.notifyRowSetChanged();
        }
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return this.rowsetWarning;
    }

    @Override
    public void populate(ResultSet resultSet, int n2) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(331).fillInStackTrace();
        }
        if (resultSet == null) {
            throw (SQLException)DatabaseError.createSqlException(332).fillInStackTrace();
        }
        int n3 = resultSet.getType();
        if (n3 == 1003) {
            int n4;
            boolean bl = false;
            for (n4 = 0; n4 < n2; ++n4) {
                if (resultSet.next()) continue;
                bl = true;
                break;
            }
            if (n4 < n2 && n2 > 0 && bl) {
                throw (SQLException)DatabaseError.createSqlException(333).fillInStackTrace();
            }
        } else if (n2 == 0) {
            resultSet.beforeFirst();
        } else {
            resultSet.absolute(n2);
        }
        this.populate(resultSet);
    }

    @Override
    public void undoDelete() throws SQLException {
        this.cancelRowDelete();
    }

    @Override
    public void undoInsert() throws SQLException {
        this.cancelRowInsert();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.cancelRowUpdates();
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.getCharacterStream(n2);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof OracleSerialClob) {
            return (NClob)object;
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object instanceof RowId) {
            return object == null ? null : (RowId)object;
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        Object object = this.getObject(n2);
        if (object == null || object instanceof SQLXML) {
            return (SQLXML)object;
        }
        throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.getColumnIndex(string));
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.getColumnIndex(string));
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.getColumnIndex(string));
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.getColumnIndex(string));
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.getColumnIndex(string));
    }

    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, 7};
        this.param.add(n2 - 1, objectArray);
    }

    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, l2, 8};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, 5};
        this.param.add(n2 - 1, objectArray);
    }

    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, l2, 6};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, 13};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{inputStream, l2, 14};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, 9};
        this.param.add(n2 - 1, objectArray);
    }

    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, l2, 10};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, 15};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{this.reader, l2, 16};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, 11};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{reader, l2, 12};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, nClob);
    }

    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{this.reader, 17};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        this.checkParamIndex(n2);
        Object[] objectArray = new Object[]{this.reader, l2, 18};
        this.param.add(n2 - 1, objectArray);
    }

    @Override
    public void setNString(int n2, String string) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, string);
    }

    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, rowId);
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.checkParamIndex(n2);
        this.param.add(n2 - 1, sQLXML);
    }

    public void setArray(String string, Array array) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setArray(i2 + 1, array);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBigDecimal(i2 + 1, bigDecimal);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBlob(i2 + 1, blob);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl2 = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBoolean(i2 + 1, bl);
            bl2 = true;
        }
        if (!bl2) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setByte(i2 + 1, by);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBytes(i2 + 1, byArray);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setClob(i2 + 1, clob);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setDate(String string, java.sql.Date date) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDate(i2 + 1, date);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setDate(String string, java.sql.Date date, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDate(i2 + 1, date, calendar);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setDouble(String string, double d2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setDouble(i2 + 1, d2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setFloat(String string, float f2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setFloat(i2 + 1, f2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setInt(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setInt(i2 + 1, n2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setLong(String string, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setLong(i2 + 1, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNClob(i2 + 1, nClob);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setNString(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object, n2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    public void setRef(String string, Ref ref) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRef(i2 + 1, ref);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setRowId(i2 + 1, rowId);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setShort(String string, short s2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setShort(i2 + 1, s2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setSQLXML(i2 + 1, sQLXML);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setString(i2 + 1, string2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTime(i2 + 1, time);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTime(i2 + 1, time, calendar);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTimestamp(i2 + 1, timestamp);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setTimestamp(i2 + 1, timestamp, calendar);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setURL(i2 + 1, uRL);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBlob(i2 + 1, inputStream);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBlob(i2 + 1, inputStream, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setClob(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setClob(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNClob(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNClob(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setAsciiStream(i2 + 1, inputStream);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setAsciiStream(i2 + 1, inputStream, n2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setAsciiStream(i2 + 1, inputStream, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryStream(i2 + 1, inputStream);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryStream(i2 + 1, inputStream, n2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setBinaryStream(i2 + 1, inputStream, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCharacterStream(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCharacterStream(i2 + 1, reader, n2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setCharacterStream(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNCharacterStream(i2 + 1, reader);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n2 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNCharacterStream(i2 + 1, reader, l2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    public void setUnicodeStream(String string, InputStream inputStream, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setUnicodeStream(i2 + 1, inputStream, n2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNull(String string, int n2) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setNull(i2 + 1, n2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        String string3 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n3 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2] != string3) continue;
            this.setNull(i2 + 1, n2, string2);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        String string2 = string.intern();
        String[] stringArray = this.osql.getParameterList();
        boolean bl = false;
        int n4 = Math.min(this.osql.getParameterCount(), stringArray.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            if (stringArray[i2] != string2) continue;
            this.setObject(i2 + 1, object, n2, n3);
            bl = true;
        }
        if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(null, 147, string).fillInStackTrace();
        }
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(n2, inputStream, 0L, false);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateAsciiStream(n2, inputStream, l2, true);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.updateAsciiStream(this.getColumnIndex(string), inputStream, l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream, 0L, false);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateBinaryStream(n2, inputStream, l2, true);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, Long.MAX_VALUE, false);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.updateBinaryStream(this.getColumnIndex(string), inputStream, l2, true);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n2, inputStream);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.updateBinaryStream(n2, inputStream, l2);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        this.updateBlob(this.getColumnIndex(string), inputStream, l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStreamInternal(n2, reader, 0L, false, false);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStreamInternal(n2, reader, l2, false, true);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStreamInternal(this.getColumnIndex(string), reader, 0L, false, false);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.updateCharacterStreamInternal(this.getColumnIndex(string), reader, l2, false, true);
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.updateCharacterStream(n2, reader);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.getColumnIndex(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        this.updateClob(this.getColumnIndex(string), reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.updateCharacterStreamInternal(n2, reader, 0L, true, false);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.updateCharacterStreamInternal(n2, reader, l2, true, true);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.getColumnIndex(string), reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.updateNCharacterStream(this.getColumnIndex(string), reader, l2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        this.updateObject(n2, (Object)new OracleSerialClob(nClob));
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        this.updateClob(n2, (Clob)new OracleSerialClob(reader));
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        this.updateClob(n2, (Clob)new OracleSerialClob(reader, l2));
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.getColumnIndex(string), nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.getColumnIndex(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        this.updateNClob(this.getColumnIndex(string), reader, l2);
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.updateObject(n2, (Object)string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.getColumnIndex(string), string2);
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        this.updateObject(n2, (Object)rowId);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        this.updateRowId(this.getColumnIndex(string), rowId);
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.updateObject(n2, (Object)sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.getColumnIndex(string), sQLXML);
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    /*
     * Opcode count of 13201 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        try {
            $$$methodRef$$$403 = OracleCachedRowSet.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$403 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$402 = OracleCachedRowSet.class.getDeclaredMethod("getCommand", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$402 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$401 = OracleCachedRowSet.class.getDeclaredMethod("getConcurrency", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$401 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$400 = OracleCachedRowSet.class.getDeclaredMethod("getDataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$400 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$399 = OracleCachedRowSet.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$399 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$398 = OracleCachedRowSet.class.getDeclaredMethod("getEscapeProcessing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$398 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$397 = OracleCachedRowSet.class.getDeclaredMethod("getFetchDirection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$397 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$396 = OracleCachedRowSet.class.getDeclaredMethod("getFetchSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$396 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$395 = OracleCachedRowSet.class.getDeclaredMethod("getMaxFieldSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$395 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$394 = OracleCachedRowSet.class.getDeclaredMethod("getMaxRows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$394 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$393 = OracleCachedRowSet.class.getDeclaredMethod("getPassword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$393 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$392 = OracleCachedRowSet.class.getDeclaredMethod("getQueryTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$392 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$391 = OracleCachedRowSet.class.getDeclaredMethod("getReadOnly", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$391 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$390 = OracleCachedRowSet.class.getDeclaredMethod("isReadOnly", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$390 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$389 = OracleCachedRowSet.class.getDeclaredMethod("getShowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$389 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$388 = OracleCachedRowSet.class.getDeclaredMethod("getTransactionIsolation", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$388 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$387 = OracleCachedRowSet.class.getDeclaredMethod("getType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$387 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$386 = OracleCachedRowSet.class.getDeclaredMethod("getTypeMap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$386 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$385 = OracleCachedRowSet.class.getDeclaredMethod("getUrl", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$385 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$384 = OracleCachedRowSet.class.getDeclaredMethod("getUsername", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$384 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$383 = OracleCachedRowSet.class.getDeclaredMethod("setConcurrency", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$383 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$382 = OracleCachedRowSet.class.getDeclaredMethod("setDataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$382 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$381 = OracleCachedRowSet.class.getDeclaredMethod("setDataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$381 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$380 = OracleCachedRowSet.class.getDeclaredMethod("setEscapeProcessing", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$380 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$379 = OracleCachedRowSet.class.getDeclaredMethod("setFetchSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$379 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$378 = OracleCachedRowSet.class.getDeclaredMethod("setMaxFieldSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$378 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$377 = OracleCachedRowSet.class.getDeclaredMethod("setMaxRows", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$377 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$376 = OracleCachedRowSet.class.getDeclaredMethod("setPassword", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$376 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$375 = OracleCachedRowSet.class.getDeclaredMethod("setQueryTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$375 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$374 = OracleCachedRowSet.class.getDeclaredMethod("setReadOnly", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$374 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$373 = OracleCachedRowSet.class.getDeclaredMethod("setShowDeleted", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$373 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$372 = OracleCachedRowSet.class.getDeclaredMethod("setTransactionIsolation", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$372 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$371 = OracleCachedRowSet.class.getDeclaredMethod("setType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$371 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$370 = OracleCachedRowSet.class.getDeclaredMethod("setTypeMap", Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$370 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$369 = OracleCachedRowSet.class.getDeclaredMethod("setUrl", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$369 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$368 = OracleCachedRowSet.class.getDeclaredMethod("setUsername", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$368 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$367 = OracleCachedRowSet.class.getDeclaredMethod("addRowSetListener", RowSetListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$367 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$366 = OracleCachedRowSet.class.getDeclaredMethod("removeRowSetListener", RowSetListener.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$366 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$365 = OracleCachedRowSet.class.getDeclaredMethod("getMatchColumnIndexes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$365 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$364 = OracleCachedRowSet.class.getDeclaredMethod("getMatchColumnNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$364 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$363 = OracleCachedRowSet.class.getDeclaredMethod("setMatchColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$363 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$362 = OracleCachedRowSet.class.getDeclaredMethod("setMatchColumn", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$362 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$361 = OracleCachedRowSet.class.getDeclaredMethod("setMatchColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$361 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$360 = OracleCachedRowSet.class.getDeclaredMethod("setMatchColumn", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$360 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$359 = OracleCachedRowSet.class.getDeclaredMethod("unsetMatchColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$359 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$358 = OracleCachedRowSet.class.getDeclaredMethod("unsetMatchColumn", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$358 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$357 = OracleCachedRowSet.class.getDeclaredMethod("unsetMatchColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$357 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$356 = OracleCachedRowSet.class.getDeclaredMethod("unsetMatchColumn", String[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$356 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$355 = OracleCachedRowSet.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$355 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$354 = OracleCachedRowSet.class.getDeclaredMethod("getHoldability", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$354 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$353 = OracleCachedRowSet.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$353 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$352 = OracleCachedRowSet.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$352 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$351 = OracleCachedRowSet.class.getDeclaredMethod("getObject", Integer.TYPE, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$351 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$350 = OracleCachedRowSet.class.getDeclaredMethod("getObject", String.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$350 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$349 = OracleCachedRowSet.class.getDeclaredMethod("updateSQLXML", String.class, SQLXML.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$349 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$348 = OracleCachedRowSet.class.getDeclaredMethod("updateSQLXML", Integer.TYPE, SQLXML.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$348 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$347 = OracleCachedRowSet.class.getDeclaredMethod("updateRowId", String.class, RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$347 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$346 = OracleCachedRowSet.class.getDeclaredMethod("updateRowId", Integer.TYPE, RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$346 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$345 = OracleCachedRowSet.class.getDeclaredMethod("updateNString", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$345 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$344 = OracleCachedRowSet.class.getDeclaredMethod("updateNString", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$344 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$343 = OracleCachedRowSet.class.getDeclaredMethod("updateNClob", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$343 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$342 = OracleCachedRowSet.class.getDeclaredMethod("updateNClob", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$342 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$341 = OracleCachedRowSet.class.getDeclaredMethod("updateNClob", String.class, NClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$341 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$340 = OracleCachedRowSet.class.getDeclaredMethod("updateNClob", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$340 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$339 = OracleCachedRowSet.class.getDeclaredMethod("updateNClob", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$339 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$338 = OracleCachedRowSet.class.getDeclaredMethod("updateNClob", Integer.TYPE, NClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$338 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$337 = OracleCachedRowSet.class.getDeclaredMethod("updateNCharacterStream", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$337 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$336 = OracleCachedRowSet.class.getDeclaredMethod("updateNCharacterStream", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$336 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$335 = OracleCachedRowSet.class.getDeclaredMethod("updateNCharacterStream", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$335 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$334 = OracleCachedRowSet.class.getDeclaredMethod("updateNCharacterStream", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$334 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$333 = OracleCachedRowSet.class.getDeclaredMethod("updateClob", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$333 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$332 = OracleCachedRowSet.class.getDeclaredMethod("updateClob", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$332 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$331 = OracleCachedRowSet.class.getDeclaredMethod("updateClob", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$331 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$330 = OracleCachedRowSet.class.getDeclaredMethod("updateClob", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$330 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$329 = OracleCachedRowSet.class.getDeclaredMethod("updateCharacterStream", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$329 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$328 = OracleCachedRowSet.class.getDeclaredMethod("updateCharacterStream", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$328 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$327 = OracleCachedRowSet.class.getDeclaredMethod("updateCharacterStream", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$327 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$326 = OracleCachedRowSet.class.getDeclaredMethod("updateCharacterStream", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$326 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$325 = OracleCachedRowSet.class.getDeclaredMethod("updateBlob", String.class, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$325 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$324 = OracleCachedRowSet.class.getDeclaredMethod("updateBlob", String.class, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$324 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$323 = OracleCachedRowSet.class.getDeclaredMethod("updateBlob", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$323 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$322 = OracleCachedRowSet.class.getDeclaredMethod("updateBlob", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$322 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$321 = OracleCachedRowSet.class.getDeclaredMethod("updateBinaryStream", String.class, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$321 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$320 = OracleCachedRowSet.class.getDeclaredMethod("updateBinaryStream", String.class, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$320 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$319 = OracleCachedRowSet.class.getDeclaredMethod("updateBinaryStream", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$319 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$318 = OracleCachedRowSet.class.getDeclaredMethod("updateBinaryStream", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$318 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$317 = OracleCachedRowSet.class.getDeclaredMethod("updateAsciiStream", String.class, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$317 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$316 = OracleCachedRowSet.class.getDeclaredMethod("updateAsciiStream", String.class, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$316 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$315 = OracleCachedRowSet.class.getDeclaredMethod("updateAsciiStream", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$315 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$314 = OracleCachedRowSet.class.getDeclaredMethod("updateAsciiStream", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$314 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$313 = OracleCachedRowSet.class.getDeclaredMethod("setObject", String.class, Object.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$313 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$312 = OracleCachedRowSet.class.getDeclaredMethod("setNull", String.class, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$312 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$311 = OracleCachedRowSet.class.getDeclaredMethod("setNull", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$311 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$310 = OracleCachedRowSet.class.getDeclaredMethod("setUnicodeStream", String.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$310 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$309 = OracleCachedRowSet.class.getDeclaredMethod("setNCharacterStream", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$309 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$308 = OracleCachedRowSet.class.getDeclaredMethod("setNCharacterStream", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$308 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$307 = OracleCachedRowSet.class.getDeclaredMethod("setCharacterStream", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$307 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$306 = OracleCachedRowSet.class.getDeclaredMethod("setCharacterStream", String.class, Reader.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$306 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$305 = OracleCachedRowSet.class.getDeclaredMethod("setCharacterStream", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$305 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$304 = OracleCachedRowSet.class.getDeclaredMethod("setBinaryStream", String.class, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$304 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$303 = OracleCachedRowSet.class.getDeclaredMethod("setBinaryStream", String.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$303 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$302 = OracleCachedRowSet.class.getDeclaredMethod("setBinaryStream", String.class, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$302 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$301 = OracleCachedRowSet.class.getDeclaredMethod("setAsciiStream", String.class, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$301 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$300 = OracleCachedRowSet.class.getDeclaredMethod("setAsciiStream", String.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$300 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$299 = OracleCachedRowSet.class.getDeclaredMethod("setAsciiStream", String.class, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$299 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$298 = OracleCachedRowSet.class.getDeclaredMethod("setNClob", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$298 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$297 = OracleCachedRowSet.class.getDeclaredMethod("setNClob", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$297 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$296 = OracleCachedRowSet.class.getDeclaredMethod("setClob", String.class, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$296 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$295 = OracleCachedRowSet.class.getDeclaredMethod("setClob", String.class, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$295 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$294 = OracleCachedRowSet.class.getDeclaredMethod("setBlob", String.class, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$294 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$293 = OracleCachedRowSet.class.getDeclaredMethod("setBlob", String.class, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$293 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$292 = OracleCachedRowSet.class.getDeclaredMethod("setURL", String.class, URL.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$292 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$291 = OracleCachedRowSet.class.getDeclaredMethod("setTimestamp", String.class, Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$291 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$290 = OracleCachedRowSet.class.getDeclaredMethod("setTimestamp", String.class, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$290 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$289 = OracleCachedRowSet.class.getDeclaredMethod("setTime", String.class, Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$289 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$288 = OracleCachedRowSet.class.getDeclaredMethod("setTime", String.class, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$288 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$287 = OracleCachedRowSet.class.getDeclaredMethod("setString", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$287 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$286 = OracleCachedRowSet.class.getDeclaredMethod("setSQLXML", String.class, SQLXML.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$286 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$285 = OracleCachedRowSet.class.getDeclaredMethod("setShort", String.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$285 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$284 = OracleCachedRowSet.class.getDeclaredMethod("setRowId", String.class, RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$284 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$283 = OracleCachedRowSet.class.getDeclaredMethod("setRef", String.class, Ref.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$283 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$282 = OracleCachedRowSet.class.getDeclaredMethod("setObject", String.class, Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$282 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$281 = OracleCachedRowSet.class.getDeclaredMethod("setObject", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$281 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$280 = OracleCachedRowSet.class.getDeclaredMethod("setNString", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$280 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$279 = OracleCachedRowSet.class.getDeclaredMethod("setNClob", String.class, NClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$279 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$278 = OracleCachedRowSet.class.getDeclaredMethod("setLong", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$278 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$277 = OracleCachedRowSet.class.getDeclaredMethod("setInt", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$277 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$276 = OracleCachedRowSet.class.getDeclaredMethod("setFloat", String.class, Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$276 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$275 = OracleCachedRowSet.class.getDeclaredMethod("setDouble", String.class, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$275 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$274 = OracleCachedRowSet.class.getDeclaredMethod("setDate", String.class, java.sql.Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$274 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$273 = OracleCachedRowSet.class.getDeclaredMethod("setDate", String.class, java.sql.Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$273 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$272 = OracleCachedRowSet.class.getDeclaredMethod("setClob", String.class, Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$272 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$271 = OracleCachedRowSet.class.getDeclaredMethod("setBytes", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$271 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$270 = OracleCachedRowSet.class.getDeclaredMethod("setByte", String.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$270 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$269 = OracleCachedRowSet.class.getDeclaredMethod("setBoolean", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$269 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$268 = OracleCachedRowSet.class.getDeclaredMethod("setBlob", String.class, Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$268 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$267 = OracleCachedRowSet.class.getDeclaredMethod("setBigDecimal", String.class, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$267 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$266 = OracleCachedRowSet.class.getDeclaredMethod("setArray", String.class, Array.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$266 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$265 = OracleCachedRowSet.class.getDeclaredMethod("setSQLXML", Integer.TYPE, SQLXML.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$265 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$264 = OracleCachedRowSet.class.getDeclaredMethod("setRowId", Integer.TYPE, RowId.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$264 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$263 = OracleCachedRowSet.class.getDeclaredMethod("setNString", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$263 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$262 = OracleCachedRowSet.class.getDeclaredMethod("setNClob", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$262 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$261 = OracleCachedRowSet.class.getDeclaredMethod("setNClob", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$261 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$260 = OracleCachedRowSet.class.getDeclaredMethod("setNClob", Integer.TYPE, NClob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$260 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$259 = OracleCachedRowSet.class.getDeclaredMethod("setNCharacterStream", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$259 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$258 = OracleCachedRowSet.class.getDeclaredMethod("setNCharacterStream", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$258 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$257 = OracleCachedRowSet.class.getDeclaredMethod("setClob", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$257 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$256 = OracleCachedRowSet.class.getDeclaredMethod("setClob", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$256 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$255 = OracleCachedRowSet.class.getDeclaredMethod("setCharacterStream", Integer.TYPE, Reader.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$255 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$254 = OracleCachedRowSet.class.getDeclaredMethod("setCharacterStream", Integer.TYPE, Reader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$254 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$253 = OracleCachedRowSet.class.getDeclaredMethod("setBlob", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$253 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$252 = OracleCachedRowSet.class.getDeclaredMethod("setBlob", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$252 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$251 = OracleCachedRowSet.class.getDeclaredMethod("setBinaryStream", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$251 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$250 = OracleCachedRowSet.class.getDeclaredMethod("setBinaryStream", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$250 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$249 = OracleCachedRowSet.class.getDeclaredMethod("setAsciiStream", Integer.TYPE, InputStream.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$249 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$248 = OracleCachedRowSet.class.getDeclaredMethod("setAsciiStream", Integer.TYPE, InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$248 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$247 = OracleCachedRowSet.class.getDeclaredMethod("getSQLXML", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$247 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$246 = OracleCachedRowSet.class.getDeclaredMethod("getRowId", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$246 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$245 = OracleCachedRowSet.class.getDeclaredMethod("getNString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$245 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$244 = OracleCachedRowSet.class.getDeclaredMethod("getNClob", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$244 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$243 = OracleCachedRowSet.class.getDeclaredMethod("getNCharacterStream", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$243 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$242 = OracleCachedRowSet.class.getDeclaredMethod("getSQLXML", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$242 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$241 = OracleCachedRowSet.class.getDeclaredMethod("getRowId", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$241 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$240 = OracleCachedRowSet.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$240 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$239 = OracleCachedRowSet.class.getDeclaredMethod("getNClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$239 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$238 = OracleCachedRowSet.class.getDeclaredMethod("getNCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$238 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$237 = OracleCachedRowSet.class.getDeclaredMethod("undoUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$237 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$236 = OracleCachedRowSet.class.getDeclaredMethod("undoInsert", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$236 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$235 = OracleCachedRowSet.class.getDeclaredMethod("undoDelete", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$235 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$234 = OracleCachedRowSet.class.getDeclaredMethod("populate", ResultSet.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$234 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$233 = OracleCachedRowSet.class.getDeclaredMethod("getRowSetWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$233 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$232 = OracleCachedRowSet.class.getDeclaredMethod("rowSetPopulated", RowSetEvent.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$232 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$231 = OracleCachedRowSet.class.getDeclaredMethod("previousPage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$231 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$230 = OracleCachedRowSet.class.getDeclaredMethod("nextPage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$230 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$229 = OracleCachedRowSet.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$229 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$228 = OracleCachedRowSet.class.getDeclaredMethod("setOriginalRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$228 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$227 = OracleCachedRowSet.class.getDeclaredMethod("oracleRollback", OracleSavepoint.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$227 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$226 = OracleCachedRowSet.class.getDeclaredMethod("rollback", Savepoint.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$226 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$225 = OracleCachedRowSet.class.getDeclaredMethod("rollback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$225 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$224 = OracleCachedRowSet.class.getDeclaredMethod("commit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$224 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$223 = OracleCachedRowSet.class.getDeclaredMethod("execute", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$223 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$222 = OracleCachedRowSet.class.getDeclaredMethod("columnUpdated", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$222 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$221 = OracleCachedRowSet.class.getDeclaredMethod("columnUpdated", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$221 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$220 = OracleCachedRowSet.class.getDeclaredMethod("createCopySchema", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$220 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$219 = OracleCachedRowSet.class.getDeclaredMethod("createCopyNoConstraints", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$219 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$218 = OracleCachedRowSet.class.getDeclaredMethod("setTableName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$218 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$217 = OracleCachedRowSet.class.getDeclaredMethod("getTableName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$217 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$216 = OracleCachedRowSet.class.getDeclaredMethod("setSyncProvider", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$216 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$215 = OracleCachedRowSet.class.getDeclaredMethod("getSyncProvider", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$215 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$214 = OracleCachedRowSet.class.getDeclaredMethod("setPageSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$214 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$213 = OracleCachedRowSet.class.getDeclaredMethod("getPageSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$213 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$212 = OracleCachedRowSet.class.getDeclaredMethod("setKeyColumns", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$212 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$211 = OracleCachedRowSet.class.getDeclaredMethod("getKeyColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$211 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$210 = OracleCachedRowSet.class.getDeclaredMethod("updateArray", String.class, Array.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$210 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$209 = OracleCachedRowSet.class.getDeclaredMethod("updateArray", Integer.TYPE, Array.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$209 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$208 = OracleCachedRowSet.class.getDeclaredMethod("updateClob", String.class, Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$208 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$207 = OracleCachedRowSet.class.getDeclaredMethod("updateClob", Integer.TYPE, Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$207 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$206 = OracleCachedRowSet.class.getDeclaredMethod("updateBlob", String.class, Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$206 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$205 = OracleCachedRowSet.class.getDeclaredMethod("updateBlob", Integer.TYPE, Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$205 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$204 = OracleCachedRowSet.class.getDeclaredMethod("updateRef", String.class, Ref.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$204 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$203 = OracleCachedRowSet.class.getDeclaredMethod("updateRef", Integer.TYPE, Ref.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$203 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$202 = OracleCachedRowSet.class.getDeclaredMethod("getURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$202 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$201 = OracleCachedRowSet.class.getDeclaredMethod("getURL", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$201 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$200 = OracleCachedRowSet.class.getDeclaredMethod("updateObject", String.class, Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$200 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$199 = OracleCachedRowSet.class.getDeclaredMethod("updateObject", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$199 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$198 = OracleCachedRowSet.class.getDeclaredMethod("updateTime", String.class, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$198 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$197 = OracleCachedRowSet.class.getDeclaredMethod("updateDate", String.class, java.sql.Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$197 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$196 = OracleCachedRowSet.class.getDeclaredMethod("updateBytes", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$196 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$195 = OracleCachedRowSet.class.getDeclaredMethod("updateString", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$195 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$194 = OracleCachedRowSet.class.getDeclaredMethod("updateBigDecimal", String.class, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$194 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$193 = OracleCachedRowSet.class.getDeclaredMethod("updateDouble", String.class, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$193 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$192 = OracleCachedRowSet.class.getDeclaredMethod("updateFloat", String.class, Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$192 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$191 = OracleCachedRowSet.class.getDeclaredMethod("updateLong", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$191 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$190 = OracleCachedRowSet.class.getDeclaredMethod("updateInt", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$190 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$189 = OracleCachedRowSet.class.getDeclaredMethod("updateShort", String.class, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$189 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$188 = OracleCachedRowSet.class.getDeclaredMethod("updateByte", String.class, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$188 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$187 = OracleCachedRowSet.class.getDeclaredMethod("updateBoolean", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$187 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$186 = OracleCachedRowSet.class.getDeclaredMethod("updateAsciiStream", String.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$186 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$185 = OracleCachedRowSet.class.getDeclaredMethod("updateNull", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$185 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$184 = OracleCachedRowSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$184 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$183 = OracleCachedRowSet.class.getDeclaredMethod("updateTime", Integer.TYPE, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$183 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$182 = OracleCachedRowSet.class.getDeclaredMethod("updateDate", Integer.TYPE, java.sql.Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$182 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$181 = OracleCachedRowSet.class.getDeclaredMethod("updateBytes", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$181 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$180 = OracleCachedRowSet.class.getDeclaredMethod("updateString", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$180 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$179 = OracleCachedRowSet.class.getDeclaredMethod("updateBigDecimal", Integer.TYPE, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$179 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$178 = OracleCachedRowSet.class.getDeclaredMethod("updateDouble", Integer.TYPE, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$178 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$177 = OracleCachedRowSet.class.getDeclaredMethod("updateFloat", Integer.TYPE, Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$177 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$176 = OracleCachedRowSet.class.getDeclaredMethod("updateLong", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$176 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$175 = OracleCachedRowSet.class.getDeclaredMethod("updateInt", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$175 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$174 = OracleCachedRowSet.class.getDeclaredMethod("updateShort", Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$174 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$173 = OracleCachedRowSet.class.getDeclaredMethod("updateByte", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$173 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$172 = OracleCachedRowSet.class.getDeclaredMethod("updateBoolean", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$172 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$171 = OracleCachedRowSet.class.getDeclaredMethod("updateTimestamp", Integer.TYPE, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$171 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$170 = OracleCachedRowSet.class.getDeclaredMethod("updateAsciiStream", Integer.TYPE, InputStream.class, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$170 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$169 = OracleCachedRowSet.class.getDeclaredMethod("updateAsciiStream", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$169 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$168 = OracleCachedRowSet.class.getDeclaredMethod("updateBinaryStream", Integer.TYPE, InputStream.class, Long.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$168 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$167 = OracleCachedRowSet.class.getDeclaredMethod("updateBinaryStream", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$167 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$166 = OracleCachedRowSet.class.getDeclaredMethod("updateBinaryStream", String.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$166 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$165 = OracleCachedRowSet.class.getDeclaredMethod("updateTimestamp", String.class, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$165 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$164 = OracleCachedRowSet.class.getDeclaredMethod("updateCharacterStream", String.class, Reader.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$164 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$163 = OracleCachedRowSet.class.getDeclaredMethod("updateCharacterStreamInternal", Integer.TYPE, Reader.class, Long.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$163 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$162 = OracleCachedRowSet.class.getDeclaredMethod("updateCharacterStream", Integer.TYPE, Reader.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$162 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$161 = OracleCachedRowSet.class.getDeclaredMethod("updateNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$161 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$160 = OracleCachedRowSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$160 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$159 = OracleCachedRowSet.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$159 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$158 = OracleCachedRowSet.class.getDeclaredMethod("getArray", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$158 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$157 = OracleCachedRowSet.class.getDeclaredMethod("getClob", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$157 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$156 = OracleCachedRowSet.class.getDeclaredMethod("getBlob", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$156 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$155 = OracleCachedRowSet.class.getDeclaredMethod("getRef", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$155 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$154 = OracleCachedRowSet.class.getDeclaredMethod("getObject", String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$154 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$153 = OracleCachedRowSet.class.getDeclaredMethod("getTimestamp", String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$153 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$152 = OracleCachedRowSet.class.getDeclaredMethod("getBigDecimal", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$152 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$151 = OracleCachedRowSet.class.getDeclaredMethod("getCharacterStream", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$151 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$150 = OracleCachedRowSet.class.getDeclaredMethod("getBinaryStream", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$150 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$149 = OracleCachedRowSet.class.getDeclaredMethod("getString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$149 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$148 = OracleCachedRowSet.class.getDeclaredMethod("getUnicodeStream", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$148 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$147 = OracleCachedRowSet.class.getDeclaredMethod("getAsciiStream", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$147 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$146 = OracleCachedRowSet.class.getDeclaredMethod("getDate", String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$146 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$145 = OracleCachedRowSet.class.getDeclaredMethod("getTime", String.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$145 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$144 = OracleCachedRowSet.class.getDeclaredMethod("getTimestamp", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$144 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$143 = OracleCachedRowSet.class.getDeclaredMethod("getTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$143 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$142 = OracleCachedRowSet.class.getDeclaredMethod("getDate", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$142 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$141 = OracleCachedRowSet.class.getDeclaredMethod("getBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$141 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$140 = OracleCachedRowSet.class.getDeclaredMethod("getBigDecimal", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$140 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$139 = OracleCachedRowSet.class.getDeclaredMethod("getDouble", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$139 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$138 = OracleCachedRowSet.class.getDeclaredMethod("getFloat", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$138 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$137 = OracleCachedRowSet.class.getDeclaredMethod("getLong", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$137 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$136 = OracleCachedRowSet.class.getDeclaredMethod("getInt", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$136 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$135 = OracleCachedRowSet.class.getDeclaredMethod("getShort", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$135 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$134 = OracleCachedRowSet.class.getDeclaredMethod("getByte", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$134 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$133 = OracleCachedRowSet.class.getDeclaredMethod("getBoolean", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$133 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$132 = OracleCachedRowSet.class.getDeclaredMethod("getObject", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$132 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$131 = OracleCachedRowSet.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$131 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$130 = OracleCachedRowSet.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$130 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$129 = OracleCachedRowSet.class.getDeclaredMethod("getUnicodeStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$129 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$128 = OracleCachedRowSet.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$128 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$127 = OracleCachedRowSet.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$127 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$126 = OracleCachedRowSet.class.getDeclaredMethod("getArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$126 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$125 = OracleCachedRowSet.class.getDeclaredMethod("getClob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$125 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$124 = OracleCachedRowSet.class.getDeclaredMethod("getBlob", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$124 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$123 = OracleCachedRowSet.class.getDeclaredMethod("getRef", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$123 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$122 = OracleCachedRowSet.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$121 = OracleCachedRowSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$120 = OracleCachedRowSet.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$119 = OracleCachedRowSet.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$118 = OracleCachedRowSet.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$117 = OracleCachedRowSet.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$116 = OracleCachedRowSet.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$115 = OracleCachedRowSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$114 = OracleCachedRowSet.class.getDeclaredMethod("getBigDecimal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$113 = OracleCachedRowSet.class.getDeclaredMethod("getDouble", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$112 = OracleCachedRowSet.class.getDeclaredMethod("getFloat", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$111 = OracleCachedRowSet.class.getDeclaredMethod("getLong", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$110 = OracleCachedRowSet.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$109 = OracleCachedRowSet.class.getDeclaredMethod("getShort", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$108 = OracleCachedRowSet.class.getDeclaredMethod("getByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$107 = OracleCachedRowSet.class.getDeclaredMethod("getBoolean", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$106 = OracleCachedRowSet.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$105 = OracleCachedRowSet.class.getDeclaredMethod("getNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$104 = OracleCachedRowSet.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$103 = OracleCachedRowSet.class.getDeclaredMethod("setURL", Integer.TYPE, URL.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$102 = OracleCachedRowSet.class.getDeclaredMethod("setDate", Integer.TYPE, java.sql.Date.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$101 = OracleCachedRowSet.class.getDeclaredMethod("setObject", Integer.TYPE, Object.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$100 = OracleCachedRowSet.class.getDeclaredMethod("setObject", Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$99 = OracleCachedRowSet.class.getDeclaredMethod("setCharacterStream", Integer.TYPE, Reader.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$98 = OracleCachedRowSet.class.getDeclaredMethod("setUnicodeStream", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$97 = OracleCachedRowSet.class.getDeclaredMethod("setAsciiStream", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$96 = OracleCachedRowSet.class.getDeclaredMethod("setTimestamp", Integer.TYPE, Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$95 = OracleCachedRowSet.class.getDeclaredMethod("setTimestamp", Integer.TYPE, Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$94 = OracleCachedRowSet.class.getDeclaredMethod("setTime", Integer.TYPE, Time.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$93 = OracleCachedRowSet.class.getDeclaredMethod("setBinaryStream", Integer.TYPE, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$92 = OracleCachedRowSet.class.getDeclaredMethod("setArray", Integer.TYPE, Array.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$91 = OracleCachedRowSet.class.getDeclaredMethod("setClob", Integer.TYPE, Clob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$90 = OracleCachedRowSet.class.getDeclaredMethod("setBlob", Integer.TYPE, Blob.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$89 = OracleCachedRowSet.class.getDeclaredMethod("setRef", Integer.TYPE, Ref.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$88 = OracleCachedRowSet.class.getDeclaredMethod("setObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$87 = OracleCachedRowSet.class.getDeclaredMethod("setTime", Integer.TYPE, Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$86 = OracleCachedRowSet.class.getDeclaredMethod("setDate", Integer.TYPE, java.sql.Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$85 = OracleCachedRowSet.class.getDeclaredMethod("setBytes", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$84 = OracleCachedRowSet.class.getDeclaredMethod("setString", Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$83 = OracleCachedRowSet.class.getDeclaredMethod("setBigDecimal", Integer.TYPE, BigDecimal.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$82 = OracleCachedRowSet.class.getDeclaredMethod("setDouble", Integer.TYPE, Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$81 = OracleCachedRowSet.class.getDeclaredMethod("setFloat", Integer.TYPE, Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$80 = OracleCachedRowSet.class.getDeclaredMethod("setLong", Integer.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$79 = OracleCachedRowSet.class.getDeclaredMethod("setInt", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$78 = OracleCachedRowSet.class.getDeclaredMethod("setShort", Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$77 = OracleCachedRowSet.class.getDeclaredMethod("setByte", Integer.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$76 = OracleCachedRowSet.class.getDeclaredMethod("setBoolean", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$75 = OracleCachedRowSet.class.getDeclaredMethod("setNull", Integer.TYPE, Integer.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = OracleCachedRowSet.class.getDeclaredMethod("setNull", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = OracleCachedRowSet.class.getDeclaredMethod("getOriginal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = OracleCachedRowSet.class.getDeclaredMethod("getOriginalRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = OracleCachedRowSet.class.getDeclaredMethod("rowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = OracleCachedRowSet.class.getDeclaredMethod("rowInserted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = OracleCachedRowSet.class.getDeclaredMethod("rowUpdated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = OracleCachedRowSet.class.getDeclaredMethod("moveToCurrentRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = OracleCachedRowSet.class.getDeclaredMethod("moveToInsertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = OracleCachedRowSet.class.getDeclaredMethod("refreshRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = OracleCachedRowSet.class.getDeclaredMethod("deleteRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = OracleCachedRowSet.class.getDeclaredMethod("updateRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = OracleCachedRowSet.class.getDeclaredMethod("insertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OracleCachedRowSet.class.getDeclaredMethod("cancelRowUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OracleCachedRowSet.class.getDeclaredMethod("cancelRowDelete", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OracleCachedRowSet.class.getDeclaredMethod("cancelRowInsert", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OracleCachedRowSet.class.getDeclaredMethod("getRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OracleCachedRowSet.class.getDeclaredMethod("toCollection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OracleCachedRowSet.class.getDeclaredMethod("toCollection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OracleCachedRowSet.class.getDeclaredMethod("toCollection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OracleCachedRowSet.class.getDeclaredMethod("restoreOriginal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OracleCachedRowSet.class.getDeclaredMethod("release", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleCachedRowSet.class.getDeclaredMethod("createShared", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleCachedRowSet.class.getDeclaredMethod("createCopy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleCachedRowSet.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleCachedRowSet.class.getDeclaredMethod("acceptChanges", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleCachedRowSet.class.getDeclaredMethod("acceptChanges", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleCachedRowSet.class.getDeclaredMethod("execute", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleCachedRowSet.class.getDeclaredMethod("setMetaData", RowSetMetaData.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleCachedRowSet.class.getDeclaredMethod("getParams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleCachedRowSet.class.getDeclaredMethod("findColumn", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleCachedRowSet.class.getDeclaredMethod("getMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleCachedRowSet.class.getDeclaredMethod("clearWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleCachedRowSet.class.getDeclaredMethod("getWarnings", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleCachedRowSet.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleCachedRowSet.class.getDeclaredMethod("wasNull", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleCachedRowSet.class.getDeclaredMethod("clearParameters", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleCachedRowSet.class.getDeclaredMethod("getCursorName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleCachedRowSet.class.getDeclaredMethod("populate", ResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleCachedRowSet.class.getDeclaredMethod("relative", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleCachedRowSet.class.getDeclaredMethod("absolute", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleCachedRowSet.class.getDeclaredMethod("last", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleCachedRowSet.class.getDeclaredMethod("first", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleCachedRowSet.class.getDeclaredMethod("afterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleCachedRowSet.class.getDeclaredMethod("beforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleCachedRowSet.class.getDeclaredMethod("isLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleCachedRowSet.class.getDeclaredMethod("isFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleCachedRowSet.class.getDeclaredMethod("isAfterLast", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleCachedRowSet.class.getDeclaredMethod("isBeforeFirst", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleCachedRowSet.class.getDeclaredMethod("previous", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleCachedRowSet.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleCachedRowSet.class.getDeclaredMethod("setOriginalRowInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleCachedRowSet.class.getDeclaredMethod("setOriginal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleCachedRowSet.class.getDeclaredMethod("isConnectionStayingOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleCachedRowSet.class.getDeclaredMethod("getCurrentPage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleCachedRowSet.class.getDeclaredMethod("isExecuteCalled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleCachedRowSet.class.getDeclaredMethod("getCurrentRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleCachedRowSet.class.getDeclaredMethod("checkAndFilterObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleCachedRowSet.class.getDeclaredMethod("notifyCursorMoved", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleCachedRowSet.class.getDeclaredMethod("isStreamType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleCachedRowSet.class.getDeclaredMethod("getSessionCalendar", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleCachedRowSet.class.getDeclaredMethod("getStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleCachedRowSet.class.getDeclaredMethod("populateInit", ResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleCachedRowSet.class.getDeclaredMethod("checkParamIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleCachedRowSet.class.getDeclaredMethod("isUpdated", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleCachedRowSet.class.getDeclaredMethod("checkColumnIndex", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleCachedRowSet.class.getDeclaredMethod("getColumnIndex", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleCachedRowSet.class.getDeclaredMethod("setWriter", RowSetWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleCachedRowSet.class.getDeclaredMethod("setReader", RowSetReader.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleCachedRowSet.class.getDeclaredMethod("setCommand", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleCachedRowSet.class.getDeclaredMethod("setFetchDirection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleCachedRowSet.class.getDeclaredMethod("getWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleCachedRowSet.class.getDeclaredMethod("getReader", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleCachedRowSet.class.getDeclaredMethod("getStatement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleCachedRowSet.class.getDeclaredMethod("getConnectionInternal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleCachedRowSet.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

