/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.net.ssl.SSLContext;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY, Feature.CONN_POOL})
public class OracleDataSource
implements oracle.jdbc.datasource.OracleDataSource,
Serializable,
Referenceable {
    static final long serialVersionUID = 3349652938965166731L;
    protected static int unnamedInstanceCount;
    protected static final String DMS_ROOT_NAME = "JDBC";
    protected static final String DMS_DEFAULT_DATASOURCE_NAME = "OracleDataSource";
    protected static final String DEFAULT_SERVICE_NAME = "SYS$USERS";
    protected PrintWriter logWriter = null;
    protected int loginTimeout = 0;
    protected String databaseName = null;
    protected String serviceName = null;
    protected String dataSourceName = "OracleDataSource";
    protected String description = null;
    protected String networkProtocol = "tcp";
    protected int portNumber = 0;
    protected String user = null;
    protected OpaqueString password = null;
    protected String serverName = null;
    protected String url = null;
    protected String driverType = null;
    protected String tnsEntry = null;
    protected int maxStatements = 0;
    protected boolean implicitCachingEnabled = false;
    protected boolean explicitCachingEnabled = false;
    protected boolean maxStatementsSet = false;
    protected boolean implicitCachingEnabledSet = false;
    protected boolean explicitCachingEnabledSet = false;
    protected transient OracleImplicitConnectionCache odsCache = null;
    protected transient OracleConnectionCacheManager cacheManager = null;
    protected String connCacheName = null;
    protected Properties connCacheProperties = null;
    protected Properties connectionProperties = null;
    protected boolean connCachingEnabled = false;
    protected boolean fastConnFailover = false;
    protected String onsConfigStr = null;
    public boolean isOracleDataSource = true;
    private String roleName = null;
    private static final boolean fastConnectionFailoverSysProperty;
    private boolean urlExplicit = false;
    private boolean useDefaultConnection = false;
    protected transient OracleDriver driver = new OracleDriver();
    private SSLContext sslContext;
    protected static final String ENABLE_AC_SUPPORT_PROPERTY = "oracle.jdbc.enableACSupport";
    private Supplier<? extends AccessToken> tokenSupplier;
    private static final String spawnNewThreadToCancelProperty = "oracle.jdbc.spawnNewThreadToCancel";
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sun_Oct_31_02:49:17_PDT_2021";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;

    protected static String dms_data_source_type() {
        return "JDBC_DataSource";
    }

    public OracleDataSource() throws SQLException {
        this.setConnectionProperty(ENABLE_AC_SUPPORT_PROPERTY, "false");
        this.processFastConnectionFailoverSysProperty();
    }

    void processFastConnectionFailoverSysProperty() {
        if (this.isOracleDataSource && fastConnectionFailoverSysProperty) {
            this.connCachingEnabled = true;
            if (this.cacheManager == null) {
                try {
                    this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
                catch (SQLException sQLException) {
                }
            }
            this.fastConnFailover = true;
            this.setSpawnNewThreadToCancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        String string = null;
        OpaqueString opaqueString = null;
        Object object = this;
        synchronized (object) {
            string = this.user;
            opaqueString = this.password;
        }
        object = null;
        if (opaqueString != null) {
            object = opaqueString.get();
        }
        return this.getConnection(string, (String)object);
    }

    @Override
    public Connection getConnection(String string, @Blind String string2) throws SQLException {
        Connection connection = null;
        connection = this.connCachingEnabled ? this.getConnection(string, string2, null) : this.getConnection(this.createConnectionBuilder().user(string).password(string2));
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        Connection connection = null;
        Properties properties = null;
        OracleDataSource oracleDataSource = this;
        synchronized (oracleDataSource) {
            String string;
            if (oracleConnectionBuilderImpl.getGSSCredential() != null && (oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null)) {
                throw (SQLException)DatabaseError.createSqlException(68, "GSSCredential and user/password cannot both be set in a connection builder.").fillInStackTrace();
            }
            this.makeURL();
            Properties properties2 = properties = this.connectionProperties == null ? new Properties() : (Properties)this.connectionProperties.clone();
            if (this.url != null) {
                properties.setProperty("connection_url", this.url);
            }
            if (oracleConnectionBuilderImpl.getUser() != null && oracleConnectionBuilderImpl.getPassword() != null) {
                properties.setProperty("user", oracleConnectionBuilderImpl.getUser());
                properties.setProperty("password", oracleConnectionBuilderImpl.getPassword());
            }
            if (this.loginTimeout != 0) {
                properties.setProperty("LoginTimeout", "" + this.loginTimeout);
            }
            if (this.maxStatementsSet) {
                properties.setProperty("stmt_cache_size", "" + this.maxStatements);
            }
            if (oracleConnectionBuilderImpl.getInstanceName() != null) {
                properties.setProperty("oracle.jdbc.targetInstanceName", oracleConnectionBuilderImpl.getInstanceName());
            }
            if (oracleConnectionBuilderImpl.getServiceName() != null && !oracleConnectionBuilderImpl.getServiceName().equalsIgnoreCase(DEFAULT_SERVICE_NAME)) {
                properties.setProperty("oracle.jdbc.targetServiceName", oracleConnectionBuilderImpl.getServiceName());
            }
            if (oracleConnectionBuilderImpl.getShardingKey() != null) {
                string = oracleConnectionBuilderImpl.getShardingKey().encodeKeyinB64Format();
                properties.setProperty("oracle.jdbc.targetShardingKey", string);
            }
            if (oracleConnectionBuilderImpl.getSuperShardingKey() != null) {
                string = oracleConnectionBuilderImpl.getSuperShardingKey().encodeKeyinB64Format();
                properties.setProperty("oracle.jdbc.targetSuperShardingKey", string);
            }
        }
        this.applyDataSourcePropertiesToBuilder(oracleConnectionBuilderImpl);
        connection = this.getPhysicalConnection(properties, oracleConnectionBuilderImpl.getGSSCredential(), oracleConnectionBuilderImpl.getSSLContext(), oracleConnectionBuilderImpl.getTokenSupplier());
        if (connection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        return connection;
    }

    private void applyDataSourcePropertiesToBuilder(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        if (oracleConnectionBuilderImpl == null) {
            return;
        }
        if (this.sslContext != null && oracleConnectionBuilderImpl.getSSLContext() == null) {
            oracleConnectionBuilderImpl.sslContext(this.sslContext);
        }
        this.configureTokenSupplier(oracleConnectionBuilderImpl);
    }

    private void configureTokenSupplier(OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        Supplier<? extends AccessToken> supplier = this.tokenSupplier;
        if (supplier == null) {
            return;
        }
        if (this.isUserOrPasswordConfigured()) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "DataSource configured with a token supplying function is also configured with a user name or password").fillInStackTrace();
        }
        if (oracleConnectionBuilderImpl == null || oracleConnectionBuilderImpl.getTokenSupplier() != null || oracleConnectionBuilderImpl.getUser() != null || oracleConnectionBuilderImpl.getPassword() != null) {
            return;
        }
        oracleConnectionBuilderImpl.setTokenSupplier(supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserOrPasswordConfigured() {
        OracleDataSource oracleDataSource = this;
        synchronized (oracleDataSource) {
            return this.user != null || this.password != null && !this.password.isNull() || this.connectionProperties != null && (this.connectionProperties.containsKey("user") || this.connectionProperties.containsKey("oracle.jdbc.user") || this.connectionProperties.containsKey("password") || this.connectionProperties.containsKey("oracle.jdbc.password"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getPhysicalConnection(Properties properties, GSSCredential gSSCredential, SSLContext sSLContext, Supplier<? extends AccessToken> supplier) throws SQLException {
        Connection connection = null;
        Properties properties2 = properties;
        String string = properties.getProperty("connection_url");
        String string2 = properties.getProperty("user");
        String string3 = properties2.getProperty("password");
        String string4 = properties2.getProperty("oracle.jdbc.targetInstanceName");
        String string5 = properties2.getProperty("oracle.jdbc.targetServiceName");
        String string6 = properties2.getProperty("oracle.jdbc.targetShardingKey");
        String string7 = properties2.getProperty("oracle.jdbc.targetSuperShardingKey");
        String string8 = null;
        boolean bl = false;
        OracleDataSource oracleDataSource = this;
        synchronized (oracleDataSource) {
            String string9;
            if (this.connectionProperties != null) {
                properties2 = (Properties)this.connectionProperties.clone();
                if (string2 != null) {
                    properties2.put("user", string2);
                }
                if (string3 != null) {
                    properties2.put("password", string3);
                }
                if (string4 != null) {
                    properties2.put("oracle.jdbc.targetInstanceName", string4);
                }
                if (string5 != null) {
                    properties2.put("oracle.jdbc.targetServiceName", string5);
                }
                if (string6 != null) {
                    properties2.put("oracle.jdbc.targetShardingKey", string6);
                }
                if (string7 != null) {
                    properties2.put("oracle.jdbc.targetSuperShardingKey", string7);
                }
            }
            if (gSSCredential == null) {
                if (string2 == null && this.user != null) {
                    properties2.put("user", this.user);
                }
                if (string3 == null && this.password != null && this.password.get() != null) {
                    properties2.put("password", this.password.get());
                }
            }
            if (string == null) {
                string = this.url;
            }
            if ((string9 = properties.getProperty("LoginTimeout")) != null) {
                properties2.put("oracle.net.CONNECT_TIMEOUT", "" + Integer.parseInt(string9) * 1000);
            }
            bl = this.useDefaultConnection;
            if (this.driver == null) {
                this.driver = new OracleDriver();
            }
            Object object = this.dataSourceName == null || this.dataSourceName.length() == 0 ? "OracleDataSource_" + unnamedInstanceCount++ : this.dataSourceName;
            properties2.setProperty("DMSName", (String)object);
            properties2.setProperty("DMSType", OracleDataSource.dms_data_source_type());
        }
        connection = bl ? this.driver.defaultConnection() : this.driver.connect(string, properties2, gSSCredential, sSLContext != null ? sSLContext : this.sslContext, supplier != null ? supplier : this.tokenSupplier);
        if (connection == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        string8 = properties.getProperty("stmt_cache_size");
        int n2 = 0;
        if (string8 != null) {
            n2 = Integer.parseInt(string8);
            ((OracleConnection)connection).setStatementCacheSize(n2);
        }
        boolean bl2 = false;
        string8 = properties.getProperty("ExplicitStatementCachingEnabled");
        if (string8 != null) {
            bl2 = string8.equals("true");
            ((OracleConnection)connection).setExplicitCachingEnabled(bl2);
        } else if (this.explicitCachingEnabled) {
            ((OracleConnection)connection).setExplicitCachingEnabled(true);
        }
        boolean bl3 = false;
        string8 = properties.getProperty("ImplicitStatementCachingEnabled");
        if (string8 != null) {
            bl3 = string8.equals("true");
            ((OracleConnection)connection).setImplicitCachingEnabled(bl3);
        } else if (this.implicitCachingEnabled) {
            ((OracleConnection)connection).setImplicitCachingEnabled(true);
        }
        if (n2 > 0 && !bl2 && !bl3) {
            ((OracleConnection)connection).setImplicitCachingEnabled(true);
            ((OracleConnection)connection).setExplicitCachingEnabled(true);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Properties properties) throws SQLException {
        String string = null;
        OpaqueString opaqueString = null;
        Object object = this;
        synchronized (object) {
            if (!this.connCachingEnabled) {
                throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
            }
            string = this.user;
            opaqueString = this.password;
        }
        object = null;
        if (opaqueString != null) {
            object = opaqueString.get();
        }
        Connection connection = this.getConnection(string, (String)object, properties);
        return connection;
    }

    public Connection getConnection(String string, @Blind String string2, Properties properties) throws SQLException {
        if (!this.connCachingEnabled) {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
        if (this.odsCache == null) {
            this.cacheInitialize();
        }
        Connection connection = this.odsCache.getConnection(string, string2, properties);
        return connection;
    }

    private synchronized void cacheInitialize() throws SQLException {
        if (this.odsCache == null) {
            if (this.connCacheName != null) {
                this.cacheManager.createCache(this.connCacheName, this, this.connCacheProperties);
            } else {
                this.connCacheName = this.cacheManager.createCache(this, this.connCacheProperties);
            }
        }
    }

    public synchronized void close() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            this.cacheManager.removeCache(this.odsCache.cacheName, 0L);
            this.odsCache = null;
        }
    }

    public synchronized void setConnectionCachingEnabled(boolean bl) throws SQLException {
        if (this.isOracleDataSource) {
            if (bl) {
                this.connCachingEnabled = true;
                if (this.cacheManager == null) {
                    this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
                }
            } else if (this.odsCache == null) {
                this.connCachingEnabled = false;
                this.fastConnFailover = false;
                this.setSpawnNewThreadToCancel(false);
                this.connCacheName = null;
                this.connCacheProperties = null;
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
    }

    public boolean getConnectionCachingEnabled() throws SQLException {
        return this.connCachingEnabled;
    }

    public synchronized void setConnectionCacheName(String string) throws SQLException {
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(138).fillInStackTrace();
        }
        this.connCacheName = string;
    }

    public String getConnectionCacheName() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            return this.odsCache.cacheName;
        }
        return this.connCacheName;
    }

    public synchronized void setConnectionCacheProperties(Properties properties) throws SQLException {
        this.connCacheProperties = properties;
    }

    public Properties getConnectionCacheProperties() throws SQLException {
        if (this.connCachingEnabled && this.odsCache != null) {
            return this.odsCache.getConnectionCacheProperties();
        }
        return this.connCacheProperties;
    }

    public synchronized void setFastConnectionFailoverEnabled(boolean bl) throws SQLException {
        if (!this.fastConnFailover) {
            this.fastConnFailover = bl;
            this.setSpawnNewThreadToCancel(bl);
        } else if (!bl) {
            throw (SQLException)DatabaseError.createSqlException(255).fillInStackTrace();
        }
    }

    public boolean getFastConnectionFailoverEnabled() throws SQLException {
        return this.fastConnFailover;
    }

    public String getONSConfiguration() throws SQLException {
        return this.onsConfigStr;
    }

    public synchronized void setONSConfiguration(String string) throws SQLException {
        this.onsConfigStr = string;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public synchronized void setLoginTimeout(int n2) {
        this.loginTimeout = n2;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public synchronized void setTNSEntryName(String string) {
        this.tnsEntry = string;
    }

    public synchronized String getTNSEntryName() {
        return this.tnsEntry;
    }

    @Override
    public synchronized void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    @Override
    public synchronized String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public synchronized String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public synchronized void setServiceName(String string) {
        this.serviceName = string;
    }

    public synchronized String getServiceName() {
        return this.serviceName;
    }

    @Override
    public synchronized void setServerName(String string) {
        this.serverName = string;
    }

    @Override
    public synchronized String getServerName() {
        return this.serverName;
    }

    @Override
    public synchronized void setURL(String string) {
        this.url = string;
        if (this.url != null) {
            this.urlExplicit = true;
        }
        if (this.connCachingEnabled && this.odsCache != null && this.odsCache.connectionPoolDS != null) {
            this.odsCache.connectionPoolDS.url = string;
        }
    }

    @Override
    public synchronized String getURL() throws SQLException {
        if (!this.urlExplicit) {
            this.makeURL();
        }
        return this.url;
    }

    @Override
    public synchronized void setUser(String string) {
        this.user = string;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    private synchronized void setPassword(OpaqueString opaqueString) {
        this.password = opaqueString;
    }

    @Override
    public synchronized void setPassword(@Blind String string) {
        this.setPassword(OpaqueString.newOpaqueString(string));
    }

    @Blind
    protected String getPassword() {
        return this.password != null ? this.password.get() : null;
    }

    @Override
    public synchronized String getDescription() {
        return this.description;
    }

    @Override
    public synchronized void setDescription(String string) {
        this.description = string;
    }

    public synchronized String getDriverType() {
        return this.driverType;
    }

    public synchronized void setDriverType(String string) {
        this.driverType = string;
    }

    @Override
    public synchronized String getNetworkProtocol() {
        return this.networkProtocol;
    }

    @Override
    public synchronized void setNetworkProtocol(String string) throws SQLException {
        this.networkProtocol = string;
    }

    @Override
    public synchronized void setPortNumber(int n2) {
        this.portNumber = n2;
    }

    @Override
    public synchronized int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
        this.addRefProperties(reference);
        return reference;
    }

    protected void addRefProperties(Reference reference) {
        if (this.url != null) {
            reference.add(new StringRefAddr("url", this.url));
        }
        if (this.user != null) {
            reference.add(new StringRefAddr("userName", this.user));
        }
        if (this.password != null && !this.password.isNull()) {
            reference.add(new StringRefAddr("passWord", this.password.get()));
        }
        if (this.description != null) {
            reference.add(new StringRefAddr("description", this.description));
        }
        if (this.driverType != null) {
            reference.add(new StringRefAddr("driverType", this.driverType));
        }
        if (this.serverName != null) {
            reference.add(new StringRefAddr("serverName", this.serverName));
        }
        if (this.databaseName != null) {
            reference.add(new StringRefAddr("databaseName", this.databaseName));
        }
        if (this.serviceName != null) {
            reference.add(new StringRefAddr("serviceName", this.serviceName));
        }
        if (this.networkProtocol != null) {
            reference.add(new StringRefAddr("networkProtocol", this.networkProtocol));
        }
        if (this.portNumber != 0) {
            reference.add(new StringRefAddr("portNumber", Integer.toString(this.portNumber)));
        }
        if (this.tnsEntry != null) {
            reference.add(new StringRefAddr("tnsentryname", this.tnsEntry));
        }
        if (this.maxStatementsSet) {
            reference.add(new StringRefAddr("maxStatements", Integer.toString(this.maxStatements)));
        }
        if (this.implicitCachingEnabledSet) {
            reference.add(new StringRefAddr("implicitCachingEnabled", this.implicitCachingEnabled ? "true" : "false"));
        }
        if (this.explicitCachingEnabledSet) {
            reference.add(new StringRefAddr("explicitCachingEnabled", this.explicitCachingEnabled ? "true" : "false"));
        }
        if (this.connCachingEnabled) {
            reference.add(new StringRefAddr("connectionCachingEnabled", "true"));
        }
        if (this.connCacheName != null) {
            reference.add(new StringRefAddr("connectionCacheName", this.connCacheName));
        }
        if (this.connCacheProperties != null) {
            reference.add(new StringRefAddr("connectionCacheProperties", this.connCacheProperties.toString()));
        }
        if (this.fastConnFailover) {
            reference.add(new StringRefAddr("fastConnectionFailoverEnabled", "true"));
        }
        if (this.onsConfigStr != null) {
            reference.add(new StringRefAddr("onsConfigStr", this.onsConfigStr));
        }
    }

    void makeURL() throws SQLException {
        if (this.urlExplicit) {
            return;
        }
        if (this.driverType == null || !this.driverType.equals("oci8") && !this.driverType.equals("oci") && !this.driverType.equals("thin") && !this.driverType.equals("kprb")) {
            throw (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
        }
        if (this.driverType.equals("kprb")) {
            this.useDefaultConnection = true;
            this.url = "jdbc:oracle:kprb:@";
            return;
        }
        if ((this.driverType.equals("oci8") || this.driverType.equals("oci")) && this.networkProtocol != null && this.networkProtocol.equals("ipc")) {
            this.url = "jdbc:oracle:oci:@";
            return;
        }
        if (this.tnsEntry != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@" + this.tnsEntry;
            return;
        }
        if (this.serviceName != null) {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")))";
        } else {
            this.url = "jdbc:oracle:" + this.driverType + ":@(DESCRIPTION=(ADDRESS=(PROTOCOL=" + this.networkProtocol + ")(PORT=" + this.portNumber + ")(HOST=" + this.serverName + "))(CONNECT_DATA=(SID=" + this.databaseName + ")))";
            DatabaseError.addSqlWarning(null, new SQLWarning("URL with SID jdbc:subprotocol:@host:port:sid will be deprecated in 10i\nPlease use URL with SERVICE_NAME as jdbc:subprotocol:@//host:port/service_name"));
            if (this.fastConnFailover) {
                throw (SQLException)DatabaseError.createSqlException(67, "OracleDataSource.makeURL").fillInStackTrace();
            }
        }
    }

    protected void trace(String string) {
        if (this.logWriter != null) {
        }
    }

    protected void copy(OracleDataSource oracleDataSource) throws SQLException {
        oracleDataSource.setUser(this.user);
        oracleDataSource.setPassword(this.password);
        oracleDataSource.setTNSEntryName(this.tnsEntry);
        this.makeURL();
        oracleDataSource.setURL(this.url);
        if (this.loginTimeout > 0) {
            oracleDataSource.setLoginTimeout(this.loginTimeout);
        }
        oracleDataSource.connectionProperties = this.connectionProperties;
    }

    @Override
    public void setMaxStatements(int n2) throws SQLException {
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        this.maxStatementsSet = true;
        this.maxStatements = n2;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return this.maxStatements;
    }

    @Override
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        this.implicitCachingEnabledSet = true;
        this.implicitCachingEnabled = bl;
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.implicitCachingEnabled;
    }

    @Override
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        this.explicitCachingEnabledSet = true;
        this.explicitCachingEnabled = bl;
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.explicitCachingEnabled;
    }

    @Override
    public void setConnectionProperties(Properties properties) throws SQLException {
        this.connectionProperties = properties == null ? properties : (Properties)properties.clone();
        this.setSpawnNewThreadToCancel(this.fastConnFailover);
    }

    protected String getConnectionProperty(String string) throws SQLException {
        return this.connectionProperties == null ? null : this.connectionProperties.getProperty(string);
    }

    protected void setConnectionProperty(String string, String string2) throws SQLException {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException();
        }
        if (this.connectionProperties == null) {
            this.connectionProperties = new Properties();
        }
        this.connectionProperties.setProperty(string, string2);
    }

    @Override
    public void setRoleName(String string) throws SQLException {
        this.roleName = string;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public Properties getConnectionProperties() throws SQLException {
        return OracleDataSource.filterConnectionProperties(this.connectionProperties);
    }

    public static final Properties filterConnectionProperties(Properties properties) {
        Properties properties2 = null;
        if (properties != null) {
            properties2 = (Properties)properties.clone();
            Enumeration<?> enumeration = properties2.propertyNames();
            Object var3_3 = null;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string == null || !string.matches(".*[P,p][A,a][S,s][S,s][W,w][O,o][R,r][D,d].*")) continue;
                properties2.remove(string);
            }
            properties.remove(spawnNewThreadToCancelProperty);
        }
        return properties2;
    }

    private void setSpawnNewThreadToCancel(boolean bl) {
        if (bl) {
            if (this.connectionProperties == null) {
                this.connectionProperties = new Properties();
            }
            this.connectionProperties.setProperty(spawnNewThreadToCancelProperty, "true");
        } else if (this.connectionProperties != null) {
            this.connectionProperties.remove(spawnNewThreadToCancelProperty);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, SQLException {
        objectInputStream.defaultReadObject();
        if (this.connCachingEnabled) {
            this.setConnectionCachingEnabled(this.connCachingEnabled);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("oracle");
    }

    @Override
    public final synchronized void setSSLContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public OracleConnectionBuilderImpl createConnectionBuilder() {
        return new OracleConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public OracleConnection build() throws SQLException {
                this.verifyBuildConfiguration();
                return (OracleConnection)OracleDataSource.this.getConnection(this);
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(OracleDataSource.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        };
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    @Override
    public final void setTokenSupplier(Supplier<? extends AccessToken> supplier) {
        this.tokenSupplier = Objects.requireNonNull(supplier, "tokenSuplier is null");
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$83 = OracleDataSource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$82 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$81 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$80 = OracleDataSource.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$79 = OracleDataSource.class.getDeclaredMethod("setTokenSupplier", Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$78 = OracleDataSource.class.getDeclaredMethod("createConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$77 = OracleDataSource.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$76 = OracleDataSource.class.getDeclaredMethod("setSSLContext", SSLContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$75 = OracleDataSource.class.getDeclaredMethod("getParentLogger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$74 = OracleDataSource.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$73 = OracleDataSource.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$72 = OracleDataSource.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$71 = OracleDataSource.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$70 = OracleDataSource.class.getDeclaredMethod("setSpawnNewThreadToCancel", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$69 = OracleDataSource.class.getDeclaredMethod("filterConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$68 = OracleDataSource.class.getDeclaredMethod("getConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$67 = OracleDataSource.class.getDeclaredMethod("getRoleName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$66 = OracleDataSource.class.getDeclaredMethod("setRoleName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = OracleDataSource.class.getDeclaredMethod("setConnectionProperty", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = OracleDataSource.class.getDeclaredMethod("getConnectionProperty", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = OracleDataSource.class.getDeclaredMethod("setConnectionProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = OracleDataSource.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = OracleDataSource.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = OracleDataSource.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = OracleDataSource.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = OracleDataSource.class.getDeclaredMethod("getMaxStatements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = OracleDataSource.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = OracleDataSource.class.getDeclaredMethod("copy", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = OracleDataSource.class.getDeclaredMethod("trace", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = OracleDataSource.class.getDeclaredMethod("makeURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = OracleDataSource.class.getDeclaredMethod("addRefProperties", Reference.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = OracleDataSource.class.getDeclaredMethod("getReference", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = OracleDataSource.class.getDeclaredMethod("getPortNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = OracleDataSource.class.getDeclaredMethod("setPortNumber", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = OracleDataSource.class.getDeclaredMethod("setNetworkProtocol", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = OracleDataSource.class.getDeclaredMethod("getNetworkProtocol", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = OracleDataSource.class.getDeclaredMethod("setDriverType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = OracleDataSource.class.getDeclaredMethod("getDriverType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = OracleDataSource.class.getDeclaredMethod("setDescription", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = OracleDataSource.class.getDeclaredMethod("getDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = OracleDataSource.class.getDeclaredMethod("getPassword", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = OracleDataSource.class.getDeclaredMethod("setPassword", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = OracleDataSource.class.getDeclaredMethod("setPassword", OpaqueString.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = OracleDataSource.class.getDeclaredMethod("getUser", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = OracleDataSource.class.getDeclaredMethod("setUser", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = OracleDataSource.class.getDeclaredMethod("getURL", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = OracleDataSource.class.getDeclaredMethod("setURL", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = OracleDataSource.class.getDeclaredMethod("getServerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = OracleDataSource.class.getDeclaredMethod("setServerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = OracleDataSource.class.getDeclaredMethod("getServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = OracleDataSource.class.getDeclaredMethod("setServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = OracleDataSource.class.getDeclaredMethod("setDatabaseName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = OracleDataSource.class.getDeclaredMethod("getDatabaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = OracleDataSource.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleDataSource.class.getDeclaredMethod("setDataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleDataSource.class.getDeclaredMethod("getTNSEntryName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleDataSource.class.getDeclaredMethod("setTNSEntryName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleDataSource.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleDataSource.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleDataSource.class.getDeclaredMethod("setLoginTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleDataSource.class.getDeclaredMethod("getLoginTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleDataSource.class.getDeclaredMethod("setONSConfiguration", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleDataSource.class.getDeclaredMethod("getONSConfiguration", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleDataSource.class.getDeclaredMethod("getFastConnectionFailoverEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleDataSource.class.getDeclaredMethod("setFastConnectionFailoverEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleDataSource.class.getDeclaredMethod("getConnectionCacheProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleDataSource.class.getDeclaredMethod("setConnectionCacheProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleDataSource.class.getDeclaredMethod("getConnectionCacheName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleDataSource.class.getDeclaredMethod("setConnectionCacheName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleDataSource.class.getDeclaredMethod("getConnectionCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleDataSource.class.getDeclaredMethod("setConnectionCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleDataSource.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleDataSource.class.getDeclaredMethod("cacheInitialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleDataSource.class.getDeclaredMethod("getConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleDataSource.class.getDeclaredMethod("getConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleDataSource.class.getDeclaredMethod("getPhysicalConnection", Properties.class, GSSCredential.class, SSLContext.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleDataSource.class.getDeclaredMethod("isUserOrPasswordConfigured", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleDataSource.class.getDeclaredMethod("configureTokenSupplier", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleDataSource.class.getDeclaredMethod("applyDataSourcePropertiesToBuilder", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleDataSource.class.getDeclaredMethod("getConnection", OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleDataSource.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleDataSource.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleDataSource.class.getDeclaredMethod("processFastConnectionFailoverSysProperty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleDataSource.class.getDeclaredMethod("dms_data_source_type", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        unnamedInstanceCount = 0;
        fastConnectionFailoverSysProperty = "true".equalsIgnoreCase(OracleDriver.getSystemPropertyFastConnectionFailover("false"));
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleDataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

