/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.jdbc.driver.HAManager;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.FanUpEventListener;
import oracle.simplefan.LoadAdvisoryEvent;
import oracle.simplefan.NodeDownEvent;
import oracle.simplefan.NodeUpEvent;
import oracle.simplefan.ServiceDownEvent;
import oracle.simplefan.ServiceUpEvent;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY})
final class HAFanListener
implements FanEventListener,
FanUpEventListener {
    HAManager haManager = null;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sun_Oct_31_02:49:17_PDT_2021";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    HAFanListener(HAManager hAManager) {
        this.haManager = hAManager;
    }

    public void handleEvent(ServiceDownEvent serviceDownEvent) {
        String string = HAFanListener.toLowerCase(serviceDownEvent.getServiceName());
        String string2 = HAFanListener.toLowerCase(serviceDownEvent.getDatabaseUniqueName());
        String string3 = null;
        String string4 = null;
        int n2 = serviceDownEvent.getDrainTimeout();
        block0 : switch (serviceDownEvent.getKind()) {
            case MEMBER: {
                string3 = HAFanListener.toLowerCase(serviceDownEvent.getServiceMemberEvent().getInstanceName());
                string4 = HAFanListener.toLowerCase(serviceDownEvent.getServiceMemberEvent().getNodeName());
            }
            case COMPOSITE: {
                switch (serviceDownEvent.getReason()) {
                    case USER: {
                        this.haManager.plannedDown(string, string3, string2, string4, n2);
                        break block0;
                    }
                }
                this.haManager.unplannedDown(string, string3, string2, string4);
                break;
            }
        }
    }

    public void handleEvent(ServiceUpEvent serviceUpEvent) {
        String string = HAFanListener.toLowerCase(serviceUpEvent.getServiceName());
        String string2 = HAFanListener.toLowerCase(serviceUpEvent.getDatabaseUniqueName());
        String string3 = null;
        String string4 = null;
        int n2 = serviceUpEvent.getCardinality();
        switch (serviceUpEvent.getKind()) {
            case MEMBER: {
                string3 = HAFanListener.toLowerCase(serviceUpEvent.getServiceMemberEvent().getInstanceName());
                string4 = HAFanListener.toLowerCase(serviceUpEvent.getServiceMemberEvent().getNodeName());
            }
            case COMPOSITE: {
                this.haManager.serviceUp(string, string3, string2, string4, n2);
                break;
            }
        }
    }

    public void handleEvent(NodeDownEvent nodeDownEvent) {
        String string = nodeDownEvent.getNodeName();
        this.haManager.nodeDown(string);
    }

    public void handleEvent(LoadAdvisoryEvent loadAdvisoryEvent) {
    }

    public void handleEvent(NodeUpEvent nodeUpEvent) {
    }

    private static String toLowerCase(String string) {
        return null == string ? null : string.toLowerCase();
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$7 = HAFanListener.class.getDeclaredConstructor(HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = HAFanListener.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = HAFanListener.class.getDeclaredMethod("toLowerCase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = HAFanListener.class.getDeclaredMethod("handleEvent", NodeUpEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = HAFanListener.class.getDeclaredMethod("handleEvent", LoadAdvisoryEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = HAFanListener.class.getDeclaredMethod("handleEvent", NodeDownEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = HAFanListener.class.getDeclaredMethod("handleEvent", ServiceUpEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = HAFanListener.class.getDeclaredMethod("handleEvent", ServiceDownEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.HAFanListener"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

