/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 32768;
    DBConversion dbConversion;
    int conversion;
    InputStream istream;
    char[] buf;
    byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;

    public OracleConversionReader(DBConversion dBConversion, InputStream inputStream, int n2) throws SQLException {
        if (dBConversion == null || inputStream == null || n2 != 8 && n2 != 9) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        this.dbConversion = dBConversion;
        this.conversion = n2;
        this.istream = inputStream;
        this.count = 0;
        this.pos = 0;
        this.numUnconvertedBytes = 0;
        this.isClosed = false;
        this.nbytes = new int[1];
        if (n2 == 8) {
            this.byteBuf = new byte[16384];
            this.buf = new char[32768];
        } else if (n2 == 9) {
            this.byteBuf = new byte[32768];
            this.buf = new char[32768];
        }
    }

    public void setFormOfUse(short s2) {
        this.csform = s2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (!this.needChars()) {
            return -1;
        }
        int n4 = n2;
        int n5 = n4 + Math.min(n3, cArray.length - n2);
        n4 += this.writeChars(cArray, n4, n5 - n4);
        while (n4 < n5 && this.needChars()) {
            n4 += this.writeChars(cArray, n4, n5 - n4);
        }
        return n4 - n2;
    }

    protected boolean needChars() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            if (!this.endOfStream) {
                try {
                    int n2 = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                    if (n2 == -1) {
                        this.endOfStream = true;
                        if (this.numUnconvertedBytes != 0) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55).fillInStackTrace();
                        }
                    }
                    if ((n2 += this.numUnconvertedBytes) > 0) {
                        switch (this.conversion) {
                            case 8: {
                                this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, n2, this.buf);
                                break;
                            }
                            case 9: {
                                this.nbytes[0] = n2;
                                this.count = this.csform == 2 ? this.dbConversion.NCHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length) : this.dbConversion.CHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
                                this.numUnconvertedBytes = this.nbytes[0];
                                for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                    this.byteBuf[i2] = this.byteBuf[n2 - this.numUnconvertedBytes + i2];
                                }
                                break;
                            }
                            default: {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                            }
                        }
                        if (this.count > 0) {
                            this.pos = 0;
                            return true;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] cArray, int n2, int n3) {
        int n4 = Math.min(n3, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n2, n4);
        this.pos += n4;
        return n4;
    }

    @Override
    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.pos < this.count;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.istream.close();
        }
    }

    void ensureOpen() throws IOException {
        try {
            if (this.isClosed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null).fillInStackTrace();
            }
        }
        catch (SQLException sQLException) {
            throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    static {
        try {
            $$$methodRef$$$8 = OracleConversionReader.class.getDeclaredConstructor(DBConversion.class, InputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleConversionReader.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleConversionReader.class.getDeclaredMethod("ensureOpen", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleConversionReader.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleConversionReader.class.getDeclaredMethod("ready", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleConversionReader.class.getDeclaredMethod("writeChars", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleConversionReader.class.getDeclaredMethod("needChars", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleConversionReader.class.getDeclaredMethod("read", char[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleConversionReader.class.getDeclaredMethod("setFormOfUse", Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

