/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIiov
extends T4CTTIMsg {
    T4C8TTIrxh rxh;
    T4CTTIrxd rxd;
    short bindtype = 0;
    byte[] iovector;
    int bindcnt = 0;
    int inbinds = 0;
    int outbinds = 0;
    static final byte BV_IN_V = 32;
    static final byte BV_OUT_V = 16;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Fri_Jul_09_09:45:31_PDT_2021";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    T4CTTIiov(T4CConnection t4CConnection, T4C8TTIrxh t4C8TTIrxh, T4CTTIrxd t4CTTIrxd) throws SQLException, IOException {
        super(t4CConnection, (byte)0);
        this.rxh = t4C8TTIrxh;
        this.rxd = t4CTTIrxd;
    }

    void init() throws SQLException, IOException {
    }

    Accessor[] processRXD(Accessor[] accessorArray, int n2, byte[] byArray, char[] cArray, short[] sArray, int n3, DBConversion dBConversion, byte[] byArray2, byte[] byArray3, InputStream[][] inputStreamArray, OracleStatement oracleStatement, byte[] byArray4, char[] cArray2, short[] sArray2) throws SQLException, IOException {
        block8: {
            if (byArray3 == null) break block8;
            for (int i2 = 0; i2 < byArray3.length; ++i2) {
                block9: {
                    int n4;
                    block10: {
                        if ((byArray3[i2] & 0x10) == 0) break block9;
                        if (accessorArray == null || accessorArray.length <= i2) break block10;
                        if (accessorArray[i2] != null) break block9;
                    }
                    int n5 = n3 + 5 + 10 * i2;
                    int n6 = n4 = sArray[n5 + 0] & 0xFFFF;
                    if (n4 == 9) {
                        n4 = 1;
                    }
                    Accessor accessor = oracleStatement.allocateAccessor(n4, n4, i2, 0, (short)0, null, false);
                    accessor.rowSpaceIndicator = null;
                    if (accessorArray == null) {
                        accessorArray = new Accessor[i2 + 1];
                        accessorArray[i2] = accessor;
                        continue;
                    }
                    if (accessorArray.length <= i2) {
                        Accessor[] accessorArray2 = new Accessor[i2 + 1];
                        accessorArray2[i2] = accessor;
                        for (int i3 = 0; i3 < accessorArray.length; ++i3) {
                            if (accessorArray[i3] == null) continue;
                            accessorArray2[i3] = accessorArray[i3];
                        }
                        accessorArray = accessorArray2;
                        continue;
                    }
                    accessorArray[i2] = accessor;
                    continue;
                }
                if ((byArray3[i2] & 0x10) != 0 || accessorArray == null || i2 >= accessorArray.length || accessorArray[i2] == null) continue;
                accessorArray[i2].isUseLess = true;
            }
        }
        return accessorArray;
    }

    void unmarshalV10() throws IOException, SQLException {
        this.rxh.unmarshalV10(this.rxd);
        this.bindcnt = this.rxh.numRqsts;
        if (TRACE) {
            this.rxh.print();
        }
        this.iovector = new byte[this.connection.all8.numberOfBindPositions];
        for (int i2 = 0; i2 < this.iovector.length; ++i2) {
            this.bindtype = this.meg.unmarshalUB1();
            if (this.bindtype == 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
            if ((this.bindtype & 0x20) > 0) {
                int n2 = i2;
                this.iovector[n2] = (byte)(this.iovector[n2] | 0x20);
                ++this.inbinds;
            }
            if ((this.bindtype & 0x10) <= 0) continue;
            int n3 = i2;
            this.iovector[n3] = (byte)(this.iovector[n3] | 0x10);
            ++this.outbinds;
        }
    }

    byte[] getIOVector() {
        return this.iovector;
    }

    boolean isIOVectorEmpty() {
        return this.iovector.length == 0;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$6 = T4CTTIiov.class.getDeclaredConstructor(T4CConnection.class, T4C8TTIrxh.class, T4CTTIrxd.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIiov.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIiov.class.getDeclaredMethod("isIOVectorEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIiov.class.getDeclaredMethod("getIOVector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIiov.class.getDeclaredMethod("unmarshalV10", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIiov.class.getDeclaredMethod("processRXD", Accessor[].class, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, DBConversion.class, byte[].class, byte[].class, InputStream[][].class, OracleStatement.class, byte[].class, char[].class, short[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIiov.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIiov"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

