/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_MANAGEMENT})
public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource = null;
    private String xaDataSourceName = null;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public OracleManagedConnectionFactory() throws ResourceException {
    }

    public OracleManagedConnectionFactory(XADataSource xADataSource) throws ResourceException {
        this.xaDataSource = xADataSource;
        this.xaDataSourceName = "XADataSource";
    }

    public void setXADataSourceName(String string) {
        this.xaDataSourceName = string;
    }

    public String getXADataSourceName() {
        return this.xaDataSourceName;
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        if (this.xaDataSource == null) {
            this.setupXADataSource();
        }
        return (DataSource)((Object)this.xaDataSource);
    }

    public Object createConnectionFactory() throws ResourceException {
        return this.createConnectionFactory(null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            XAConnection xAConnection = null;
            PasswordCredential passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
            xAConnection = passwordCredential == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(passwordCredential.getUserName(), new String(passwordCredential.getPassword()));
            OracleManagedConnection oracleManagedConnection = new OracleManagedConnection(xAConnection);
            oracleManagedConnection.setPasswordCredential(passwordCredential);
            oracleManagedConnection.setLogWriter(this.getLogWriter());
            return oracleManagedConnection;
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        PasswordCredential passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
        for (Object e2 : set) {
            OracleManagedConnection oracleManagedConnection;
            if (!(e2 instanceof OracleManagedConnection) || !(oracleManagedConnection = (OracleManagedConnection)e2).getPasswordCredential().equals((Object)passwordCredential)) continue;
            return oracleManagedConnection;
        }
        return null;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            this.xaDataSource.setLogWriter(printWriter);
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            return this.xaDataSource.getLogWriter();
        }
        catch (SQLException sQLException) {
            EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
            eISSystemException.setLinkedException((Exception)sQLException);
            throw eISSystemException;
        }
    }

    private void setupXADataSource() throws ResourceException {
        try {
            Object object;
            InitialContext initialContext = null;
            try {
                object = System.getProperties();
                initialContext = new InitialContext((Hashtable<?, ?>)object);
            }
            catch (java.lang.SecurityException securityException) {
                // empty catch block
            }
            if (initialContext == null) {
                initialContext = new InitialContext();
            }
            if ((object = (XADataSource)initialContext.lookup(this.xaDataSourceName)) == null) {
                throw new ResourceAdapterInternalException("Invalid XADataSource object");
            }
            this.xaDataSource = object;
        }
        catch (NamingException namingException) {
            ResourceException resourceException = new ResourceException("NamingException: " + namingException.getMessage());
            resourceException.setLinkedException((Exception)namingException);
            throw resourceException;
        }
    }

    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (subject != null) {
            Set<PasswordCredential> set = subject.getPrivateCredentials(PasswordCredential.class);
            for (PasswordCredential passwordCredential : set) {
                if (!passwordCredential.getManagedConnectionFactory().equals((Object)this)) continue;
                return passwordCredential;
            }
            throw new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
        }
        if (connectionRequestInfo == null) {
            return null;
        }
        OracleConnectionRequestInfo oracleConnectionRequestInfo = (OracleConnectionRequestInfo)connectionRequestInfo;
        PasswordCredential passwordCredential = new PasswordCredential(oracleConnectionRequestInfo.getUser(), oracleConnectionRequestInfo.getPassword().toCharArray());
        passwordCredential.setManagedConnectionFactory((ManagedConnectionFactory)this);
        return passwordCredential;
    }

    static {
        try {
            $$$methodRef$$$11 = OracleManagedConnectionFactory.class.getDeclaredConstructor(XADataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleManagedConnectionFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleManagedConnectionFactory.class.getDeclaredMethod("getPasswordCredential", Subject.class, ConnectionRequestInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleManagedConnectionFactory.class.getDeclaredMethod("setupXADataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleManagedConnectionFactory.class.getDeclaredMethod("getLogWriter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleManagedConnectionFactory.class.getDeclaredMethod("setLogWriter", PrintWriter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleManagedConnectionFactory.class.getDeclaredMethod("matchManagedConnections", Set.class, Subject.class, ConnectionRequestInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleManagedConnectionFactory.class.getDeclaredMethod("createManagedConnection", Subject.class, ConnectionRequestInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleManagedConnectionFactory.class.getDeclaredMethod("createConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleManagedConnectionFactory.class.getDeclaredMethod("createConnectionFactory", ConnectionManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleManagedConnectionFactory.class.getDeclaredMethod("getXADataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleManagedConnectionFactory.class.getDeclaredMethod("setXADataSourceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

