/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class ExpirationMap<K, V>
implements Map<K, V> {
    private Map<KeyWithTime, V> mInnerMap;
    private boolean mUseWeakReferenceKeys;
    private ReentrantLock mReentrantLock;
    private long mExpiredEntriesCount;
    private static long ONE_HOUR_IN_MILLIS = 3600000L;
    private AtomicLong mMaxLengthOfStayInMillis = new AtomicLong(ONE_HOUR_IN_MILLIS);
    private AtomicInteger mExpireEmptyRefCountdown;
    private int mEmptyRefClearInterval;

    public ExpirationMap(Map map, boolean useWeakReferenceKeys) {
        this.mUseWeakReferenceKeys = useWeakReferenceKeys;
        this.mInnerMap = map;
        this.mReentrantLock = new ReentrantLock();
        this.mExpireEmptyRefCountdown = new AtomicInteger();
        this.mEmptyRefClearInterval = 500;
        map.clear();
    }

    public void setEmptyRefClearInterval(int mapAccessCount) {
        this.mEmptyRefClearInterval = mapAccessCount;
    }

    public void setMaxLengthOfStayInMillis(long value) {
        this.mMaxLengthOfStayInMillis.set(value);
    }

    @Override
    public int size() {
        return this.mInnerMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mInnerMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        KeyWithTime kwt = this.createKeyForLookup(key, this.mUseWeakReferenceKeys);
        return this.mInnerMap.containsKey(kwt);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mInnerMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        KeyWithTime kwt = this.createKeyForLookup(key, this.mUseWeakReferenceKeys);
        return this.mInnerMap.get(kwt);
    }

    @Override
    public V put(K key, V value) {
        this.expireAtLeastEmptyKeys();
        KeyWithTime kwt = this.createKeyForPut(key, this.mUseWeakReferenceKeys);
        V retVal = this.mInnerMap.put(kwt, value);
        return retVal;
    }

    @Override
    public V remove(Object key) {
        KeyWithTime kwt = this.createKeyForLookup(key, this.mUseWeakReferenceKeys);
        return this.mInnerMap.remove(kwt);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.expireAtLeastEmptyKeys();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            KeyWithTime kwt = this.createKeyForPut(entry.getKey(), this.mUseWeakReferenceKeys);
            this.mInnerMap.put(kwt, entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mInnerMap.clear();
    }

    @Override
    public Set<K> keySet() {
        Set<KeyWithTime> set = this.mInnerMap.keySet();
        HashSet<Object> retVal = new HashSet<Object>();
        for (KeyWithTime kwt : set) {
            retVal.add(kwt.getObject());
        }
        return retVal;
    }

    @Override
    public Collection<V> values() {
        return this.mInnerMap.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<KeyWithTime, V>> entrySet = this.mInnerMap.entrySet();
        HashSet<Map.Entry<K, V>> retVal = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<KeyWithTime, V> e : entrySet) {
            retVal.add(new SimpleEntry(e.getKey().getObject(), e.getValue()));
        }
        return retVal;
    }

    public long getMaxLengthOfStayInMillis() {
        return this.mMaxLengthOfStayInMillis.get();
    }

    int expireAtLeastEmptyKeys() {
        int retVal = -1;
        if (this.mUseWeakReferenceKeys && this.mExpireEmptyRefCountdown.incrementAndGet() > this.mEmptyRefClearInterval) {
            this.mExpireEmptyRefCountdown.set(0);
            retVal = this.expire();
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int expire() {
        long timeLimit = System.currentTimeMillis() - this.mMaxLengthOfStayInMillis.get();
        int droppedCount = 0;
        if (this.mReentrantLock.tryLock()) {
            try {
                Set<KeyWithTime> keySet = this.mInnerMap.keySet();
                Iterator<KeyWithTime> iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    KeyWithTime entry = iterator.next();
                    if (entry.getTime() > timeLimit && entry.getObject() != null) continue;
                    iterator.remove();
                    ++droppedCount;
                }
                this.mExpiredEntriesCount += (long)droppedCount;
            }
            finally {
                this.mReentrantLock.unlock();
            }
        }
        return droppedCount;
    }

    public long getExpiredEntriesCount() {
        return this.mExpiredEntriesCount;
    }

    KeyWithTime createKeyForPut(K key, boolean useWeakRef) {
        KeyWithTime retVal = null;
        retVal = useWeakRef ? new KeyWithTime(null, key) : new KeyWithTime(key, null);
        return retVal;
    }

    KeyWithTime createKeyForLookup(K key, boolean useWeakRef) {
        return new KeyWithTime(key, null);
    }

    class SimpleEntry
    implements Map.Entry<K, V> {
        K mKey;
        V mValue;

        SimpleEntry(K key, V value) {
            this.mKey = key;
            this.mValue = value;
        }

        @Override
        public K getKey() {
            return this.mKey;
        }

        @Override
        public V getValue() {
            return this.mValue;
        }

        @Override
        public V setValue(V value) {
            return null;
        }
    }

    class KeyWithTime {
        private long time = System.currentTimeMillis();
        private K mHardRef = null;
        private WeakReference<K> mWeakRef;
        private int mHashCode;

        private KeyWithTime(K hardReferrant, K weakReferrant) {
            if (hardReferrant != null) {
                this.mHardRef = hardReferrant;
                this.mHashCode = hardReferrant.hashCode();
            } else if (weakReferrant != null) {
                this.mWeakRef = new WeakReference(weakReferrant);
                this.mHashCode = weakReferrant.hashCode();
            }
        }

        long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            boolean retVal = false;
            if (o != null) {
                if (this == o) {
                    retVal = true;
                } else if (o.getClass() == this.getClass()) {
                    KeyWithTime that = (KeyWithTime)o;
                    Object thisKey = this.getObject();
                    Object thatKey = that.getObject();
                    if (thisKey == null && thatKey == null) {
                        retVal = this.mHashCode == that.mHashCode;
                    } else if (thisKey != null && thatKey != null) {
                        retVal = thisKey.equals(thatKey);
                    }
                }
            }
            return retVal;
        }

        public int hashCode() {
            return this.mHashCode;
        }

        private K getObject() {
            Object retVal = null;
            if (this.mWeakRef != null) {
                retVal = this.mWeakRef.get();
            } else if (this.mHardRef != null) {
                retVal = this.mHardRef;
            }
            return retVal;
        }
    }
}

