/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.producer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import oracle.dms.config.CollectorConfig;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.producer.ColumnInfo;
import oracle.dms.producer.MetricInfo;
import oracle.dms.producer.RowInfo;
import oracle.dms.table.ColumnDefinitionSupport;
import oracle.dms.table.RowSupport;
import oracle.dms.table.SchemaSupport;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.table.TableSupport;
import oracle.dms.table.ValueType;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.PlatformSupportFactory;
import oracle.dms.util.QueryOptions;

public abstract class MetricConvertor
implements Runnable,
NotificationListener {
    private volatile Status m_init = Status.INIT;
    private TableSource m_tableBuilder = null;
    private ScheduledExecutorService m_dmsTimer;
    private ScheduledFuture m_discovererFuture = null;
    private PhaseEvent m_getAttributePhase = null;
    protected String m_serverName;
    protected MBeanServerConnection m_mbeanServer;
    protected MBeanServerConnection m_domainMBeanServer;
    private CollectorConfig m_collectorConfig = null;
    protected Map<String, MetricInfo> m_metricInfoByTypes = new HashMap<String, MetricInfo>();
    private HashMap<ObjectName, RowInfo> m_rowInfoByMBeans = new HashMap();
    protected static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");
    private final Map<ObjectName, Set<String>> EXCLUDED_ATTRIBUTES = new HashMap<ObjectName, Set<String>>(3);
    protected static final ObjectName QUERY_ALL_MBEANS;
    private static final String[] TABLE_KEYS;
    private static final String SERVICE_NAME = "MetricService";
    private static final String GET_ATTRIBUTES = "getAttributes";

    public MetricConvertor(MBeanServerConnection mbeanServer, MBeanServerConnection domainMBeanServer, CollectorConfig collectorConfig, ScheduledExecutorService dmsTimer) {
        if (mbeanServer == null || dmsTimer == null) {
            throw new IllegalArgumentException("mbeanServer=" + mbeanServer + " dmsTimer=" + dmsTimer);
        }
        this.m_mbeanServer = mbeanServer;
        this.m_domainMBeanServer = domainMBeanServer;
        this.m_dmsTimer = dmsTimer;
        this.m_serverName = PlatformSupportFactory.getPlatformSupport().getServerName();
        this.m_collectorConfig = collectorConfig;
        if (DMSConsole.getSensorWeight() != 0) {
            Noun parent = Noun.create(DMSUtil.genCompNounPath(SERVICE_NAME));
            this.m_getAttributePhase = PhaseEvent.create(parent, GET_ATTRIBUTES, GET_ATTRIBUTES);
            this.m_getAttributePhase.deriveMetric(511);
        }
        this.setExcludedAttributes(ObjectName.WILDCARD, "Credential", "Authorization");
        if (this.m_collectorConfig != null) {
            Map<ObjectName, Set<String>> excludeAttribute = this.m_collectorConfig.getExcludeAttributeMap();
            for (Map.Entry<ObjectName, Set<String>> entry : excludeAttribute.entrySet()) {
                ObjectName objNamePattern = entry.getKey();
                Set<String> excludedAttributeSet = entry.getValue();
                Set<String> set = this.EXCLUDED_ATTRIBUTES.get(objNamePattern);
                if (set != null) {
                    set.addAll(excludedAttributeSet);
                    continue;
                }
                this.EXCLUDED_ATTRIBUTES.put(objNamePattern, set);
            }
        }
    }

    public void setTableBuilder(TableSource tableBuilder) {
        if (tableBuilder != null) {
            this.m_tableBuilder = tableBuilder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _init() {
        if (this.m_init != Status.INIT) {
            return false;
        }
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            if (this.m_init != Status.INIT) {
                return false;
            }
            this.m_init = Status.RUNNING;
        }
        if (this.m_collectorConfig == null || this.m_collectorConfig.isMBeanRegListenerEnabled()) {
            this.addNotificationListener();
        }
        this.run();
        if (!this.m_dmsTimer.isShutdown()) {
            this.m_discovererFuture = this.m_dmsTimer.scheduleWithFixedDelay(this, 180000L, 180000L, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTableNames(Collection<String> list, QueryOptions options) {
        if (list == null) {
            return;
        }
        this._init();
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            list.addAll(this.m_metricInfoByTypes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableNames(QueryOptions options) {
        this._init();
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            String[] tables = new String[this.m_metricInfoByTypes.size()];
            this.m_metricInfoByTypes.keySet().toArray(tables);
            return tables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tableCount(QueryOptions options) {
        this._init();
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            return this.m_metricInfoByTypes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsTable(String tablename, QueryOptions options) {
        this._init();
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            return this.m_metricInfoByTypes.containsKey(tablename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(String tablename, QueryOptions options) {
        MetricInfo metricInfo;
        this._init();
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            metricInfo = this.m_metricInfoByTypes.get(tablename);
        }
        TableSupport table = null;
        if (metricInfo != null) {
            table = metricInfo.getTable();
        }
        if (table == null) {
            return null;
        }
        table = table.clone(options);
        if (!options.includeRows()) {
            return table;
        }
        Collection<RowInfo> rowInfos = null;
        if (metricInfo != null) {
            rowInfos = metricInfo.getRowInfos();
        }
        if (rowInfos == null || rowInfos.size() == 0) {
            return table;
        }
        for (RowInfo rowInfo : rowInfos) {
            RowSupport row = new RowSupport(table);
            Map<String, Serializable> columnValues = this.getColumnValues(rowInfo);
            for (Map.Entry<String, Serializable> entry : columnValues.entrySet()) {
                String columnName = entry.getKey();
                Serializable columnValue = entry.getValue();
                if (row.containsColumn(columnName)) continue;
                row.updateValue(columnName, columnValue);
            }
            table.addRow(row);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Serializable> getColumnValues(RowInfo rowInfo) {
        String METHOD_NAME = "getColumnValues";
        HashMap<String, Serializable> columnValues = new HashMap<String, Serializable>();
        if (rowInfo == null) {
            return columnValues;
        }
        ObjectName objName = rowInfo.getObjectName();
        columnValues.put("ObjectName", (Serializable)((Object)objName.getCanonicalName()));
        columnValues.put("ServerName", (Serializable)((Object)this.m_serverName));
        ArrayList attriList = null;
        String[] attributeNames = rowInfo.getAttributeNames();
        MBeanServerConnection mbeanServer = rowInfo.getMBeanServer();
        if (attributeNames != null && attributeNames.length > 0) {
            long token = this.m_getAttributePhase == null ? 0L : this.m_getAttributePhase.start();
            try {
                attriList = mbeanServer.getAttributes(objName, attributeNames);
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.logp(Level.FINE, this.getClass().getName(), "getColumnValues", "Fails to get attributes for: " + rowInfo, e);
                }
            }
            finally {
                if (this.m_getAttributePhase != null) {
                    this.m_getAttributePhase.stop(token);
                }
            }
        }
        if (attriList != null && attriList.size() > 0) {
            for (Attribute attribute : ((AttributeList)attriList).asList()) {
                if (attribute == null) continue;
                String name = attribute.getName();
                Object value = attribute.getValue();
                ColumnInfo columnInfo = rowInfo.getColumnInfo(name);
                this.putValue(name, value, columnInfo, columnValues);
            }
        }
        Hashtable<String, String> keyPropertyMap = objName.getKeyPropertyList();
        for (Map.Entry<String, String> entry : keyPropertyMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (columnValues.containsKey(key)) continue;
            columnValues.put(key, (Serializable)((Object)value));
        }
        return columnValues;
    }

    protected void putValue(String name, Object value, ColumnInfo columnInfo, Map<String, Serializable> columnValues) {
        if (value != null) {
            ValueType valueType = null;
            if (columnInfo != null) {
                valueType = columnInfo.getValueType();
            }
            if (valueType == null) {
                valueType = ValueType.STRING;
            }
            switch (valueType) {
                case LONG: {
                    if (value instanceof Long) break;
                    value = ((Number)value).longValue();
                    break;
                }
                case INTEGER: {
                    if (value instanceof Integer) break;
                    value = ((Number)value).intValue();
                    break;
                }
                case DOUBLE: {
                    if (value instanceof Double) break;
                    value = ((Number)value).doubleValue();
                    break;
                }
                default: {
                    if (value instanceof String) break;
                    value = value.toString();
                }
            }
        }
        columnValues.put(name, (Serializable)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ObjectName> getObjectNames(String type) {
        this._init();
        MetricInfo minfo = null;
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            minfo = this.m_metricInfoByTypes.get(type);
        }
        if (minfo == null) {
            return new HashSet<ObjectName>(0);
        }
        return minfo.getObjectNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowInfo getRowInfo(ObjectName objName) {
        if (objName == null) {
            return null;
        }
        this._init();
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            return this.m_rowInfoByMBeans.get(objName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsRowInfo(ObjectName objName) {
        if (objName == null) {
            return false;
        }
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            return this.m_rowInfoByMBeans.containsKey(objName);
        }
    }

    private void _processMBeans(Set<ObjectName> objNames, Set<ObjectName> oldObjNames, MBeanServerConnection mbeanServer) {
        if (objNames == null || objNames.size() == 0) {
            return;
        }
        oldObjNames.removeAll(objNames);
        this.convertToMetrics(objNames, mbeanServer);
        for (ObjectName objName : oldObjNames) {
            this.removeMetric(objName);
        }
    }

    protected void convertToMetrics(Set<ObjectName> objNames, MBeanServerConnection mbeanServer) {
        List<RowInfo> rowInfos;
        String METHOD_NAME = "getRowInfos";
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, this.getClass().getName(), "getRowInfos", "All MBean ObjectNames=" + objNames);
        }
        if ((rowInfos = this.getRowInfos(objNames, mbeanServer)) == null || rowInfos.size() == 0) {
            return;
        }
        for (RowInfo rowInfo : rowInfos) {
            this.convertRowInfoToMetrics(rowInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertRowInfoToMetrics(RowInfo rowInfo) {
        String METHOD_NAME = "convertRowInfoToMetrics";
        String tableName = rowInfo.getTableName();
        ObjectName objName = rowInfo.getObjectName();
        Map<String, ColumnInfo> columnInfos = rowInfo.getColumnInfos();
        SchemaSupport schema = null;
        TableSupport table = null;
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            MetricInfo metricInfo = this.m_metricInfoByTypes.get(tableName);
            if (metricInfo != null) {
                table = metricInfo.getTable();
                schema = (SchemaSupport)table.getSchema();
            } else {
                table = new TableSupport();
                table.setName(tableName);
                table.setKeys(TABLE_KEYS);
                String tnlsId = "QU_" + table.getName();
                schema = new SchemaSupport(DMSNLSupport.getString(tnlsId), table);
                schema.addProperty("SpyCategory", this.getSpyCategory());
                metricInfo = new MetricInfo(table);
                this.m_metricInfoByTypes.put(tableName, metricInfo);
            }
            metricInfo.addRowInfo(rowInfo);
            this.m_rowInfoByMBeans.put(objName, rowInfo);
        }
        if (!schema.containsColumn("ObjectName")) {
            this.createColumnDefinition(schema, table, "ObjectName", ValueType.STRING, null);
        }
        if (!schema.containsColumn("ServerName")) {
            this.createColumnDefinition(schema, table, "ServerName", ValueType.STRING, null);
        }
        for (ColumnInfo columnInfo : columnInfos.values()) {
            String name = columnInfo.getName();
            String description = columnInfo.getDescription();
            ValueType valueType = columnInfo.getValueType();
            this.createColumnDefinition(schema, table, name, valueType, description);
        }
        Hashtable<String, String> keyPropertyMap = objName.getKeyPropertyList();
        for (String key : keyPropertyMap.keySet()) {
            this.createColumnDefinition(schema, table, key, ValueType.STRING, null);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, this.getClass().getName(), "convertRowInfoToMetrics", "Added ObjectName: " + objName);
        }
    }

    public abstract List<RowInfo> getRowInfos(Set<ObjectName> var1, MBeanServerConnection var2);

    protected abstract String getSpyCategory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            if (this.m_init != Status.RUNNING) {
                return;
            }
            this.m_init = Status.STOP;
            this.m_metricInfoByTypes.clear();
            this.m_rowInfoByMBeans.clear();
        }
        if (this.m_discovererFuture != null) {
            this.m_discovererFuture.cancel(true);
            this.m_discovererFuture = null;
        }
        if (this.m_getAttributePhase != null) {
            this.m_getAttributePhase.destroy();
            this.m_getAttributePhase = null;
        }
        try {
            this.m_mbeanServer.removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isConvertable(String type) {
        if (type == null || type.trim().length() == 0) {
            return false;
        }
        if (Noun.getDescriptorByType(type) != null) {
            return false;
        }
        return this.m_tableBuilder == null || !this.m_tableBuilder.containsTable(type, null);
    }

    public static ValueType getValueType(String column, String className) {
        ValueType valueType = ValueType.STRING;
        if (Long.class.getName().equals(className) || Long.TYPE.getName().equals(className)) {
            valueType = ValueType.LONG;
        } else if (Integer.class.getName().equals(className) || Integer.TYPE.getName().equals(className) || Short.class.getName().equals(className) || Short.TYPE.getName().equals(className) || Byte.class.getName().equals(className) || Byte.TYPE.getName().equals(className)) {
            valueType = ValueType.INTEGER;
        } else if (Double.class.getName().equals(className) || Double.TYPE.getName().equals(className) || Float.class.getName().equals(className) || Float.TYPE.getName().equals(className)) {
            valueType = ValueType.DOUBLE;
        } else if (!(String.class.getName().equals(className) || ObjectName.class.getName().equals(className) || Boolean.class.getName().equals(className) || Boolean.TYPE.getName().equals(className) || Character.class.getName().equals(className) || Character.TYPE.getName().equals(className) || Date.class.getName().equals(className) || BigDecimal.class.getName().equals(className) || BigInteger.class.getName().equals(className))) {
            return null;
        }
        return valueType;
    }

    protected void createColumnDefinition(SchemaSupport schema, TableSupport table, String name, ValueType valueType, String description) {
        if (schema.containsColumn(name)) {
            return;
        }
        table.setColumnType(name, valueType);
        if (description == null || description.trim().length() == 0) {
            String nlsId = "QU_" + name;
            description = DMSNLSupport.getString(nlsId);
        }
        new ColumnDefinitionSupport(schema, name, description, null);
    }

    protected RowInfo getRowInfo(String typeName, ObjectName objName, MBeanAttributeInfo[] attrInfos, MBeanServerConnection mbeanServer) {
        if (attrInfos == null || attrInfos.length == 0) {
            return null;
        }
        if (Noun.getDescriptorByType(typeName) != null) {
            typeName = typeName + "_mbean";
        }
        if (!this.isConvertable(typeName)) {
            return null;
        }
        HashSet<String> excludedAttributes = new HashSet<String>();
        for (Map.Entry<ObjectName, Set<String>> entry : this.EXCLUDED_ATTRIBUTES.entrySet()) {
            ObjectName objNamePattern = entry.getKey();
            Set<String> excludedAttributeSet = entry.getValue();
            if (!objNamePattern.apply(objName)) continue;
            excludedAttributes.addAll(excludedAttributeSet);
        }
        HashMap<String, ColumnInfo> columnInfos = new HashMap<String, ColumnInfo>();
        ArrayList<String> attriNameList = new ArrayList<String>();
        for (MBeanAttributeInfo attrInfo : attrInfos) {
            ValueType valueType;
            String name = attrInfo.getName();
            String type = attrInfo.getType();
            if (this._indexOfIgnoreCase(name, "password") >= 0 || this._indexOfIgnoreCase(name, "passphrase") >= 0 || excludedAttributes != null && excludedAttributes.contains(name) || (valueType = MetricConvertor.getValueType(name, type)) == null) continue;
            String description = attrInfo.getDescription();
            Object unit = null;
            Descriptor desc = attrInfo.getDescriptor();
            if (desc != null) {
                unit = desc.getFieldValue("units");
            }
            ColumnInfo columnInfo = new ColumnInfo(name, null, valueType, description, unit == null ? null : unit.toString());
            columnInfos.put(name, columnInfo);
            attriNameList.add(name);
        }
        excludedAttributes.clear();
        if (attriNameList.size() == 0) {
            return null;
        }
        String[] attributeConverted = new String[attriNameList.size()];
        attriNameList.toArray(attributeConverted);
        RowInfo rowInfo = new RowInfo(typeName, objName, attributeConverted, mbeanServer);
        rowInfo.addColumnInfos(columnInfos);
        return rowInfo;
    }

    protected void addNotificationListener() {
        block2: {
            String METHOD_NAME = "addNotificationListener";
            try {
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType("JMX.mbean.registered");
                filter.enableType("JMX.mbean.unregistered");
                this.m_mbeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)filter, null);
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.logp(Level.FINE, this.getClass().getName(), "addNotificationListener", "Failed to listen to cluster MBeans", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMetric(ObjectName objName) {
        String METHOD_NAME = "removeMetric";
        MetricConvertor metricConvertor = this;
        synchronized (metricConvertor) {
            RowInfo rowInfo = this.m_rowInfoByMBeans.remove(objName);
            if (rowInfo == null) {
                return;
            }
            String tableName = rowInfo.getTableName();
            if (tableName == null || tableName.trim().length() == 0) {
                return;
            }
            MetricInfo metricInfo = this.m_metricInfoByTypes.get(tableName);
            if (metricInfo != null) {
                metricInfo.removeRowInfo(rowInfo);
                if (metricInfo.rowInfoCount() == 0) {
                    this.m_metricInfoByTypes.remove(tableName);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, this.getClass().getName(), "removeMetric", "Removed ObjectName: " + objName);
        }
    }

    private int _indexOfIgnoreCase(String source, String target) {
        int charactorLength;
        int max = source.length() - target.length();
        int target1 = target.codePointAt(0);
        for (int index = 0; index <= max; index += charactorLength) {
            int targetNext;
            int charactorNext;
            int charactor1 = source.codePointAt(index);
            charactorLength = Character.charCount(charactor1);
            if (Character.toLowerCase(charactor1) != target1) continue;
            int j = charactorLength;
            while (j < target.length() && index + j < source.length() && (charactorNext = Character.toLowerCase(source.codePointAt(index + j))) == (targetNext = target.codePointAt(j))) {
                if ((j += Character.charCount(targetNext)) != target.length()) continue;
                return index;
            }
        }
        return -1;
    }

    protected void setExcludedAttributes(String objName, String ... columns) {
        block3: {
            String METHOD_NAME = "setExcludedAttributes";
            if (objName == null || columns == null) {
                return;
            }
            try {
                ObjectName objectName = new ObjectName(objName);
                this.setExcludedAttributes(objectName, columns);
            }
            catch (MalformedObjectNameException mone) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.logp(Level.FINE, this.getClass().getName(), "setExcludedAttributes", "Invalid Object Name: " + objName, mone);
            }
        }
    }

    protected void setExcludedAttributes(ObjectName objectName, String ... columns) {
        if (objectName == null || columns == null) {
            return;
        }
        Set<String> excludeAttributes = this.EXCLUDED_ATTRIBUTES.get(objectName);
        if (excludeAttributes == null) {
            excludeAttributes = new HashSet<String>(5);
            this.EXCLUDED_ATTRIBUTES.put(objectName, excludeAttributes);
        }
        for (String columnName : columns) {
            if (columnName == null) continue;
            excludeAttributes.add(columnName);
        }
    }

    public void filterTables(TableSupport[][] tables, QueryOptions[] options) {
    }

    protected Set<ObjectName> getDomainMBeans() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Set<ObjectName> objNames;
        HashSet<ObjectName> oldObjNames;
        block7: {
            String METHOD_NAME = "run";
            if (this.m_init != Status.RUNNING) {
                return;
            }
            MetricConvertor metricConvertor = this;
            synchronized (metricConvertor) {
                oldObjNames = new HashSet<ObjectName>(this.m_rowInfoByMBeans.keySet());
            }
            try {
                objNames = this.m_mbeanServer.queryNames(QUERY_ALL_MBEANS, null);
                this._processMBeans(objNames, oldObjNames, this.m_mbeanServer);
            }
            catch (Throwable e) {
                if (!LOGGER.isLoggable(Level.INFO)) break block7;
                LOGGER.logp(Level.INFO, this.getClass().getName(), "run", "DMS-50973", e);
            }
        }
        if (this.m_domainMBeanServer != null) {
            objNames = this.getDomainMBeans();
            this._processMBeans(objNames, oldObjNames, this.m_domainMBeanServer);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object obj) {
        if (!(notification instanceof MBeanServerNotification)) {
            return;
        }
        MBeanServerNotification msnotification = (MBeanServerNotification)notification;
        String nType = msnotification.getType();
        ObjectName mbn = msnotification.getMBeanName();
        if (nType.equals("JMX.mbean.registered")) {
            HashSet<ObjectName> objNames = new HashSet<ObjectName>(2);
            objNames.add(mbn);
            this.convertToMetrics(objNames, this.m_mbeanServer);
        } else if (nType.equals("JMX.mbean.unregistered")) {
            this.removeMetric(mbn);
        }
    }

    static {
        TABLE_KEYS = new String[]{"ObjectName", "ServerName"};
        ObjectName queryAllMBean = null;
        try {
            queryAllMBean = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        QUERY_ALL_MBEANS = queryAllMBean;
    }

    private static enum Status {
        INIT,
        RUNNING,
        STOP;

    }
}

