/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.ArrayList;
import java.util.List;
import oracle.dms.context.DMSContextManager;
import oracle.dms.context.ExecutionContext;
import oracle.dms.instrument.BucketSensor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;

public class Bucket {
    static void drop(Sensor sensor, long amount, long updateTime) {
        ArrayList<Noun> bucketNouns = Bucket.getBucketNouns(sensor, null, null, null);
        if (bucketNouns == null) {
            return;
        }
        for (Noun noun : bucketNouns) {
            BucketSensor bucketSensor = Bucket.getBucketSensor(noun, sensor);
            if (bucketSensor == null) continue;
            bucketSensor.update(amount, updateTime);
        }
    }

    static void drop(Sensor sensor, int amount, long updateTime) {
        ArrayList<Noun> bucketNouns = Bucket.getBucketNouns(sensor, null, null, null);
        if (bucketNouns == null) {
            return;
        }
        for (Noun noun : bucketNouns) {
            BucketSensor bucketSensor = Bucket.getBucketSensor(noun, sensor);
            if (bucketSensor == null) continue;
            bucketSensor.update(amount, updateTime);
        }
    }

    static void drop(Sensor sensor, double amount, long updateTime) {
        ArrayList<Noun> bucketNouns = Bucket.getBucketNouns(sensor, null, null, null);
        if (bucketNouns == null) {
            return;
        }
        for (Noun noun : bucketNouns) {
            BucketSensor bucketSensor = Bucket.getBucketSensor(noun, sensor);
            if (bucketSensor == null) continue;
            bucketSensor.update(amount, updateTime);
        }
    }

    static List<Noun> drop(Sensor originalSensor, List<String> bucketKeys, List<String> bucketValues, Number numberValue, long updateTime) {
        ArrayList<Noun> bucketNouns = Bucket.getBucketNouns(originalSensor, bucketKeys, bucketValues, null);
        if (bucketNouns == null) {
            return null;
        }
        for (Noun noun : bucketNouns) {
            BucketSensor bucketSensor = Bucket.getBucketSensor(noun, originalSensor);
            if (bucketSensor == null) continue;
            if (numberValue instanceof Integer) {
                bucketSensor.update(((Integer)numberValue).intValue(), updateTime);
                continue;
            }
            if (numberValue instanceof Double) {
                bucketSensor.update((Double)numberValue, updateTime);
                continue;
            }
            if (!(numberValue instanceof Long)) continue;
            bucketSensor.update((Long)numberValue, updateTime);
        }
        return bucketNouns;
    }

    static boolean isBucketed(Sensor sensor) {
        if (sensor == null) {
            return false;
        }
        Noun noun = sensor.getParent();
        ArrayList<String> bucketKeys = noun.getBucketKeys();
        return bucketKeys != null && bucketKeys.size() > 0;
    }

    private static ArrayList<Noun> getBucketNouns(Sensor sensor, List<String> bucketKeys, List<String> bucketValues, ExecutionContext ctx) {
        Noun parent = sensor.getParent();
        if (bucketKeys == null) {
            bucketKeys = parent.getBucketKeys();
        }
        if (bucketKeys == null) {
            return null;
        }
        if (bucketValues == null) {
            if (ctx == null) {
                ctx = DMSContextManager.getActiveContext();
            }
            if (ctx != null) {
                bucketValues = new ArrayList<String>(bucketKeys.size());
                for (String bucketKey : bucketKeys) {
                    if (bucketKey == null) {
                        bucketValues.add(null);
                        continue;
                    }
                    String bucketValue = ctx.getValue(bucketKey);
                    bucketValues.add(bucketValue);
                }
            }
        }
        if (bucketValues == null) {
            return null;
        }
        ArrayList<Noun> bucketNouns = new ArrayList<Noun>();
        for (int index = 0; index < bucketKeys.size(); ++index) {
            Noun bucketNoun;
            String bucketKey = bucketKeys.get(index);
            String bucketValue = null;
            if (index < bucketValues.size()) {
                bucketValue = bucketValues.get(index);
            }
            if (bucketKey == null || bucketValue == null || (bucketNoun = Bucket.getBucketNoun(parent, bucketKey, bucketValue)) == null) continue;
            bucketNouns.add(bucketNoun);
        }
        return bucketNouns;
    }

    private static BucketSensor getBucketSensor(Noun bucket, Sensor sens) {
        Sensor sensor = bucket.getSensor(sens.getName());
        if (sensor != null) {
            return (BucketSensor)sensor;
        }
        return BucketSensor.create(bucket, sens);
    }

    static Noun getBucketNoun(Noun noun, String key, String value) {
        String name;
        if (noun == null || key == null || value == null) {
            return null;
        }
        Noun parent = noun.getParent();
        Noun bucket = parent.getChild(name = noun.getName() + "_B" + key + "_" + value);
        if (bucket != null) {
            return bucket;
        }
        String type = noun.getType() + "_bucketBy_" + key;
        bucket = Noun.create(parent, name, type);
        Bucket.createBucketSensors(noun, bucket);
        return bucket;
    }

    static void createBucketSensors(Noun original, Noun bucket) {
        Sensor[] sensors;
        for (Sensor sensor : sensors = original.getSensors()) {
            BucketSensor.create(bucket, sensor);
        }
    }
}

