/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.config.DiagnosticsConfigurationException;
import oracle.dfw.config.DumpSampleInfo;
import oracle.dfw.impl.common.MapUtils;
import oracle.dfw.sampling.DumpSamplingArchive;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class DiagnosticsConfiguration {
    private Object _config_sync = new Object();
    private int m_maxTotalIncidentSize = 500;
    private long m_tempDirMaxSize = 100L;
    private long m_tempDirInterval = 21600L;
    private boolean m_incidentCreationEnabled = true;
    private boolean m_logDetectionEnabled = true;
    private boolean m_floodControlEnabled = true;
    private int m_floodControlIncidentCount = 5;
    private int m_floodControlIncidentTimePeriod = 60;
    private int m_reservedMemoryKB = 512;
    private boolean m_threadDumpUseExternalCommands = true;
    private boolean m_uncaughtExceptionDetectionEnabled = true;
    private Map<String, String> m_problemKeyFilters = new HashMap<String, String>(1);
    private DocumentBuilderFactory m_schemaFactory = DocumentBuilderFactory.newInstance();
    private boolean m_dumpSamplingEnabled = true;
    private boolean m_dumpSamplingIdleWhenHealthy = true;
    private long m_dumpSamplingMinimumHealthyPeriod = 259200000L;
    private Map<String, DumpSampleInfo> m_dumpSamples = new LinkedHashMap<String, DumpSampleInfo>(1);
    private static final String SCHEMA_FILE = "/oracle/dfw/config/diagnostic_config.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String DIAGNOSTICS_NAMESPACE = "http://xmlns.oracle.com/DFW/DiagnosticsFrameworkConfiguration";

    public DiagnosticsConfiguration() throws DiagnosticsConfigurationException {
        this.m_schemaFactory.setNamespaceAware(true);
        this.m_schemaFactory.setValidating(true);
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, "http://www.w3.org/2001/XMLSchema");
        URL defaultSchema = AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return this.getClass().getResource(DiagnosticsConfiguration.SCHEMA_FILE);
            }
        });
        if (defaultSchema == null) {
            throw new DiagnosticsConfigurationException("DFW-40200", SCHEMA_FILE);
        }
        this.m_schemaFactory.setAttribute(JAXP_SCHEMA_SOURCE, defaultSchema.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseDiagnosticsConfiguration(InputStream confStream) throws DiagnosticsConfigurationException {
        Document document = null;
        ConfigErrorHandler errorHandler = new ConfigErrorHandler();
        try {
            DocumentBuilder parser = this.m_schemaFactory.newDocumentBuilder();
            parser.setErrorHandler(errorHandler);
            document = parser.parse(confStream);
        }
        catch (Exception e) {
            throw new DiagnosticsConfigurationException("DFW-40201", e);
        }
        if (errorHandler.getException() != null) {
            throw new DiagnosticsConfigurationException("DFW-40201", errorHandler.getException());
        }
        if (document == null) {
            throw new DiagnosticsConfigurationException("DFW-40201");
        }
        Element config = document.getDocumentElement();
        if (config == null) {
            throw new DiagnosticsConfigurationException("DFW-40201");
        }
        NodeList nodes = config.getElementsByTagName("incidentCleanup");
        Element incidentCleanup = (Element)nodes.item(0);
        NodeList nodes1 = config.getElementsByTagName("tempDirCleanup");
        Element tempDirCleanup = null;
        if (nodes1 != null) {
            tempDirCleanup = (Element)nodes1.item(0);
        }
        Object object = this._config_sync;
        synchronized (object) {
            int i;
            Element dumpSampling;
            String tdStr;
            this.m_maxTotalIncidentSize = Integer.parseInt(incidentCleanup.getAttribute("maxTotalIncidentSize"));
            if (tempDirCleanup != null) {
                this.m_tempDirMaxSize = Long.parseLong(tempDirCleanup.getAttribute("maxSize"));
                this.m_tempDirInterval = Long.parseLong(tempDirCleanup.getAttribute("interval"));
            }
            nodes = config.getElementsByTagName("incidentCreation");
            Element incidentCreation = (Element)nodes.item(0);
            this.m_incidentCreationEnabled = Boolean.parseBoolean(incidentCreation.getAttribute("incidentCreationEnabled"));
            this.m_logDetectionEnabled = Boolean.parseBoolean(incidentCreation.getAttribute("logDetectionEnabled"));
            this.m_floodControlEnabled = Boolean.parseBoolean(incidentCreation.getAttribute("floodControlEnabled"));
            this.m_floodControlIncidentCount = Integer.parseInt(incidentCreation.getAttribute("floodControlIncidentCount"));
            this.m_floodControlIncidentTimePeriod = Integer.parseInt(incidentCreation.getAttribute("floodControlIncidentTimePeriod"));
            String rmStr = incidentCreation.getAttribute("reservedMemoryKB");
            if (rmStr != null && rmStr.length() > 0) {
                this.m_reservedMemoryKB = Integer.parseInt(rmStr);
            }
            this.m_uncaughtExceptionDetectionEnabled = Boolean.parseBoolean(incidentCreation.getAttribute("uncaughtExceptionDetectionEnabled"));
            nodes = config.getElementsByTagName("threadDump");
            Element threadDump = (Element)nodes.item(0);
            if (threadDump != null && (tdStr = threadDump.getAttribute("useExternalCommands")) != null) {
                this.m_threadDumpUseExternalCommands = Boolean.parseBoolean(tdStr);
            }
            if ((dumpSampling = (Element)(nodes = config.getElementsByTagName("dumpSampling")).item(0)) != null) {
                this.m_dumpSamplingEnabled = Boolean.parseBoolean(dumpSampling.getAttribute("enabled"));
                this.m_dumpSamplingIdleWhenHealthy = Boolean.parseBoolean(dumpSampling.getAttribute("idleWhenHealthy"));
                this.m_dumpSamplingMinimumHealthyPeriod = Long.parseLong(dumpSampling.getAttribute("minHealthyPeriod"));
                nodes = dumpSampling.getElementsByTagName("dumpSample");
                if (nodes != null) {
                    for (i = 0; i < nodes.getLength(); ++i) {
                        Element dumpSample = (Element)nodes.item(i);
                        String name = dumpSample.getAttribute("sampleName");
                        if (name == null || name.length() <= 0) continue;
                        DumpSampleInfo di = new DumpSampleInfo();
                        di.setSampleName(name);
                        String diagnosticDumpName = dumpSample.getAttribute("diagnosticDumpName");
                        if (diagnosticDumpName != null && diagnosticDumpName.equals(DumpSamplingArchive.getDiagnosticDumpName())) {
                            throw new DiagnosticsConfigurationException("DFW-40210", diagnosticDumpName);
                        }
                        di.setDiagnosticDumpName(diagnosticDumpName);
                        di.setAppName(dumpSample.getAttribute("appName"));
                        di.setSamplingInterval(Long.parseLong(dumpSample.getAttribute("samplingInterval")));
                        di.setRotationCount(Long.parseLong(dumpSample.getAttribute("rotationCount")));
                        di.setToBeDumpedImplicitly(Boolean.parseBoolean(dumpSample.getAttribute("dumpedImplicitly")));
                        di.setToAppend(Boolean.parseBoolean(dumpSample.getAttribute("toAppend")));
                        NodeList dumpArgs = dumpSample.getElementsByTagName("dumpArgument");
                        if (dumpArgs != null && dumpArgs.getLength() > 0) {
                            HashMap<String, String> args = new HashMap<String, String>(1);
                            for (int j = 0; j < dumpArgs.getLength(); ++j) {
                                Element elm = (Element)dumpArgs.item(j);
                                String argName = elm.getAttribute("name");
                                String argValue = elm.getAttribute("value");
                                if (argName == null || argName.length() <= 0) continue;
                                args.put(argName, argValue);
                            }
                            if (args.size() > 0) {
                                di.setDumpArguments(args);
                            }
                        }
                        this.m_dumpSamples.put(name, di);
                    }
                }
            }
            if ((nodes = config.getElementsByTagName("filter")).getLength() > 0) {
                for (i = 0; i < nodes.getLength(); ++i) {
                    Element filter = (Element)nodes.item(i);
                    this.m_problemKeyFilters.put(filter.getAttribute("id"), filter.getAttribute("pattern"));
                }
            }
            DiagnosticsEventManager.notifyListeners(new DiagnosticsConfigurationChangedEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createDiagnosticsConfiguration(OutputStream out) throws DiagnosticsConfigurationException {
        Document document = null;
        try {
            DocumentBuilder parser = this.m_schemaFactory.newDocumentBuilder();
            document = parser.getDOMImplementation().createDocument(DIAGNOSTICS_NAMESPACE, "diagnosticsConfiguration", null);
        }
        catch (Exception e) {
            throw new DiagnosticsConfigurationException("DFW-40202", e);
        }
        if (document == null) {
            throw new DiagnosticsConfigurationException("DFW-40202");
        }
        Element config = document.getDocumentElement();
        if (config == null) {
            throw new DiagnosticsConfigurationException("DFW-40202");
        }
        config.setAttribute("xmlns", DIAGNOSTICS_NAMESPACE);
        config.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema-instance");
        Element incidentCleanup = document.createElementNS(DIAGNOSTICS_NAMESPACE, "incidentCleanup");
        config.appendChild(incidentCleanup);
        Element incidentCreation = document.createElementNS(DIAGNOSTICS_NAMESPACE, "incidentCreation");
        config.appendChild(incidentCreation);
        Element tempDirCleanup = document.createElementNS(DIAGNOSTICS_NAMESPACE, "tempDirCleanup");
        config.appendChild(tempDirCleanup);
        Element threadDump = document.createElementNS(DIAGNOSTICS_NAMESPACE, "threadDump");
        config.appendChild(threadDump);
        Element dumpSampling = document.createElementNS(DIAGNOSTICS_NAMESPACE, "dumpSampling");
        config.appendChild(dumpSampling);
        Element problemKeyFilters = document.createElementNS(DIAGNOSTICS_NAMESPACE, "problemKeyFilters");
        config.appendChild(problemKeyFilters);
        Object object = this._config_sync;
        synchronized (object) {
            incidentCleanup.setAttribute("maxTotalIncidentSize", Integer.toString(this.m_maxTotalIncidentSize));
            tempDirCleanup.setAttribute("maxSize", Long.toString(this.m_tempDirMaxSize));
            tempDirCleanup.setAttribute("interval", Long.toString(this.m_tempDirInterval));
            incidentCreation.setAttribute("incidentCreationEnabled", Boolean.toString(this.m_incidentCreationEnabled));
            incidentCreation.setAttribute("logDetectionEnabled", Boolean.toString(this.m_logDetectionEnabled));
            incidentCreation.setAttribute("floodControlEnabled", Boolean.toString(this.m_floodControlEnabled));
            incidentCreation.setAttribute("floodControlIncidentCount", Integer.toString(this.m_floodControlIncidentCount));
            incidentCreation.setAttribute("floodControlIncidentTimePeriod", Integer.toString(this.m_floodControlIncidentTimePeriod));
            incidentCreation.setAttribute("reservedMemoryKB", Integer.toString(this.m_reservedMemoryKB));
            incidentCreation.setAttribute("uncaughtExceptionDetectionEnabled", Boolean.toString(this.m_uncaughtExceptionDetectionEnabled));
            threadDump.setAttribute("useExternalCommands", Boolean.toString(this.m_threadDumpUseExternalCommands));
            dumpSampling.setAttribute("enabled", Boolean.toString(this.m_dumpSamplingEnabled));
            dumpSampling.setAttribute("idleWhenHealthy", Boolean.toString(this.m_dumpSamplingIdleWhenHealthy));
            dumpSampling.setAttribute("minHealthyPeriod", Long.toString(this.m_dumpSamplingMinimumHealthyPeriod));
            for (Map.Entry<String, DumpSampleInfo> entry : this.m_dumpSamples.entrySet()) {
                if (entry == null || entry.getKey() == null) continue;
                DumpSampleInfo di = entry.getValue();
                Element dumpSampleElement = document.createElementNS(DIAGNOSTICS_NAMESPACE, "dumpSample");
                dumpSampling.appendChild(dumpSampleElement);
                dumpSampleElement.setAttribute("sampleName", di.getSampleName());
                dumpSampleElement.setAttribute("diagnosticDumpName", di.getDiagnosticDumpName());
                dumpSampleElement.setAttribute("appName", di.getAppName());
                dumpSampleElement.setAttribute("samplingInterval", Long.toString(di.getSamplingInterval()));
                dumpSampleElement.setAttribute("rotationCount", Long.toString(di.getRotationCount()));
                dumpSampleElement.setAttribute("dumpedImplicitly", Boolean.toString(di.canBeDumpedImplicitly()));
                dumpSampleElement.setAttribute("toAppend", Boolean.toString(di.isAppending()));
                Map<String, String> dumpArguments = di.getDumpArguments();
                if (dumpArguments == null || dumpArguments.size() <= 0) continue;
                for (Map.Entry<String, String> e : dumpArguments.entrySet()) {
                    if (e == null || e.getKey() == null) continue;
                    Element dumpArgument = document.createElementNS(DIAGNOSTICS_NAMESPACE, "dumpArgument");
                    dumpSampleElement.appendChild(dumpArgument);
                    dumpArgument.setAttribute("name", e.getKey());
                    dumpArgument.setAttribute("value", e.getValue());
                }
            }
            for (Map.Entry<String, Object> entry : this.m_problemKeyFilters.entrySet()) {
                Element filterElement = document.createElementNS(DIAGNOSTICS_NAMESPACE, "filter");
                problemKeyFilters.appendChild(filterElement);
                filterElement.setAttribute("id", entry.getKey());
                filterElement.setAttribute("pattern", (String)entry.getValue());
            }
        }
        try {
            Transformer tf = TransformerFactory.newInstance().newTransformer();
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tf.transform(new DOMSource(config), new StreamResult(out));
        }
        catch (TransformerException te) {
            throw new DiagnosticsConfigurationException("DFW-40202", te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxTotalIncidentSize() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_maxTotalIncidentSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTempDirMaxSize() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_tempDirMaxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTempDirMaxSizeInBytes() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_tempDirMaxSize * 1024L * 1024L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTempDirInterval() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_tempDirInterval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTempDirIntervalInMilli() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_tempDirInterval * 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean useThreadDumpExternalCommands() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_threadDumpUseExternalCommands;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIncidentCreationEnabled() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_incidentCreationEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLogDetectionEnabled() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_logDetectionEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFloodControlEnabled() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_floodControlEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFloodControlIncidentCount() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_floodControlIncidentCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFloodControlIncidentTimePeriod() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_floodControlIncidentTimePeriod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReservedMemoryKB() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_reservedMemoryKB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUncaughtExceptionDetectionEnabled() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_uncaughtExceptionDetectionEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDumpSamplingEnabled() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_dumpSamplingEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDumpSamplingIdleWhenHealthy() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_dumpSamplingIdleWhenHealthy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDumpSamplingMinimumHealthyPeriod() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_dumpSamplingMinimumHealthyPeriod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDumpSamplingMinimumHealthyPeriodInMillis() {
        Object object = this._config_sync;
        synchronized (object) {
            return this.m_dumpSamplingMinimumHealthyPeriod * 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DumpSampleInfo> getDumpSamples() {
        Object object = this._config_sync;
        synchronized (object) {
            return new LinkedHashMap<String, DumpSampleInfo>(this.m_dumpSamples);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProblemKeyFilters() {
        Object object = this._config_sync;
        synchronized (object) {
            return new HashMap<String, String>(this.m_problemKeyFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getAttributes(String[] attributes) {
        HashMap<String, Object> al = new HashMap<String, Object>();
        Object object = this._config_sync;
        synchronized (object) {
            for (String att : attributes) {
                Map<String, String> v = null;
                if ((att = att.intern()) == "maxTotalIncidentSize") {
                    v = this.m_maxTotalIncidentSize;
                } else if (att == "maxSize") {
                    v = this.m_tempDirMaxSize;
                } else if (att == "interval") {
                    v = this.m_tempDirInterval;
                } else if (att == "incidentCreationEnabled") {
                    v = this.m_incidentCreationEnabled;
                } else if (att == "logDetectionEnabled") {
                    v = this.m_logDetectionEnabled;
                } else if (att == "floodControlEnabled") {
                    v = this.m_floodControlEnabled;
                } else if (att == "floodControlIncidentCount") {
                    v = this.m_floodControlIncidentCount;
                } else if (att == "floodControlIncidentTimePeriod") {
                    v = this.m_floodControlIncidentTimePeriod;
                } else if (att == "reservedMemoryKB") {
                    v = this.m_reservedMemoryKB;
                } else if (att == "useExternalCommands") {
                    v = this.m_threadDumpUseExternalCommands;
                } else if (att == "uncaughtExceptionDetectionEnabled") {
                    v = this.m_uncaughtExceptionDetectionEnabled;
                } else if (att == "enabled") {
                    v = this.m_dumpSamplingEnabled;
                } else if (att == "idleWhenHealthy") {
                    v = this.m_dumpSamplingIdleWhenHealthy;
                } else if (att == "minHealthyPeriod") {
                    v = this.m_dumpSamplingMinimumHealthyPeriod;
                } else if (att == "dumpSampling") {
                    v = this.m_dumpSamples;
                } else {
                    if (att != "problemKeyFilters") continue;
                    v = this.m_problemKeyFilters;
                }
                al.put(att, v);
            }
        }
        return al;
    }

    public Map<String, Object> setAttributes(Map<String, Object> attributes) {
        return this.setAttributes(attributes, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> setAttributes(Map<String, Object> attributes, boolean sentEventOnChange) {
        HashMap<String, Object> al = new HashMap<String, Object>();
        Object object = this._config_sync;
        synchronized (object) {
            for (Map.Entry<String, Object> keyAtt : attributes.entrySet()) {
                Object v = keyAtt.getValue();
                String att = keyAtt.getKey();
                if ((att = att.intern()) == "maxTotalIncidentSize") {
                    if (!(v instanceof Integer)) continue;
                    this.m_maxTotalIncidentSize = (Integer)v;
                } else if (att == "maxSize") {
                    if (!(v instanceof Long)) continue;
                    this.m_tempDirMaxSize = (Long)v;
                } else if (att == "interval") {
                    if (!(v instanceof Long)) continue;
                    this.m_tempDirInterval = (Long)v;
                } else if (att == "incidentCreationEnabled") {
                    if (!(v instanceof Boolean)) continue;
                    this.m_incidentCreationEnabled = (Boolean)v;
                } else if (att == "logDetectionEnabled") {
                    if (!(v instanceof Boolean)) continue;
                    this.m_logDetectionEnabled = (Boolean)v;
                } else if (att == "floodControlEnabled") {
                    if (!(v instanceof Boolean)) continue;
                    this.m_floodControlEnabled = (Boolean)v;
                } else if (att == "floodControlIncidentCount") {
                    if (!(v instanceof Integer)) continue;
                    this.m_floodControlIncidentCount = (Integer)v;
                } else if (att == "floodControlIncidentTimePeriod") {
                    if (!(v instanceof Integer)) continue;
                    this.m_floodControlIncidentTimePeriod = (Integer)v;
                } else if (att == "reservedMemoryKB") {
                    if (!(v instanceof Integer)) continue;
                    this.m_reservedMemoryKB = (Integer)v;
                } else if (att == "uncaughtExceptionDetectionEnabled") {
                    if (!(v instanceof Boolean)) continue;
                    this.m_uncaughtExceptionDetectionEnabled = (Boolean)v;
                } else if (att == "enabled") {
                    if (!(v instanceof Boolean)) continue;
                    this.m_dumpSamplingEnabled = (Boolean)v;
                } else if (att == "idleWhenHealthy") {
                    if (!(v instanceof Boolean)) continue;
                    this.m_dumpSamplingIdleWhenHealthy = (Boolean)v;
                } else if (att == "minHealthyPeriod") {
                    if (!(v instanceof Long)) continue;
                    this.m_dumpSamplingMinimumHealthyPeriod = (Long)v;
                } else if (att == "useExternalCommands") {
                    if (!(v instanceof Boolean)) continue;
                    this.m_threadDumpUseExternalCommands = (Boolean)v;
                } else if (att == "dumpSampling") {
                    if (!(v instanceof Map)) continue;
                    this.m_dumpSamples.clear();
                    for (Map.Entry e : ((Map)v).entrySet()) {
                        this.m_dumpSamples.put((String)e.getKey(), (DumpSampleInfo)e.getValue());
                    }
                } else {
                    if (att != "problemKeyFilters" || !(v instanceof Map)) continue;
                    this.m_problemKeyFilters.clear();
                    for (Map.Entry filter : ((Map)v).entrySet()) {
                        try {
                            Pattern.compile((String)filter.getValue());
                        }
                        catch (PatternSyntaxException e) {
                            throw new IllegalArgumentException("invalid Problem Key filter pattern \"" + (String)filter.getValue() + "\"; it should be a valid regular expression", e);
                        }
                        this.m_problemKeyFilters.put((String)filter.getKey(), (String)filter.getValue());
                    }
                }
                al.put(att, v);
            }
        }
        if (!al.isEmpty() && sentEventOnChange) {
            DiagnosticsEventManager.notifyListeners(new DiagnosticsConfigurationChangedEvent(this, al), false);
        }
        return al;
    }

    public void sync(DiagnosticsConfiguration sourceConfig) {
        if (sourceConfig == null) {
            return;
        }
        HashMap<String, Object> changes = new HashMap<String, Object>();
        if (this.m_maxTotalIncidentSize != sourceConfig.getMaxTotalIncidentSize()) {
            changes.put("maxTotalIncidentSize", sourceConfig.getMaxTotalIncidentSize());
        }
        if (this.m_tempDirMaxSize != sourceConfig.getTempDirMaxSize()) {
            changes.put("maxSize", sourceConfig.getTempDirMaxSize());
        }
        if (this.m_tempDirInterval != sourceConfig.getTempDirInterval()) {
            changes.put("interval", sourceConfig.getTempDirInterval());
        }
        if (this.m_incidentCreationEnabled != sourceConfig.isIncidentCreationEnabled()) {
            changes.put("incidentCreationEnabled", sourceConfig.isIncidentCreationEnabled());
        }
        if (this.m_logDetectionEnabled != sourceConfig.isLogDetectionEnabled()) {
            changes.put("logDetectionEnabled", sourceConfig.isLogDetectionEnabled());
        }
        if (this.m_floodControlEnabled != sourceConfig.isFloodControlEnabled()) {
            changes.put("floodControlEnabled", sourceConfig.isFloodControlEnabled());
        }
        if (this.m_floodControlIncidentCount != sourceConfig.getFloodControlIncidentCount()) {
            changes.put("floodControlIncidentCount", sourceConfig.getFloodControlIncidentCount());
        }
        if (this.m_floodControlIncidentTimePeriod != sourceConfig.getFloodControlIncidentTimePeriod()) {
            changes.put("floodControlIncidentTimePeriod", sourceConfig.getFloodControlIncidentTimePeriod());
        }
        if (this.m_reservedMemoryKB != sourceConfig.getReservedMemoryKB()) {
            changes.put("reservedMemoryKB", sourceConfig.getReservedMemoryKB());
        }
        if (this.m_threadDumpUseExternalCommands != sourceConfig.useThreadDumpExternalCommands()) {
            changes.put("useExternalCommands", sourceConfig.useThreadDumpExternalCommands());
        }
        if (!MapUtils.compare(this.m_dumpSamples, sourceConfig.getDumpSamples())) {
            changes.put("dumpSampling", sourceConfig.getDumpSamples());
        }
        if (this.m_uncaughtExceptionDetectionEnabled != sourceConfig.isUncaughtExceptionDetectionEnabled()) {
            changes.put("uncaughtExceptionDetectionEnabled", sourceConfig.isUncaughtExceptionDetectionEnabled());
        }
        if (this.m_dumpSamplingEnabled != sourceConfig.isDumpSamplingEnabled()) {
            changes.put("enabled", sourceConfig.isDumpSamplingEnabled());
        }
        if (this.m_dumpSamplingIdleWhenHealthy != sourceConfig.isDumpSamplingIdleWhenHealthy()) {
            changes.put("idleWhenHealthy", sourceConfig.isDumpSamplingIdleWhenHealthy());
        }
        if (this.m_dumpSamplingMinimumHealthyPeriod != sourceConfig.getDumpSamplingMinimumHealthyPeriod()) {
            changes.put("minHealthyPeriod", sourceConfig.getDumpSamplingMinimumHealthyPeriod());
        }
        if (!MapUtils.compare(this.m_problemKeyFilters, sourceConfig.getProblemKeyFilters())) {
            changes.put("problemKeyFilters", sourceConfig.getProblemKeyFilters());
        }
        if (!changes.isEmpty()) {
            this.setAttributes(changes);
        }
    }

    private static class ConfigErrorHandler
    implements ErrorHandler {
        private SAXParseException m_parseException = null;

        private ConfigErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
            this.m_parseException = exception;
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.m_parseException = exception;
        }

        @Override
        public void warning(SAXParseException exception) {
        }

        public SAXParseException getException() {
            return this.m_parseException;
        }
    }
}

