/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.dms.event.Destination;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.util.StackTrace;
import oracle.dms.util.StackTraceAggregate;
import oracle.dms.util.Validatable;

public class StackTraceLifecycleListener
implements Destination {
    private static boolean mReportNouns = true;
    private static boolean mReportSensors = false;
    private static boolean mReportStackTraces = false;
    private static boolean mClearStackTraces = false;
    private static AtomicInteger sInstanceCount = new AtomicInteger(0);
    private int mInstance = 0;
    private StackTraceAggregate cnsta = new StackTraceAggregate();
    private StackTraceAggregate dnsta = new StackTraceAggregate();
    private StackTraceAggregate cssta = new StackTraceAggregate();
    private StackTraceAggregate dssta = new StackTraceAggregate();

    public static void enableReportNouns() {
        mReportNouns = true;
    }

    public static void disableReportNouns() {
        mReportNouns = false;
    }

    public static void enableReportSensors() {
        mReportSensors = true;
    }

    public static void disableReportSensors() {
        mReportSensors = false;
    }

    public static void printStackTraces() {
        mReportStackTraces = true;
    }

    public static void clearStackTraces() {
        mClearStackTraces = true;
    }

    public StackTraceLifecycleListener() {
        this.mInstance = sInstanceCount.incrementAndGet();
    }

    @Override
    public void handleEvent(Event event) {
        if (mReportStackTraces) {
            if (mReportNouns) {
                this.cnsta.printStackTraces("NOUN.CREATE");
                this.dnsta.printStackTraces("NOUN.DELETE");
            }
            if (mReportSensors) {
                this.cssta.printStackTraces("SENSOR.CREATE");
                this.dssta.printStackTraces("SENSOR.DELETE");
            }
            mReportStackTraces = false;
        }
        if (mClearStackTraces) {
            this.cnsta.clearStackTraces();
            this.dnsta.clearStackTraces();
            this.cssta.clearStackTraces();
            this.dssta.clearStackTraces();
            mClearStackTraces = false;
        }
        if (mReportNouns && event.getSourceType().isTypeOf(EventSourceType.NOUN)) {
            if (event.getActionType() == EventActionType.CREATE) {
                this.cnsta.addStackTrace(new StackTrace());
                return;
            }
            if (event.getActionType() == EventActionType.DELETE) {
                this.dnsta.addStackTrace(new StackTrace());
                return;
            }
        }
        if (mReportSensors && event.getSourceType().isTypeOf(EventSourceType.SENSOR)) {
            if (event.getActionType() == EventActionType.CREATE) {
                this.cssta.addStackTrace(new StackTrace());
                return;
            }
            if (event.getActionType() == EventActionType.DELETE) {
                this.dssta.addStackTrace(new StackTrace());
                return;
            }
        }
    }

    @Override
    public String getId() {
        return "StackTraceLifecycleListener" + this.mInstance;
    }

    public void setId(String id) {
    }

    public void setName(String name) {
    }

    @Override
    public String getName() {
        return "StackTraceLifecycleListener" + this.mInstance;
    }

    @Override
    public boolean needsContext() {
        return false;
    }

    @Override
    public void initDestination() {
    }

    @Override
    public void shutdownDestination() {
    }

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) {
    }
}

