/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.event.config;

public enum DataType {
    LONG,
    STRING,
    DOUBLE;


    public static DataType getDataType(String dataType) {
        try {
            return DataType.valueOf(dataType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static DataType getDataType(String dataType, String dataTypeValue) {
        DataType derivedDataType = STRING;
        if (dataType != null) {
            try {
                derivedDataType = DataType.valueOf(dataType.toUpperCase());
            }
            catch (IllegalArgumentException e) {}
        } else if (dataTypeValue != null) {
            if (dataTypeValue.indexOf(46) != -1) {
                boolean allFloat = true;
                for (int i = 0; i < dataTypeValue.length(); ++i) {
                    if (Character.isDigit(dataTypeValue.charAt(i)) || Character.toString(dataTypeValue.charAt(i)).equals(".")) continue;
                    allFloat = false;
                    break;
                }
                if (allFloat) {
                    derivedDataType = DOUBLE;
                }
            } else {
                boolean allInteger = true;
                for (int i = 0; i < dataTypeValue.length(); ++i) {
                    if (Character.isDigit(dataTypeValue.charAt(i))) continue;
                    allInteger = false;
                    break;
                }
                if (allInteger) {
                    derivedDataType = LONG;
                }
            }
        }
        return derivedDataType;
    }

    public static DataType getDataType(DataType dataType, String dataTypeValue) {
        if (dataType == null) {
            return DataType.getDataType((String)null, dataTypeValue);
        }
        return DataType.getDataType(dataType.toString(), dataTypeValue);
    }
}

