/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.incident;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dfw.common.DiagnosticsEvent;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.DiagnosticsListener;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.config.DiagnosticsConfigurationChangedEvent;
import oracle.dfw.impl.dump.ClassHistogram;
import oracle.dfw.incident.IncidentFacts;

class FloodController
implements Runnable,
DiagnosticsListener {
    private boolean m_isEnabled;
    private boolean m_stop = false;
    private boolean m_reset = true;
    private static Object m_sync = new Object();
    private Logger m_logger = LoggerFactory.getFrameworkLogger();
    private Map<String, FloodIncident> m_incidents = Collections.synchronizedMap(new HashMap());
    private int m_incidentCount = 1;
    private long m_incidentTimePeriod = 900000L;
    private static long ONE_MINUTE_IN_MS = 60000L;
    private static final long SLEEP_INTERVAL = 60000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FloodController(DiagnosticsConfiguration diagConfig) {
        Object object = m_sync;
        synchronized (object) {
            Thread floodThread = new Thread(this);
            floodThread.setDaemon(true);
            floodThread.setName("oracle.dfw.incident.FloodController");
            floodThread.start();
            this.setConfig(diagConfig);
        }
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.fine("DFW Flood control initialized [enabled=" + diagConfig.isFloodControlEnabled() + "][floodControlIncidentCount=" + diagConfig.getFloodControlIncidentCount() + "][floodControlTimeoutPeriod=" + diagConfig.getFloodControlIncidentTimePeriod() + " minutes]");
        }
        DiagnosticsEventManager.registerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastIncidentId(String problemKey, String incidentId) {
        if (!this.m_isEnabled) {
            return;
        }
        Map<String, FloodIncident> map = this.m_incidents;
        synchronized (map) {
            FloodIncident floodIncident = this.m_incidents.get(problemKey);
            if (floodIncident != null) {
                floodIncident.setLastIncidentId(incidentId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String isFloodControlled(IncidentFacts facts) {
        if (!this.m_isEnabled) {
            return null;
        }
        String isFloodControlled = null;
        Map<String, FloodIncident> map = this.m_incidents;
        synchronized (map) {
            FloodIncident floodIncident = this.m_incidents.get(facts.getProblemKey());
            if (floodIncident != null) {
                boolean floodControlled = floodIncident.getAccessCount() >= this.m_incidentCount;
                floodIncident.accessed();
                if (floodControlled) {
                    isFloodControlled = floodIncident.getLastIncidentId();
                }
            } else {
                this.m_incidents.put(facts.getProblemKey(), new FloodIncident());
            }
        }
        return isFloodControlled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.m_logger.fine("DFW Flood control daemon started");
        while (true) {
            Object object = m_sync;
            synchronized (object) {
                try {
                    this.m_reset = false;
                    if (this.m_isEnabled) {
                        m_sync.wait(60000L);
                    } else {
                        if (this.m_logger.isLoggable(Level.FINEST)) {
                            this.m_logger.log(Level.FINEST, "Flood control is disabled, flood controller daemon is going to sleep indefinitely");
                        }
                        m_sync.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.m_reset = true;
                }
                if (this.m_stop) {
                    break;
                }
                if (!this.m_isEnabled || this.m_reset) {
                    continue;
                }
            }
            ArrayList<String> expiredIncidents = null;
            try {
                expiredIncidents = new ArrayList<String>();
            }
            catch (OutOfMemoryError oome) {
                ClassHistogram.releaseReservedMemory();
                expiredIncidents = new ArrayList();
            }
            Map<String, FloodIncident> map = this.m_incidents;
            synchronized (map) {
                for (String problemKey : this.m_incidents.keySet()) {
                    FloodIncident floodIncident = this.m_incidents.get(problemKey);
                    if (System.currentTimeMillis() - floodIncident.getCreationTime() <= this.m_incidentTimePeriod) continue;
                    expiredIncidents.add(problemKey);
                }
                for (String key : expiredIncidents) {
                    this.m_incidents.remove(key);
                    this.m_logger.fine("Removed incident problem key from flood control: " + key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfig(DiagnosticsConfiguration config) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.log(Level.FINEST, "Resetting the configuration of flood control daemon");
        }
        Object object = m_sync;
        synchronized (object) {
            this.m_isEnabled = config.isFloodControlEnabled();
            if (!this.m_isEnabled) {
                Map<String, FloodIncident> map = this.m_incidents;
                synchronized (map) {
                    this.m_incidents.clear();
                }
            }
            this.m_incidentCount = config.getFloodControlIncidentCount();
            this.m_incidentTimePeriod = (long)config.getFloodControlIncidentTimePeriod() * ONE_MINUTE_IN_MS;
            this.m_reset = true;
            m_sync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DiagnosticsEventManager.deregisterListener(this);
        Object object = m_sync;
        synchronized (object) {
            this.m_stop = true;
            m_sync.notify();
        }
    }

    @Override
    public void handleEvent(DiagnosticsEvent event) {
        if (event instanceof DiagnosticsConfigurationChangedEvent) {
            this.setConfig(((DiagnosticsConfigurationChangedEvent)event).getDiagnosticsConfiguration());
        }
    }

    @Override
    public Class<? extends DiagnosticsEvent>[] getHandledEventClasses() {
        return new Class[]{DiagnosticsConfigurationChangedEvent.class};
    }

    private static class FloodIncident {
        private long m_creationTime = System.currentTimeMillis();
        private int m_accessCount = 1;
        private String m_incidentId;

        FloodIncident() {
        }

        synchronized void accessed() {
            ++this.m_accessCount;
        }

        synchronized int getAccessCount() {
            return this.m_accessCount;
        }

        long getCreationTime() {
            return this.m_creationTime;
        }

        void setLastIncidentId(String incidentId) {
            this.m_incidentId = incidentId;
        }

        String getLastIncidentId() {
            return this.m_incidentId;
        }
    }
}

