/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.impl.dump;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import oracle.as.jmx.framework.PortableMBeanFactory;
import oracle.as.management.streaming.MBeanInputStream;
import oracle.dfw.common.ArgumentType;
import oracle.dfw.common.DiagnosticsCategory;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.dump.ComponentDiagnosticDump;
import oracle.dfw.dump.DumpContext;
import oracle.dfw.dump.DumpExecutionException;
import oracle.dfw.dump.DumpResult;
import oracle.dfw.dump.DumpWriter;
import oracle.dfw.dump.DumpWriterException;
import oracle.dfw.impl.dump.AccessCheck;
import oracle.dfw.resource.DiagnosticTranslation;
import oracle.dms.instrument.Noun;
import oracle.dms.util.DMSProperties;

public class DMSDump
extends ComponentDiagnosticDump {
    private boolean m_useMBean = false;
    private MBeanServer m_mbeanServer = null;
    private static final String QUERY_STRING = "operation=get&value=true&units=true&description=true&nodoctype=true&format=";
    private static final Map<String, String> ENV_NO_CACHE = new HashMap<String, String>();
    private static final ObjectName SPY_MBEAN_OBJ_NAMES;
    private static final String DUMP_ARG = "dump";
    private static final String FORMAT_ARG = "format";
    private static final String NOUN_TYPE_ARG = "nountypes";
    private static final String NAME_ARG = "names";
    private static final String SERVER_ARG = "servers";
    private static final Pattern LIST_SPLITTER;
    private static final String DFW_MESSAGES;

    public DMSDump(boolean useMBean) {
        this.m_useMBean = useMBean;
        this.defineArgument(FORMAT_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_DMS_METRICS_FORMAT_ARG");
        this.defineArgument(NOUN_TYPE_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_DMS_METRICS_NOUN_TYPE_ARG");
        this.defineArgument(NAME_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_DMS_METRICS_NAME_ARG");
        this.defineArgument(DUMP_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_DMS_METRICS_DUMP_ARG");
        this.defineArgument(SERVER_ARG, ArgumentType.STRING, false, DFW_MESSAGES, "DFW_DMS_METRICS_SERVER_ARG");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DumpResult executeDump(DumpContext context) throws DumpExecutionException, DumpWriterException {
        String queryString;
        DumpType dumpType;
        File dumpFile;
        DumpResult result;
        DumpWriter dw;
        block23: {
            String format = context.getArguments().getString(FORMAT_ARG, "raw");
            String extension = null;
            extension = format.compareToIgnoreCase("xml") == 0 || format.compareToIgnoreCase("pdml") == 0 ? "xml" : "txt";
            dw = null;
            result = null;
            dumpFile = null;
            try {
                dumpFile = context.generateUniqueFile(extension);
            }
            catch (IOException e) {
                throw new DumpExecutionException("failure generating unique dump filename", e);
            }
            String dumpString = context.getArguments().getString(DUMP_ARG, "LOCALDMS");
            try {
                dumpType = DumpType.valueOf(dumpString.toUpperCase());
            }
            catch (Exception e) {
                dumpType = DumpType.LOCALDMS;
            }
            queryString = this._buildQueryString(context);
            if (this.m_useMBean && dumpType == DumpType.ALL) {
                InputStream din = null;
                try {
                    Set<ObjectName> spyMBeans;
                    if (this.m_mbeanServer == null) {
                        PortableMBeanFactory portableMBeanFactory = new PortableMBeanFactory();
                        this.m_mbeanServer = portableMBeanFactory.getMBeanServer();
                    }
                    if ((spyMBeans = this.m_mbeanServer.queryNames(SPY_MBEAN_OBJ_NAMES, null)) == null) break block23;
                    int buflen = 4096;
                    dw = new DumpWriter(context, dumpFile);
                    Iterator<ObjectName> i$ = spyMBeans.iterator();
                    if (i$.hasNext()) {
                        String dumpHandle;
                        ObjectName spyMBean = i$.next();
                        String serverNames = context.getArguments().getString(SERVER_ARG, "");
                        String[] serverNameArray = LIST_SPLITTER.split(serverNames);
                        if (serverNameArray == null || serverNameArray.length == 0) {
                            serverNameArray = new String[]{DMSProperties.getProperty("oracle.server.name")};
                        }
                        if ((dumpHandle = (String)this.m_mbeanServer.invoke(spyMBean, "metricDumpHandle", new Object[]{queryString, serverNameArray, ENV_NO_CACHE}, new String[]{String.class.getName(), String[].class.getName(), Map.class.getName()})) == null) {
                            dw.getDumpResult();
                            dw = null;
                            LoggerFactory.getDumpLogger(this, DFW_MESSAGES).log(Level.FINER, "failure getting metrics dump streaming handle using DMS Spy MBean, using the DMSConsole dump method instead");
                        } else {
                            din = new MBeanInputStream(dumpHandle, this.m_mbeanServer, spyMBean, 10000);
                            InputStreamReader reader = new InputStreamReader(din, "UTF-8");
                            char[] buf = new char[4096];
                            int len = 0;
                            do {
                                if ((len = reader.read(buf, 0, 4096)) <= 0) continue;
                                dw.dump(buf, 0, len);
                            } while (len != -1);
                            try {
                                din.close();
                            }
                            catch (IOException ioe) {
                                LoggerFactory.getDumpLogger(this, DFW_MESSAGES).log(Level.FINER, "failure closing metric dump Stream", ioe);
                            }
                            finally {
                                din = null;
                            }
                            dw.dumpln();
                        }
                    }
                    result = dw.getDumpResult();
                }
                catch (Throwable e) {
                    if (din != null) {
                        try {
                            din.close();
                        }
                        catch (IOException ioe) {
                            LoggerFactory.getDumpLogger(this, DFW_MESSAGES).log(Level.FINER, "failure closing metric dump Stream", ioe);
                        }
                    }
                    if (dw != null) {
                        dw.getDumpResult();
                        dw = null;
                    }
                    LoggerFactory.getDumpLogger(this, DFW_MESSAGES).log(Level.FINER, "failure dumping DMS metrics using DMS Spy MBean  using the DMSConsole dump method instead", e);
                }
            }
        }
        if (!this.m_useMBean || dumpType == DumpType.LOCALDMS || dw == null) {
            String dumpFilename = dumpFile.getName();
            Noun.getRoot().dumpMetrics(AccessCheck.getAbsolutePath(dumpFile), queryString, false);
            result = new DumpResult(context, dumpFilename);
        }
        return result;
    }

    @Override
    public String getName() {
        return "metrics";
    }

    @Override
    public String getOwner() {
        return "dms";
    }

    @Override
    public EnumSet<DiagnosticsCategory> getDumpCategories() {
        return EnumSet.of(DiagnosticsCategory.PERFORMANCE);
    }

    @Override
    public String getDumpDescription() {
        return this.getMsg("DFW_DMS_METRICS_DESCRIPTION", null);
    }

    @Override
    public String getDumpDescription(Locale locale) {
        return this.getMsg("DFW_DMS_METRICS_DESCRIPTION", locale);
    }

    private String getMsg(String key, Locale locale) {
        try {
            if (locale != null) {
                return ResourceBundle.getBundle(DFW_MESSAGES, locale).getString(key);
            }
            return ResourceBundle.getBundle(DFW_MESSAGES).getString(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    private String _buildQueryString(DumpContext context) {
        String[] nameArray;
        String format = context.getArguments().getString(FORMAT_ARG, "raw");
        String nounTypes = context.getArguments().getString(NOUN_TYPE_ARG, "");
        String[] nounTypeArray = LIST_SPLITTER.split(nounTypes);
        StringBuilder queryString = new StringBuilder();
        for (String nounType : nounTypeArray) {
            if (nounType == null || nounType.length() == 0) continue;
            queryString.append("nountype=");
            queryString.append(nounType);
            queryString.append('&');
        }
        String names = context.getArguments().getString(NAME_ARG, "");
        for (String name : nameArray = LIST_SPLITTER.split(names)) {
            if (name == null || name.length() == 0) continue;
            queryString.append("name=");
            queryString.append(name);
            queryString.append('&');
        }
        if (queryString.length() > 0) {
            queryString.append("recurse=children&");
        }
        queryString.append(QUERY_STRING);
        queryString.append(format.toLowerCase());
        return queryString.toString();
    }

    static {
        LIST_SPLITTER = Pattern.compile("[, ]");
        DFW_MESSAGES = DiagnosticTranslation.class.getName();
        ObjectName spyMBeans = null;
        try {
            spyMBeans = new ObjectName("oracle.dms:type=Spy,*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        SPY_MBEAN_OBJ_NAMES = spyMBeans;
        ENV_NO_CACHE.put("oracle.dms.jmx.prefetch", "false");
        ENV_NO_CACHE.put("oracle.dms.jmx.querytype", "all");
        ENV_NO_CACHE.put("oracle.dms.jmx.usecache", "refreshall");
    }

    private static enum DumpType {
        ALL,
        LOCALDMS;

    }
}

