/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.dms.util.ByteBuf;

public class ReadLine {
    private int m_nextByte = 0;

    public ReadLine(int nextByte) {
        this.m_nextByte = nextByte;
    }

    public String readLine(InputStream instm) throws IOException {
        if (instm == null) {
            return null;
        }
        if (this.m_nextByte == 13) {
            this.m_nextByte = instm.read();
        }
        if (this.m_nextByte == 10) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.m_nextByte = ReadLine.parse822HeaderBody(this.m_nextByte, instm, out);
        if (out.size() == 0) {
            return null;
        }
        return out.toString();
    }

    public static int parse822HeaderBody(int curByte, InputStream instm, ByteArrayOutputStream headerBody) throws IOException {
        block8: while (true) {
            block0 : switch (curByte) {
                case -1: {
                    break block8;
                }
                case 13: {
                    curByte = instm.read();
                    if (curByte != 10) {
                        headerBody.write(curByte);
                        continue block8;
                    }
                }
                case 10: {
                    curByte = instm.read();
                    switch (curByte) {
                        case 9: 
                        case 32: {
                            while ((curByte = instm.read()) == 32 || curByte == 9) {
                            }
                            headerBody.write(curByte);
                            break block0;
                        }
                    }
                    break block8;
                }
                default: {
                    headerBody.write(curByte);
                }
            }
            curByte = instm.read();
        }
        return curByte;
    }

    public static ByteBuf read(InputStream input, int contentLength) throws IOException {
        int len;
        if (input == null) {
            return null;
        }
        if (contentLength < 0) {
            return ReadLine.read(input);
        }
        byte[] buf = new byte[contentLength];
        int num = 0;
        for (len = contentLength; len > 0 && (num = input.read(buf, contentLength - len, len)) != -1; len -= num) {
        }
        return new ByteBuf(buf, contentLength - len);
    }

    public static ByteBuf read(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        byte[] buf = new byte[2048];
        int len = 0;
        int num = 0;
        while ((num = input.read(buf, len, buf.length - len)) != -1) {
            if ((len += num) < buf.length) continue;
            byte[] newBuf = new byte[buf.length * 2];
            System.arraycopy(buf, 0, newBuf, 0, len);
            buf = newBuf;
        }
        return new ByteBuf(buf, len);
    }
}

