/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.dms.config.CollectorConfig;
import oracle.dms.config.Config;
import oracle.dms.http.DmsServletRequest;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.producer.J2EETableSource;
import oracle.dms.producer.JseMetricConvertor;
import oracle.dms.producer.MBeanTreeletGeneratorFactory;
import oracle.dms.reporter.Reporter;
import oracle.dms.reporter.SpyAgency;
import oracle.dms.table.MultiTableSource;
import oracle.dms.table.SpyTableSource;
import oracle.dms.util.DmsThreadFactory;
import oracle.dms.util.MBeanServerSupport;

public class DmsSpyLite
extends HttpServlet {
    static final long serialVersionUID = 2139568486802899457L;
    private static ScheduledThreadPoolExecutor s_timer = new ScheduledThreadPoolExecutor(1, new DmsThreadFactory());
    private volatile transient SpyAgency m_agency = null;
    private static final Logger LOGGER = Logger.getLogger("oracle.dms.collector", "oracle.dms.util.dms");

    public void init(ServletConfig config) throws ServletException {
        String METHOD_NAME = "init";
        super.init(config);
        if (this.m_agency == null) {
            CollectorConfig collectorConfig;
            DMSConsole console = new DMSConsole();
            Config dmsConfig = console.getConfig();
            if (dmsConfig == null) {
                collectorConfig = new CollectorConfig();
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.logp(Level.INFO, ((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).getClass().getName(), "DMS-50760");
                }
            } else {
                collectorConfig = dmsConfig.getCollectorConfig();
            }
            MBeanServer mbeanServer = MBeanServerSupport.getMBeanServer();
            JseMetricConvertor metricConverter = new JseMetricConvertor(mbeanServer, collectorConfig, s_timer);
            J2EETableSource tableSource = new J2EETableSource(metricConverter);
            MultiTableSource multiSource = new MultiTableSource();
            multiSource.registerTableSource(SpyTableSource.getTableSource());
            multiSource.registerTableSource(tableSource);
            this.m_agency = new SpyAgency(multiSource);
            MBeanTreeletGeneratorFactory mbGeneratorFactory = new MBeanTreeletGeneratorFactory(mbeanServer, metricConverter);
            this.m_agency.registerTreeletGeneratorFactory(mbGeneratorFactory);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String METHOD_NAME = "doPost";
        PrintWriter out = null;
        DmsServletRequest srequest = new DmsServletRequest(request);
        srequest.setLogout(false);
        Reporter reporter = this.m_agency.getReporter(srequest);
        response.setContentType(reporter.getContentType());
        response.setCharacterEncoding("UTF-8");
        response.setIntHeader("Expires", 0);
        response.setHeader("Cache-Control", "no-cache");
        try {
            out = response.getWriter();
            reporter.printResponse(out);
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "doPost", "ServerSpy fails to response: " + request.getQueryString(), e);
            }
            throw e;
        }
        finally {
            reporter.clear();
            if (out != null) {
                out.close();
            }
        }
    }
}

