/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.Hashtable;
import oracle.dms.instrument.Descriptor;
import oracle.dms.instrument.MetricDescriptor;

public class SensorDescriptor
extends Descriptor {
    private String m_desc = null;
    private String m_type = null;
    private Hashtable<String, MetricDescriptor> m_children = new Hashtable(31);

    public SensorDescriptor(String name, String desc, String type) {
        super(name);
        if (desc == null) {
            throw new IllegalArgumentException(this.toString() + ": desc=" + desc);
        }
        this.m_desc = desc;
        this.m_type = type;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public String getType() {
        return this.m_type;
    }

    public MetricDescriptor getMetricDescriptor(String name) {
        return this.m_children.get(name);
    }

    public void addMetricDescriptor(MetricDescriptor mdesc) {
        if (mdesc == null) {
            return;
        }
        this.m_children.put(mdesc.getName(), mdesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMetricNames() {
        String[] ret = null;
        Hashtable<String, MetricDescriptor> hashtable = this.m_children;
        synchronized (hashtable) {
            ret = new String[this.m_children.size()];
            this.m_children.keySet().toArray(ret);
        }
        return ret;
    }

    public int getMetricCount() {
        return this.m_children.size();
    }
}

