/*
 * Decompiled with CFR 0.152.
 */
package oracle.dfw.spi.portable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.core.ojdl.logging.LogUtil;
import oracle.dfw.common.ApplicationContext;
import oracle.dfw.common.DiagnosticsEventManager;
import oracle.dfw.common.LoggerFactory;
import oracle.dfw.config.DiagnosticsConfiguration;
import oracle.dfw.dump.DiagnosticDump;
import oracle.dfw.dump.DumpManager;
import oracle.dfw.framework.DiagnosticsFrameworkProviderLifecycle;
import oracle.dfw.impl.common.SecurityContext;
import oracle.dfw.impl.common.TempFileManager;
import oracle.dfw.impl.dump.ClassHistogram;
import oracle.dfw.impl.dump.DMSConfigDump;
import oracle.dfw.impl.dump.DMSDump;
import oracle.dfw.impl.dump.DumpManagerImpl;
import oracle.dfw.impl.dump.ExecutionContextDump;
import oracle.dfw.impl.dump.HTTPRequestTrackerDump;
import oracle.dfw.impl.dump.ThreadDump;
import oracle.dfw.impl.incident.ADRInfo;
import oracle.dfw.impl.incident.DiagnosticsDataExtractorImpl;
import oracle.dfw.impl.incident.IncidentManagerImpl;
import oracle.dfw.impl.incident.UncaughtExceptionHandler;
import oracle.dfw.incident.DiagnosticsDataExtractor;
import oracle.dfw.incident.IncidentFacts;
import oracle.dfw.incident.IncidentManager;
import oracle.dfw.sampling.DumpSampling;
import oracle.dfw.sampling.DumpSamplingArchive;
import oracle.dfw.spi.jse.JSEDiagnosticsFrameworkExtension;
import oracle.dfw.spi.portable.ApplicationContextImpl;
import oracle.dfw.spi.portable.DiagnosticsFrameworkPlatformExtension;
import oracle.dfw.spi.weblogic.WebLogicDiagnosticsFrameworkExtension;
import oracle.dfw.spi.websphere.WebSphereDiagnosticsFrameworkExtension;
import oracle.dms.jfr.JFREnvironmentInspector;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.ServerPlatformSupportFactory;

public class PortableDiagnosticsFrameworkProvider
implements DiagnosticsFrameworkProviderLifecycle {
    private HashMap<String, String> m_properties = new HashMap();
    private static int NOT_INITIALIZED = 0;
    private static int INITIALIZING = 1;
    private static int INITIALIZED = 2;
    private volatile int m_initialized = NOT_INITIALIZED;
    private DMSDump m_dmsDump;
    private DMSConfigDump m_dmsConfigDump;
    private DiagnosticDump m_jfrDump;
    private ExecutionContextDump m_ctxDump;
    private ThreadDump m_threadDump;
    private DumpSamplingArchive m_dumpSamplingArchive;
    private HTTPRequestTrackerDump m_httpRequestDump;
    private ClassHistogram m_histogramDump;
    private UncaughtExceptionHandler m_uncaughtHandler;
    private String m_oracleHome;
    private ADRInfo m_defaultADR;
    private DiagnosticsConfiguration m_config;
    private DiagnosticsDataExtractorImpl m_dde;
    private DumpManagerImpl m_dumpManager;
    private IncidentManagerImpl m_incidentManager;
    private ApplicationContext m_appCtx;
    private DiagnosticsFrameworkPlatformExtension m_platformExt;
    private static final String PORTABLE_DIAG_RULES = "portable-rules.xml";
    private static final PortableDiagnosticsFrameworkProvider INSTANCE = new PortableDiagnosticsFrameworkProvider();

    private PortableDiagnosticsFrameworkProvider() {
    }

    public static DiagnosticsFrameworkProviderLifecycle getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() throws Exception {
        if (this.m_initialized != NOT_INITIALIZED) {
            return;
        }
        try {
            this.m_initialized = INITIALIZING;
            Platform platform = this.getPlatform();
            if (Platform.WEBLOGIC == platform) {
                this.m_platformExt = new WebLogicDiagnosticsFrameworkExtension();
                this.m_appCtx = new ApplicationContextImpl();
            } else if (Platform.WEBSPHERE == platform) {
                this.m_platformExt = new WebSphereDiagnosticsFrameworkExtension();
                this.m_appCtx = new ApplicationContextImpl();
            } else if (Platform.JSE == platform) {
                this.m_platformExt = new JSEDiagnosticsFrameworkExtension();
            }
            TempFileManager.init(this.m_platformExt.getADRBase());
            String adrBase = ".";
            String productType = "ofm";
            String productId = "domain";
            String instanceId = "server";
            if (this.m_platformExt != null) {
                this.m_oracleHome = this.m_platformExt.getOracleHome();
                if (this.m_platformExt.getADRBase() != null) {
                    adrBase = this.m_platformExt.getADRBase();
                }
                if (this.m_platformExt.getInstanceId() != null) {
                    instanceId = this.m_platformExt.getInstanceId();
                }
                if (this.m_platformExt.getProductId() != null) {
                    productId = this.m_platformExt.getProductId();
                }
            }
            this.m_oracleHome = PortableDiagnosticsFrameworkProvider.getProperty("oracle.adr.home", this.m_oracleHome);
            if (this.m_oracleHome == null || this.m_oracleHome.length() == 0) {
                this.m_oracleHome = PortableDiagnosticsFrameworkProvider.getProperty("oracle.home", null);
            }
            if (this.m_oracleHome == null || this.m_oracleHome.length() == 0) {
                this.m_oracleHome = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getenv("ORACLE_HOME");
                    }
                });
            }
            adrBase = PortableDiagnosticsFrameworkProvider.getProperty("oracle.adr.base", adrBase);
            productType = PortableDiagnosticsFrameworkProvider.getProperty("oracle.adr.product.type", productType);
            productId = PortableDiagnosticsFrameworkProvider.getProperty("oracle.adr.product.id", productId);
            instanceId = PortableDiagnosticsFrameworkProvider.getProperty("oracle.adr.instance.id", instanceId);
            this.m_defaultADR = ADRInfo.getADRInfo(adrBase, productType, productId, instanceId);
            this.m_dumpManager = DumpManagerImpl.getInstance();
            if (this.m_appCtx != null) {
                this.m_dumpManager.setApplicationConext(this.m_appCtx);
                IncidentFacts.setApplicationContext(this.m_appCtx);
            }
            this.m_ctxDump = new ExecutionContextDump();
            this.m_httpRequestDump = new HTTPRequestTrackerDump();
            this.m_dumpManager.registerDump(this.m_ctxDump, true, null);
            this.m_dumpManager.registerDump(this.m_httpRequestDump, true, null);
            this.m_dmsDump = platform == Platform.WEBLOGIC ? new DMSDump(true) : new DMSDump(false);
            this.m_dumpManager.registerDump(this.m_dmsDump, true, null);
            this.m_dmsConfigDump = new DMSConfigDump();
            this.m_dumpManager.registerDump(this.m_dmsConfigDump, true, null);
            if (JFREnvironmentInspector.isFlightRecorderAvailable() == JFREnvironmentInspector.Availability.AVAILABLE) {
                try {
                    Class<?> jfrClazz = Class.forName("oracle.dfw.impl.dump.JavaFlightRecorderDump");
                    this.m_jfrDump = (DiagnosticDump)jfrClazz.newInstance();
                    this.m_dumpManager.registerDump(this.m_jfrDump, true, null);
                }
                catch (Throwable jre) {
                    LoggerFactory.getFrameworkLogger().log(Level.WARNING, "DFW-40010", jre);
                }
            }
            this.m_config = new DiagnosticsConfiguration();
            File cfile = null;
            String filename = PortableDiagnosticsFrameworkProvider.getProperty("oracle.dfw.config", null);
            if (filename != null && filename.length() > 0) {
                cfile = new File(filename);
            }
            if (cfile == null && this.m_platformExt != null && this.m_platformExt.getDiagnosticsConfigFile() != null) {
                cfile = this.m_platformExt.getDiagnosticsConfigFile();
            }
            if (cfile != null) {
                final File configFile = cfile;
                FileInputStream fis = null;
                try {
                    fis = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                        @Override
                        public FileInputStream run() throws FileNotFoundException {
                            return new FileInputStream(configFile);
                        }
                    });
                    this.m_config.parseDiagnosticsConfiguration(fis);
                }
                catch (PrivilegedActionException e) {
                    this.m_config = new DiagnosticsConfiguration();
                    LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40205", (Object[])new Object[]{configFile.getAbsolutePath()}, (Throwable)e.getException());
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            if (this.m_config != null) {
                TempFileManager.setMaxSize(this.m_config.getTempDirMaxSizeInBytes());
                TempFileManager.setMinCheckInterval(this.m_config.getTempDirIntervalInMilli());
                this.m_threadDump = Platform.WEBSPHERE == platform ? new ThreadDump(false) : new ThreadDump(this.m_config);
                this.m_dumpManager.registerDump(this.m_threadDump, true, null);
                if (Platform.WEBSPHERE != platform) {
                    this.m_histogramDump = new ClassHistogram(this.m_config);
                    this.m_dumpManager.registerDump(this.m_histogramDump, true, null);
                }
                DumpSampling.setEnable(this.m_config.isDumpSamplingEnabled());
                DumpSampling.setIdleWhenHealthy(this.m_config.isDumpSamplingIdleWhenHealthy());
                DumpSampling.setMinmumHealthyPeriod(this.m_config.getDumpSamplingMinimumHealthyPeriodInMillis());
                DiagnosticsEventManager.registerListener(DumpSampling.getEventListener());
                if (DumpSampling.isEnabled()) {
                    DumpSampling.recreateAllInstances(this.m_config);
                }
                this.m_dumpSamplingArchive = new DumpSamplingArchive();
                this.m_dumpManager.registerDump(this.m_dumpSamplingArchive, true, null);
            }
            SecurityContext secContext = null;
            if (this.m_platformExt != null) {
                secContext = this.m_platformExt.getSecurityContext();
            }
            File[] customRulesDirs = null;
            if (this.m_platformExt != null) {
                customRulesDirs = this.m_platformExt.getCustomRuleDirs();
            }
            this.m_dde = new DiagnosticsDataExtractorImpl(this.m_oracleHome, this.m_defaultADR, this.m_appCtx, secContext, this.m_dumpManager, this.m_config, customRulesDirs, this.m_properties);
            InputStreamReader isr = null;
            try {
                InputStream rulesStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return this.getClass().getResourceAsStream(PortableDiagnosticsFrameworkProvider.PORTABLE_DIAG_RULES);
                    }
                });
                isr = new InputStreamReader(rulesStream);
                this.m_dde.registerRules(isr, "portable-rules", true, null);
            }
            catch (Exception e) {
                LogUtil.log((Logger)LoggerFactory.getFrameworkLogger(), (Level)Level.WARNING, (String)"DFW-40206", (Object[])new Object[]{PORTABLE_DIAG_RULES}, (Throwable)e);
            }
            finally {
                if (isr != null) {
                    isr.close();
                }
            }
            try {
                this.m_incidentManager = new IncidentManagerImpl(this.m_dde, this.m_defaultADR, this.m_config);
            }
            catch (Exception e) {
                LoggerFactory.getFrameworkLogger().log(Level.FINE, "ADR unavailable; ADR incident management will be disabled.");
                LoggerFactory.getFrameworkLogger().log(Level.FINE, "failure initializing ADR", e);
            }
            this.m_uncaughtHandler = new UncaughtExceptionHandler(this.m_dde);
            if (this.m_config != null) {
                this.m_uncaughtHandler.setEnable(this.m_config.isUncaughtExceptionDetectionEnabled());
            }
            if (this.m_platformExt != null) {
                this.m_platformExt.setupExtension(this, this.m_properties);
            }
        }
        finally {
            this.m_initialized = NOT_INITIALIZED;
        }
        this.m_initialized = INITIALIZED;
    }

    private static String getProperty(final String key, final String def) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, def);
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.m_initialized == INITIALIZED;
    }

    @Override
    public String getOracleHome() {
        return this.m_oracleHome;
    }

    @Override
    public String getADRBase() {
        return this.m_defaultADR.getADRBase();
    }

    @Override
    public String getProductType() {
        return this.m_defaultADR.getProductType();
    }

    @Override
    public String getProductId() {
        return this.m_defaultADR.getProductId();
    }

    @Override
    public String getInstanceId() {
        return this.m_defaultADR.getInstanceId();
    }

    @Override
    public DiagnosticsDataExtractor getDDE() {
        return this.m_dde;
    }

    @Override
    public DumpManager getDumpManager() {
        return this.m_dumpManager;
    }

    @Override
    public IncidentManager getIncidentManager() {
        return this.m_incidentManager;
    }

    @Override
    public DiagnosticsConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.m_appCtx;
    }

    @Override
    public String setApplicationADRHome(String appName, String productType, String productId, String instanceId) {
        return this.m_dde.setApplicationADRHome(appName, productType, productId, instanceId);
    }

    @Override
    public String getApplicationADRHome(String appName) {
        return this.m_dde.getApplicationADRHome(appName);
    }

    @Override
    public String getProperty(String name) {
        return this.m_properties.get(name);
    }

    private Platform getPlatform() {
        Platform platform = Platform.JSE;
        try {
            ServerPlatformSupport helper = ServerPlatformSupportFactory.getInstance();
            if (helper.isWebLogic()) {
                platform = Platform.WEBLOGIC;
            } else if (helper.isWebSphere()) {
                platform = Platform.WEBSPHERE;
            }
        }
        catch (NoClassDefFoundError noclass) {
            LoggerFactory.getFrameworkLogger().fine("JRF libraries are unavailable: " + noclass.getMessage());
        }
        catch (Exception e) {
            LoggerFactory.getFrameworkLogger().fine("failure initializing JRF: " + e.getMessage());
        }
        return platform;
    }

    static enum Platform {
        WEBLOGIC,
        WEBSPHERE,
        JSE;

    }
}

