/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.table;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import oracle.dms.table.Table;
import oracle.dms.table.TableSource;
import oracle.dms.table.TableSupport;
import oracle.dms.util.QueryOptions;

public abstract class TableStorage
extends TableSource {
    protected TableStorage() {
    }

    @Override
    public String[] getTableNames(QueryOptions options) {
        Map<String, ? extends TableSupport> tables = this.getInternalTables();
        if (tables == null || tables.size() == 0) {
            return new String[0];
        }
        String[] names = new String[tables.size()];
        Set<String> keys = tables.keySet();
        keys.toArray(names);
        return names;
    }

    @Override
    public void getTableNames(Collection<String> list, QueryOptions options) {
        if (list == null) {
            return;
        }
        Map<String, ? extends TableSupport> tables = this.getInternalTables();
        if (tables == null || tables.size() == 0) {
            return;
        }
        list.addAll(tables.keySet());
    }

    @Override
    public int tableCount(QueryOptions options) {
        Map<String, ? extends TableSupport> tables = this.getInternalTables();
        if (tables == null || tables.size() == 0) {
            return 0;
        }
        return tables.size();
    }

    @Override
    public Table getTable(String name, QueryOptions options) {
        if (name == null || name.trim().length() == 0) {
            return null;
        }
        Map<String, ? extends TableSupport> tables = this.getInternalTables();
        if (tables == null || tables.size() == 0) {
            return null;
        }
        TableSupport table = tables.get(name);
        if (table == null) {
            return null;
        }
        return table.clone(options);
    }

    @Override
    public boolean containsTable(String name, QueryOptions options) {
        if (name == null || name.trim().length() == 0) {
            return false;
        }
        Map<String, ? extends TableSupport> tables = this.getInternalTables();
        if (tables == null || tables.size() == 0) {
            return false;
        }
        return tables.containsKey(name);
    }

    protected abstract Map<String, ? extends TableSupport> getInternalTables();
}

