/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Vector;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;

@Deprecated
public class InstrumentationNodeWalker {
    private boolean mReportNouns;
    private boolean mReportSensors;
    private Listener mListener;

    public InstrumentationNodeWalker(Listener listener) {
        this.mListener = listener;
        this.mReportNouns = listener.getClass().isAnnotationPresent(ReportNouns.class);
        this.mReportSensors = listener.getClass().isAnnotationPresent(ReportSensors.class);
    }

    public void walk(Noun noun) {
        Vector<Noun> childNouns;
        Sensor[] sensors;
        if (noun == null) {
            return;
        }
        if (this.mReportNouns) {
            this.mListener.processNode(noun);
        }
        if (this.mReportSensors && (sensors = noun.getSensors()) != null) {
            for (Sensor s : sensors) {
                this.mListener.processNode(s);
            }
        }
        if ((childNouns = noun.getNouns()) != null) {
            for (Noun childNoun : childNouns) {
                if (childNoun == null) continue;
                this.walk(childNoun);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ReportSensors {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ReportNouns {
    }

    public static interface Listener {
        public void processNode(Object var1);
    }
}

